/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.beans.Introspector;
import com.sas.beans.Util;
import com.sas.swing.property.BoundAttribute;
import com.sas.swing.property.ConstrainedAttribute;
import com.sas.swing.property.DescriptionAttribute;
import com.sas.swing.property.DescriptorDisplayNameComparator;
import com.sas.swing.property.DisplayNameAttribute;
import com.sas.swing.property.ExpertAttribute;
import com.sas.swing.property.HiddenAttribute;
import com.sas.swing.property.NameAttribute;
import com.sas.swing.property.PreferredAttribute;
import com.sas.swing.property.PropertyDescriptorAttribute;
import com.sas.swing.property.PropertyDescriptorAttributeModifier;
import com.sas.swing.property.RB;
import com.sas.swing.property.ReadOnlyAttribute;
import com.sas.swing.property.TypeAttribute;
import com.sas.swing.property.ValueAttribute;
import com.sas.text.Message;
import com.sas.util.StringComparator;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class PropertyTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final String RB_KEY = "PropertyTableModel.";
    protected List beanList;
    protected List currentDescList;
    protected List propDescList = new ArrayList();
    protected boolean sortAscending = true;
    protected String currentSortID = "displayName";
    protected int descFilter = 110;
    protected List columnIDList;
    protected Map columnNameMap;
    protected Map attributeMap;
    protected Map sortComparators;
    protected boolean sendTableChangedEvents = true;
    public static final String LINK_ID = "link";
    public static final String BOUND_ID = "bound";
    public static final String DISPLAY_NAME_ID = "displayName";
    public static final String CONSTRAINED_ID = "constrained";
    public static final String EXPERT_ID = "expert";
    public static final String HIDDEN_ID = "hidden";
    public static final String NAME_ID = "name";
    public static final String PREFERRED_ID = "preferred";
    public static final String SHORT_DESC_ID = "shortDescription";
    public static final String TYPE_ID = "type";
    public static final String VALUE_ID = "value";
    public static final String READ_ONLY_ID = "readOnly";
    public static final int VIEW_EXPERT = 1;
    public static final int VIEW_READ_ONLY = 2;
    public static final int VIEW_BOUND = 4;
    public static final int VIEW_CONSTRAINED = 8;
    public static final int VIEW_HIDDEN = 16;
    public static final int VIEW_PREFERRED = 32;
    public static final int VIEW_NORMAL = 64;
    public static final int VIEW_STANDARD = 110;
    public static final int VIEW_ALL = 127;

    public PropertyTableModel() {
        this.currentDescList = new ArrayList();
        this.columnIDList = new ArrayList();
        this.columnNameMap = new HashMap();
        this.columnNameMap.put(LINK_ID, RB.getStringResource(RB_KEY, "link.txt"));
        this.columnNameMap.put(BOUND_ID, RB.getStringResource(RB_KEY, "bound.txt"));
        this.columnNameMap.put(CONSTRAINED_ID, RB.getStringResource(RB_KEY, "constrained.txt"));
        this.columnNameMap.put(DISPLAY_NAME_ID, RB.getStringResource(RB_KEY, "property.txt"));
        this.columnNameMap.put(EXPERT_ID, RB.getStringResource(RB_KEY, "expert.txt"));
        this.columnNameMap.put(HIDDEN_ID, RB.getStringResource(RB_KEY, "hidden.txt"));
        this.columnNameMap.put(NAME_ID, RB.getStringResource(RB_KEY, "property.txt"));
        this.columnNameMap.put(PREFERRED_ID, RB.getStringResource(RB_KEY, "preferred.txt"));
        this.columnNameMap.put(SHORT_DESC_ID, RB.getStringResource(RB_KEY, "description.txt"));
        this.columnNameMap.put(TYPE_ID, RB.getStringResource(RB_KEY, "type.txt"));
        this.columnNameMap.put(VALUE_ID, RB.getStringResource(RB_KEY, "value.txt"));
        this.columnNameMap.put(READ_ONLY_ID, RB.getStringResource(RB_KEY, "readOnly.txt"));
        this.attributeMap = new HashMap();
        this.attributeMap.put(BOUND_ID, BoundAttribute.defaultInstance);
        this.attributeMap.put(CONSTRAINED_ID, ConstrainedAttribute.defaultInstance);
        this.attributeMap.put(DISPLAY_NAME_ID, DisplayNameAttribute.defaultInstance);
        this.attributeMap.put(EXPERT_ID, ExpertAttribute.defaultInstance);
        this.attributeMap.put(HIDDEN_ID, HiddenAttribute.defaultInstance);
        this.attributeMap.put(NAME_ID, NameAttribute.defaultInstance);
        this.attributeMap.put(PREFERRED_ID, PreferredAttribute.defaultInstance);
        this.attributeMap.put(SHORT_DESC_ID, DescriptionAttribute.defaultInstance);
        this.attributeMap.put(TYPE_ID, TypeAttribute.defaultInstance);
        this.attributeMap.put(VALUE_ID, ValueAttribute.defaultInstance);
        this.attributeMap.put(READ_ONLY_ID, ReadOnlyAttribute.defaultInstance);
        this.sortComparators = new HashMap();
        this.sortComparators.put(DISPLAY_NAME_ID, new DescriptorDisplayNameComparator());
    }

    public PropertyTableModel(Object[] beans) {
        this();
        this.setObjects(beans);
    }

    public Map getSortComparators() {
        return this.sortComparators;
    }

    public Comparator getSortComparator(String sortID) {
        if (this.sortComparators.containsKey(sortID)) {
            return (Comparator)this.sortComparators.get(sortID);
        }
        return null;
    }

    public void setSortComparator(String sortID, Comparator sortComparator) {
        this.sortComparators.put(sortID, sortComparator);
    }

    public PropertyDescriptorAttribute getPropertyDescriptorAttribute(String columnID) {
        return (PropertyDescriptorAttribute)this.attributeMap.get(columnID);
    }

    public void setColumnInfo(String columnID, String columnName, PropertyDescriptorAttribute propAttribute) {
        this.columnNameMap.put(columnID, columnName);
        this.attributeMap.put(columnID, propAttribute);
    }

    public void clearColumnInfo(String columnID) {
        this.columnNameMap.remove(columnID);
        this.attributeMap.remove(columnID);
        if (this.columnIDList.contains(columnID)) {
            this.removeColumn(columnID);
        }
    }

    public void addColumn(String columnID, int index) {
        if (index == -1) {
            this.columnIDList.add(columnID);
        } else {
            this.columnIDList.add(index, columnID);
        }
        this.fireTableStructureChanged();
    }

    public void removeColumn(String columnID) {
        this.columnIDList.remove(columnID);
        this.fireTableStructureChanged();
    }

    public Object[] getObjects() {
        if (this.beanList != null) {
            return this.beanList.toArray();
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjects(Object[] objects) {
        if (this.beanList != null && !this.beanList.isEmpty()) {
            for (int i = 0; i < this.beanList.size(); ++i) {
                Util.removePropertyChangeListener(this.beanList.get(i), (PropertyChangeListener)this);
            }
        }
        this.beanList = objects == null ? new ArrayList() : Arrays.asList(objects);
        this.propDescList.clear();
        this.currentDescList.clear();
        Object valueAttribute = this.attributeMap.get(VALUE_ID);
        if (valueAttribute instanceof ValueAttribute) {
            ((ValueAttribute)valueAttribute).resetExceptions();
        }
        if (!this.beanList.isEmpty()) {
            for (int i = 0; i < this.beanList.size(); ++i) {
                Util.addPropertyChangeListener(this.beanList.get(i), (PropertyChangeListener)this);
            }
            if (this.beanList.size() == 1) {
                BeanInfo beanInfo = null;
                try {
                    beanInfo = Introspector.getBeanInfo(this.beanList.get(0).getClass());
                }
                catch (IntrospectionException e) {
                    System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "errorSetObjects.txt"), (Object)e.toString()));
                }
                if (beanInfo != null) {
                    PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                    this.propDescList.addAll(Arrays.asList(descriptors));
                }
            } else {
                Set propNameSet = null;
                HashMap<String, PropertyDescriptor> propDescMap = new HashMap<String, PropertyDescriptor>();
                BeanInfo[] beanInfos = new BeanInfo[this.beanList.size()];
                for (int i = 0; i < this.beanList.size(); ++i) {
                    try {
                        beanInfos[i] = Introspector.getBeanInfo(this.beanList.get(i).getClass());
                    }
                    catch (IntrospectionException e) {
                        System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "errorSetObjects.txt"), (Object)e.toString()));
                    }
                    if (beanInfos[i] == null) continue;
                    if (propNameSet == null) {
                        PropertyDescriptor[] descriptors = beanInfos[0].getPropertyDescriptors();
                        for (int j = 0; j < descriptors.length; ++j) {
                            propDescMap.put(descriptors[j].getName(), descriptors[j]);
                        }
                        propNameSet = propDescMap.keySet();
                        continue;
                    }
                    Iterator keyIterator = propNameSet.iterator();
                    HashMap<String, PropertyDescriptor> tmpDescMap = new HashMap<String, PropertyDescriptor>();
                    PropertyDescriptor[] tmpDesc = beanInfos[i].getPropertyDescriptors();
                    for (int j = 0; j < tmpDesc.length; ++j) {
                        tmpDescMap.put(tmpDesc[j].getName(), tmpDesc[j]);
                    }
                    while (keyIterator.hasNext()) {
                        Class<?> propType;
                        String propName = (String)keyIterator.next();
                        PropertyDescriptor propDesc = (PropertyDescriptor)propDescMap.get(propName);
                        PropertyDescriptor tmpPropDesc = (PropertyDescriptor)tmpDescMap.get(propName);
                        if (propDesc instanceof IndexedPropertyDescriptor) {
                            propType = ((IndexedPropertyDescriptor)propDesc).getIndexedPropertyType();
                            if (tmpPropDesc != null && tmpPropDesc instanceof IndexedPropertyDescriptor && propType.equals(((IndexedPropertyDescriptor)tmpPropDesc).getIndexedPropertyType())) continue;
                            keyIterator.remove();
                            continue;
                        }
                        propType = propDesc.getPropertyType();
                        if (tmpPropDesc != null && propType.equals(tmpPropDesc.getPropertyType())) continue;
                        keyIterator.remove();
                    }
                }
                this.propDescList.addAll(propDescMap.values());
            }
            try {
                this.sendTableChangedEvents = false;
                this.filterTable();
            }
            finally {
                this.sendTableChangedEvents = true;
            }
        }
        this.fireTableDataChanged();
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean ascending) {
        this.sortTable(this.getSortID(), ascending);
    }

    public String getSortID() {
        return this.currentSortID;
    }

    public void setSortID(String sortID) {
        this.sortTable(sortID, this.isSortAscending());
    }

    public int getPropertyDescriptorFilter() {
        return this.descFilter;
    }

    public void setPropertyDescriptorFilter(int filter) {
        this.descFilter = filter;
    }

    public Set getColumnIDSet() {
        return Collections.unmodifiableSet(this.attributeMap.keySet());
    }

    public List getCurrentColumnIDList() {
        return Collections.unmodifiableList(this.columnIDList);
    }

    public String getColumnID(int col) {
        return (String)this.columnIDList.get(col);
    }

    public int getColumnIndex(String columnID) {
        return this.columnIDList.indexOf(columnID);
    }

    @Override
    public int getRowCount() {
        return this.currentDescList.size();
    }

    public Class getColumnClass(int col) {
        String id = this.getColumnID(col);
        PropertyDescriptorAttribute attribute = (PropertyDescriptorAttribute)this.attributeMap.get(id);
        if (attribute != null) {
            return attribute.getAttributeClass();
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getColumnCount() {
        return this.columnIDList.size();
    }

    @Override
    public String getColumnName(int col) {
        String columnID = this.getColumnID(col);
        return (String)this.columnNameMap.get(columnID);
    }

    public String getColumnName(String columnID) {
        return (String)this.columnNameMap.get(columnID);
    }

    public void setColumnName(int col, String columnName) {
        this.setColumnName(columnName, this.getColumnID(col));
    }

    public void setColumnName(String columnID, String columnName) {
        this.columnNameMap.put(columnID, columnName);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.currentDescList.isEmpty() || row > this.currentDescList.size() || row < 0 || col > this.columnIDList.size() || col < 0) {
            return false;
        }
        String id = this.getColumnID(col);
        PropertyDescriptorAttribute attribute = (PropertyDescriptorAttribute)this.attributeMap.get(id);
        if (attribute != null) {
            return attribute.isEditable(this.getObjects(), this.getPropertyDescriptor(row));
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.currentDescList.isEmpty() || row > this.currentDescList.size() || row < 0 || col > this.columnIDList.size() || col < 0) {
            return null;
        }
        String id = this.getColumnID(col);
        PropertyDescriptorAttribute attribute = (PropertyDescriptorAttribute)this.attributeMap.get(id);
        if (attribute != null) {
            return attribute.getAttribute(this.getObjects(), this.getPropertyDescriptor(row));
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        boolean updated;
        if (this.currentDescList.isEmpty() || row > this.currentDescList.size() || row < 0 || col > this.columnIDList.size() || col < 0) {
            return;
        }
        String id = this.getColumnID(col);
        PropertyDescriptorAttribute attribute = (PropertyDescriptorAttribute)this.attributeMap.get(id);
        if (attribute != null && attribute instanceof PropertyDescriptorAttributeModifier && (updated = ((PropertyDescriptorAttributeModifier)attribute).setAttribute(this.getObjects(), this.getPropertyDescriptor(row), value))) {
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object eSource = evt.getSource();
        if (this.beanList != null && this.beanList.contains(eSource)) {
            String propName = evt.getPropertyName();
            if (propName != null) {
                for (int i = 0; i < this.currentDescList.size(); ++i) {
                    String descName = ((PropertyDescriptor)this.currentDescList.get(i)).getName();
                    if (!com.sas.util.Util.equal((Object)descName, (Object)propName)) continue;
                    this.fireTableCellUpdated(i, this.getColumnIndex(VALUE_ID));
                    return;
                }
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    public Class getPropertyType(int row) {
        return this.getPropertyDescriptor(row).getPropertyType();
    }

    public PropertyDescriptor getPropertyDescriptor(int row) {
        return (PropertyDescriptor)this.currentDescList.get(row);
    }

    public List getAllPropertyDescriptors() {
        return Collections.unmodifiableList(this.propDescList);
    }

    public List getCurrentPropertyDescriptors() {
        return Collections.unmodifiableList(this.currentDescList);
    }

    public void filterTable() {
        this.filterTable(this.getPropertyDescriptorFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterTable(int view) {
        this.setPropertyDescriptorFilter(view);
        List allPropList = this.getAllPropertyDescriptors();
        if (allPropList.isEmpty()) {
            return;
        }
        this.currentDescList.clear();
        this.currentDescList.addAll(allPropList);
        boolean viewReadOnly = (view & 2) == 2;
        boolean viewHidden = (view & 0x10) == 16;
        boolean viewExpert = (view & 1) == 1;
        boolean viewBound = (view & 4) == 4;
        boolean viewConstrained = (view & 8) == 8;
        boolean viewPreferred = (view & 0x20) == 32;
        boolean viewNormal = (view & 0x40) == 64;
        ListIterator iterator = this.currentDescList.listIterator();
        while (iterator.hasNext()) {
            PropertyDescriptor desc = (PropertyDescriptor)iterator.next();
            boolean hidden = desc.isHidden();
            boolean expert = desc.isExpert();
            boolean bound = desc.isBound();
            boolean constrained = desc.isConstrained();
            boolean preferred = desc.isPreferred();
            boolean readOnly = desc.getWriteMethod() == null;
            boolean removeDesc = true;
            if (!(!viewHidden || !hidden || !viewExpert && expert || !viewBound && bound || !viewConstrained && constrained || !viewPreferred && preferred || !viewReadOnly && readOnly)) {
                removeDesc = false;
            } else if (!(!viewExpert || !expert || !viewHidden && hidden || !viewBound && bound || !viewConstrained && constrained || !viewPreferred && preferred || !viewReadOnly && readOnly)) {
                removeDesc = false;
            } else if (!(!viewBound || !bound || !viewExpert && expert || !viewHidden && hidden || !viewConstrained && constrained || !viewPreferred && preferred || !viewReadOnly && readOnly)) {
                removeDesc = false;
            } else if (!(!viewConstrained || !constrained || !viewExpert && expert || !viewBound && bound || !viewHidden && hidden || !viewPreferred && preferred || !viewReadOnly && readOnly)) {
                removeDesc = false;
            } else if (!(!viewPreferred || !preferred || !viewExpert && expert || !viewBound && bound || !viewConstrained && constrained || !viewHidden && hidden || !viewReadOnly && readOnly)) {
                removeDesc = false;
            } else if (!(!viewReadOnly || !readOnly || !viewExpert && expert || !viewBound && bound || !viewConstrained && constrained || !viewPreferred && preferred || !viewHidden && hidden)) {
                removeDesc = false;
            } else if (!(!viewNormal || hidden || expert || bound || constrained || preferred || readOnly)) {
                removeDesc = false;
            }
            if (!removeDesc) continue;
            iterator.remove();
        }
        boolean prevSendEvents = this.sendTableChangedEvents;
        try {
            this.sendTableChangedEvents = false;
            this.sortTable(this.getSortID(), this.isSortAscending());
        }
        finally {
            this.sendTableChangedEvents = prevSendEvents;
        }
        if (this.sendTableChangedEvents) {
            this.fireTableDataChanged();
        }
    }

    public void sortTable(String sortType, boolean ascending) {
        if (this.currentDescList.isEmpty() || !this.sortComparators.containsKey(sortType)) {
            return;
        }
        this.currentSortID = sortType;
        Comparator comparator = (Comparator)this.sortComparators.get(sortType);
        if (comparator != null) {
            if (comparator instanceof StringComparator) {
                this.sortAscending = ascending;
                ((StringComparator)comparator).setAscending(ascending);
            }
            Collections.sort(this.currentDescList, comparator);
            if (this.sendTableChangedEvents) {
                this.fireTableDataChanged();
            }
        }
    }
}

