/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.swing.adapters.EditNavigationalAction;
import com.sas.swing.adapters.JTableMouseInputAdapter;
import com.sas.swing.property.PropertyDialog;
import com.sas.swing.property.PropertyTableModel;
import com.sas.swing.property.PropertyValueEditor;
import com.sas.swing.property.RB;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyDescriptor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class PropertySheetTable
extends JTable {
    public static int DEFAULT_ROW_HEIGHT = 22;
    protected int[] nonRepostColumns;
    protected PropertyValueEditor propEditor = new PropertyValueEditor();
    protected MouseInputListener mouseInputAdapter;
    protected JPopupMenu _popupMenu;
    protected static JMenuItem _propertiesMenuItem;
    protected static final String RB_KEY = "PropertySheetTable.";
    protected boolean readOnly = false;

    public PropertySheetTable() {
        this(new PropertyTableModel());
    }

    public PropertySheetTable(PropertyTableModel model) {
        super(model);
        this.setDefaultRenderer(PropertyDescriptor.class, this.propEditor);
        this.setDefaultEditor(PropertyDescriptor.class, this.propEditor);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.readOnly) {
            return false;
        }
        return super.isCellEditable(row, column);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readonly) {
        this.readOnly = readonly;
        this.propEditor.setForceReadOnly(this.readOnly);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (this.isEditing()) {
            TableCellEditor editor = this.getCellEditor();
            editor.stopCellEditing();
        }
        super.columnMarginChanged(e);
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.nonRepostColumns = new int[0];
        this.setSelectionMode(0);
        this.setRowHeight(DEFAULT_ROW_HEIGHT);
    }

    public int getColumnIndex(String columnID) {
        TableModel propertyModel = this.getModel();
        if (propertyModel instanceof PropertyTableModel) {
            return ((PropertyTableModel)propertyModel).getColumnIndex(columnID);
        }
        return -1;
    }

    public Object[] getObjects() {
        TableModel propertyModel = this.getModel();
        if (propertyModel instanceof PropertyTableModel) {
            return ((PropertyTableModel)propertyModel).getObjects();
        }
        return new Object[0];
    }

    public void setObjects(Object[] objs) {
        this.propEditor.setObjects(objs);
        TableModel propertyModel = this.getModel();
        if (propertyModel instanceof PropertyTableModel) {
            ((PropertyTableModel)propertyModel).setObjects(objs);
        }
    }

    public void setNonEventRepostColumns(int[] nonRepostColumns) {
        if (this.mouseInputAdapter != null) {
            this.removeMouseListener(this.mouseInputAdapter);
            this.removeMouseMotionListener(this.mouseInputAdapter);
        }
        this.nonRepostColumns = nonRepostColumns;
        this.mouseInputAdapter = this.createMouseInputListener();
        this.addMouseListener(this.mouseInputAdapter);
        this.addMouseMotionListener(this.mouseInputAdapter);
    }

    protected void updateUIMaps() {
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "selectCurrentCell");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectNextColumnCell", (Action)new EditNavigationalAction(1));
        actionMap.put("selectPreviousColumnCell", (Action)new EditNavigationalAction(-1));
        actionMap.put("selectCurrentCell", actionMap.get("startEditing"));
    }

    protected void updateListeners() {
        MouseListener[] mouseListeners = (MouseListener[])this.getListeners(MouseListener.class);
        int listenerIndex = -1;
        for (int i = 0; i < mouseListeners.length; ++i) {
            if (!(mouseListeners[i] instanceof BasicTableUI.MouseInputHandler)) continue;
            listenerIndex = i;
            break;
        }
        if (listenerIndex != -1) {
            this.removeMouseListener(mouseListeners[listenerIndex]);
            this.removeMouseMotionListener((MouseMotionListener)((Object)mouseListeners[listenerIndex]));
            this.mouseInputAdapter = this.createMouseInputListener();
            this.addMouseListener(this.mouseInputAdapter);
            this.addMouseMotionListener(this.mouseInputAdapter);
        }
    }

    protected MouseInputListener createMouseInputListener() {
        return new JTableMouseInputAdapter(this, this.nonRepostColumns);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateUIMaps();
        this.updateListeners();
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        JComponent jComp;
        boolean isSelected;
        Object value = this.getValueAt(row, column);
        Component comp = editor.getTableCellEditorComponent(this, value, isSelected = this.isCellSelected(row, column), row, column);
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
            jComp.setNextFocusableComponent(this);
        }
        return comp;
    }

    public void createPopupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
            this.add(this._popupMenu);
        }
    }

    public void showPopup(Point point) {
        this._popupMenu.removeAll();
        this.populatePopupMenu(this._popupMenu);
        int subElementCount = this._popupMenu.getSubElements().length;
        if (subElementCount != 0) {
            Dimension menuSize = Util.computePopupMenuSize((JPopupMenu)this._popupMenu, (Component)this);
            final Point popupLoc = Util.computePopupMenuLocation((int)point.x, (int)point.y, (int)menuSize.width, (int)menuSize.height, (Component)this);
            final PropertySheetTable table = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertySheetTable.this._popupMenu.show(table, popupLoc.x, popupLoc.y);
                }
            });
        }
    }

    protected void populatePopupMenu(JPopupMenu popup) {
        _propertiesMenuItem = new JMenuItem(RB.getStringResource(RB_KEY, "properties.txt"));
        _propertiesMenuItem.addActionListener(new PropertiesActionListener());
        popup.add(_propertiesMenuItem);
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            Action a = actionMap.get("drillDown");
            if (a != null) {
                JMenuItem drillDown = popup.add(a);
                drillDown.setText(RB.getStringResource(RB_KEY, "drillDown.txt"));
            }
            if ((a = actionMap.get("drillDown")) != null) {
                JMenuItem drillUp = popup.add(actionMap.get("drillUp"));
                drillUp.setText(RB.getStringResource(RB_KEY, "drillUp.txt"));
            }
        }
    }

    class PropertiesActionListener
    implements ActionListener {
        PropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == _propertiesMenuItem) {
                TableModel propertyModel = PropertySheetTable.this.getModel();
                PropertyDescriptor propDesc = null;
                if (propertyModel instanceof PropertyTableModel && PropertySheetTable.this.getSelectedRow() >= 0) {
                    propDesc = ((PropertyTableModel)propertyModel).getPropertyDescriptor(PropertySheetTable.this.getSelectedRow());
                }
                if (propDesc != null) {
                    JFrame f = Util.getParentFrame((Component)PropertySheetTable.this);
                    if (f == null) {
                        f = new JFrame();
                    }
                    PropertyDialog propDialog = new PropertyDialog(f, true, propDesc);
                    propDialog.pack();
                    Util.centerOverWindow((Window)propDialog, (Component)PropertySheetTable.this);
                    propDialog.setVisible(true);
                }
            }
        }
    }
}

