/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.ComponentException;
import com.sas.beans.ExtendedPropertyEditorInterface;
import com.sas.beans.Introspector;
import com.sas.beans.ParentWindowRequestor;
import com.sas.beans.PropertyEditorBeanRequestor;
import com.sas.beans.PropertyEditorDescriptorRequestor;
import com.sas.beans.SwingCustomizerUtil;
import com.sas.graphics.IDEDnDManager;
import com.sas.security.SecuritySupport;
import com.sas.swing.property.RB;
import com.sas.swing.visuals.SwingCustomizerView;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.SystemLog;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PropertyEditorHost
extends JPanel
implements ActionListener,
FocusListener,
PropertyChangeListener {
    public static final String RB_KEY = "PropertyEditorHost.";
    static int PAINT_AREA_SIZE = 18;
    private static int START = 1;
    private static int END = 2;
    protected static String EDITING_DONE = "editingDone";
    protected Object bean;
    protected PropertyDescriptor propertyDescriptor;
    protected PropertyEditor propertyEditor;
    protected Object propertyValue;
    protected Class propertyType;
    protected String property;
    protected boolean indexed;
    protected boolean readOnly;
    protected boolean writeOnly;
    protected boolean masked;
    protected int initialIndex;
    protected boolean propertyExceptionThrown;
    protected boolean showIndexed;
    protected boolean alwaysShowControls;
    protected boolean controlsInitialized;
    protected boolean updateValue;
    protected boolean updateEditor;
    protected boolean editMode;
    protected AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 0);
    protected PropertyEditorPaintArea paintArea;
    protected JLabel propertyLabel;
    protected JTextField propertyField;
    protected JComboBox propertyTags;
    protected DefaultComboBoxModel propertyTagsModel;
    protected JButton customButton;
    protected JComponent startFocusComponent;
    protected JComponent endFocusComponent;
    protected FocusAdapter propertyFieldFocusAdapter;
    protected boolean forceReadOnly = false;

    public PropertyEditorHost() {
        this.layout.setFillCell(true);
        this.layout.setUseColumnRemainder(true);
        this.layout.setRemainderColumn(1);
        this.layout.setUseRowRemainder(true);
        this.layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)this.layout);
        this.showIndexed = false;
        this.alwaysShowControls = true;
        this.controlsInitialized = false;
        this.updateEditor = false;
        this.updateValue = false;
        this.editMode = false;
    }

    public boolean isReadOnly() {
        return this.forceReadOnly || this.readOnly;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public void setForceReadOnly(boolean fro) {
        this.forceReadOnly = fro;
    }

    public boolean isForceReadOnly() {
        return this.forceReadOnly;
    }

    @Override
    protected void processFocusEvent(FocusEvent evt) {
        super.processFocusEvent(evt);
        if (evt.getID() == 1004) {
            if (this.propertyTags != null) {
                this.propertyTags.requestFocus();
            } else if (this.propertyField != null) {
                this.propertyField.requestFocus();
            } else if (this.customButton != null) {
                this.customButton.requestFocus();
            }
        }
    }

    public boolean getShowIndexedProperty() {
        return this.showIndexed;
    }

    public void setShowIndexedProperty(boolean showProperty) {
        this.showIndexed = showProperty;
    }

    public boolean isAlwaysShowControls() {
        return this.alwaysShowControls;
    }

    public void setAlwaysShowControls(boolean show) {
        this.alwaysShowControls = show;
    }

    public Object getPropertyValue() {
        PropertyEditor propEditor = this.getPropertyEditor();
        if (propEditor != null) {
            return propEditor.getValue();
        }
        return this.propertyValue;
    }

    public void setPropertyValue(Object value) {
        this.propertyValue = value;
        PropertyEditor propEditor = this.getPropertyEditor();
        if (propEditor != null) {
            propEditor.setValue(value);
        }
    }

    public void setPropertyValue(Object value, Class propertyType) {
        this.bean = null;
        this.property = null;
        this.propertyValue = value;
        this.propertyType = propertyType;
        this.indexed = false;
        this.setReadOnly(false);
        this.writeOnly = false;
        this.masked = false;
        this.showIndexed = false;
        PropertyEditor propEditor = PropertyEditorManager.findEditor(this.propertyType);
        this.setPropertyEditor(propEditor);
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propEditor) {
        if (this.propertyEditor == propEditor && this.controlsInitialized) {
            return;
        }
        if (this.propertyEditor != null) {
            this.propertyEditor.removePropertyChangeListener(this);
        }
        this.propertyEditor = propEditor;
        if (this.propertyEditor != null) {
            if (this.propertyValue != null) {
                this.propertyEditor.setValue(this.propertyValue);
            }
            if (this.propertyDescriptor != null && this.propertyEditor instanceof PropertyEditorDescriptorRequestor) {
                ((PropertyEditorDescriptorRequestor)this.propertyEditor).setPropertyDescriptor(this.propertyDescriptor);
            }
            if (this.bean != null && this.propertyEditor instanceof PropertyEditorBeanRequestor) {
                ((PropertyEditorBeanRequestor)this.propertyEditor).setBeanContainingProperty(this.bean);
            }
            if (this.propertyEditor instanceof ExtendedPropertyEditorInterface && !((ExtendedPropertyEditorInterface)this.propertyEditor).isEditable()) {
                this.readOnly = true;
            }
        }
        this.initializeControls();
        if (this.propertyEditor != null) {
            this.propertyEditor.addPropertyChangeListener(this);
        }
    }

    public int getPropertyValueIndex() {
        if (this.indexed) {
            return this.initialIndex;
        }
        return -1;
    }

    public void setPropertyValueIndex(int propertyIndex) {
        this.initialIndex = propertyIndex;
    }

    public void setProperty(Object bean, String property, int index) throws IntrospectionException {
        this.setPropertyValueIndex(index);
        this.setProperty(bean, property);
    }

    public void setProperty(Object bean, String property) throws IntrospectionException {
        if (bean == null) {
            return;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor propDesc = Introspector.getPropertyDescriptor((String)property, (BeanInfo)beanInfo);
        if (propDesc != null) {
            this.setProperty(bean, propDesc);
        }
    }

    public void setProperty(Object bean, PropertyDescriptor propDesc) {
        this.bean = bean;
        this.propertyDescriptor = propDesc;
        this.updateProperty(this.bean, propDesc);
        PropertyEditor propEditor = this.findPropertyEditor(propDesc, this.propertyType);
        this.setPropertyEditor(propEditor);
    }

    public Object getBean() {
        return this.bean;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    protected void updateProperty(Object bean, PropertyDescriptor propDesc) {
        this.propertyExceptionThrown = false;
        this.property = propDesc.getName();
        this.masked = false;
        if (propDesc instanceof com.sas.beans.PropertyDescriptor) {
            this.masked = ((com.sas.beans.PropertyDescriptor)propDesc).isMasked();
        }
        if (propDesc instanceof IndexedPropertyDescriptor) {
            this.indexed = true;
            IndexedPropertyDescriptor indexedPropDesc = (IndexedPropertyDescriptor)propDesc;
            if (indexedPropDesc.getIndexedWriteMethod() == null) {
                this.readOnly = true;
            }
            if (indexedPropDesc.getIndexedReadMethod() == null) {
                this.writeOnly = true;
            }
            if (bean != null && this.showIndexed) {
                System.out.println(RB.getStringResource(RB_KEY, "updateProperty.txt"));
            }
            this.propertyType = this.propertyValue != null ? this.propertyValue.getClass() : indexedPropDesc.getIndexedPropertyType();
        } else {
            this.indexed = false;
            if (propDesc.getWriteMethod() == null) {
                this.readOnly = true;
            }
            if (propDesc.getReadMethod() == null) {
                this.writeOnly = true;
            }
            try {
                if (bean != null && !this.writeOnly) {
                    this.propertyValue = SecuritySupport.securitySupport.invokeMethod(propDesc.getReadMethod(), bean, null);
                }
            }
            catch (IllegalAccessException e) {
                this.propertyExceptionThrown = true;
            }
            catch (IllegalArgumentException e) {
                this.propertyExceptionThrown = true;
            }
            catch (InvocationTargetException e) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "exceptionThrown.txt"), (Object)e));
                this.propertyExceptionThrown = true;
            }
            this.propertyType = this.propertyValue != null ? this.propertyValue.getClass() : propDesc.getPropertyType();
        }
    }

    protected PropertyEditor findPropertyEditor(PropertyDescriptor propDesc, Class propType) {
        PropertyEditor propEditor;
        Class<?> propertyEditorClass = propDesc.getPropertyEditorClass();
        if (propertyEditorClass != null) {
            try {
                return (PropertyEditor)propertyEditorClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((propEditor = PropertyEditorManager.findEditor(propType)) == null) {
            Class<?> descPropType = propDesc.getPropertyType();
            if (this.indexed) {
                descPropType = ((IndexedPropertyDescriptor)propDesc).getIndexedPropertyType();
            }
            propEditor = PropertyEditorManager.findEditor(descPropType);
        }
        return propEditor;
    }

    protected String getAsText() {
        if (this.writeOnly) {
            return RB.getStringResource(RB_KEY, "writeOnly.txt");
        }
        if (this.indexed && !this.showIndexed) {
            return RB.getStringResource(RB_KEY, "indexedProperty.txt");
        }
        if (this.propertyExceptionThrown) {
            return RB.getStringResource(RB_KEY, "exceptionThrownGettingValue.txt");
        }
        PropertyEditor propEditor = this.getPropertyEditor();
        if (propEditor != null) {
            return propEditor.getAsText();
        }
        String labelText = "";
        labelText = this.propertyValue == null ? "null" : (this.propertyValue instanceof String || this.propertyValue instanceof Boolean || this.propertyValue instanceof Number ? this.propertyValue.toString() : (this.propertyValue instanceof Class ? ((Class)this.propertyValue).getName() : Message.format((String)RB.getStringResource(RB_KEY, "instanceOf.txt"), (Object)this.propertyValue.getClass().getName())));
        return labelText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTags(String[] tags) {
        boolean prevUpdateValue = this.updateValue;
        try {
            this.updateValue = true;
            if (this.propertyTagsModel == null) {
                this.propertyTagsModel = new DefaultComboBoxModel<String>(tags);
            } else {
                this.propertyTagsModel.removeAllElements();
                if (tags != null) {
                    for (int i = 0; i < tags.length; ++i) {
                        this.propertyTagsModel.addElement(tags[i]);
                    }
                }
            }
            this.propertyTagsModel.setSelectedItem(this.getAsText());
        }
        finally {
            this.updateValue = prevUpdateValue;
        }
    }

    protected Component initLabel() {
        if (this.propertyLabel == null) {
            this.propertyLabel = new JLabel();
        }
        if (this.isReadOnly()) {
            this.propertyLabel.setEnabled(false);
        }
        String txt = this.getAsText();
        if (this.masked) {
            txt = this.maskText(txt);
        }
        this.propertyLabel.setText(txt);
        return this.propertyLabel;
    }

    protected String maskText(String txt) {
        if (txt == null || txt.equals("null") && this.propertyValue == null) {
            return null;
        }
        int txtLen = txt.length();
        StringBuffer maskedText = new StringBuffer(txtLen);
        for (int i = 0; i < txtLen; ++i) {
            maskedText.append('*');
        }
        return maskedText.toString();
    }

    protected Component initPaintArea() {
        if (this.paintArea == null) {
            this.paintArea = new PropertyEditorPaintArea();
        }
        this.paintArea.setPropertyEditor(this.getPropertyEditor());
        int paintWidth = PAINT_AREA_SIZE;
        if (this.getAsText() == null) {
            paintWidth = 100;
        }
        Dimension paintAreaSize = new Dimension(paintWidth, PAINT_AREA_SIZE);
        this.paintArea.setPreferredSize(paintAreaSize);
        return this.paintArea;
    }

    protected Component initPropertyTags() {
        if (this.propertyTags == null) {
            this.propertyTags = new JComboBox();
        }
        PropertyEditor propEditor = this.getPropertyEditor();
        String[] tags = propEditor.getTags();
        this.readTags(tags);
        this.propertyTags.setModel(this.propertyTagsModel);
        this.propertyTags.setSelectedItem(this.getAsText());
        return this.propertyTags;
    }

    protected Component initPropertyField() {
        if (this.propertyField == null) {
            if (this.masked) {
                this.propertyField = new JPasswordField();
                ((JPasswordField)this.propertyField).setEchoChar('*');
            } else {
                this.propertyField = new JTextField();
            }
        }
        if (this.masked && !(this.propertyField instanceof JPasswordField)) {
            this.propertyField = new JPasswordField();
            ((JPasswordField)this.propertyField).setEchoChar('*');
        } else if (!this.masked && this.propertyField instanceof JPasswordField) {
            this.propertyField = new JTextField();
        }
        if (this.masked && this.propertyValue == null) {
            this.propertyField.setText(null);
        } else {
            this.propertyField.setText(this.getAsText());
        }
        return this.propertyField;
    }

    protected Component initCustomButton() {
        if (this.customButton == null) {
            this.customButton = new JButton("...");
            this.customButton.setMargin(new Insets(0, 2, 0, 2));
        }
        return this.customButton;
    }

    protected Component initFocusControl(int index) {
        if (index == START) {
            if (this.startFocusComponent == null) {
                this.startFocusComponent = new FocusComponent();
            }
            return this.startFocusComponent;
        }
        if (this.endFocusComponent == null) {
            this.endFocusComponent = new FocusComponent();
        }
        return this.endFocusComponent;
    }

    protected void addSpacerComponent() {
        JLabel spacerComp = new JLabel();
        spacerComp.setPreferredSize(new Dimension(3, 1));
        if (this.getComponentCount() != 0) {
            this.add(spacerComp);
        }
    }

    protected void resetControls() {
        this.paintArea = null;
        this.propertyLabel = null;
        this.propertyField = null;
        this.propertyTags = null;
        this.propertyTagsModel = null;
        this.customButton = null;
    }

    protected void initializeControls() {
        this.controlsInitialized = true;
        this.removeListeners();
        this.removeAll();
        this.resetControls();
        PropertyEditor propEditor = this.getPropertyEditor();
        if (propEditor == null || this.propertyExceptionThrown) {
            this.layout.setRemainderColumn(1);
            this.add(this.initLabel());
            return;
        }
        boolean showPaintAreaOnly = false;
        if (propEditor.isPaintable()) {
            showPaintAreaOnly = true;
            this.add(this.initPaintArea());
        }
        int remainderColumn = 1;
        String[] tags = propEditor.getTags();
        if (this.isReadOnly() || !this.alwaysShowControls) {
            this.addSpacerComponent();
            this.add(this.initLabel());
            String labelText = this.propertyLabel.getText();
            if (labelText != null && labelText.length() > 0) {
                showPaintAreaOnly = false;
            }
            remainderColumn = this.getComponentCount();
        } else {
            if (tags != null) {
                this.addSpacerComponent();
                this.add(this.initPropertyTags());
                showPaintAreaOnly = false;
            } else if (propEditor.getAsText() != null) {
                this.addSpacerComponent();
                this.add(this.initPropertyField());
                showPaintAreaOnly = false;
            }
            remainderColumn = this.getComponentCount();
            if (propEditor.supportsCustomEditor()) {
                this.addSpacerComponent();
                this.add(this.initCustomButton());
                showPaintAreaOnly = false;
            }
            this.addListeners();
        }
        if (showPaintAreaOnly) {
            remainderColumn = 1;
        }
        this.layout.setRemainderColumn(remainderColumn);
        this.validate();
    }

    protected void addListeners() {
        if (this.propertyTags != null) {
            this.propertyTags.addActionListener(this);
        }
        if (this.propertyField != null) {
            this.propertyField.addActionListener(this);
            this.propertyFieldFocusAdapter = new PropertyFieldFocusAdapter();
            this.propertyField.addFocusListener(this.propertyFieldFocusAdapter);
        }
        if (this.customButton != null) {
            this.customButton.addActionListener(this);
        }
    }

    protected void removeListeners() {
        if (this.propertyTags != null) {
            this.propertyTags.removeActionListener(this);
        }
        if (this.propertyField != null) {
            this.propertyField.removeActionListener(this);
            this.propertyField.removeFocusListener(this.propertyFieldFocusAdapter);
        }
        if (this.customButton != null) {
            this.customButton.removeActionListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(boolean forceUpdate) {
        if (this.editMode && !forceUpdate) {
            return;
        }
        PropertyEditor propEditor = this.getPropertyEditor();
        if (this.bean != null) {
            Object value = null;
            if (!this.indexed) {
                value = com.sas.beans.Util.getPropertyValue((Object)this.bean, (String)this.property);
            }
            if (propEditor == null) {
                this.propertyValue = value;
                this.resetControls();
                this.initializeControls();
                return;
            }
            Object propertyEditorValue = propEditor.getValue();
            if (!this.writeOnly && com.sas.util.Util.unequal((Object)propertyEditorValue, (Object)value)) {
                propEditor.setValue(value);
            }
        }
        try {
            this.updateValue = true;
            if (this.propertyLabel != null) {
                String txt = this.getAsText();
                if (this.masked) {
                    txt = this.maskText(txt);
                }
                this.propertyLabel.setText(txt);
            }
            if (this.propertyTagsModel != null) {
                this.readTags(propEditor.getTags());
            }
            if (this.propertyField != null) {
                this.propertyField.setText(this.getAsText());
            }
            if (this.paintArea != null) {
                this.paintArea.repaint();
            }
        }
        finally {
            this.updateValue = false;
        }
    }

    public void handleException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (this.propertyField != null) {
            this.propertyField.removeFocusListener(this.propertyFieldFocusAdapter);
        }
        SystemLog.logException((String)Message.format((String)RB.getStringResource(RB_KEY, "unableToSetProperty.txt"), (Object)this.property), (Throwable)e);
        Frame frame = Util.getParentAWTFrame((Component)this);
        if (frame == null) {
            frame = new Frame();
        }
        JOptionPane pane = new JOptionPane(Message.format((String)RB.getStringResource(RB_KEY, "unableToSetValue.txt"), (Object)this.property, e.getClass(), (Object)e.getMessage()), 1);
        final JDialog dialog = pane.createDialog(frame, RB.getStringResource(RB_KEY, "note.txt"));
        Util.centerOver((Window)dialog, (Component)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.show();
            }
        });
        if (this.propertyField != null) {
            this.propertyField.addFocusListener(this.propertyFieldFocusAdapter);
        }
        this.updateValue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTextValue() {
        String text;
        PropertyEditor propEditor = this.getPropertyEditor();
        if (propEditor == null || this.propertyField == null || this.updateValue) {
            return;
        }
        String oldText = this.getAsText();
        if (com.sas.util.Util.unequal((Object)oldText, (Object)(text = this.propertyField.getText()))) {
            try {
                this.updateEditor = true;
                this.propertyEditor.setAsText(text);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            finally {
                this.updateEditor = false;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        if (eSource == this.propertyField) {
            this.updateTextValue();
        } else if (eSource == this.propertyTags) {
            this.updateSelectedTag();
        } else if (eSource == this.customButton) {
            this.showCustomEditor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelectedTag() {
        String text;
        PropertyEditor propEditor = this.getPropertyEditor();
        if (propEditor == null || this.updateValue) {
            return;
        }
        String oldText = this.getAsText();
        if (com.sas.util.Util.unequal((Object)oldText, (Object)(text = (String)this.propertyTagsModel.getSelectedItem()))) {
            try {
                this.updateEditor = true;
                this.propertyEditor.setAsText(text);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            finally {
                this.updateEditor = false;
            }
        }
    }

    protected String getCustomizerTitle() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showCustomEditor() {
        Component customEditor;
        Window customEditorWindow = null;
        PropertyEditor propEditor = this.getPropertyEditor();
        if (propEditor instanceof ParentWindowRequestor) {
            ((ParentWindowRequestor)propEditor).setParentWindow((Window)this.getContainingFrame());
        }
        if ((customEditor = propEditor.getCustomEditor()) instanceof Window) {
            customEditorWindow = (Window)customEditor;
        } else if (customEditor == null) {
            Object value = com.sas.beans.Util.getPropertyValue((Object)this.bean, (String)this.property);
            if (value == null) {
                this.handleException((Throwable)new ComponentException(RB.getStringResource(RB_KEY, "noCustomEditor.txt")));
                return;
            }
            customEditorWindow = SwingCustomizerUtil.getCustomizerDialog(value, customEditor, this.getContainingFrame());
        } else if (customEditor != null) {
            customEditorWindow = SwingCustomizerUtil.getCustomizerDialog(this.getPropertyEditor().getValue(), customEditor, this.getContainingFrame());
            Dimension prefSize = customEditor.getPreferredSize();
            Dimension curSize = customEditorWindow.getSize();
            Dimension newSize = new Dimension();
            newSize.width = Math.max(curSize.width, prefSize.width);
            newSize.height = Math.max(curSize.height, prefSize.height);
            customEditorWindow.setSize(newSize);
        }
        if (customEditorWindow == null) {
            this.handleException((Throwable)new ComponentException(RB.getStringResource(RB_KEY, "errorCreatingEditor.txt")));
            return;
        }
        if (customEditor instanceof SwingCustomizerView) {
            ((SwingCustomizerView)customEditor).setViewer(this.bean);
        }
        if (customEditorWindow instanceof Dialog) {
            ((Dialog)customEditorWindow).setModal(true);
            String customTitle = this.getCustomizerTitle();
            if (customTitle != null && customTitle.length() > 0) {
                ((Dialog)customEditorWindow).setTitle(customTitle);
            }
        }
        Util.centerOverWindow((Window)customEditorWindow, (Component)this);
        final Window editorWindow = customEditorWindow;
        customEditorWindow.addWindowListener(new WindowAdapter(){

            public void windowOpening(WindowEvent evt) {
                Window parentWindow = SwingUtilities.getWindowAncestor(PropertyEditorHost.this);
                if (parentWindow != null) {
                    Util.centerOver((Window)editorWindow, (Component)parentWindow);
                } else {
                    Util.centerOverWindow((Window)editorWindow, (Component)PropertyEditorHost.this);
                }
            }
        });
        IDEDnDManager.suspend(this.getContainingFrame());
        customEditorWindow.setVisible(true);
        IDEDnDManager.resume(this.getContainingFrame());
        this.propertyChange(new PropertyChangeEvent(this.propertyEditor, null, null, null));
        customEditorWindow.dispose();
        this.customButton.setEnabled(true);
        this.customButton.requestFocus();
    }

    protected Frame getContainingFrame() {
        Container component;
        for (component = this; component != null && !(component instanceof Frame); component = component.getParent()) {
        }
        if (component == null) {
            component = new Frame();
        }
        return (Frame)component;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.propertyEditor && e.getPropertyName() == null) {
            if (this.propertyLabel != null) {
                String txt = this.getAsText();
                if (this.masked) {
                    txt = this.maskText(txt);
                }
                this.propertyLabel.setText(txt);
            }
            if (this.propertyField != null) {
                this.propertyField.setText(this.getAsText());
            }
            if (this.propertyTagsModel != null && !this.updateEditor) {
                this.readTags(this.propertyEditor.getTags());
            }
            if (this.paintArea != null) {
                this.paintArea.repaint();
            }
            this.propertyValue = this.propertyEditor.getValue();
            this.firePropertyChange("propertyValue", null, this.propertyEditor.getValue());
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (this.editMode) {
            this.fireActionPerformed(new ActionEvent(this, 1001, EDITING_DONE));
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, EDITING_DONE, event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void startEditing() {
        this.editMode = true;
    }

    public void stopEditing() {
        if (this.editMode) {
            this.editMode = false;
            this.updateTextValue();
        }
    }

    protected void enableSubcomponents(boolean enabled) {
        if (!enabled) {
            Util.setEnabledOnContainer((Container)this, (boolean)enabled);
        } else {
            if (this.propertyLabel != null) {
                this.propertyLabel.setEnabled(!this.isReadOnly());
            }
            if (this.propertyField != null) {
                this.propertyField.setEnabled(!this.isReadOnly());
            }
            if (this.propertyTags != null) {
                this.propertyTags.setEnabled(!this.isReadOnly());
            }
        }
        if (this.customButton != null) {
            this.customButton.setEnabled(enabled);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableSubcomponents(enabled);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.propertyLabel != null) {
            this.propertyLabel.setForeground(color);
        }
        if (this.paintArea != null) {
            this.paintArea.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.propertyLabel != null) {
            this.propertyLabel.setBackground(color);
        }
        if (this.paintArea != null) {
            this.paintArea.setBackground(color);
        }
    }

    static {
        com.sas.beans.Util.prependToPropertyEditorSearchPath((String)"com.sas.beans.editors");
    }

    class PropertyEditorPaintArea
    extends JComponent {
        protected PropertyEditor editor;

        public PropertyEditorPaintArea() {
        }

        public PropertyEditorPaintArea(PropertyEditor editor) {
            this.editor = editor;
        }

        public void setPropertyEditor(PropertyEditor editor) {
            this.editor = editor;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.editor != null) {
                this.editor.paintValue(g, new Rectangle(0, 0, this.getSize().width, this.getSize().height));
            }
        }
    }

    class FocusComponent
    extends JComponent {
        FocusComponent() {
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }
    }

    class PropertyFieldFocusAdapter
    extends FocusAdapter {
        PropertyFieldFocusAdapter() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            PropertyEditorHost.this.updateTextValue();
        }
    }
}

