/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.beans.PropertyDescriptor;
import com.sas.swing.property.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.MinMaxSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PropertyDialog
extends JDialog
implements LayoutConstants {
    private transient java.beans.PropertyDescriptor _property;
    private transient JButton closeBtn;
    private transient Frame parentFrame;
    protected static final String RB_KEY = "PropertyDialog.";

    public PropertyDialog(JFrame frame, boolean modal, java.beans.PropertyDescriptor property) {
        super(frame, property.getDisplayName(), modal);
        this._property = property;
        this.createPropertyPanel();
    }

    private void createPropertyPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(3, 1, 5, 5, true, false, true);
        layout.setRemainderColumn(1);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)layout);
        if (pane instanceof JComponent) {
            ((JComponent)pane).setBorder(TAB_BORDER);
        } else {
            JPanel newPane = new JPanel();
            newPane.setBorder(TAB_BORDER);
            this.setContentPane(newPane);
        }
        JPanel generalPanel = new JPanel();
        AutoSizingGridLayout generalLayout = new AutoSizingGridLayout(1, 2, 20, 0);
        generalPanel.setLayout((LayoutManager)generalLayout);
        TitledBorder generalBorder = new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "genInfo.txt"));
        CompoundBorder generalCompoundBorder = new CompoundBorder(generalBorder, new EmptyBorder(5, 5, 5, 5));
        generalPanel.setBorder(generalCompoundBorder);
        this.getContentPane().add(generalPanel);
        JPanel leftGeneralPanel = new JPanel();
        AutoSizingGridLayout leftGeneralLayout = new AutoSizingGridLayout(-1, 1, 5, 5);
        leftGeneralPanel.setLayout((LayoutManager)leftGeneralLayout);
        generalPanel.add(leftGeneralPanel);
        JPanel rightGeneralPanel = new JPanel();
        AutoSizingGridLayout rightGeneralLayout = new AutoSizingGridLayout(-1, 1, 5, 5);
        int[] mins = new int[]{200};
        int[] maxs = new int[]{-1};
        rightGeneralLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new MinMaxSpacePartitioner(mins, maxs));
        rightGeneralPanel.setLayout((LayoutManager)rightGeneralLayout);
        generalPanel.add(rightGeneralPanel);
        JLabel nameLabel = new JLabel(RB.getStringResource(RB_KEY, "name.txt"));
        JLabel name = new JLabel(this._property.getName());
        leftGeneralPanel.add(nameLabel);
        rightGeneralPanel.add(name);
        JLabel displayNameLabel = new JLabel(RB.getStringResource(RB_KEY, "displayName.txt"));
        JLabel displayName = new JLabel(this._property.getDisplayName());
        leftGeneralPanel.add(displayNameLabel);
        rightGeneralPanel.add(displayName);
        JLabel shortDescriptionLabel = new JLabel(RB.getStringResource(RB_KEY, "shortDesc.txt"));
        JLabel shortDescription = new JLabel(this._property.getShortDescription());
        leftGeneralPanel.add(shortDescriptionLabel);
        rightGeneralPanel.add(shortDescription);
        if (this._property instanceof PropertyDescriptor) {
            JLabel descriptionLabel = new JLabel(RB.getStringResource(RB_KEY, "desc.txt"));
            JLabel description = new JLabel(((PropertyDescriptor)this._property).getDescription());
            leftGeneralPanel.add(descriptionLabel);
            rightGeneralPanel.add(description);
        }
        JLabel propertyTypeLabel = new JLabel(RB.getStringResource(RB_KEY, "propType.txt"));
        JLabel propertyType = new JLabel();
        if (this._property.getPropertyType() != null) {
            propertyType.setText(this._property.getPropertyType().getName());
        } else {
            propertyType.setText(RB.getStringResource(RB_KEY, "null.txt"));
        }
        leftGeneralPanel.add(propertyTypeLabel);
        rightGeneralPanel.add(propertyType);
        JLabel expertLabel = new JLabel(RB.getStringResource(RB_KEY, "expert.txt"));
        JLabel expert = new JLabel(String.valueOf(this._property.isExpert()));
        leftGeneralPanel.add(expertLabel);
        rightGeneralPanel.add(expert);
        JLabel preferredLabel = new JLabel(RB.getStringResource(RB_KEY, "preferred.txt"));
        JLabel preferred = new JLabel(String.valueOf(this._property.isPreferred()));
        leftGeneralPanel.add(preferredLabel);
        rightGeneralPanel.add(preferred);
        JPanel usagePanel = new JPanel();
        AutoSizingGridLayout usageLayout = new AutoSizingGridLayout(1, 2, 20, 0);
        usagePanel.setLayout((LayoutManager)usageLayout);
        TitledBorder usageBorder = new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "useInfo.txt"));
        CompoundBorder usageCompoundBorder = new CompoundBorder(usageBorder, new EmptyBorder(5, 5, 5, 5));
        usagePanel.setBorder(usageCompoundBorder);
        this.getContentPane().add(usagePanel);
        JPanel leftUsagePanel = new JPanel();
        AutoSizingGridLayout leftUsageLayout = new AutoSizingGridLayout(-1, 1, 5, 5);
        leftUsagePanel.setLayout((LayoutManager)leftUsageLayout);
        usagePanel.add(leftUsagePanel);
        JPanel rightUsagePanel = new JPanel();
        AutoSizingGridLayout rightUsageLayout = new AutoSizingGridLayout(-1, 1, 5, 5);
        rightUsagePanel.setLayout((LayoutManager)rightUsageLayout);
        usagePanel.add(rightUsagePanel);
        JLabel boundLabel = new JLabel(RB.getStringResource(RB_KEY, "bound.txt"));
        JLabel bound = new JLabel(String.valueOf(this._property.isBound()));
        leftUsagePanel.add(boundLabel);
        rightUsagePanel.add(bound);
        JLabel constrainedLabel = new JLabel(RB.getStringResource(RB_KEY, "constrained.txt"));
        JLabel constrained = new JLabel(String.valueOf(this._property.isConstrained()));
        leftUsagePanel.add(constrainedLabel);
        rightUsagePanel.add(constrained);
        if (this._property instanceof PropertyDescriptor) {
            JLabel linkableLabel = new JLabel(RB.getStringResource(RB_KEY, "linkable.txt"));
            JLabel linkable = new JLabel(String.valueOf(((PropertyDescriptor)this._property).isLinkable()));
            leftUsagePanel.add(linkableLabel);
            rightUsagePanel.add(linkable);
        }
        JLabel readMethodLabel = new JLabel(RB.getStringResource(RB_KEY, "readMethod.txt"));
        JLabel readMethod = new JLabel();
        if (this._property.getReadMethod() != null) {
            readMethod.setText(this._property.getReadMethod().getName());
        } else {
            readMethod.setText(RB.getStringResource(RB_KEY, "null.txt"));
        }
        leftUsagePanel.add(readMethodLabel);
        rightUsagePanel.add(readMethod);
        JLabel writeMethodLabel = new JLabel(RB.getStringResource(RB_KEY, "writeMethod.txt"));
        JLabel writeMethod = new JLabel();
        if (this._property.getWriteMethod() != null) {
            writeMethod.setText(this._property.getWriteMethod().getName());
        } else {
            writeMethod.setText(RB.getStringResource(RB_KEY, "null.txt"));
        }
        leftUsagePanel.add(writeMethodLabel);
        rightUsagePanel.add(writeMethod);
        JLabel propertyEditorClassLabel = new JLabel(RB.getStringResource(RB_KEY, "propEditor.txt"));
        JLabel propertyEditorClass = new JLabel();
        if (this._property.getPropertyEditorClass() != null) {
            propertyEditorClass.setText(this._property.getPropertyEditorClass().getName());
        } else {
            propertyEditorClass.setText(RB.getStringResource(RB_KEY, "null.txt"));
        }
        leftUsagePanel.add(propertyEditorClassLabel);
        rightUsagePanel.add(propertyEditorClass);
        leftGeneralLayout.setInterlockedColumnContainer((Container)leftUsagePanel);
        rightGeneralLayout.setInterlockedColumnContainer((Container)rightUsagePanel);
        leftUsageLayout.setInterlockedColumnContainer((Container)leftGeneralPanel);
        rightUsageLayout.setInterlockedColumnContainer((Container)rightGeneralPanel);
        JPanel closePanel = new JPanel();
        FlowLayout closeLayout = new FlowLayout(4);
        closePanel.setLayout(closeLayout);
        this.closeBtn = new JButton(RB.getStringResource(RB_KEY, "close.txt"));
        closePanel.add(this.closeBtn);
        this.getContentPane().add(closePanel);
        this.closeBtn.addActionListener(new PropertyDialogActionListener());
    }

    class PropertyDialogActionListener
    implements ActionListener {
        PropertyDialogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == PropertyDialog.this.closeBtn) {
                PropertyDialog.this.setVisible(false);
            }
        }
    }
}

