/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.swing.property.DrillAction;
import com.sas.swing.property.DrillInfo;
import com.sas.swing.property.PropertySheetTable;
import com.sas.swing.property.PropertyTableModel;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import java.util.Stack;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DrillUpAction
extends DrillAction
implements ChangeListener {
    public DrillUpAction(String name, Stack compStack, PropertySheetTable table) {
        super(name, compStack, table);
        this.updateEnabled();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.drillUp();
    }

    protected void drillUp() {
        if (this.objStack != null && !this.objStack.empty()) {
            if (this.propTable.isEditing() && !this.propTable.getCellEditor().stopCellEditing()) {
                return;
            }
            DrillInfo info = (DrillInfo)this.objStack.pop();
            this.propTable.setObjects(info.objects);
            PropertyTableModel propModel = (PropertyTableModel)this.propTable.getModel();
            PropertyDescriptor propDesc = propModel.getPropertyDescriptor(info.rowIndex);
            if (!info.name.equals(propDesc.getName())) {
                info.rowIndex = -1;
                for (int i = 0; i < propModel.getRowCount(); ++i) {
                    propDesc = propModel.getPropertyDescriptor(i);
                    if (!info.name.equals(propDesc.getName())) continue;
                    info.rowIndex = i;
                    break;
                }
            }
            if (info.rowIndex != -1) {
                this.propTable.changeSelection(info.rowIndex, info.rowIndex, false, false);
            } else {
                this.propTable.clearSelection();
            }
            this.updateEnabled();
            this.fireStateChanged();
        }
    }

    protected void updateEnabled() {
        if (this.objStack == null || this.objStack.empty()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

