/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.Tree;
import com.sas.models.TreeInterface;
import com.sas.swing.models.TreeNodeAdapter;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.util.transforms.DisplayTransformInterface;
import com.sas.util.transforms.TransformInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeModelAdapter
implements TreeModel,
ContentsChangedListener,
PropertyChangeSource,
ViewDefaultModel,
DisplayTransformInterface {
    protected boolean defaultModelAttached;
    protected TreeNode root;
    protected TreeInterface model;
    protected List propertyChangeListenersList;
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport propertyChangeSupport;
    protected TransformInterface displayTransform;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "model";
        ebi.defaultOutputPropertyName = "model";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public TreeModelAdapter() {
        this.setModel(null);
    }

    public TreeModelAdapter(TreeInterface table) {
        this.setModel(table);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        if (this.propertyChangeListenersList == null) {
            this.propertyChangeListenersList = new ArrayList();
        }
        this.propertyChangeListenersList.add(listener);
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
        if (this.propertyChangeListenersList != null) {
            this.propertyChangeListenersList.remove(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    protected TreeNode newTreeNode(SimpleNodeInterface node) {
        return new TreeNodeAdapter(node, this.getDisplayTransform());
    }

    protected TreeInterface newDefaultModel() {
        this.setDefaultModelAttached(true);
        return new Tree((NodeInterface)new Node());
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModelAttached;
    }

    protected void setDefaultModelAttached(boolean defaultModelUsed) {
        if (defaultModelUsed != this.defaultModelAttached) {
            this.defaultModelAttached = defaultModelUsed;
            this.firePropertyChange("defaultModelAttached", new Boolean(!this.defaultModelAttached), new Boolean(this.defaultModelAttached));
        }
    }

    public TreeInterface getModel() {
        return this.model;
    }

    public void setModel(TreeInterface tree) {
        boolean defaultModelUsed = false;
        if (tree == null) {
            defaultModelUsed = true;
            tree = this.newDefaultModel();
        }
        if (this.model != tree) {
            if (this.model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.model).removeContentsChangedListener((ContentsChangedListener)this);
            }
            TreeInterface oldModel = this.model;
            this.model = tree;
            this.root = this.newTreeNode((SimpleNodeInterface)this.model.getRoot());
            if (this.model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.model).addContentsChangedListener((ContentsChangedListener)this);
            }
            if (!defaultModelUsed) {
                this.setDefaultModelAttached(false);
            }
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
            this.firePropertyChange("model", oldModel, this.model);
        }
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(TransformInterface newTransform) {
        if (this.displayTransform != newTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = newTransform;
            this.root = this.newTreeNode((SimpleNodeInterface)this.model.getRoot());
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
            this.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        this.root = this.newTreeNode((SimpleNodeInterface)this.model.getRoot());
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeNode child = new DefaultMutableTreeNode();
        try {
            if (parent instanceof SimpleNodeInterface) {
                child = this.newTreeNode(((SimpleNodeInterface)parent).getNodeChild(index));
            } else if (parent instanceof TreeNode) {
                child = ((TreeNode)parent).getChildAt(index);
            }
        }
        catch (Exception e) {
            System.out.println(" exception thrown " + e);
        }
        return child;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        if (parent instanceof SimpleNodeInterface) {
            count = ((SimpleNodeInterface)parent).getNodeChildCount();
            if (count < 0) {
                count = 0;
            }
        } else if (parent instanceof TreeNode) {
            count = ((TreeNode)parent).getChildCount();
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index = 0;
        if (parent instanceof SimpleNodeInterface) {
            SimpleNodeInterface node = (SimpleNodeInterface)parent;
            SimpleNodeInterface[] children = node.getNodeChildren(0, node.getNodeChildCount());
            for (int i = 0; i < children.length; ++i) {
                if (!child.equals(children[i])) continue;
                index = i;
                break;
            }
        } else if (parent instanceof TreeNode && child instanceof TreeNode) {
            index = ((TreeNode)parent).getIndex((TreeNode)child);
        }
        return index;
    }

    @Override
    public Object getRoot() {
        if (this.root == null || this.root instanceof TreeNodeAdapter && this.getModel().getRoot() != ((TreeNodeAdapter)this.root).getModel()) {
            this.root = this.newTreeNode((SimpleNodeInterface)this.getModel().getRoot());
        }
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof SimpleNodeInterface) {
            return ((SimpleNodeInterface)node).isLeafNode();
        }
        if (node instanceof TreeNode) {
            return ((TreeNode)node).isLeaf();
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fireTreeNodesChanged(new TreeModelEvent(newValue, path));
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList.getListenerCount(TreeModelListener.class) > 0) {
            this.fireTreeNodesChanged(new TreeModelEvent(source, path, childIndices, children));
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(event);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList.getListenerCount(TreeModelListener.class) > 0) {
            this.fireTreeNodesInserted(new TreeModelEvent(source, path, childIndices, children));
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList.getListenerCount(TreeModelListener.class) > 0) {
            this.fireTreeNodesRemoved(new TreeModelEvent(source, path, childIndices, children));
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(event);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList.getListenerCount(TreeModelListener.class) > 0) {
            this.fireTreeStructureChanged(new TreeModelEvent(source, path, childIndices, children));
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        if (PropertyChangeListener.class.isAssignableFrom(listenerType) && this.propertyChangeListenersList != null) {
            return (EventListener[])this.propertyChangeListenersList.toArray();
        }
        return this.listenerList.getListeners(listenerType);
    }
}

