/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.dialogs.remote;

import com.sas.swing.dialogs.remote.FormatHandlerInterface;
import com.sas.swing.dialogs.remote.RB;
import com.sas.text.FormatDescription;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class SASFormatHandler
implements FormatHandlerInterface {
    private FormatDescription _item;
    protected static final String RB_KEY = "SASFormatHandler.";
    public static final int NUMERIC_FORMATS = 1;
    public static final int DATETIME_FORMATS = 2;
    public static final int CHARACTER_FORMATS = 3;
    public static final int USERDEFINED_FORMATS = 4;
    public static final int ALL_FORMATS = 5;

    SASFormatHandler() {
    }

    @Override
    public void setSelectedFormat(Object item) {
        if (item instanceof FormatDescription) {
            this._item = (FormatDescription)item;
        }
    }

    @Override
    public String[] getCategories() {
        String[] catData = new String[]{RB.getStringResource(RB_KEY, "Numeric.txt"), RB.getStringResource(RB_KEY, "DateTime.txt"), RB.getStringResource(RB_KEY, "Character.txt"), RB.getStringResource(RB_KEY, "All.txt")};
        return catData;
    }

    @Override
    public String getFormatDescription() {
        return this._item.getDescription();
    }

    @Override
    public Object[] getFormats(int category) {
        if (category != -1) {
            ArrayList<FormatDescription> al = new ArrayList<FormatDescription>();
            if (category == 1) {
                al.addAll(Arrays.asList(SASNumericFormat.getDescriptions()));
            } else if (category == 3) {
                al.addAll(Arrays.asList(SASCharacterFormat.getDescriptions()));
            } else if (category == 2) {
                al.addAll(Arrays.asList(SASDateTimeFormat.getDescriptions()));
            } else if (category == 5) {
                al.addAll(Arrays.asList(SASNumericFormat.getDescriptions()));
                al.addAll(Arrays.asList(SASCharacterFormat.getDescriptions()));
                al.addAll(Arrays.asList(SASDateTimeFormat.getDescriptions()));
            }
            Object[] a = al.toArray();
            return a;
        }
        return new Object[0];
    }

    @Override
    public boolean isDecimalWidthSupported() {
        if (this._item == null) {
            return false;
        }
        return this._item.isDecimalWidthSupported();
    }

    @Override
    public ListCellRenderer getCellRenderer() {
        return new MyCellRenderer();
    }

    @Override
    public int getDefaultDecimalWidth() {
        return 0;
    }

    @Override
    public int getDefaultWidth() {
        if (this._item == null) {
            return 0;
        }
        return this._item.getDefaultWidth();
    }

    @Override
    public int getMaxWidth() {
        if (this._item == null) {
            return 0;
        }
        return this._item.getMaxWidth();
    }

    @Override
    public int getMinWidth() {
        if (this._item == null) {
            return 0;
        }
        return this._item.getMinWidth();
    }

    @Override
    public int getMaxDValue() {
        if (this._item == null) {
            return 0;
        }
        return this._item.getMaxDValue();
    }

    @Override
    public int getMinDValue() {
        if (this._item == null) {
            return 0;
        }
        return this._item.getMinDValue();
    }

    @Override
    public String getSample(int width, int decimal) {
        SASFormat formatter;
        String sample = " ";
        if (this._item != null && (formatter = SASFormat.getInstance((String)this._item.getBaseFormatName(), (int)width, (int)decimal)) != null) {
            sample = formatter instanceof SASNumericFormat || formatter instanceof SASDateTimeFormat ? formatter.format((Object)new Double(1234.123456789)) : formatter.format((Object)new String("abcdefgh"));
        }
        return sample;
    }

    @Override
    public String getBaseFormatName(Object format) {
        if (format instanceof SASFormat) {
            return ((SASFormat)format).getBaseFormatName();
        }
        if (format instanceof FormatDescription) {
            return ((FormatDescription)format).getBaseFormatName();
        }
        return " ";
    }

    @Override
    public int getWidth(Object format) {
        if (format instanceof SASFormat) {
            return ((SASFormat)format).getWidth();
        }
        return 0;
    }

    @Override
    public int getDecimalWidth(Object format) {
        if (format instanceof SASFormat) {
            return ((SASFormat)format).getDecimalWidth();
        }
        return 0;
    }

    @Override
    public String getCategoryName(int category) {
        String categoryString = category == 1 ? RB.getStringResource(RB_KEY, "Numeric.txt") : (category == 3 ? RB.getStringResource(RB_KEY, "DateTime.txt") : (category == 2 ? RB.getStringResource(RB_KEY, "Character.txt") : RB.getStringResource(RB_KEY, "All.txt")));
        return categoryString;
    }

    @Override
    public int getCategory(Object o) {
        int category = -1;
        if (o instanceof SASFormat) {
            category = o instanceof SASNumericFormat ? 1 : (o instanceof SASDateTimeFormat ? 2 : (o instanceof SASCharacterFormat ? 3 : 5));
        } else if (o instanceof String) {
            category = o.equals(RB.getStringResource(RB_KEY, "Numeric.txt")) ? 1 : (o.equals(RB.getStringResource(RB_KEY, "Character.txt")) ? 3 : (o.equals(RB.getStringResource(RB_KEY, "DateTime.txt")) ? 2 : 5));
        }
        return category;
    }

    @Override
    public boolean isUserDefined(int category) {
        return false;
    }

    @Override
    public Object getSelectedFormat(int width, int decimal) {
        if (this._item != null) {
            SASFormat format = SASFormat.getInstance((String)this._item.getBaseFormatName(), (int)width, (int)decimal);
            return format;
        }
        return null;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof FormatDescription) {
                this.setText(((FormatDescription)value).getBaseFormatName());
            } else {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            if (index != -1) {
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
            }
            return this;
        }
    }
}

