/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.dialogs.remote;

import com.sas.iom.SAS.BaseType;
import com.sas.iom.SAS.BaseTypeSeqHolder;
import com.sas.iom.SAS.IFormatEnumerator;
import com.sas.iom.SAS.IFormatService;
import com.sas.iom.SAS.IFormatServicePackage.FormattingMethod;
import com.sas.iom.SAS.IFormatServicePackage.FormattingMethodSeqHolder;
import com.sas.iom.SAS.IFormatServicePackage.IFType;
import com.sas.iom.SAS.IFormatServicePackage.IFTypeSeqHolder;
import com.sas.iom.SAS.IFormatServicePackage.ImplType;
import com.sas.iom.SAS.IFormatServicePackage.ImplTypeSeqHolder;
import com.sas.iom.SAS.IFormatServicePackage.NameMatchOp;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.swing.dialogs.remote.FormatHandlerInterface;
import com.sas.swing.dialogs.remote.RB;
import com.sas.text.BaseSASFormat;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import org.omg.CORBA.IntHolder;

class IOMFormatHandler
implements FormatHandlerInterface {
    private IFType[] IFTypes;
    private String[] canonicalNames;
    private BaseType[] baseTypes;
    private int[] minWidths;
    private int[] maxWidths;
    private int[] defaultWidths;
    private int[] minDecimals;
    private int[] maxDecimals;
    private int[] defaultDecimals;
    private int[] justifications;
    private ImplType[] implTypes;
    private FormattingMethod[] formattingMethods;
    private String[] correspondings;
    private String[] keywords;
    private String[] descriptions;
    private String[] examples;
    private int numFormats;
    private IFormatService _format;
    private String _item;
    private int _selectedFormat;
    protected static final String RB_KEY = "SASFormatHandler.";
    public static final int NUMERIC_FORMATS = 1;
    public static final int DATETIME_FORMATS = 2;
    public static final int CHARACTER_FORMATS = 3;
    public static final int USERDEFINED_FORMATS = 4;
    public static final int ALL_FORMATS = 5;

    public IOMFormatHandler(IFormatService format) {
        this._format = format;
        this._selectedFormat = -1;
    }

    @Override
    public void setSelectedFormat(Object item) {
        this._item = (String)item;
        if (this.canonicalNames != null) {
            if (this._selectedFormat != -1 && this._selectedFormat < this.canonicalNames.length && this.canonicalNames[this._selectedFormat].equals(this._item)) {
                return;
            }
            for (int i = 0; i < this.numFormats; ++i) {
                if (!this.canonicalNames[i].equals(this._item)) continue;
                this._selectedFormat = i;
            }
        }
    }

    @Override
    public Object[] getFormats(int category) {
        ArrayList<FormattingMethod> filters = new ArrayList<FormattingMethod>();
        ArrayList<ImplType> impls = new ArrayList<ImplType>();
        if (category == 1) {
            filters.add(FormattingMethod.FormattingMethodNumeric);
            impls.add(ImplType.ImplTypeSASInstalled);
        } else if (category == 3) {
            filters.add(FormattingMethod.FormattingMethodCharacter);
            impls.add(ImplType.ImplTypeSASInstalled);
        } else if (category == 2) {
            filters.add(FormattingMethod.FormattingMethodDateTime);
            impls.add(ImplType.ImplTypeSASInstalled);
        } else if (category == 5) {
            filters.add(FormattingMethod.FormattingMethodNumeric);
            filters.add(FormattingMethod.FormattingMethodCharacter);
            filters.add(FormattingMethod.FormattingMethodDateTime);
            impls.add(ImplType.ImplTypeSASInstalled);
            impls.add(ImplType.ImplTypePROCFormat);
        } else if (category == 4) {
            filters.add(FormattingMethod.FormattingMethodNumeric);
            filters.add(FormattingMethod.FormattingMethodCharacter);
            filters.add(FormattingMethod.FormattingMethodDateTime);
            impls.add(ImplType.ImplTypePROCFormat);
        }
        ImplType[] ImplArray = new ImplType[]{};
        FormattingMethod[] FilterArray = new FormattingMethod[]{};
        FormattingMethod[] filter = filters.toArray(FilterArray);
        ImplType[] implFilter = impls.toArray(ImplArray);
        this.getInfo(filter, implFilter);
        return this.canonicalNames;
    }

    @Override
    public String[] getCategories() {
        String[] catData = new String[]{RB.getStringResource(RB_KEY, "Numeric.txt"), RB.getStringResource(RB_KEY, "DateTime.txt"), RB.getStringResource(RB_KEY, "Character.txt"), RB.getStringResource(RB_KEY, "UserDefined.txt"), RB.getStringResource(RB_KEY, "All.txt")};
        return catData;
    }

    @Override
    public ListCellRenderer getCellRenderer() {
        return new DefaultListCellRenderer();
    }

    @Override
    public String getFormatDescription() {
        if (this._selectedFormat == -1 || this.descriptions == null) {
            return " ";
        }
        return this.descriptions[this._selectedFormat];
    }

    @Override
    public boolean isDecimalWidthSupported() {
        return this._item != null;
    }

    @Override
    public int getDefaultDecimalWidth() {
        if (this._selectedFormat == -1 || this.defaultDecimals == null) {
            return 0;
        }
        return this.defaultDecimals[this._selectedFormat];
    }

    @Override
    public int getDefaultWidth() {
        if (this._selectedFormat == -1 || this.defaultWidths == null) {
            return 0;
        }
        return this.defaultWidths[this._selectedFormat];
    }

    @Override
    public int getMaxWidth() {
        if (this._selectedFormat == -1 || this.maxWidths == null) {
            return 0;
        }
        return this.maxWidths[this._selectedFormat];
    }

    @Override
    public int getMinWidth() {
        if (this._selectedFormat == -1 || this.minWidths == null) {
            return 0;
        }
        return this.minWidths[this._selectedFormat];
    }

    @Override
    public int getMaxDValue() {
        if (this._selectedFormat == -1 || this.maxDecimals == null) {
            return 0;
        }
        return this.maxDecimals[this._selectedFormat];
    }

    @Override
    public int getMinDValue() {
        if (this._selectedFormat == -1 || this.minDecimals == null) {
            return 0;
        }
        return this.minDecimals[this._selectedFormat];
    }

    @Override
    public String getSample(int width, int decimal) {
        if (this._selectedFormat == -1 || this.examples == null) {
            return " ";
        }
        return this.examples[this._selectedFormat];
    }

    @Override
    public String getCategoryName(int category) {
        String categoryString = category == 1 ? RB.getStringResource(RB_KEY, "Numeric.txt") : (category == 3 ? RB.getStringResource(RB_KEY, "DateTime.txt") : (category == 2 ? RB.getStringResource(RB_KEY, "Character.txt") : (category == 4 ? RB.getStringResource(RB_KEY, "UserDefined.txt") : RB.getStringResource(RB_KEY, "All.txt"))));
        return categoryString;
    }

    @Override
    public int getCategory(Object o) {
        int category = -1;
        if (o instanceof BaseSASFormat) {
            category = 5;
        } else if (o instanceof String) {
            category = o.equals(RB.getStringResource(RB_KEY, "Numeric.txt")) ? 1 : (o.equals(RB.getStringResource(RB_KEY, "Character.txt")) ? 3 : (o.equals(RB.getStringResource(RB_KEY, "DateTime.txt")) ? 2 : (o.equals(RB.getStringResource(RB_KEY, "UserDefined.txt")) ? 4 : 5)));
        }
        return category;
    }

    @Override
    public boolean isUserDefined(int category) {
        return category == 4;
    }

    @Override
    public String getBaseFormatName(Object format) {
        if (format instanceof BaseSASFormat) {
            return ((BaseSASFormat)format).getBaseFormatName();
        }
        if (format instanceof String) {
            return ((String)format).trim();
        }
        return " ";
    }

    @Override
    public int getWidth(Object format) {
        int width = 0;
        if (format instanceof BaseSASFormat) {
            return ((BaseSASFormat)format).getWidth();
        }
        return width;
    }

    @Override
    public int getDecimalWidth(Object format) {
        int decimal = 0;
        if (format instanceof BaseSASFormat) {
            return ((BaseSASFormat)format).getDecimalWidth();
        }
        return decimal;
    }

    @Override
    public Object getSelectedFormat(int width, int decimal) {
        if (this._selectedFormat == -1 || this.canonicalNames == null) {
            return null;
        }
        BaseSASFormat format = new BaseSASFormat(this.canonicalNames[this._selectedFormat].trim(), width, decimal);
        return format;
    }

    private void getInfo(FormattingMethod[] typeFilter, ImplType[] implTypesFilter) {
        try {
            IFType[] iFTypesFormatsFilter = new IFType[]{IFType.IFTypeFormat};
            IFType[] iFTypesInformatsFilter = new IFType[]{IFType.IFTypeInformat};
            IFType[] iFTypesBothFilter = new IFType[]{IFType.IFTypeFormat, IFType.IFTypeInformat};
            NameMatchOp op = NameMatchOp.NameMatchOpContains;
            String nameFilterString = "";
            BaseType[] baseTypesFilter = new BaseType[]{BaseType.BaseTypeNumeric, BaseType.BaseTypeCharacter};
            String keyword = "";
            IntHolder numberFound = new IntHolder();
            IFormatEnumerator iFE = this._format.EnumerateFormats(iFTypesFormatsFilter, op, nameFilterString, baseTypesFilter, implTypesFilter, keyword, typeFilter, numberFound);
            IFTypeSeqHolder IFTypesHolder = new IFTypeSeqHolder();
            StringSeqHolder canonicalNamesHolder = new StringSeqHolder();
            BaseTypeSeqHolder baseTypesHolder = new BaseTypeSeqHolder();
            LongSeqHolder minimumWidthsHolder = new LongSeqHolder();
            LongSeqHolder maximumWidthsHolder = new LongSeqHolder();
            LongSeqHolder defaultWidthsHolder = new LongSeqHolder();
            LongSeqHolder minimumDecimalsHolder = new LongSeqHolder();
            LongSeqHolder maximumDecimalsHolder = new LongSeqHolder();
            LongSeqHolder defaultDecimalsHolder = new LongSeqHolder();
            LongSeqHolder justificationsHolder = new LongSeqHolder();
            ImplTypeSeqHolder implTypesHolder = new ImplTypeSeqHolder();
            FormattingMethodSeqHolder formattingMethodsHolder = new FormattingMethodSeqHolder();
            StringSeqHolder correspondingsHolder = new StringSeqHolder();
            StringSeqHolder keywordsHolder = new StringSeqHolder();
            StringSeqHolder descriptionsHolder = new StringSeqHolder();
            StringSeqHolder examplesHolder = new StringSeqHolder();
            int startIndex = 0;
            iFE.CurrentIndex(0);
            int numToRead = this.numFormats = iFE.NumFormats();
            iFE.GetInfo(startIndex, numToRead, IFTypesHolder, canonicalNamesHolder, baseTypesHolder, minimumWidthsHolder, maximumWidthsHolder, defaultWidthsHolder, minimumDecimalsHolder, maximumDecimalsHolder, defaultDecimalsHolder, justificationsHolder, implTypesHolder, formattingMethodsHolder, correspondingsHolder, keywordsHolder, descriptionsHolder, examplesHolder);
            this.IFTypes = IFTypesHolder.value;
            this.canonicalNames = canonicalNamesHolder.value;
            this.baseTypes = baseTypesHolder.value;
            this.minWidths = minimumWidthsHolder.value;
            this.maxWidths = maximumWidthsHolder.value;
            this.defaultWidths = defaultWidthsHolder.value;
            this.minDecimals = minimumDecimalsHolder.value;
            this.maxDecimals = maximumDecimalsHolder.value;
            this.defaultDecimals = defaultDecimalsHolder.value;
            this.justifications = justificationsHolder.value;
            this.implTypes = implTypesHolder.value;
            this.formattingMethods = formattingMethodsHolder.value;
            this.correspondings = correspondingsHolder.value;
            this.keywords = keywordsHolder.value;
            this.descriptions = descriptionsHolder.value;
            this.examples = examplesHolder.value;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

