/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.dialogs.remote;

import com.sas.awt.util.Util;
import com.sas.iom.SAS.IWorkspace;
import com.sas.swing.dialogs.remote.FormatHandlerInterface;
import com.sas.swing.dialogs.remote.IOMFormatHandler;
import com.sas.swing.dialogs.remote.RB;
import com.sas.swing.dialogs.remote.SASFormatHandler;
import com.sas.swing.visuals.SpinBox;
import com.sas.text.SASFormat;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormatPanel
extends JPanel
implements ListSelectionListener,
AdjustmentListener {
    FormatHandlerInterface _formatHandler;
    protected transient Object _format;
    protected transient SASFormat formatter;
    private transient JList formatlist;
    private transient JLabel extext;
    private transient JLabel descLabel;
    private transient JLabel rngtext;
    private transient JList catList;
    private transient SpinBox wspin;
    private transient SpinBox dspin;
    private transient Object item;
    private transient int category;
    private transient ListSelectionModel catSM;
    private transient ListSelectionModel formatSM;
    protected static final String RB_KEY = "FormatPanel.";

    public FormatPanel(SASFormat format) {
        this._formatHandler = new SASFormatHandler();
        this._format = format;
        this.category = -1;
        this.item = null;
        if (this._format != null) {
            this.category = this._formatHandler.getCategory(this._format);
        }
        this.setup();
    }

    public FormatPanel(IWorkspace iWorkspace) {
        this(iWorkspace, null);
    }

    public FormatPanel(IWorkspace iWorkspace, Object format) {
        this._format = format;
        this._formatHandler = new IOMFormatHandler(iWorkspace.Utilities().FormatService());
        this.category = format == null ? -1 : this._formatHandler.getCategory(format);
        this.item = null;
        this.setup();
    }

    public void setup() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 10, true, true, true);
        layout.setRemainderRow(1);
        this.setLayout((LayoutManager)layout);
        if (this._format != null) {
            this.createNewPanel();
            if (this.category != -1) {
                this.selectCategory();
                this.selectFormat();
            }
        } else {
            this.createNewPanel();
        }
    }

    private void createNewPanel() {
        JPanel listpanel = new JPanel();
        AutoSizingGridLayout listLayout = new AutoSizingGridLayout(2, 2, 5, 0, true, true, true);
        listLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new EqualSpacePartitioner(true));
        listpanel.setLayout((LayoutManager)listLayout);
        JLabel label = new JLabel(RB.getStringResource(RB_KEY, "availableCategories.txt"));
        listpanel.add(label);
        JLabel availFormatLabel = new JLabel(RB.getStringResource(RB_KEY, "availableFormats.txt"));
        listpanel.add(availFormatLabel);
        this.catList = new JList();
        JScrollPane catScroll = new JScrollPane(this.catList);
        listpanel.add(catScroll);
        this.catSM = this.catList.getSelectionModel();
        this.catSM.addListSelectionListener(this);
        this.fillCategoryList(this._formatHandler.getCategories());
        this.formatlist = new JList();
        this.formatlist.setCellRenderer(this._formatHandler.getCellRenderer());
        JScrollPane formatScroll = new JScrollPane(this.formatlist);
        listpanel.add(formatScroll);
        this.formatSM = this.formatlist.getSelectionModel();
        this.formatlist.setSelectionMode(0);
        this.formatSM.addListSelectionListener(this);
        this.add(listpanel);
        JPanel detExPanel = new JPanel();
        AutoSizingGridLayout detExLayout = new AutoSizingGridLayout(3, 1, 5, 0, true, true, true);
        detExPanel.setLayout((LayoutManager)detExLayout);
        JPanel detailsPanel = new JPanel();
        AutoSizingGridLayout detailsLayout = new AutoSizingGridLayout(4, 2, 10, 10, true, false, true);
        detailsPanel.setLayout((LayoutManager)detailsLayout);
        EtchedBorder border = new EtchedBorder();
        detailsPanel.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "details.txt"), (int)4, (int)10, (int)10, (int)10));
        JLabel rangeLabel = new JLabel();
        rangeLabel.setText(RB.getStringResource(RB_KEY, "range.txt"));
        detailsPanel.add(rangeLabel);
        this.rngtext = new JLabel(" ");
        detailsPanel.add(this.rngtext);
        JLabel widthLabel = new JLabel();
        widthLabel.setText(RB.getStringResource(RB_KEY, "width.txt"));
        detailsPanel.add(widthLabel);
        this.wspin = new SpinBox();
        this.wspin.addAdjustmentListener(this);
        NumberFormat nf = NumberFormat.getInstance();
        this.wspin.setNumberFormat(nf);
        detailsPanel.add(this.wspin);
        JLabel decimalLabel = new JLabel();
        decimalLabel.setText(RB.getStringResource(RB_KEY, "decimal.txt"));
        detailsPanel.add(decimalLabel);
        this.dspin = new SpinBox();
        this.dspin.addAdjustmentListener(this);
        this.dspin.setNumberFormat(nf);
        detailsPanel.add(this.dspin);
        detExPanel.add(detailsPanel);
        JPanel descPanel = new JPanel();
        AutoSizingGridLayout descLayout = new AutoSizingGridLayout(1, 1, 10, 10, true, false, true);
        descPanel.setLayout((LayoutManager)descLayout);
        EtchedBorder border3 = new EtchedBorder();
        descPanel.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "description.txt"), (int)4, (int)10, (int)10, (int)10));
        this.descLabel = new JLabel();
        descPanel.add(this.descLabel);
        detExPanel.add(descPanel);
        JPanel examplePanel = new JPanel();
        AutoSizingGridLayout exampleLayout = new AutoSizingGridLayout(1, 1, 10, 10, true, false, true);
        examplePanel.setLayout((LayoutManager)exampleLayout);
        EtchedBorder border2 = new EtchedBorder();
        examplePanel.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "example.txt"), (int)4, (int)10, (int)10, (int)10));
        this.extext = new JLabel(" ");
        examplePanel.add(this.extext);
        detExPanel.add(examplePanel);
        this.add(detExPanel);
    }

    protected void fillCategoryList(String[] catData) {
        this.catList.setListData(catData);
    }

    private void fillTable(Object[] formatData) {
        this.formatlist.setListData(formatData);
    }

    private void selectCategory() {
        String categoryString = (String)this.catList.getSelectedValue();
        if (categoryString == null && this.category > 0) {
            categoryString = this._formatHandler.getCategoryName(this.category);
            this.catList.setSelectedValue(categoryString, true);
            this.catList.ensureIndexIsVisible(this.catList.getSelectedIndex());
        }
    }

    private void selectFormat() {
        int selectedRow = this.formatlist.getSelectedIndex();
        if (selectedRow != -1) {
            this.item = this.formatlist.getSelectedValue();
        } else {
            String baseName = this._formatHandler.getBaseFormatName(this._format);
            if (baseName != null) {
                int width;
                this.item = null;
                ListModel lm = this.formatlist.getModel();
                for (int i = 0; i < lm.getSize(); ++i) {
                    if (!this._formatHandler.getBaseFormatName(lm.getElementAt(i)).equals(baseName)) continue;
                    this.formatlist.setSelectedIndex(i);
                    this.formatlist.ensureIndexIsVisible(i);
                    this.formatlist.revalidate();
                    break;
                }
                if ((width = this._formatHandler.getWidth(this._format)) >= 0) {
                    this.wspin.setValue(width);
                } else {
                    this.wspin.setValue(0);
                }
                int dec = this._formatHandler.getDecimalWidth(this._format);
                if (dec >= 0) {
                    this.dspin.setValue(dec);
                } else {
                    this.dspin.setValue(0);
                }
                this.checkWidth();
                this.checkDecimalWidth();
                this.setSample();
            } else {
                this.item = null;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (event.getSource() == this.formatSM) {
            if (this.formatlist.getSelectedIndex() < 0) {
                this.item = null;
            } else {
                if (this._formatHandler.isUserDefined(this.category)) {
                    this.dspin.setEnabled(false);
                    this.wspin.setEnabled(false);
                } else {
                    this.dspin.setEnabled(true);
                    this.wspin.setEnabled(true);
                }
                this.item = this.formatlist.getSelectedValue();
                this._formatHandler.setSelectedFormat(this.item);
                this.setRange();
                this.setDescription();
                this.setSample();
            }
        } else if (event.getSource() == this.catSM) {
            this.dspin.setValue(0);
            this.wspin.setValue(0);
            this.descLabel.setText(" ");
            this.extext.setText(" ");
            this.rngtext.setText(" ");
            this.dspin.setEnabled(false);
            this.wspin.setEnabled(false);
            this._formatHandler.setSelectedFormat(null);
            String categoryString = (String)this.catList.getSelectedValue();
            this.category = this._formatHandler.getCategory(categoryString);
            if (this.category != -1) {
                this.fillTable(this._formatHandler.getFormats(this.category));
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        if (event.getSource() == this.wspin) {
            this.checkWidth();
        } else if (event.getSource() == this.dspin) {
            this.checkDecimalWidth();
        }
        this.setSample();
    }

    private void checkWidth() {
        if (this.item != null) {
            int wval = this.wspin.getValue();
            int wmax = this._formatHandler.getMaxWidth();
            int wmin = this._formatHandler.getMinWidth();
            int dval = this.dspin.getValue();
            int dmax = this._formatHandler.getMaxDValue();
            int dmin = this._formatHandler.getMinDValue();
            if (wval > wmax) {
                this.wspin.setValue(wmax);
                this.dspin.setValue(0);
            }
            if (wval < wmin) {
                this.wspin.setValue(wmin);
            }
            if (dval + wval > wmax) {
                this.dspin.setValue(0);
                this.displayError();
            }
        }
    }

    private void checkDecimalWidth() {
        if (this.item != null) {
            int wval = this.wspin.getValue();
            int wmax = this._formatHandler.getMaxWidth();
            int wmin = this._formatHandler.getMinWidth();
            int dval = this.dspin.getValue();
            int dmax = this._formatHandler.getMaxDValue();
            int dmin = this._formatHandler.getMinDValue();
            if (dval > dmax) {
                this.dspin.setValue(Math.max(dmax, 0));
            }
            if (dval < dmin) {
                this.dspin.setValue(Math.max(dmin, 0));
            }
            if (dval >= wval) {
                this.dspin.setValue(dval - 1);
                this.displayError();
            }
            if (dval + wval > wmax) {
                this.dspin.setValue(0);
                this.displayError();
            }
        }
    }

    public void setRange() {
        if (this._formatHandler.isUserDefined(this.category)) {
            this.descLabel.setText(" ");
        } else if (this.item != null) {
            int minWidth = this._formatHandler.getMinWidth();
            int maxWidth = this._formatHandler.getMaxWidth();
            this.rngtext.setText(minWidth + "-" + maxWidth);
            this.wspin.setMaximum(maxWidth);
            this.wspin.setMinimum(minWidth);
            this.wspin.setValue(this._formatHandler.getDefaultWidth());
            if (this._formatHandler.isDecimalWidthSupported()) {
                int minDecWidth = this._formatHandler.getMinDValue();
                int maxDecWidth = this._formatHandler.getMaxDValue();
                this.dspin.setEnabled(true);
                if (minDecWidth == -1 || maxDecWidth == -1) {
                    this.dspin.setEnabled(false);
                    this.dspin.setValue(0);
                } else {
                    this.dspin.setMaximum(maxDecWidth);
                    this.dspin.setMinimum(minDecWidth);
                    this.dspin.setValue(0);
                }
            } else {
                this.dspin.setEnabled(false);
                this.dspin.setValue(0);
            }
        }
    }

    public void setDescription() {
        if (this._formatHandler.isUserDefined(this.category)) {
            this.descLabel.setText(RB.getStringResource(RB_KEY, "noDescAvailable.txt"));
        } else if (this.item != null) {
            this.descLabel.setText(this._formatHandler.getFormatDescription());
        }
    }

    public void setSample() {
        if (this._formatHandler.isUserDefined(this.category)) {
            this.extext.setText(RB.getStringResource(RB_KEY, "noExampleAvailable.txt"));
        } else if (this.item != null) {
            this.extext.setText(this._formatHandler.getSample(this.wspin.getValue(), this.dspin.getValue()));
        }
    }

    public void setFormatType(int formatType) {
        this.category = formatType;
        this.fillCategoryList(this._formatHandler.getCategories());
    }

    public long getFormatType() {
        return this.category;
    }

    public Object getFormat() {
        return this._formatHandler.getSelectedFormat(this.wspin.getValue(), this.dspin.getValue());
    }

    private void displayError() {
        String findError = RB.getStringResource(RB_KEY, "error.txt");
        Frame f = Util.getParentFrame(this);
        JOptionPane.showMessageDialog(f, findError, RB.getStringResource(RB_KEY, "errorTitle.txt"), 0);
    }
}

