/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.dialogs.remote;

import com.sas.beans.PropertyChangeSource;
import com.sas.iom.SAS.IWorkspace;
import com.sas.swing.dialogs.remote.FormatPanel;
import com.sas.swing.dialogs.remote.RB;
import com.sas.text.SASFormat;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FormatDialog
extends JDialog
implements PropertyChangeSource {
    protected static final String RB_KEY = "FormatDialog.";
    protected FormatPanel _panel;
    protected transient Object _format;
    protected transient IWorkspace _iWorkspace;
    protected transient Object _context;
    private ArrayList listeners = new ArrayList();
    protected static JFrame jf;

    public FormatDialog(Frame f, SASFormat format) {
        super(f, RB.getStringResource(RB_KEY, "title.txt"), true);
        this._format = format;
        this.createPanel();
    }

    public FormatDialog(Frame f, IWorkspace iWorkspace) {
        this(f, iWorkspace, null);
    }

    public FormatDialog(Frame f, IWorkspace iWorkspace, Object format) {
        super(f, RB.getStringResource(RB_KEY, "title.txt"), true);
        this._iWorkspace = iWorkspace;
        this._format = format;
        this.createPanel();
    }

    public void createPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 10, true, true, true);
        layout.setRemainderRow(1);
        this.getContentPane().setLayout((LayoutManager)layout);
        JPanel fp = new JPanel();
        AutoSizingGridLayout fpLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        fp.setLayout((LayoutManager)fpLayout);
        EmptyBorder fpborder = new EmptyBorder(10, 10, 0, 10);
        fp.setBorder(fpborder);
        this._panel = this._iWorkspace != null ? new FormatPanel(this._iWorkspace, this._format) : new FormatPanel((SASFormat)this._format);
        fp.add(this._panel);
        this.getContentPane().add("Center", fp);
        FlowLayout buttonLayout = new FlowLayout(4);
        JPanel buttonPanel = new JPanel(buttonLayout);
        EmptyBorder border = new EmptyBorder(0, 10, 10, 10);
        buttonPanel.setBorder(border);
        this.getContentPane().add("South", buttonPanel);
        JPanel buttons = new JPanel();
        GridLayout buttonsASGL = new GridLayout(1, 2, 5, 5);
        buttons.setLayout(buttonsASGL);
        buttonPanel.add(buttons);
        final JButton ok = new JButton(RB.getStringResource(RB_KEY, "okButton.txt"));
        buttons.add(ok);
        final JButton cancel = new JButton(RB.getStringResource(RB_KEY, "cancelButton.txt"));
        buttons.add(cancel);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = null;
                if (e.getSource() == cancel) {
                    FormatDialog.this.dispose();
                } else if (e.getSource() == ok) {
                    Object format = FormatDialog.this._panel.getFormat();
                    if (format != null) {
                        for (int i = 0; i < FormatDialog.this.listeners.size(); ++i) {
                            PropertyChangeListener listener = (PropertyChangeListener)FormatDialog.this.listeners.get(i);
                            PropertyChangeEvent fe = new PropertyChangeEvent(this, "FORMAT", null, format);
                            listener.propertyChange(fe);
                        }
                    }
                    FormatDialog.this.dispose();
                }
            }
        };
        ok.addActionListener(buttonListener);
        cancel.addActionListener(buttonListener);
        this.setResizable(true);
    }

    public void addPropertyListener(Object listener) {
        this.listeners.add(listener);
    }

    public void removePropertyListener(Object listener) {
        this.listeners.remove(listener);
    }
}

