/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.charts;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.models.RangeCollection;
import com.sas.models.RangeCollectionInterface;
import com.sas.swing.charts.DefaultRangeViewData;
import com.sas.swing.charts.RB;
import com.sas.swing.charts.RangeViewDataInterface;
import com.sas.swing.charts.RangeViewRendererInterface;
import com.sas.swing.charts.RangeViewStyle;
import com.sas.swing.charts.StandardRangeViewRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;

public class RangeView
extends JComponent
implements PropertyChangeListener,
ContentsChangedListener,
PropertyBagChangedListener {
    public static final String RB_KEY = "RangeView.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.models.RangeCollectionInterface"};
    protected RangeViewRendererInterface graphType = new StandardRangeViewRenderer();
    protected RangeViewDataInterface rangeViewData = new DefaultRangeViewData();
    protected RangeCollectionInterface rangeCollection = new RangeCollection();
    protected RangeViewStyle rangeViewStyle = new RangeViewStyle();
    static int defaultWidth = 280;
    static int defaultHeight = 160;

    public RangeView() {
        if (this.rangeViewData instanceof PropertyChangeSource) {
            ((PropertyChangeSource)this.rangeViewData).addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.rangeViewStyle.addPropertyBagChangedListener(this);
        this.rangeCollection.addContentsChangedListener((ContentsChangedListener)this);
        this.graphType.setData(this.rangeViewData);
        this.graphType.setStyle(this.rangeViewStyle);
        this.graphType.setRange(this.rangeCollection);
        this.setModel(this.rangeCollection);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public void contentsChanged(ContentsChangedEvent cev) {
        this.setRange(this.rangeCollection);
        this.repaint();
        this.firePropertyChange("rangeCollection", null, this.rangeCollection);
    }

    public RangeCollectionInterface getRange() {
        return this.rangeCollection;
    }

    public void setRange(RangeCollectionInterface newRangeCollection) {
        if (newRangeCollection == this.rangeCollection) {
            return;
        }
        if (newRangeCollection == null) {
            this.rangeCollection = new RangeCollection();
        }
        RangeCollectionInterface holder = this.rangeCollection;
        this.rangeCollection = newRangeCollection;
        if (this.rangeCollection != null) {
            this.rangeCollection.removeContentsChangedListener((ContentsChangedListener)this);
        }
        if (newRangeCollection != null) {
            newRangeCollection.addContentsChangedListener((ContentsChangedListener)this);
        }
        this.graphType.setRange(this.rangeCollection);
        this.repaint();
        this.firePropertyChange("rangeCollection", holder, newRangeCollection);
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public RangeCollectionInterface getModel() {
        return this.rangeCollection;
    }

    @Override
    public void addNotify() {
        Color fg;
        String fontName;
        super.addNotify();
        Font supFont = super.getFont();
        String string = fontName = supFont != null ? supFont.getName() : "SansSerif";
        if (this.rangeViewStyle.getValueFont() == null) {
            this.rangeViewStyle.setValueFont(new Font(fontName, 1, 16));
        }
        if (this.rangeViewStyle.getLabelFont() == null) {
            this.rangeViewStyle.setLabelFont(new Font(fontName, 0, 11));
        }
        if ((fg = super.getForeground()) == null) {
            fg = Color.black;
        }
        if (this.rangeViewStyle.getValueColor() == null) {
            this.rangeViewStyle.setValueColor(fg);
        }
        if (this.rangeViewStyle.getLabelColor() == null) {
            this.rangeViewStyle.setLabelColor(fg);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.repaint();
    }

    public void propertyBagChanged(PropertyBagChangedEvent e) {
        this.repaint();
    }

    public void setData(RangeViewDataInterface data) {
        if (this.rangeViewData instanceof PropertyChangeSource) {
            ((PropertyChangeSource)this.rangeViewData).removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.rangeViewData = data;
        this.graphType.setData(data);
        if (this.rangeViewData instanceof PropertyChangeSource) {
            ((PropertyChangeSource)this.rangeViewData).addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.repaint();
    }

    public RangeViewDataInterface getData() {
        return this.rangeViewData;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gc = (Graphics2D)g;
        this.graphType.paint(this, gc);
    }

    public void setStyle(RangeViewStyle style) {
        this.rangeViewStyle.removePropertyBagChangedListener(this);
        this.rangeViewStyle = style;
        this.graphType.setStyle(style);
        this.rangeViewStyle.addPropertyBagChangedListener(this);
        this.repaint();
    }

    public RangeViewRendererInterface getGraphType() {
        return this.graphType;
    }

    public void setGraphType(RangeViewRendererInterface renderer) {
        this.graphType = renderer;
        this.graphType.setData(this.rangeViewData);
        this.graphType.setStyle(this.rangeViewStyle);
        this.graphType.setRange(this.rangeCollection);
        this.repaint();
    }

    public RangeViewStyle getStyle() {
        return this.rangeViewStyle;
    }

    public void setModel(RangeCollectionInterface newRangeCollection) {
        RangeCollectionInterface oldModel = this.getModel();
        if (oldModel == newRangeCollection) {
            return;
        }
        if (newRangeCollection != null) {
            this.setRange(newRangeCollection);
        } else {
            this.setRange(new RangeCollection());
        }
        this.firePropertyChange("model", oldModel, newRangeCollection);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.rangeViewStyle == null) {
            return;
        }
        this.rangeViewStyle.setForeground(color);
    }
}

