/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.charts;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.collection.PropertyBag;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.swing.charts.RangeViewDataInterface;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.Format;

public class DefaultRangeViewData
implements RangeViewDataInterface,
PropertyChangeSource {
    private PropertyChangeSupport propertyChangeSupport;
    protected double value;
    protected double[] secondaryValues;
    protected Format displayValueFormat = null;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "value"}, {"Description", "value"}}, {{"Name", "numberSecondaryValues"}, {"Description", "number of secondary values displayed"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "value";
        ebi.defaultOutputPropertyName = "value";
        ebi.shortDescription = "value";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public DefaultRangeViewData() {
        this.init();
    }

    private void init() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.value = 0.0;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double newValue) {
        if (newValue == this.value) {
            return;
        }
        double holder = this.value;
        this.value = newValue;
        this.firePropertyChange("value", new Double(holder), new Double(newValue));
    }

    public void setSecondaryValues(double[] newValues) {
        double[] holder = this.secondaryValues;
        this.secondaryValues = newValues;
        this.firePropertyChange("secondaryValues", holder, newValues);
    }

    public void setValueAt(double newValue, int index) {
        if (this.secondaryValues == null) {
            this.secondaryValues = new double[1];
        }
        if (index >= this.secondaryValues.length) {
            return;
        }
        if (newValue == this.secondaryValues[index]) {
            return;
        }
        double holder = this.secondaryValues[index];
        this.secondaryValues[index] = newValue;
        this.firePropertyChange("secondaryValues", new Double(holder), new Double(newValue));
    }

    public double[] getSecondaryValues() {
        return this.secondaryValues;
    }

    @Override
    public int getDataCount() {
        if (this.secondaryValues == null) {
            return 1;
        }
        return this.secondaryValues.length + 1;
    }

    @Override
    public StaticPropertyBagInterface getDataAt(int index) {
        if (this.secondaryValues != null && index > this.secondaryValues.length) {
            return null;
        }
        if (this.secondaryValues == null && index > 0) {
            return null;
        }
        double tempValue = index == 0 ? this.value : this.secondaryValues[index - 1];
        PropertyBag pb = new PropertyBag();
        pb.set("value", (Object)new Double(tempValue));
        return pb;
    }

    @Override
    public Format getDisplayValueFormat() {
        return this.displayValueFormat;
    }

    public void setDisplayValueFormat(Format format) {
        this.displayValueFormat = format;
    }
}

