/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.swing.property.PropertySheetTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;

public class JTableMouseInputAdapter
implements MouseInputListener {
    private Component dispatchComponent;
    private boolean selectedOnPress;
    private JTable table;
    private int[] noRepostColumns;

    public JTableMouseInputAdapter(JTable jTable, int[] nonRepostColumns) {
        this.table = jTable;
        this.noRepostColumns = nonRepostColumns;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void setDispatchComponent(MouseEvent e) {
        Component editorComponent = this.table.getEditorComponent();
        Point p = e.getPoint();
        Point p2 = SwingUtilities.convertPoint(this.table, p, editorComponent);
        this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
    }

    private boolean repostEvent(MouseEvent e) {
        if (this.dispatchComponent == null || !this.table.isEditing()) {
            return false;
        }
        MouseEvent e2 = SwingUtilities.convertMouseEvent(this.table, e, this.dispatchComponent);
        this.dispatchComponent.dispatchEvent(e2);
        return true;
    }

    private void setValueIsAdjusting(boolean flag) {
        this.table.getSelectionModel().setValueIsAdjusting(flag);
        this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
    }

    private boolean shouldIgnore(MouseEvent e) {
        return e.isConsumed();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            this.selectedOnPress = false;
            return;
        }
        this.selectedOnPress = true;
        this.adjustFocusAndSelection(e);
        if (!SwingUtilities.isLeftMouseButton(e) && e.getSource() instanceof PropertySheetTable) {
            ((PropertySheetTable)e.getSource()).createPopupMenu();
            Point p = new Point(e.getPoint().x, e.getPoint().y);
            ((PropertySheetTable)e.getSource()).showPopup(p);
        }
    }

    void adjustFocusAndSelection(MouseEvent e) {
        if (this.shouldIgnore(e)) {
            return;
        }
        Point p = e.getPoint();
        int row = this.table.rowAtPoint(p);
        int column = this.table.columnAtPoint(p);
        if (column == -1 || row == -1) {
            return;
        }
        if (this.table.editCellAt(row, column, e)) {
            boolean columnFound = false;
            for (int i = 0; i < this.noRepostColumns.length; ++i) {
                if (this.noRepostColumns[i] != column) continue;
                columnFound = true;
                break;
            }
            if (columnFound) {
                this.dispatchComponent = null;
                Component editorComponent = this.table.getEditorComponent();
                editorComponent.requestFocus();
            } else {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            }
        } else if (this.table.isRequestFocusEnabled()) {
            this.table.requestFocus();
        }
        TableCellEditor editor = this.table.getCellEditor();
        if (editor == null || editor.shouldSelectCell(e)) {
            boolean adjusting = e.getID() == 501;
            this.setValueIsAdjusting(adjusting);
            this.table.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.selectedOnPress) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.repostEvent(e);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        } else {
            this.adjustFocusAndSelection(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.shouldIgnore(e)) {
            return;
        }
        this.repostEvent(e);
        TableCellEditor editor = this.table.getCellEditor();
        if (editor == null || editor.shouldSelectCell(e)) {
            Point p = e.getPoint();
            int row = this.table.rowAtPoint(p);
            int column = this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            this.table.changeSelection(row, column, false, true);
        }
    }
}

