/*
 * Decompiled with CFR 0.152.
 */
package com.sas.spedo.jdbc;

import com.sas.spedo.IBookmark;
import com.sas.spedo.ISpedoDSO;
import com.sas.spedo.ISpedoSchemaRowset;
import com.sas.spedo.SpedoException;
import com.sas.spedo.jdbc.JDBCDSO;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCSchemaRowset
implements ISpedoSchemaRowset {
    static final int NONE = 0;
    static final int COLUMNS = 1;
    int specialHandling = 0;
    protected JDBCDSO dso;
    Connection connection = null;
    ResultSet rs = null;
    ResultSetMetaData rsmd = null;
    Statement statement = null;
    String tableName = null;
    String className = null;
    String columnName = null;
    String columnLabel = null;
    int[] rstypes;
    int len;
    int accessMode = 0;
    int openMode = 0;
    int lockType = 0;
    int updateMode = 0;
    String format = null;
    String informat = null;
    boolean sortedby = false;
    boolean indexed = false;
    boolean getQueryResultsCalled = false;
    String byText = null;
    String orderByText = null;
    String whereText = null;
    String selectOption = null;
    private boolean start = false;
    private boolean end = false;
    protected boolean isOpen = false;
    String query = null;
    String bindCol = new String("*");
    String strCol = new String("*");
    boolean bind = false;
    private String password = null;
    boolean bof = true;
    boolean eof = false;
    boolean haveCount = false;
    int countRows = -1;
    int numCols = 0;
    int recordCache;

    public JDBCSchemaRowset() throws SpedoException {
    }

    public JDBCSchemaRowset(String tableName, JDBCDSO dso) throws SpedoException {
        this.dso = dso;
        this.connection = dso.connection;
        this.tableName = tableName;
    }

    public JDBCSchemaRowset(String tableName, String password, JDBCDSO dso) throws SpedoException {
        this.dso = dso;
        this.connection = dso.connection;
        this.tableName = tableName;
        this.password = password;
    }

    public JDBCSchemaRowset(ResultSet results, String tableName, JDBCDSO dso) throws SpedoException {
        this.dso = dso;
        this.connection = dso.connection;
        this.tableName = tableName;
        if (results == null) {
            System.err.println("SpedoWarning : JDBCSchemaRowset() : ResultSet is null. Creating Rowset.");
        } else {
            this.rs = results;
            try {
                this.rsmd = this.rs.getMetaData();
            }
            catch (SQLException e) {
                throw new SpedoException("SpedoException: JDBCSchemaRowset: " + e.getMessage());
            }
        }
        this.rstypes = new int[8];
        this.rstypes[0] = 12;
        this.rstypes[1] = 12;
        this.rstypes[2] = 4;
        this.rstypes[3] = 4;
        this.rstypes[4] = 12;
        this.rstypes[5] = 12;
        this.rstypes[6] = 12;
        this.rstypes[7] = 12;
    }

    public JDBCSchemaRowset(Statement statement, ResultSet results, int specHandling) throws SpedoException {
        this.statement = statement;
        if (results == null) {
            System.err.println("SpedoWarning : JDBCSchemaRowset() : ResultSet is null. Creating Rowset.");
        } else {
            this.rs = results;
            try {
                this.rsmd = this.rs.getMetaData();
            }
            catch (SQLException e) {
                throw new SpedoException("SpedoException: JDBCSchemaRowset() : " + e.getMessage());
            }
        }
        this.specialHandling = specHandling;
        this.rstypes = new int[8];
        this.rstypes[0] = 12;
        this.rstypes[1] = 12;
        this.rstypes[2] = 4;
        this.rstypes[3] = 4;
        this.rstypes[4] = 12;
        this.rstypes[5] = 12;
        this.rstypes[6] = 12;
        this.rstypes[7] = 12;
    }

    @Override
    public Object[] getColumn(int columnIndex) throws SpedoException {
        Object[] obj = new Object[this.recordCache];
        boolean b = true;
        b = this.positionCursor();
        try {
            for (int i = 0; i < this.recordCache; ++i) {
                if (!b) {
                    throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumn : cannot get column values.");
                }
                obj[i] = this.rs.getObject(columnIndex);
                b = this.positionCursor();
            }
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumn : " + se.getMessage());
        }
        return obj;
    }

    @Override
    public int getColumnCount() throws SpedoException {
        try {
            return this.rsmd.getColumnCount();
        }
        catch (SQLException e) {
            throw new SpedoException(e.getMessage());
        }
    }

    @Override
    public int getColumnType(int columnIndex) throws SpedoException {
        try {
            return this.rsmd.getColumnType(columnIndex);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnType " + se.getMessage());
        }
    }

    @Override
    public int[] getColumnTypes() throws SpedoException {
        try {
            int[] columnTypes = new int[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnTypes[i] = this.rsmd.getColumnType(i + 1);
            }
            return columnTypes;
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnTypes " + se.getMessage());
        }
    }

    @Override
    public int[] getColumnFormats() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnFormats : method not supported.");
    }

    @Override
    public int getColumnFormat(int columnIndex) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnFormat : method not supported.");
    }

    @Override
    public int[] getColumnInformats() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnInformats : method not supported.");
    }

    @Override
    public Object[][] getRow(IBookmark startBookMark, int startPosition, int numRecs, int stride) throws SpedoException {
        int i;
        int columnCount = this.getColumnCount();
        Object[][] obj = new Object[numRecs][columnCount];
        boolean b = true;
        for (i = 0; i < startPosition; ++i) {
            if (!b) {
                throw new SpedoException("SpedoException: JDBCSchemaRowset.getRow : cannot position cursor to startPosition.");
            }
            b = this.positionCursor();
        }
        try {
            for (i = 0; i < numRecs; ++i) {
                if (b) {
                    for (int j = 0; j < columnCount; ++j) {
                        obj[i][j] = this.rs.getObject(j + 1);
                    }
                } else {
                    throw new SpedoException("SpedoException: JDBCSchemaRowset.getRow : cannot get numRecs rows.");
                }
                b = this.positionCursor();
            }
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getRow : " + se.getMessage());
        }
        return obj;
    }

    @Override
    public int getRowCount() throws SpedoException {
        String query = "select nobs,memtype from dictionary.tables where libname='" + this.dso.dso.trim().toUpperCase() + "' and memname='" + this.tableName.trim().toUpperCase() + "';";
        int count = 0;
        String memtype = null;
        try {
            this.statement = this.connection.createStatement();
            ResultSet rs = this.statement.executeQuery(query);
            if (rs.next()) {
                count = new Float(rs.getString(1)).intValue();
                memtype = rs.getString(2);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getRowCount : " + ex.getMessage());
        }
        if (memtype.trim().toUpperCase().equals("VIEW")) {
            return -1;
        }
        return count;
    }

    @Override
    public int countRows() throws SpedoException {
        String memtype;
        int whereIndex = -1;
        if (this.getQueryResultsCalled) {
            if (this.query == null || this.query.length() == 0) {
                throw new SpedoException("SpedoException: no resultset available");
            }
            String temp = this.query.toUpperCase();
            whereIndex = temp.indexOf("WHERE");
        }
        if (this.haveCount) {
            return this.countRows;
        }
        int count = 0;
        if ((!this.getQueryResultsCalled || whereIndex != -1 || this.password != null) && (this.getQueryResultsCalled || this.whereText != null && this.whereText.length() != 0)) {
            return this.countRows;
        }
        String countQuery = "select nobs,memtype from dictionary.tables where libname='" + this.dso.dso.trim().toUpperCase() + "' and memname='" + this.tableName.trim().toUpperCase() + "';";
        try {
            this.statement = this.connection.createStatement();
            ResultSet trs = this.statement.executeQuery(countQuery);
            trs.next();
            count = trs.getInt(1);
            memtype = trs.getString(2);
            trs.close();
            this.countRows = count;
            this.haveCount = true;
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.countRows() : " + ex.getMessage());
        }
        if (memtype.trim().toUpperCase().equals("VIEW")) {
            this.countRows = -1;
        }
        return this.countRows;
    }

    @Override
    public boolean isOpen() throws SpedoException {
        return this.isOpen;
    }

    @Override
    public void open() throws SpedoException {
        if (this.isOpen) {
            System.out.println("SpedoWarning: JDBCSchemaRowset.open : Rowset already open.");
        }
        String query = new String("select ");
        if (this.selectOption != null && this.selectOption.length() != 0) {
            query = query + new String(this.selectOption + " ");
        }
        query = query + new String(this.bindCol + " from " + this.dso.dso + "." + this.tableName);
        if (this.password != null && this.password.length() != 0) {
            query = query + new String(" (pw=" + this.password + ")");
        }
        if (this.whereText != null && this.whereText.length() != 0) {
            query = query + new String(" where " + this.whereText);
        }
        if (this.orderByText != null && this.orderByText.length() != 0) {
            query = query + new String(" order by " + this.orderByText);
        }
        try {
            this.statement = this.connection.createStatement();
            this.rs = this.statement.executeQuery(query);
            this.rsmd = this.rs.getMetaData();
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.open() : " + ex.getMessage());
        }
        this.isOpen = true;
    }

    @Override
    public void close() throws SpedoException {
        this.bindCol = new String("*");
        this.strCol = new String("*");
        this.whereText = null;
        this.orderByText = null;
        this.selectOption = null;
        this.countRows = -1;
        this.isOpen = false;
        this.getQueryResultsCalled = false;
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
        }
        catch (SQLException se) {
            this.rs = null;
            throw new SpedoException("SpedoException: JDBCSchemaRowset.close : " + se.getMessage());
        }
    }

    @Override
    public void setRecordCache(int recordCache) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.setRecordCache : property is read-only as Rowset is already open.");
        }
        this.recordCache = recordCache;
    }

    @Override
    public void setAccessMode(int accessMode) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCBasicRowset.setRecordCache : property is read-only as Rowset is already open.");
        }
        this.accessMode = accessMode;
    }

    @Override
    public void setOpenMode(int openMode) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCBasicRowset.setRecordCache : property is read-only as Rowset is already open.");
        }
        this.openMode = openMode;
    }

    @Override
    public void setLockType(int lockType) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCBasicRowset.setRecordCache : property is read-only as Rowset is already open.");
        }
        this.lockType = lockType;
    }

    @Override
    public void setUpdateMode(int updateMode) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCBasicRowset.setRecordCache : property is read-only as Rowset is already open.");
        }
        this.updateMode = updateMode;
    }

    @Override
    public boolean getBOF() throws SpedoException {
        return this.bof;
    }

    @Override
    public boolean getEOF() throws SpedoException {
        return this.eof;
    }

    @Override
    public int getRecordCache() throws SpedoException {
        return this.recordCache;
    }

    @Override
    public String getTableName() throws SpedoException {
        return this.tableName;
    }

    @Override
    public ISpedoDSO getDSO() throws SpedoException {
        JDBCDSO jdso = new JDBCDSO();
        return jdso;
    }

    @Override
    public String getPassword() throws SpedoException {
        return this.password;
    }

    @Override
    public void setPassword(String password) throws SpedoException {
        this.password = password;
    }

    @Override
    public int getAccessMode() throws SpedoException {
        return this.accessMode;
    }

    @Override
    public int getOpenMode() throws SpedoException {
        return this.openMode;
    }

    @Override
    public int getLockType() throws SpedoException {
        return this.lockType;
    }

    @Override
    public int getUpdateMode() throws SpedoException {
        return this.updateMode;
    }

    @Override
    public void setSelectOptions(String option) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.setSelectOptions() : SpedoRowset already open. Cannot set select options.");
        }
        if (option != null && option.length() != 0) {
            this.selectOption = option;
        }
    }

    @Override
    public void bindAllColumns(int dataType) throws SpedoException {
        this.bindCol = new String("*");
        this.strCol = new String("*");
    }

    @Override
    public void startColumnBinding() throws SpedoException {
        this.start = true;
        this.end = false;
    }

    @Override
    public void bindColumn(String columnName) throws SpedoException {
        if (!this.start) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.bindColumn() : startColumnBinding() must be called first.");
        }
        if (this.end) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.bindColumn() : endColumnBinding() has been called.");
        }
        if (this.bind) {
            this.bindCol = this.bindCol + new String(", " + columnName);
            this.strCol = this.strCol + new String(", '" + columnName.toUpperCase() + "'");
        } else {
            this.bindCol = new String(columnName);
            this.strCol = new String("'" + columnName.toUpperCase() + "'");
            this.bind = true;
        }
    }

    @Override
    public void endColumnBinding() throws SpedoException {
        this.bind = false;
        this.end = true;
    }

    @Override
    public int[] getColumnBindings() throws SpedoException {
        try {
            int[] boundTypes = new int[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                boundTypes[i] = this.rsmd.getColumnType(i + 1);
            }
            return boundTypes;
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnBindings " + se.getMessage());
        }
    }

    @Override
    public String[] getColumnDesc() throws SpedoException {
        try {
            String[] columnLabels = new String[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnLabels[i] = this.rsmd.getColumnLabel(i + 1);
            }
            return columnLabels;
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnDesc " + se.getMessage());
        }
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SpedoException {
        try {
            return this.rsmd.getColumnLabel(columnIndex);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnLabel " + se.getMessage());
        }
    }

    @Override
    public String[] getColumnNames() throws SpedoException {
        try {
            String[] columnNames = new String[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnNames[i] = this.rsmd.getColumnName(i + 1);
            }
            return columnNames;
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnNames " + se.getMessage());
        }
    }

    @Override
    public String getColumnName(int columnIndex) throws SpedoException {
        try {
            return this.rsmd.getColumnName(columnIndex);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnName " + se.getMessage());
        }
    }

    @Override
    public int[] getColumnSizes() throws SpedoException {
        try {
            int[] columnSizes = new int[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnSizes[i] = this.rsmd.getColumnDisplaySize(i + 1);
            }
            return columnSizes;
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnSizes " + se.getMessage());
        }
    }

    @Override
    public int getColumnSize(int columnIndex) throws SpedoException {
        try {
            return this.rsmd.getColumnDisplaySize(columnIndex);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getColumnSize " + se.getMessage());
        }
    }

    @Override
    public boolean positionCursor() throws SpedoException {
        boolean bool = true;
        try {
            bool = this.rs.next();
            if (bool) {
                this.bof = false;
                this.eof = false;
            } else {
                this.eof = true;
            }
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.positionCursor : " + se.getMessage());
        }
        return bool;
    }

    public boolean positionCursor(IBookmark startBookmark, int startPosition) throws SpedoException {
        boolean bool = true;
        if (startBookmark != null) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.positionCursor: Bookmarks not supported. Must be null.");
        }
        try {
            for (int i = 0; i < startPosition; ++i) {
                bool = this.rs.next();
            }
            if (bool) {
                this.bof = false;
                this.eof = false;
            } else {
                this.eof = true;
            }
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.positionCursor: cannot position cursor to startPosition.");
        }
        return bool;
    }

    @Override
    public String getString(int column) throws SpedoException {
        try {
            return this.rs.getString(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getString : " + se.getMessage());
        }
    }

    public Date getDate(int column) throws SpedoException {
        try {
            return this.rs.getDate(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getDate : " + se.getMessage());
        }
    }

    @Override
    public boolean getBoolean(int column) throws SpedoException {
        try {
            return this.rs.getBoolean(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getBoolean : " + se.getMessage());
        }
    }

    @Override
    public byte getByte(int column) throws SpedoException {
        try {
            return this.rs.getByte(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getBoolean : " + se.getMessage());
        }
    }

    @Override
    public short getShort(int column) throws SpedoException {
        try {
            return this.rs.getShort(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getShort : " + se.getMessage());
        }
    }

    @Override
    public int getInt(int column) throws SpedoException {
        try {
            return this.rs.getInt(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getInt : " + se.getMessage());
        }
    }

    @Override
    public long getLong(int column) throws SpedoException {
        try {
            return this.rs.getLong(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getLong : " + se.getMessage());
        }
    }

    @Override
    public float getFloat(int column) throws SpedoException {
        try {
            return this.rs.getFloat(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getFloat : " + se.getMessage());
        }
    }

    @Override
    public double getDouble(int column) throws SpedoException {
        try {
            return this.rs.getDouble(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getDouble : " + se.getMessage());
        }
    }

    @Override
    public Object getCell(int column) throws SpedoException {
        try {
            return this.rs.getObject(column);
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCSchemaRowset.getCell : " + se.getMessage());
        }
    }
}

