/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.tree;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticLevelNodeInterface;
import com.sas.models.TreeNode;
import com.sas.sasserver.tree.LevelTreeInterface;

public class ProgressiveLevelTreeNode
extends TreeNode
implements StaticLevelNodeInterface {
    protected int childCount = -1;
    protected int childListIndex;
    protected int uncleIndex;
    protected int nodeIndex;
    protected int nodeLevel;
    protected String nodeKey;
    protected HListInterface childList;
    protected HListInterface hlist;
    protected LevelTreeInterface m_remoteObject;
    protected ProgressiveLevelTreeNode parent;
    protected boolean visible;
    protected SimpleNodeInterface[] nodeChildren = null;

    public ProgressiveLevelTreeNode(LevelTreeInterface m_remoteObject, ProgressiveLevelTreeNode parent, HListInterface hlist, int childListIndex, int nodeLevel) {
        this.m_remoteObject = m_remoteObject;
        this.childListIndex = childListIndex;
        this.nodeLevel = nodeLevel;
        this.parent = parent;
        this.hlist = hlist;
        this.uncleIndex = 0;
        this.initTreeNode();
    }

    public ProgressiveLevelTreeNode(ProgressiveLevelTreeNode parent, HListInterface hlist, int childListIndex, int nodeLevel) {
        this(null, parent, hlist, childListIndex, nodeLevel);
    }

    protected void initTreeNode() {
        HListInterface nodeList = null;
        Object nvp = null;
        boolean numNVP = false;
        boolean tidx = false;
        String nodeName = null;
        String text = null;
        String link = null;
        String dImage = null;
        String eImage = null;
        String key = null;
        String title = null;
        String dAltImageText = null;
        String eAltImageText = null;
        String accessKey = null;
        int tabIndex = -1;
        nodeList = this.hlist.getList(this.childListIndex);
        Integer tempLvl = new Integer(nodeList.getString("LEVEL"));
        this.nodeLevel = Integer.parseInt(nodeList.getString("LEVEL"));
        Integer tempIdx = new Integer(nodeList.getString("INDEX"));
        this.nodeIndex = Integer.parseInt(nodeList.getString("INDEX"));
        nodeName = nodeList.getString("NODENAME");
        text = nodeList.getString("TEXT");
        dImage = nodeList.getString("DEFAULTICON");
        eImage = nodeList.getString("EXPANDEDICON");
        link = nodeList.getString("LINK");
        key = nodeList.getString("KEY");
        title = nodeList.getString("TITLE");
        dAltImageText = nodeList.getString("DEFAULTIMAGEALTTEXT");
        eAltImageText = nodeList.getString("EXPANDEDIMAGEALTTEXT");
        accessKey = nodeList.getString("ACCESSKEY");
        if (this.parent == null) {
            this.setText(text);
            this.setURL(link);
            this.setName(nodeName);
            this.setDefaultImage(dImage);
            this.setExpandedImage(eImage);
            this.setKey(key);
            this.setIndex(this.nodeIndex);
            this.setLevel(this.nodeLevel);
            this.setChildListIndex(this.childListIndex);
            this.setDefaultImageAltText(dAltImageText);
            this.setExpandedImageAltText(eAltImageText);
            if (tabIndex != -1) {
                this.setTabIndex(tabIndex);
            }
            this.setAccessKey(accessKey);
            this.setTitle(title);
            this.setParent(this.parent);
        } else {
            this.setText(text);
            this.setName(nodeName);
            this.setDefaultImage(dImage);
            this.setExpandedImage(eImage);
            this.setKey(key);
            this.setURL(link);
            this.setIndex(this.nodeIndex);
            this.setLevel(this.nodeLevel);
            this.setParent(this.parent);
            this.setChildListIndex(this.childListIndex);
            this.setUncleIndex(this.findUncleIndex());
            this.setDefaultImageAltText(dAltImageText);
            this.setExpandedImageAltText(eAltImageText);
            if (tabIndex != -1) {
                this.setTabIndex(tabIndex);
            }
            this.setAccessKey(accessKey);
            this.setTitle(title);
            this.parent.addNodeChild((SimpleNodeInterface)this);
        }
    }

    public SimpleNodeInterface getNodeChild(int childIndex) {
        if (this.getNodeChildCount() > 0) {
            return this.getNodeChildren(childIndex, 1)[0];
        }
        return null;
    }

    public void initChildNodes() {
        this.initChildList();
        if (this.nodeChildren == null) {
            this.nodeChildren = new SimpleNodeInterface[this.childCount];
            for (int i = 0; i < this.childCount; ++i) {
                this.nodeChildren[i] = new ProgressiveLevelTreeNode(this.m_remoteObject, this, this.childList, i, this.nodeLevel + 1);
            }
        }
    }

    protected int findUncleIndex() {
        ProgressiveLevelTreeNode grandParent;
        int uIndex = 0;
        if (this.getLevel() > 2 && this.getUncleIndex() == 0 && (grandParent = this.parent.getParent()).getNodeChildCount() > this.parent.getChildListIndex() + 1) {
            SimpleNodeInterface uncle = grandParent.getNodeChild(this.parent.getChildListIndex() + 1);
            uIndex = ((ProgressiveLevelTreeNode)uncle).getIndex();
        }
        return uIndex;
    }

    protected void initChildList() {
        int sIndex = 0;
        if (this.parent != null && this.parent.getNodeChildCount() > this.getChildListIndex() + 1) {
            SimpleNodeInterface sibling = this.parent.getNodeChild(this.getChildListIndex() + 1);
            sIndex = ((ProgressiveLevelTreeNode)sibling).getIndex();
        }
        if (this.getIndex() != sIndex + 1 || this.getIndex() == 1) {
            if (this.childCount == -1) {
                int newlevel = this.nodeLevel + 1;
                if (this.nodeLevel == 1) {
                    this.m_remoteObject.setWhere("level = " + newlevel);
                } else if (this.parent != null && this.parent.getNodeChildCount() != this.getChildListIndex() + 1) {
                    this.m_remoteObject.setWhere("level = " + newlevel + " and index < " + sIndex + " and index > " + this.getIndex());
                } else if (this.getUncleIndex() != 0) {
                    this.m_remoteObject.setWhere("level = " + newlevel + " and index < " + this.getUncleIndex() + " and index > " + this.getIndex());
                } else {
                    this.m_remoteObject.setWhere("level = " + newlevel + " and index > " + this.getIndex());
                }
                this.childList = this.m_remoteObject._getTreeNodes();
                this.childCount = this.childList.count();
            }
        } else {
            HList temp = new HList();
            this.childList = temp;
            this.childCount = 0;
        }
    }

    public SimpleNodeInterface[] getNodeChildren(int childIndex, int count) {
        this.initChildNodes();
        SimpleNodeInterface[] children = new SimpleNodeInterface[count];
        System.arraycopy(this.nodeChildren, childIndex, children, 0, count);
        return children;
    }

    public boolean isLeafNode() {
        return this.getNodeChildCount() == 0;
    }

    public int getNodeChildCount() {
        if (this.childCount == -1) {
            this.initChildNodes();
        }
        return this.childCount;
    }

    public void setIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public int getIndex() {
        return this.nodeIndex;
    }

    public void setLevel(int nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public int getLevel() {
        return this.nodeLevel;
    }

    public void setParent(ProgressiveLevelTreeNode parent) {
        this.parent = parent;
    }

    public ProgressiveLevelTreeNode getParent() {
        return this.parent;
    }

    public void setUncleIndex(int uncleIndex) {
        this.uncleIndex = uncleIndex;
    }

    public int getUncleIndex() {
        return this.uncleIndex;
    }

    public void setChildListIndex(int childListIndex) {
        this.childListIndex = childListIndex;
    }

    public int getChildListIndex() {
        return this.childListIndex;
    }

    public void setKey(String nodeKey) {
        this.nodeKey = nodeKey;
    }

    public void setNodeCellStyleKey(String key) {
        this.setKey(key);
    }

    public String getKey() {
        return this.nodeKey;
    }

    public String getNodeCellStyleKey() {
        return this.getKey();
    }
}

