/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.tree;

import com.sas.collection.hlist.HListInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticLevelNodeInterface;
import com.sas.models.TreeNode;

public class LevelTreeNode
extends TreeNode
implements StaticLevelNodeInterface {
    protected int level;
    protected int index;
    protected int nLevel;
    protected int nIndex;
    protected String nKey;
    protected HListInterface hlist;
    protected TreeNode parent;
    protected boolean visible;
    protected SimpleNodeInterface[] nodeChildren;

    public LevelTreeNode(TreeNode parent, HListInterface hlist, int index, int level) {
        this.hlist = hlist;
        this.index = index;
        this.level = level;
        this.parent = parent;
        this.initTreeNode();
    }

    protected void initTreeNode() {
        Object nvp = null;
        Object nextItem = null;
        boolean numNVP = false;
        boolean rlevel = false;
        boolean tidx = false;
        Object sValue = null;
        Object dValue = null;
        Object amper = null;
        String nodeName = null;
        String text = null;
        String link = null;
        String dImage = null;
        String eImage = null;
        Object itemName = null;
        String key = null;
        SimpleNodeInterface node = null;
        HListInterface list = this.hlist.getList(this.index - 1);
        Integer tempLvl = new Integer(list.getString("LEVEL"));
        int itemLevel = Integer.parseInt(list.getString("LEVEL"));
        Integer tempIdx = new Integer(list.getString("INDEX"));
        int itemIndex = Integer.parseInt(list.getString("INDEX"));
        nodeName = list.getString("NODENAME");
        text = list.getString("TEXT");
        dImage = list.getString("DEFAULTICON");
        eImage = list.getString("EXPANDEDICON");
        link = list.getString("LINK");
        key = list.getString("KEY");
        if (this.parent == null) {
            this.setText(text);
            this.setURL(link);
            this.setName(nodeName);
            this.setDefaultImage(dImage);
            this.setExpandedImage(eImage);
            this.setKey(key);
            this.setIndex(itemIndex);
            this.setLevel(itemLevel);
        } else {
            this.setText(text);
            this.setName(nodeName);
            this.setDefaultImage(dImage);
            this.setExpandedImage(eImage);
            this.setKey(key);
            this.setURL(link);
            this.setIndex(itemIndex);
            this.setLevel(itemLevel);
            this.parent.addNodeChild(node);
        }
    }

    public SimpleNodeInterface getNodeChild(int childIndex) {
        if (this.getNodeChildCount() > 0) {
            return this.getNodeChildren(childIndex, 1)[0];
        }
        return null;
    }

    public void initChildNodes() {
        if (this.nodeChildren != null) {
            return;
        }
        this.nodeChildren = new SimpleNodeInterface[this.getNodeChildCount()];
        int childIndex = 0;
        int hlistCount = this.hlist.count();
        int childCounter = 0;
        for (int searchIndex = this.index + 1; searchIndex <= hlistCount; ++searchIndex) {
            HListInterface subList = this.hlist.getList(searchIndex - 1);
            Integer tempInt = new Integer(subList.getString("LEVEL"));
            int itemLevel = Integer.parseInt(subList.getString("LEVEL"));
            int tmplvl = this.level + 1;
            if (itemLevel < this.level) break;
            if (itemLevel > tmplvl) continue;
            this.nodeChildren[childCounter - childIndex] = new LevelTreeNode(this, this.hlist, searchIndex, this.level + 1);
            if (++childCounter - childIndex == this.getNodeChildCount()) break;
        }
    }

    public SimpleNodeInterface[] getNodeChildren(int childIndex, int count) {
        this.initChildNodes();
        SimpleNodeInterface[] children = new SimpleNodeInterface[count];
        int hlistCount = this.hlist.count();
        int childCounter = 0;
        int childToGet = childIndex;
        for (int searchIndex = this.index + 1; searchIndex <= hlistCount; ++searchIndex) {
            HListInterface subList = this.hlist.getList(searchIndex - 1);
            Integer tempInt = new Integer(subList.getString("LEVEL"));
            int itemLevel = Integer.parseInt(subList.getString("LEVEL"));
            int tmplvl = this.level + 1;
            if (itemLevel < this.level) break;
            if (itemLevel > tmplvl) continue;
            if (childIndex <= childCounter && children[childCounter - childIndex] == null) {
                System.arraycopy(this.nodeChildren, childToGet, children, childCounter - childIndex, 1);
                ++childToGet;
            }
            if (++childCounter - childIndex == count) break;
        }
        return children;
    }

    public boolean isLeafNode() {
        return this.getNodeChildCount() == 0;
    }

    public int getNodeChildCount() {
        int count = 0;
        int cnt = this.hlist.count();
        for (int i = this.index + 1; i <= cnt; ++i) {
            HListInterface list = this.hlist.getList(i - 1);
            Integer tempInt = new Integer(list.getString("LEVEL"));
            int itemLevel = Integer.parseInt(list.getString("LEVEL"));
            if (itemLevel <= this.level) break;
            if (itemLevel != this.level + 1) continue;
            ++count;
        }
        return count;
    }

    public void setIndex(int nIndex) {
        this.nIndex = nIndex;
    }

    public int getIndex() {
        return this.nIndex;
    }

    public void setLevel(int nLevel) {
        this.nLevel = nLevel;
    }

    public int getLevel() {
        return this.nLevel;
    }

    public void setKey(String nKey) {
        this.nKey = nKey;
    }

    public void setNodeCellStyleKey(String key) {
        this.setKey(key);
    }

    public String getKey() {
        return this.nKey;
    }

    public String getNodeCellStyleKey() {
        return this.getKey();
    }
}

