/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.tree;

import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.OrderedCollection;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.models.NodeInterface;
import com.sas.sasserver.SASListDelegate;
import com.sas.sasserver.tree.LevelTreeInterface;
import com.sas.sasserver.tree.ProgressiveLevelTreeNode;
import com.sas.sasserver.tree.RB;
import com.sas.table.TableException;
import com.sas.util.Util;

public class LevelTreeDelegate
extends SASListDelegate {
    static final String RB_KEY = "TreeDelegate.";
    private transient LevelTreeInterface m_remoteObject;
    protected transient String where;
    private ProgressiveLevelTreeNode root = null;

    @Override
    protected synchronized void resubmitQuery() {
    }

    @Override
    public void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.m_remoteObject = (LevelTreeInterface)this.remoteObject();
    }

    public String getWhere() {
        HListInterface hlist = this.m_remoteObject._getWhere();
        String returnwc = "";
        for (int i = 0; i < hlist.count(); ++i) {
            HListItem item = hlist.getItem(i);
            if (!(item instanceof StringItem)) continue;
            String sValue = ((StringItem)item).getValue();
            returnwc = returnwc + sValue;
        }
        return returnwc;
    }

    public void setWhere(String wc) {
        String oldWhere = this.where;
        if (Util.equal((Object)oldWhere, (Object)wc)) {
            return;
        }
        HListInterface hlist = LevelTreeDelegate.parseWhereClauseToList(wc);
        this.m_remoteObject._setWhere(hlist);
        this.where = wc;
        this.fireContentsChanged(new ContentsChangedEvent((Object)this.m_remoteObject));
        this.firePropertyChange("where", oldWhere, this.where);
    }

    private static HListInterface parseWhereClauseToList(String whereClause) {
        HList whereList = new HList();
        if (whereClause != null) {
            int whereClauseLength = whereClause.length();
            while (whereClauseLength > 200) {
                StringBuffer buffer = new StringBuffer();
                boolean inSingleQuoteString = false;
                boolean inDoubleQuoteString = false;
                int lastBreak = 0;
                for (int j = 0; j < 200; ++j) {
                    char c = whereClause.charAt(j);
                    if (c == '\'') {
                        if (inSingleQuoteString) {
                            inSingleQuoteString = false;
                            lastBreak = j;
                            continue;
                        }
                        inSingleQuoteString = true;
                        continue;
                    }
                    if (c == '\"') {
                        if (inDoubleQuoteString) {
                            inDoubleQuoteString = false;
                            lastBreak = j;
                            continue;
                        }
                        inDoubleQuoteString = true;
                        continue;
                    }
                    if (c != ' ' || inSingleQuoteString || inDoubleQuoteString) continue;
                    lastBreak = j;
                }
                if (lastBreak == 0) {
                    throw new IllegalArgumentException("No part of a where clause can be 200 characters.");
                }
                String substring = whereClause.substring(0, lastBreak + 1);
                StringItem stringItem = new StringItem(substring);
                whereList.addItem((HListItem)stringItem);
                whereClause = whereClause.substring(lastBreak + 1);
                whereClauseLength = whereClause.length();
            }
            if (whereClauseLength > 0) {
                StringItem stringItem = new StringItem(whereClause);
                whereList.addItem((HListItem)stringItem);
            }
        }
        return whereList;
    }

    public void validate() throws TableException {
        String errorStr = this.m_remoteObject._validate();
        if (errorStr != null && errorStr.length() != 0) {
            throw new TableException(RB.getStringResource(RB_KEY, errorStr + ".txt"));
        }
    }

    private void validateIt() {
        try {
            this.validate();
        }
        catch (TableException te) {
            System.out.println(te.getMessage());
        }
    }

    public NodeInterface getRoot() {
        HListInterface hlist = null;
        HListInterface nvp = null;
        HListInterface list = null;
        int numNVP = 0;
        String nodeName = null;
        String parentNodeName = null;
        String text = null;
        String link = null;
        String dIcon = null;
        String eIcon = null;
        Object makeNode = null;
        String itemName = null;
        String amper = null;
        String sValue = null;
        String dValue = null;
        String levelS = null;
        String indexS = null;
        Object childrenOf = null;
        if (this.root != null) {
            return this.root;
        }
        try {
            this.validate();
        }
        catch (TableException te) {
            throw new RuntimeException("Error validating model - " + te.getMessage());
        }
        if (!this.m_remoteObject._isValid()) {
            return null;
        }
        this.m_remoteObject.setWhere("level = 1");
        hlist = this.m_remoteObject._getTreeNodes();
        OrderedCollection oc = new OrderedCollection();
        if (hlist.count() > 0) {
            list = hlist.getList(0);
            int pLevel = 0;
            nodeName = list.getString("NODENAME");
            parentNodeName = list.getString("PARENTNODE");
            text = list.getString("TEXT");
            link = list.getString("LINK");
            dIcon = list.getString("DEFAULTICON");
            eIcon = list.getString("EXPANDEDICON");
            nvp = list.getList("NAMEVALUEPAIRS");
            numNVP = nvp.count();
            for (int k = 0; k < numNVP; ++k) {
                HListItem item;
                if (k == 0) {
                    link = link + "?";
                }
                if ((item = nvp.getItem(k)) instanceof StringItem) {
                    itemName = item.getName();
                    StringItem si = (StringItem)item;
                    sValue = si.getValue();
                    amper = k > 0 ? "&" : "";
                    if (si != null) {
                        link = link + amper + itemName + "=" + sValue;
                        continue;
                    }
                    link = link + amper + itemName + "=";
                    continue;
                }
                if (!(item instanceof DoubleItem)) continue;
                itemName = item.getName();
                DoubleItem di = (DoubleItem)item;
                dValue = di.isMissing() ? "." : itemName + "=" + Double.toString(di.getValue());
                amper = k > 0 ? "&" : "";
                link = link + amper + dValue;
            }
            levelS = list.getString("LEVEL");
            indexS = list.getString("INDEX");
            int level = Integer.parseInt(levelS);
            int index = Integer.parseInt(indexS);
            pLevel = level;
            this.root = new ProgressiveLevelTreeNode(this.m_remoteObject, null, hlist, 0, 1);
            this.root.setExpanded(true);
            return this.root;
        }
        return null;
    }
}

