/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.summary;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.sasserver.dataset.DataSetDelegate;
import com.sas.sasserver.summary.ColumnInfoTypes;
import com.sas.sasserver.summary.ColumnLabelTypes;
import com.sas.sasserver.summary.MissingTypes;
import com.sas.sasserver.summary.RB;
import com.sas.sasserver.summary.SortOrders;
import com.sas.sasserver.summary.StatisticTypes;
import com.sas.sasserver.summary.SummaryInterface;
import com.sas.table.TableException;
import com.sas.util.Util;

public class SummaryDelegate
extends DataSetDelegate {
    static final long serialVersionUID = 1997628594139145792L;
    static final String RB_KEY = "SummaryDelegate.";
    private transient SummaryInterface m_remoteObject;
    private transient String inputDataSet;
    private transient boolean initialized;
    private transient boolean computeEnabled;
    private transient boolean buildTime;
    protected transient String categoryName;
    protected transient String responseName;
    protected transient String groupName;
    protected transient String subGroupName;
    protected transient String responseColorName;
    protected transient String categoryStatistic;
    protected transient String responseStatistic;
    protected transient String responseColorStatistic;
    protected transient String sortOrder;
    protected transient String columnLabels;
    protected transient String statisticFormat;
    protected transient int percentDecimals;
    protected transient double alpha;
    protected transient int classifierCutoff;
    protected transient String missing;
    protected transient String where;

    @Override
    public void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.m_remoteObject = (SummaryInterface)this.remoteObject();
    }

    public void setBuildTime(boolean flag) {
        this.buildTime = flag;
    }

    public void enableSummarize() {
        this.computeEnabled = true;
        this.summarize();
    }

    public void disableSummarize() {
        this.computeEnabled = false;
    }

    @Override
    public void setDataSet(String name) {
        if (Util.equal((Object)this.inputDataSet, (Object)name)) {
            return;
        }
        this.inputDataSet = name;
        this.summarize();
    }

    @Override
    public void initialize() {
        super.initialize();
        Connection connection = ((RemoteBaseClient)((Object)this.m_remoteObject))._RemoteObject_getContext();
        if (connection != null) {
            this.m_remoteObject._setLogMessage(connection.isLogTrap());
        }
        if (this.buildTime) {
            this.buildTime = false;
            super.setDataSet(this.inputDataSet);
            if (this.inputDataSet != null && !this.inputDataSet.trim().equals("")) {
                this.m_remoteObject._setInputDataSet(this.inputDataSet);
            }
            return;
        }
        this.initialized = true;
        this.computeEnabled = true;
        this.initStatisticLabels();
        this.summarize();
    }

    private void summarize() {
        try {
            this.summarize(this.inputDataSet);
        }
        catch (TableException te) {
            System.out.println(te.getMessage());
        }
    }

    private void summarize(String name) throws TableException {
        if (!this.initialized || !this.computeEnabled) {
            return;
        }
        if (name == null || name.trim().equals("")) {
            return;
        }
        this.m_remoteObject._setInputDataSet(name);
        String rc = this.m_remoteObject._validate();
        if (rc != null && !rc.equals("")) {
            throw new TableException(RB.getStringResource(RB_KEY, rc + ".txt"));
        }
        rc = this.m_remoteObject._compute();
        if (rc != null && !rc.equals("")) {
            throw new TableException(RB.getStringResource(RB_KEY, rc + ".txt"));
        }
        super.setDataSet(this.m_remoteObject._getSummaryDataSet());
    }

    private void initStatisticLabels() {
        HListInterface hi = this.m_remoteObject._getStatisticLabels();
        if (hi == null || hi.count() == 0 || hi.getItem(0) == null) {
            return;
        }
        HList labels = new HList();
        for (int i = 0; i < hi.count(); ++i) {
            String name = hi.getName(i);
            labels.addItem(RB.getStringResource(RB_KEY, name + ".txt"), i, name);
        }
        this.m_remoteObject._setStatisticLabels((HListInterface)labels);
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String name) {
        String oldName = this.categoryName;
        if (Util.equal((Object)name, (Object)oldName)) {
            return;
        }
        this.m_remoteObject._setCategoryName(name);
        this.categoryName = name;
        this.firePropertyChange("categoryName", oldName, name);
        this.summarize();
    }

    public String getResponseName() {
        return this.responseName;
    }

    public void setResponseName(String name) {
        String oldName = this.responseName;
        if (Util.equal((Object)name, (Object)oldName)) {
            return;
        }
        this.m_remoteObject._setResponseName(name);
        this.responseName = name;
        this.firePropertyChange("responseName", oldName, name);
        this.summarize();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String name) {
        String oldName = this.groupName;
        if (Util.equal((Object)name, (Object)oldName)) {
            return;
        }
        this.m_remoteObject._setGroupName(name);
        this.groupName = name;
        this.firePropertyChange("groupName", oldName, name);
        this.summarize();
    }

    public String getSubGroupName() {
        return this.subGroupName;
    }

    public void setSubGroupName(String name) {
        String oldName = this.subGroupName;
        if (Util.equal((Object)name, (Object)oldName)) {
            return;
        }
        this.m_remoteObject._setSubGroupName(name);
        this.subGroupName = name;
        this.firePropertyChange("subGroupName", oldName, name);
        this.summarize();
    }

    public String getResponseColorName() {
        return this.responseColorName;
    }

    public void setResponseColorName(String name) {
        String oldName = this.responseColorName;
        if (Util.equal((Object)name, (Object)oldName)) {
            return;
        }
        this.m_remoteObject._setColorName(name);
        this.responseColorName = name;
        this.firePropertyChange("responseColorName", oldName, name);
        this.summarize();
    }

    public SortOrders getSortOrder() {
        return SortOrders.get(this.sortOrder);
    }

    public void setSortOrderString(String aString) {
        this.setSortOrder(SortOrders.get(aString));
    }

    public void setSortOrder(SortOrders order) {
        if (order == null) {
            return;
        }
        String oldOrder = this.sortOrder;
        if (Util.equal((Object)order.toString(), (Object)oldOrder)) {
            return;
        }
        this.m_remoteObject._setSortOrder(order.toString());
        this.sortOrder = order.toString();
        this.firePropertyChange("sortOrder", (Object)SortOrders.get(oldOrder), (Object)order);
        this.summarize();
    }

    public StatisticTypes getCategoryStatistic() {
        return StatisticTypes.get(this.categoryStatistic);
    }

    public void setCategoryStatisticString(String aString) {
        this.setCategoryStatistic(StatisticTypes.get(aString));
    }

    public void setCategoryStatistic(StatisticTypes statistic) {
        if (statistic == null) {
            return;
        }
        String oldStat = this.categoryStatistic;
        if (Util.equal((Object)statistic.toString(), (Object)oldStat)) {
            return;
        }
        this.m_remoteObject._setCategoryStatistic(statistic.toString());
        this.categoryStatistic = statistic.toString();
        this.firePropertyChange("categoryStatistic", (Object)StatisticTypes.get(oldStat), (Object)statistic);
        this.summarize();
    }

    public StatisticTypes getResponseStatistic() {
        return StatisticTypes.get(this.responseStatistic);
    }

    public void setResponseStatisticString(String aString) {
        this.setResponseStatistic(StatisticTypes.get(aString));
    }

    public void setResponseStatistic(StatisticTypes statistic) {
        if (statistic == null) {
            return;
        }
        String oldStat = this.responseStatistic;
        if (Util.equal((Object)statistic.toString(), (Object)oldStat)) {
            return;
        }
        this.m_remoteObject._setResponseStatistic(statistic.toString());
        this.responseStatistic = statistic.toString();
        this.firePropertyChange("responseStatistic", (Object)StatisticTypes.get(oldStat), (Object)statistic);
        this.summarize();
    }

    public StatisticTypes getResponseColorStatistic() {
        return StatisticTypes.get(this.responseColorStatistic);
    }

    public void setResponseColorStatisticString(String aString) {
        this.setResponseColorStatistic(StatisticTypes.get(aString));
    }

    public void setResponseColorStatistic(StatisticTypes statistic) {
        if (statistic == null) {
            return;
        }
        String oldStat = this.responseColorStatistic;
        if (Util.equal((Object)statistic.toString(), (Object)oldStat)) {
            return;
        }
        this.m_remoteObject._setColorStatistic(statistic.toString());
        this.responseColorStatistic = statistic.toString();
        this.firePropertyChange("responseColorStatistic", (Object)StatisticTypes.get(oldStat), (Object)statistic);
        this.summarize();
    }

    public String[] getColumnInfoList(ColumnInfoTypes type) {
        if (this.inputDataSet == null || this.inputDataSet.trim().equals("")) {
            return new String[0];
        }
        return this.getHListStringValues(this.m_remoteObject._getColumnInfo(type.toString()), type.toString());
    }

    public ColumnLabelTypes getModifyLabels() {
        return ColumnLabelTypes.get(this.columnLabels);
    }

    public void setModifyLabelsString(String aString) {
        this.setModifyLabels(ColumnLabelTypes.get(aString));
    }

    public void setModifyLabels(ColumnLabelTypes type) {
        if (type == null) {
            return;
        }
        String oldValue = this.columnLabels;
        if (Util.equal((Object)type.toString(), (Object)oldValue)) {
            return;
        }
        this.m_remoteObject._setModifyLabels(type.toString());
        this.columnLabels = type.toString();
        this.firePropertyChange("modifyLabels", (Object)ColumnLabelTypes.get(oldValue), (Object)type);
        this.summarize();
    }

    public int getClassifierCutoff() {
        return this.classifierCutoff;
    }

    public void setClassifierCutoff(int cutoff) {
        int oldValue = this.classifierCutoff;
        if (cutoff == oldValue) {
            return;
        }
        this.m_remoteObject._setClassifierCutoff(cutoff);
        this.classifierCutoff = cutoff;
        this.firePropertyChange("classifierCutoff", new Integer(oldValue), new Integer(cutoff));
        this.summarize();
    }

    public String getStatisticFormat() {
        return this.statisticFormat;
    }

    public void setStatisticFormat(String format) {
        String oldValue = this.statisticFormat;
        if (Util.equal((Object)format, (Object)oldValue)) {
            return;
        }
        this.m_remoteObject._setStatisticFormat(format);
        this.statisticFormat = format;
        this.firePropertyChange("statisticFormat", oldValue, format);
        this.summarize();
    }

    public int getPercentDecimals() {
        return this.percentDecimals;
    }

    public void setPercentDecimals(int decimals) {
        int oldValue = this.percentDecimals;
        if (decimals == oldValue) {
            return;
        }
        this.m_remoteObject._setPercentDecimals(decimals);
        this.percentDecimals = decimals;
        this.firePropertyChange("percentDecimals", new Integer(oldValue), new Integer(decimals));
        this.summarize();
    }

    public double getConfidenceLevel() {
        return this.alpha;
    }

    public void setConfidenceLevel(double value) {
        double oldValue = this.alpha;
        if (value == oldValue) {
            return;
        }
        this.m_remoteObject._setConfidenceLevel(value);
        this.alpha = value;
        this.firePropertyChange("confidenceLevel", new Double(oldValue), new Double(value));
        this.summarize();
    }

    public MissingTypes getMissingType() {
        return MissingTypes.get(this.missing);
    }

    public void setMissingTypeString(String aString) {
        this.setMissingType(MissingTypes.get(aString));
    }

    public void setMissingType(MissingTypes type) {
        if (type == null) {
            return;
        }
        String oldType = this.missing;
        if (Util.equal((Object)type.toString(), (Object)oldType)) {
            return;
        }
        this.m_remoteObject._setMissing(type.toString());
        this.missing = type.toString();
        this.firePropertyChange("missing", (Object)MissingTypes.get(oldType), (Object)type);
        this.summarize();
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public void setWhere(String whereClause) {
        String oldWhere = this.where;
        if (Util.equal((Object)whereClause, (Object)oldWhere)) {
            return;
        }
        this.m_remoteObject._setWhere(whereClause);
        this.where = whereClause;
        this.firePropertyChange("where", oldWhere, whereClause);
        this.summarize();
    }

    protected void resetAll() {
        if (!this.initialized || !this.computeEnabled) {
            return;
        }
        this.m_remoteObject._resetAll();
    }

    private String[] getHListStringValues(HListInterface hlist, String type) {
        if (hlist == null || hlist.count() == 0) {
            return null;
        }
        String[] values = new String[hlist.count()];
        if (type.equals("UNIQUE")) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = hlist.getString(i);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                values[i] = hlist.getName(i);
            }
        }
        return values;
    }
}

