/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.profiler;

import com.sas.rmi.Connection;
import com.sas.rmi.ProfilerListener;
import com.sas.rmi.Rocf;
import com.sas.sasserver.profiler.ProfStat;
import com.sas.sasserver.profiler.ProfilerInterface;
import com.sas.sasserver.profiler.StatFrame;
import com.sas.sasserver.profiler._rprxIOMProfiler;
import java.util.Hashtable;

public class FinalIOMProfiler
extends _rprxIOMProfiler
implements ProfilerListener {
    Connection ctxt;
    Hashtable m_ht = new Hashtable();
    StatFrame sf;
    int m_count = 0;
    int maxrows = 15;
    int maxmthd = 2048;
    ProfStat[] psvec = new ProfStat[this.maxmthd];

    @Override
    public void nop() {
    }

    @Override
    public void _RemoteObject_setupClient(Connection ctxt) throws Exception {
        super._RemoteObject_setupClient(ctxt);
    }

    public void initialize() {
        super.initialize();
        this.sf = new StatFrame("Remote Object Class Factory Profiler");
        this.sf.setSize(600, 450);
        this.sf.setup(this.maxrows, 5);
        this.sf.setVal(0, 0, "Class");
        this.sf.setVal(0, 1, "Method");
        this.sf.setVal(0, 2, "N");
        this.sf.setVal(0, 3, "MEAN");
        this.sf.setVal(0, 4, "SUM");
        this.sf.show();
        ProfStat ps = this.fps(this, " - Totals - ");
        this.ctxt = this._RemoteObject_getContext();
        this.ctxt.addProfilerListener(this);
    }

    private void setup() {
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.ctxt != null) {
            this.ctxt.removeProfilerListener(this);
            this.ctxt = null;
        }
    }

    ProfStat fps(Object o, String m) {
        String className = o.getClass().getName();
        String hashname = className + "::" + m;
        ProfStat ps = (ProfStat)this.m_ht.get(hashname);
        if (ps == null) {
            ps = new ProfStat(className, m);
            this.m_ht.put(hashname, ps);
            ps.m_index = this.m_count;
            if (this.m_count < this.maxmthd) {
                this.psvec[this.m_count] = ps;
            }
            ++this.m_count;
        }
        return ps;
    }

    @Override
    public void traceEnter(Object o, String m) {
        ProfStat ps = this.fps(o, m);
        ps.traceEnter();
        int row = ps.m_index + 1;
        if (row < this.maxrows) {
            this.sf.setVal(row, 0, ps.m_className + " *");
            this.sf.setVal(row, 1, ps.m_methodName);
        }
    }

    @Override
    public void traceExit(Object o, String m, long l) {
        ProfStat ps = this.fps(o, m);
        this.psvec[0].traceExit(l);
        ps.traceExit(l);
        this.setSingleRow(this.psvec[0]);
        this.setSingleRow(ps);
        this.sortEm(ps);
    }

    private void setSingleRow(ProfStat ps) {
        int row = ps.m_index + 1;
        if (row < this.maxrows) {
            this.sf.setVal(row, 0, ps.m_className);
            this.sf.setVal(row, 1, ps.m_methodName);
            this.sf.setVal(row, 2, "" + ps.m_n);
            this.sf.setVal(row, 3, "" + ps.m_mean);
            this.sf.setVal(row, 4, "" + ps.m_sum);
        }
    }

    private void sortEm(ProfStat ps) {
        int n;
        int pos = n = ps.m_index;
        if (n >= this.maxmthd) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (this.psvec[i].m_n >= ps.m_n) continue;
            this.swap(i, n);
            pos = i;
            this.setSingleRow(this.psvec[i]);
            this.setSingleRow(this.psvec[n]);
            break;
        }
    }

    private void swap(int i, int j) {
        ProfStat psTemp = this.psvec[i];
        this.psvec[i] = this.psvec[j];
        this.psvec[i].m_index = i;
        this.psvec[j] = psTemp;
        this.psvec[j].m_index = j;
    }

    public static void main(String[] args) {
        Rocf rocf = new Rocf();
        Connection ctxt = new Connection();
        ctxt.setTraceProxyClient(true);
        try {
            ProfilerInterface p = (ProfilerInterface)rocf.newInstance(ProfilerInterface.class, ctxt);
            p.nop();
            rocf.stop();
            Thread.sleep(15000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    @Override
    public void stop() {
        System.out.println(" - Profiler Summary - ");
        this.pstr("Class", 29);
        this.pstr("Method", 29);
        this.pstr("N", 6);
        this.pstr("MEAN", 6);
        this.pstr("SUM", 6);
        this.pstr("MIN", 6);
        this.pstr("MAX", 6);
        System.out.println();
        for (int i = 0; i < this.m_count; ++i) {
            ProfStat ps = this.psvec[i];
            this.pstr(ps.m_className, 29);
            this.pstr(ps.m_methodName, 29);
            this.pstr("" + ps.m_n, 6);
            this.pstr("" + ps.m_mean, 6);
            this.pstr("" + ps.m_sum, 6);
            this.pstr("" + ps.m_min, 6);
            this.pstr("" + ps.m_max, 6);
            System.out.println();
        }
        super.stop();
    }

    private void pstr(String s, int n) {
        int l = s.length();
        for (int i = 0; i < n; ++i) {
            char c = i >= l ? (char)' ' : (char)s.charAt(i);
            System.out.print("" + c);
        }
    }
}

