/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.parentchild;

import com.sas.awt.Choice;
import com.sas.awt.Container;
import com.sas.awt.Dialog;
import com.sas.awt.Label;
import com.sas.awt.Panel;
import com.sas.awt.TextField;
import com.sas.awt.util.Util;
import com.sas.sasserver.parentchild.ParentChildVariablesDialog;
import com.sas.sasserver.parentchild.RB;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.ButtonPanel;
import com.sas.visuals.EmptyComponent;
import com.sas.visuals.IconView;
import com.sas.visuals.ImageView;
import com.sas.visuals.PropertyEditorHost;
import com.sas.visuals.PushButton;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

class ParentChildImageDialog
extends Dialog
implements ActionListener,
WindowListener,
ItemListener {
    public static final String RB_KEY = "ParentChildImageDialog.";
    public static String CLOSE = "Close";
    public static String CANCEL = "Cancel";
    static final String[] extension = new String[]{"gif", "jpg", "jpeg"};
    String prevDirectory;
    String selectedValue;
    String initialValue;
    String[] varList;
    Panel panel;
    ButtonPanel buttonPanel;
    PushButton okButton;
    PushButton cancelButton;
    PushButton valPushButton;
    int initialPathType;
    int selectedPathType;
    int imageType;
    boolean imageName;
    Label valLabel;
    Label pathTypeLabel;
    Label classLabel;
    Choice pathTypeChoice;
    TextField valTextField;
    TextField classTextField;
    Container classContainer;
    Class initialClass = null;
    Class relativeClass;
    IconView icon;
    ImageView image;
    PropertyEditorHost relativeClassHost;

    public ParentChildImageDialog(Frame parent, int imageType, String[] vars, String initialVal, int initialPath) {
        super(parent, RB.getStringResource(RB_KEY, "dialogTitle.txt"), true);
        this.imageType = imageType;
        this.varList = vars;
        this.initialValue = initialVal;
        this.initialPathType = initialPath;
        this.imageName = false;
        this.createComponents();
    }

    public ParentChildImageDialog(Frame parent, int imageType, String initialVal, int initialPath, Class c) {
        super(parent, RB.getStringResource(RB_KEY, "dialogTitle.txt"), true);
        this.imageType = imageType;
        this.varList = null;
        this.initialValue = initialVal;
        this.initialPathType = initialPath;
        this.initialClass = c;
        this.imageName = true;
        this.createComponents();
    }

    private void createComponents() {
        this.setInsets(new Insets(10, 10, 10, 10));
        this.buttonPanel = new ButtonPanel(new String[][]{{RB.getStringResource("okButton.txt"), CLOSE}, {RB.getStringResource("cancelButton.txt"), CANCEL}});
        this.buttonPanel.initialize();
        this.okButton = this.buttonPanel.getButton(RB.getStringResource("okButton.txt"));
        this.okButton.initialize();
        this.okButton.addActionListener(this);
        this.cancelButton = this.buttonPanel.getButton(RB.getStringResource("cancelButton.txt"));
        this.cancelButton.initialize();
        this.cancelButton.addActionListener(this);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, false);
        this.setLayout((LayoutManager)layout);
        Container container = new Container();
        AutoSizingGridLayout cLayout = new AutoSizingGridLayout(3, 3, 5, 5, false, false, true);
        cLayout.setRemainderColumn(1);
        container.setLayout((LayoutManager)cLayout);
        this.valLabel = new Label();
        this.valLabel.initialize();
        switch (this.imageType) {
            case 4: {
                this.valLabel.setText(RB.getStringResource(RB_KEY, "defIcon.txt"));
                break;
            }
            case 5: {
                this.valLabel.setText(RB.getStringResource(RB_KEY, "expIcon.txt"));
                break;
            }
            case 6: {
                this.valLabel.setText(RB.getStringResource(RB_KEY, "expSelIcon.txt"));
                break;
            }
            case 7: {
                this.valLabel.setText(RB.getStringResource(RB_KEY, "selIcon.txt"));
                break;
            }
        }
        Container textContainer = new Container();
        AutoSizingGridLayout textLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, false, false);
        textContainer.setLayout((LayoutManager)textLayout);
        this.valTextField = new TextField();
        this.valTextField.initialize();
        this.valTextField.setColumns(15);
        this.valTextField.setText(this.initialValue);
        this.valTextField.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        textContainer.add(this.valTextField);
        this.valPushButton = new PushButton();
        this.valPushButton.initialize();
        this.valPushButton.setText("...");
        this.valPushButton.addActionListener(this);
        textContainer.add(this.valPushButton);
        this.icon = new IconView();
        this.icon.initialize();
        if (this.imageName) {
            switch (this.initialPathType) {
                case 3: {
                    try {
                        this.image = new ImageView(new URL(this.valTextField.getText()));
                    }
                    catch (MalformedURLException ue) {
                        this.image = new ImageView(this.valTextField.getText());
                    }
                    this.image.initialize();
                    break;
                }
                case 0: {
                    this.image = new ImageView(this.valTextField.getText());
                    this.image.initialize();
                    break;
                }
                case 1: {
                    this.image = new ImageView(this.valTextField.getText());
                    this.image.initialize();
                    break;
                }
                case 2: {
                    this.image = new ImageView(this.initialClass, this.valTextField.getText());
                    this.image.initialize();
                    break;
                }
                default: {
                    this.image = new ImageView(this.valTextField.getText());
                    this.image.initialize();
                    break;
                }
            }
        } else {
            this.image = new ImageView();
            this.image.initialize();
        }
        this.image.setDisplayMode(1);
        this.icon.setIcon(this.image);
        this.icon.repaint();
        Container ic = new Container();
        ic.initialize();
        ic.setPreferredSize(new Dimension(16, 16));
        ic.setLayout(new BorderLayout());
        ic.add("Center", this.icon);
        this.pathTypeLabel = new Label();
        this.pathTypeLabel.initialize();
        this.pathTypeLabel.setText(RB.getStringResource(RB_KEY, "pathType.txt"));
        this.pathTypeChoice = new Choice();
        this.pathTypeChoice.initialize();
        this.pathTypeChoice.add(RB.getStringResource("absolute.txt"));
        this.pathTypeChoice.add(RB.getStringResource("applet.txt"));
        this.pathTypeChoice.add(RB.getStringResource("class.txt"));
        this.pathTypeChoice.add(RB.getStringResource("url.txt"));
        this.pathTypeChoice.setSelectedIndex(this.initialPathType);
        this.pathTypeChoice.addItemListener(this);
        EmptyComponent e1 = new EmptyComponent();
        this.classLabel = new Label();
        this.classLabel.initialize();
        this.classLabel.setText(RB.getStringResource(RB_KEY, "relativeClass.txt"));
        this.relativeClassHost = new PropertyEditorHost();
        this.relativeClassHost.initialize();
        this.relativeClassHost.setProperty(this.image, "relativeSourceClass");
        if (this.relativeClassHost.getPropertyEditor() != null) {
            this.relativeClassHost.getPropertyEditor().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        EmptyComponent e2 = new EmptyComponent();
        container.add(this.valLabel);
        container.add(textContainer);
        container.add(ic);
        container.add(this.pathTypeLabel);
        container.add(this.pathTypeChoice);
        container.add(e1);
        container.add(this.classLabel);
        container.add(this.relativeClassHost);
        container.add(e2);
        this.add(container);
        this.add(this.buttonPanel);
        if (this.initialPathType == 2 && this.imageName) {
            this.classLabel.setVisible(true);
            this.relativeClassHost.setVisible(true);
        } else {
            this.classLabel.setVisible(false);
            this.relativeClassHost.setVisible(false);
        }
        this.addWindowListener(this);
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public int getSelectedPathType() {
        return this.selectedPathType;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        this.icon.setIcon(null);
        if (source == this.pathTypeChoice && this.imageName) {
            int choice = this.pathTypeChoice.getSelectedIndex();
            switch (choice) {
                case 3: {
                    try {
                        this.image.setSourceURL(new URL(this.valTextField.getText()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    this.image.setRelativeSourceClass(null);
                    this.image.setSourceAppletRelative(false);
                    this.relativeClassHost.setVisible(false);
                    this.relativeClassHost.getPropertyEditor().setValue(null);
                    this.classLabel.setVisible(false);
                    break;
                }
                case 0: {
                    this.image.setRelativeSourceClass(null);
                    this.image.setSourceAppletRelative(false);
                    this.relativeClassHost.setVisible(false);
                    this.relativeClassHost.getPropertyEditor().setValue(null);
                    this.classLabel.setVisible(false);
                    break;
                }
                case 1: {
                    this.image.setSourceAppletRelative(true);
                    this.relativeClassHost.setVisible(false);
                    this.relativeClassHost.getPropertyEditor().setValue(null);
                    this.classLabel.setVisible(false);
                    break;
                }
                case 2: {
                    this.image.setSourceAppletRelative(false);
                    this.relativeClassHost.setVisible(true);
                    this.classLabel.setVisible(true);
                    break;
                }
            }
            this.icon.setIcon(this.image);
            this.icon.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != null) {
            if (e.getActionCommand().equals(CLOSE)) {
                Class cls;
                this.setVisible(false);
                this.selectedValue = this.valTextField.getText();
                this.selectedPathType = this.pathTypeChoice.getSelectedIndex();
                if (this.selectedPathType == 2 && (cls = this.image.getRelativeSourceClass()) != null) {
                    this.selectedValue = this.image.getRelativeSourceClass().getName() + "," + this.selectedValue.trim();
                }
            } else if (e.getActionCommand().equals(CANCEL)) {
                this.setVisible(false);
                this.selectedValue = this.initialValue;
                this.selectedPathType = this.initialPathType;
                if (this.initialPathType == 2) {
                    this.selectedValue = this.initialClass.getName() + "," + this.selectedValue.trim();
                }
            }
        }
        if (e.getSource() == this.valPushButton) {
            if (!this.imageName) {
                ParentChildVariablesDialog vDialog = new ParentChildVariablesDialog(Util.getParentFrame(this), this.varList, this.valTextField.getText());
                vDialog.pack();
                vDialog.centerOver(this);
                vDialog.setVisible(true);
                this.valTextField.setText(vDialog.getSelectedVariable());
                vDialog.dispose();
            } else if (this.imageName) {
                Frame parentFrame = Util.getParentFrame(this);
                FileDialog openPicture = null;
                openPicture = parentFrame != null ? new FileDialog(parentFrame) : new FileDialog(new Frame());
                try {
                    File dir = new File(this.valTextField.getText());
                    this.prevDirectory = dir.getParent();
                }
                catch (NullPointerException except) {
                    this.prevDirectory = null;
                }
                if (this.prevDirectory != null) {
                    openPicture.setDirectory(this.prevDirectory);
                }
                openPicture.pack();
                openPicture.show();
                this.prevDirectory = openPicture.getDirectory();
                if (openPicture.getFile() != null) {
                    this.prevDirectory = openPicture.getDirectory();
                    this.valTextField.setText(openPicture.getDirectory() + openPicture.getFile());
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.setVisible(false);
        this.selectedValue = this.initialValue;
        this.selectedPathType = this.initialPathType;
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName;
        super.propertyChange(evt);
        PropertyEditor relativeClassEditor = this.relativeClassHost.getPropertyEditor();
        Object source = evt.getSource();
        if (source == relativeClassEditor) {
            this.image.setRelativeSourceClass((Class)relativeClassEditor.getValue());
            this.image.setSource(this.valTextField.getText());
            this.icon.setIcon(this.image);
            this.icon.repaint();
        } else if (source == this.valTextField && this.imageName && com.sas.util.Util.equal((Object)(propertyName = evt.getPropertyName()), (Object)"text")) {
            this.image.setSource(this.valTextField.getText());
            this.icon.setIcon(this.image);
            this.icon.repaint();
        }
    }
}

