/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.metabaselist;

import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticStringListInterface;
import com.sas.collection.StringCollection;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.models.NodeIcon;
import com.sas.models.SimpleNodeInterface;
import com.sas.sasserver.SASListNodeDelegate;
import com.sas.sasserver.metabaselist.MetabaseListInterface;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;

public class MetabaseListDelegate
extends SASListNodeDelegate {
    MetabaseListInterface remoteObject;
    private static String DATABASE = "DATABASE";
    private static String METABASE = "METABASE";
    protected HListInterface metabaseDetails;
    protected String metabaseDescription;
    protected String database;
    protected String metabase;
    private static String[] FILTERS = new String[]{"MULTI", "GRAPHS"};
    private static String CATLOC = "CATLOC";
    private static String DESCRIPT = "DESCRIPT";
    protected transient String[] applicationCatalogs;
    protected transient String[] libnames;
    private transient String[] singleLibname;
    protected transient HListInterface applications;
    protected transient String dataset;
    protected transient String[] filters;
    private transient OrderedCollection nodeChildren;
    private transient boolean childrenInitialized;

    @Override
    public void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.remoteObject = (MetabaseListInterface)o;
    }

    private String[] copyArray(String[] array) {
        if (array == null) {
            return null;
        }
        String[] copy = new String[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public HListInterface getDetails(String metabaseDescription) {
        if (!Util.equal((Object)metabaseDescription, (Object)this.metabaseDescription)) {
            this.metabaseDetails = this.remoteObject._getDetails(metabaseDescription);
            this.metabaseDescription = metabaseDescription;
        }
        return this.metabaseDetails;
    }

    public String getDatabase(String metabaseDescription) {
        return this.getMetabaseItem(DATABASE, metabaseDescription);
    }

    public String getMetabase(String metabaseDescription) {
        return this.getMetabaseItem(METABASE, metabaseDescription);
    }

    public StaticStringListInterface getDatabaseNames(String metabaseName) {
        StringCollection databaseNames = new StringCollection();
        int cnt = this.count();
        for (int i = 0; i < cnt; ++i) {
            String strDB;
            String desc = this.get(i).toString();
            String strMB = this.getMetabase(desc);
            if (!Util.equal((Object)strMB, (Object)metabaseName) || databaseNames.contains((Object)(strDB = this.getDatabase(desc)))) continue;
            databaseNames.add(strDB);
        }
        return databaseNames;
    }

    public StaticStringListInterface getMetabaseNames() {
        StringCollection metabaseNames = new StringCollection();
        int cnt = this.count();
        for (int i = 0; i < cnt; ++i) {
            String metabaseName = this.getMetabase(this.get(i).toString());
            if (metabaseNames.contains((Object)metabaseName)) continue;
            metabaseNames.add(metabaseName);
        }
        return metabaseNames;
    }

    protected String getMetabaseItem(String item, String metabaseDescription) {
        HListInterface hlist = this.getDetails(metabaseDescription);
        HListItem hitem = hlist.getItem(item);
        return ((StringItem)hitem).getValue();
    }

    public String[] getApplicationCatalogs(String[] libnames) {
        if (!Strings.equals((String[])libnames, (String[])this.libnames)) {
            this.applicationCatalogs = this.remoteObject._getApplicationCatalogs(libnames);
            this.libnames = this.copyArray(libnames);
        }
        return this.applicationCatalogs;
    }

    public String[] getApplicationCatalogs(String libname) {
        if (this.singleLibname == null) {
            this.singleLibname = new String[1];
        }
        this.singleLibname[0] = libname;
        return this.getApplicationCatalogs(this.singleLibname);
    }

    public HListInterface getApplications(String dataset, String[] filters) {
        if (!Util.equal((Object)dataset, (Object)this.dataset) || !Strings.equals((String[])filters, (String[])this.filters)) {
            this.applications = this.remoteObject._getApplications(dataset, filters);
            this.dataset = dataset;
            this.filters = this.copyArray(filters);
        }
        return this.applications;
    }

    public String[] getApplicationDescriptions(String dataset, String[] filters) {
        return this.getApplicationItems(DESCRIPT, dataset, filters);
    }

    public String[] getApplicationLocations(String dataset, String[] filters) {
        return this.getApplicationItems(CATLOC, dataset, filters);
    }

    public String[] getApplicationNames(String dataset, String[] filters) {
        HListInterface hlist = this.getApplications(dataset, filters);
        if (hlist == null) {
            return null;
        }
        int cnt = hlist.count();
        if (cnt == 0) {
            return null;
        }
        String[] applNames = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            applNames[i] = hlist.getName(i);
        }
        return applNames;
    }

    public String getApplicationDescription(String applicationName) {
        return this.getApplicationItem(DESCRIPT, applicationName);
    }

    public String getApplicationLocation(String applicationName) {
        return this.getApplicationItem(CATLOC, applicationName);
    }

    protected String[] getApplicationItems(String item, String dataset, String[] filters) {
        HListInterface hlist = this.getApplications(dataset, filters);
        if (hlist == null) {
            return null;
        }
        int cnt = hlist.count();
        if (cnt == 0) {
            return null;
        }
        String[] applItems = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            HListItem hitem = hlist.getItem(i);
            hitem = ((ListItem)hitem).getValue().getItem(item);
            applItems[i] = ((StringItem)hitem).getValue();
        }
        return applItems;
    }

    protected String getApplicationItem(String item, String applicationName) {
        HListInterface hlist = this.getApplications(null, FILTERS);
        if (hlist == null) {
            return null;
        }
        int cnt = hlist.count();
        if (cnt == 0) {
            return null;
        }
        HListItem hitem = hlist.getItem(applicationName);
        if (hitem == null) {
            return null;
        }
        hitem = ((ListItem)hitem).getValue().getItem(item);
        return ((StringItem)hitem).getValue();
    }

    @Override
    public synchronized void initialize() {
        this.dataset = "1_2_3";
        this.libnames = new String[1];
        this.filters = this.libnames;
        this.filters[0] = this.libnames[0] = this.dataset;
        super.initialize();
    }

    private void initializeChildren() {
        this.childrenInitialized = true;
        if (this.nodeChildren == null) {
            this.nodeChildren = new OrderedCollection();
        }
        this.nodeChildren.removeAll();
        this.initializeMetabaseChildren();
    }

    private void initializeApplicationChildren() {
        this.initializeMetabaseChildren();
    }

    private void initializeMetabaseChildren() {
        ImageView imgLib = new ImageView(Resources.getImage((String)"Library"));
        ImageView imgLibExp = new ImageView(Resources.getImage((String)"LibraryExpanded"));
        StaticStringListInterface metabaseNames = this.getMetabaseNames();
        StaticStringListInterface libraryNames = this.getLibraries(metabaseNames);
        int cnt = libraryNames.count();
        for (int i = 0; i < cnt; ++i) {
            String lib = libraryNames.getString(i);
            NodeIcon node = new NodeIcon(lib);
            node.setDefaultIcon(imgLib);
            node.setExpandedIcon(imgLibExp);
            this.nodeChildren.add((Object)node);
            StaticStringListInterface shortMetabaseNames = this.getShortMetabaseNames(metabaseNames, lib);
            int cnt2 = shortMetabaseNames.count();
            for (int j = 0; j < cnt2; ++j) {
                NodeIcon dbNode = new NodeIcon();
                dbNode.setNodeText(shortMetabaseNames.getString(j));
                dbNode.setNodeExpandedText(lib + '.' + dbNode.getNodeText());
                node.addNodeChild((SimpleNodeInterface)dbNode);
            }
        }
    }

    private StaticStringListInterface getLibraries(StaticStringListInterface metabaseNames) {
        StringCollection libraries = new StringCollection();
        int cnt = metabaseNames.count();
        for (int i = 0; i < cnt; ++i) {
            String strMB = metabaseNames.getString(i);
            String lib = null;
            try {
                lib = strMB.substring(0, strMB.indexOf(46));
            }
            catch (StringIndexOutOfBoundsException sie) {
                lib = strMB;
            }
            if (lib == null || libraries.contains((Object)lib)) continue;
            libraries.add(lib);
        }
        return libraries;
    }

    private StaticStringListInterface getShortMetabaseNames(StaticStringListInterface metabaseNames, String libraryName) {
        StringCollection shortMetabaseNames = new StringCollection();
        int cnt = metabaseNames.count();
        for (int i = 0; i < cnt; ++i) {
            String strShortMB;
            int index;
            String strMB = metabaseNames.getString(i);
            if (!strMB.startsWith(libraryName) || (index = strMB.indexOf(46)) < 0 || shortMetabaseNames.contains((Object)(strShortMB = strMB.substring(strMB.indexOf(46) + 1, strMB.length())))) continue;
            shortMetabaseNames.add(strShortMB);
        }
        return shortMetabaseNames;
    }

    @Override
    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        if (!this.childrenInitialized) {
            this.initializeChildren();
        }
        SimpleNodeInterface[] sniArray = new SimpleNodeInterface[count];
        int cnt = startIndex + count;
        for (int i = startIndex; i < cnt; ++i) {
            sniArray[i - startIndex] = (SimpleNodeInterface)this.nodeChildren.get(i);
        }
        return sniArray;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public int getNodeChildCount() {
        int childCount;
        if (!this.childrenInitialized) {
            this.initializeChildren();
        }
        if ((childCount = this.nodeChildren.count()) == 0 && this.hasChildren) {
            this.hasChildren = false;
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return childCount;
    }

    @Override
    public String getNodeText() {
        return "Metabase List";
    }

    @Override
    public IconInterface getDefaultIcon() {
        return null;
    }
}

