/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.dialogs;

import com.sas.sasserver.mdtable.ComputedValuesCustomizerPanel;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewDialog
extends JDialog
implements ActionListener {
    protected static final String RB_KEY = "NewDialog.";
    protected String _title;
    private MultidimensionalTableInterface _imddb;
    private Level _level;
    private ComputedValuesCustomizerPanel _cvPanel;
    private JButton cancelBtn;
    private JButton okBtn;
    private JTextField newText;
    private Frame parentFrame;
    private boolean _isNew;

    public NewDialog(Frame frame, String title, boolean modal, ComputedValuesCustomizerPanel cvPanel) {
        super(frame, title, modal);
        this.parentFrame = frame;
        this._title = title;
        this._cvPanel = cvPanel;
        this.createNewPanel();
    }

    public NewDialog(Frame frame, boolean isNew, boolean modal, ComputedValuesCustomizerPanel cvPanel) {
        this(frame, isNew ? RB.getStringResource(RB_KEY, "newTitle.txt") : RB.getStringResource(RB_KEY, "renameTitle.txt"), modal, cvPanel);
        this._isNew = isNew;
    }

    @Override
    public void setTitle(String title) {
        this._title = title;
    }

    private void createNewPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5));
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel textContainer = new JPanel();
        textContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 5, 0));
        JLabel newLabel = new JLabel(RB.getStringResource(RB_KEY, "newlabel.txt"));
        this.newText = new JTextField();
        this.newText.setColumns(20);
        this.newText.addActionListener(this);
        textContainer.add(newLabel);
        textContainer.add(this.newText);
        textContainer.requestFocus();
        topPanel.add(textContainer);
        JPanel btnContainer = new JPanel();
        AutoSizingGridLayout btnContainerLayout = new AutoSizingGridLayout(1, 3, 5, 0, true, true, true);
        btnContainerLayout.setGridGravity(2);
        btnContainer.setLayout((LayoutManager)btnContainerLayout);
        this.okBtn = new JButton(Util.getCommonStringResource((String)"Ok.txt"));
        this.cancelBtn = new JButton(Util.getCommonStringResource((String)"Cancel.txt"));
        this.okBtn.addActionListener(this);
        btnContainer.add(this.okBtn);
        this.cancelBtn.addActionListener(this);
        btnContainer.add(this.cancelBtn);
        topPanel.add(btnContainer);
        this.getContentPane().add(topPanel);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        if (eSource == this.cancelBtn) {
            this.setVisible(false);
        } else if (eSource == this.okBtn || eSource == this.newText) {
            String cvName = this.newText.getText();
            boolean isAdded = false;
            isAdded = this._isNew ? this._cvPanel.addCVNode(cvName) : this._cvPanel.replaceCVNode(cvName);
            if (!isAdded) {
                this.displayError();
            } else {
                this.setVisible(false);
            }
        }
    }

    private void displayError() {
        String findError = RB.getStringResource(RB_KEY, "error.txt");
        String findTitle = RB.getStringResource(RB_KEY, "errorTitle.txt");
        JOptionPane.showMessageDialog(null, findError, findTitle, -1);
    }
}

