/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.dialogs;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.MultidimensionalTableView;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.LevelTable;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.Row;
import com.sas.swing.visuals.table.RowSelection;
import com.sas.swing.visuals.table.TableView;
import com.sas.table.Column;
import com.sas.table.ColumnSelection;
import com.sas.table.DataCell;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class FindDialog
extends JDialog
implements ActionListener {
    private transient MultidimensionalTableInterface _imddb;
    private transient com.sas.table.TableView currentMDTable;
    private transient BaseTableView swingMDTable;
    private transient Member _member;
    private transient Level _level;
    private transient Axis axis;
    private transient boolean ignoreCase;
    private transient JCheckBox caseSensitive;
    private transient JButton findNextBtn;
    private transient JPanel directionBox;
    private transient JPanel matchOnBox;
    private transient ButtonGroup directionButtonGroup;
    private transient ButtonGroup matchOnButtonGroup;
    private transient JButton closeBtn;
    private transient JTextField findText;
    private transient int index;
    private transient int previousIndex;
    private transient String previousFind;
    private transient boolean _isMDTable;
    private transient Frame parentFrame;
    private transient int _version;
    private boolean isTransposed;
    protected static final String RB_KEY = "FindDialog.";

    public FindDialog(Frame frame, boolean modal) {
        this(frame, RB.getStringResource(RB_KEY, "title.txt"), modal);
    }

    public FindDialog(Dialog dialog, boolean modal) {
        super(dialog, RB.getStringResource(RB_KEY, "title.txt"), modal);
        this._isMDTable = true;
    }

    public FindDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.parentFrame = frame;
        this._isMDTable = true;
    }

    public FindDialog(Frame frame, boolean modal, ParentNode node, Component _view) {
        this(frame, modal);
        if (node != null) {
            if (node instanceof Level) {
                this.setLevel((Level)node);
            } else if (node instanceof Member) {
                this.setMember((Member)node);
            }
        }
        if (_view != null && _view instanceof BaseTableView) {
            this.setMultidimensionalTableView((BaseTableView)_view);
        } else if (_view != null && _view instanceof com.sas.table.TableView) {
            this.currentMDTable = (com.sas.table.TableView)_view;
            this.swingMDTable = null;
            this._isMDTable = true;
        }
    }

    public void setMember(Member member) {
        this._member = member;
        this.setMultidimensionalTableInterface(this._member.getImddb());
        this._level = (Level)member.getLevel();
    }

    public void setLevel(Level level) {
        this._level = level;
        this.setMultidimensionalTableInterface(this._level.getImddb());
    }

    public void setMultidimensionalTableInterface(MultidimensionalTableInterface mdTableInt) {
        this._imddb = mdTableInt;
        if (this._imddb instanceof MultidimensionalTableV3Interface) {
            this._version = 3;
        } else if (this._imddb instanceof MultidimensionalTableV2Interface) {
            this._version = 2;
        }
    }

    public void setMultidimensionalTableView(com.sas.table.TableView mdTableView) {
        this.currentMDTable = mdTableView;
        try {
            if (this.currentMDTable != null && !(this.currentMDTable instanceof MultidimensionalTableView)) {
                DataCell dc;
                int ind;
                this.axis = (Axis)this._imddb.getAxis(1);
                this._isMDTable = false;
                if (this.findText != null && (ind = this.getSelectionIndex()) >= 0 && (dc = this.currentMDTable.getCell(this.currentMDTable.findRow(ind), this.currentMDTable.findColumn(1))) != null) {
                    this.findText.setText((String)dc.getObjectData());
                    this.findText.selectAll();
                }
            } else {
                this.setTransposed();
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public void setMultidimensionalTableView(BaseTableView mdTableView) {
        this.swingMDTable = mdTableView;
        try {
            if (this.swingMDTable != null && !(this.swingMDTable instanceof com.sas.swing.visuals.mdtable.MultidimensionalTableView)) {
                com.sas.swing.visuals.table.DataCell dc;
                int ind;
                this.axis = (Axis)this._imddb.getAxis(1);
                this._isMDTable = false;
                if (this.findText != null && (ind = this.getSelectionIndex()) >= 0 && (dc = this.swingMDTable.getCell(this.swingMDTable.findRow(ind), this.swingMDTable.findColumn(1))) != null) {
                    this.findText.setText((String)dc.getObjectData());
                    this.findText.selectAll();
                }
            } else {
                this.setTransposed();
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public void setDefaultValues() {
        this.index = 0;
        this.previousIndex = 0;
        this.axis = null;
        this.previousFind = "";
    }

    public void initialize() {
        this.createFindPanel();
    }

    private void createFindPanel() {
        JPanel findPanel = new JPanel();
        findPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout findPanelLayout = new AutoSizingGridLayout(1, 1, 15, 5, true, false, false);
        findPanel.setLayout((LayoutManager)findPanelLayout);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, false, false));
        JPanel rightPanel = new JPanel();
        AutoSizingGridLayout rightPanelLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, false);
        rightPanelLayout.setRemainderRow(3);
        rightPanel.setLayout((LayoutManager)rightPanelLayout);
        JPanel textContainer = new JPanel();
        JLabel findLabel = new JLabel(RB.getStringResource(RB_KEY, "findLabel.txt"));
        this.findText = new JTextField();
        AutoSizingGridLayout textLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, true);
        textLayout.setRemainderColumn(2);
        textContainer.setLayout((LayoutManager)textLayout);
        this.findText.addActionListener(this);
        textContainer.add(findLabel);
        textContainer.add(this.findText);
        leftPanel.add(textContainer);
        findPanel.add(leftPanel);
        findPanel.add(rightPanel);
        this.findNextBtn = new JButton(RB.getStringResource(RB_KEY, "findNextBtn.txt"));
        this.closeBtn = new JButton(RB.getStringResource(RB_KEY, "cancelBtn.txt"));
        this.findNextBtn.addActionListener(this);
        this.closeBtn.addActionListener(this);
        rightPanel.add(this.findNextBtn);
        JPanel oContainer = new JPanel();
        oContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 15, 5, true, false, false));
        this.matchOnBox = new JPanel();
        AutoSizingGridLayout radioLayout = new AutoSizingGridLayout(3, 1, 0, 0, true, false, false);
        this.matchOnBox.setLayout((LayoutManager)radioLayout);
        this.matchOnButtonGroup = new ButtonGroup();
        JRadioButton matchOnButton1 = new JRadioButton(RB.getStringResource(RB_KEY, "sel1.txt"));
        matchOnButton1.setActionCommand(RB.getStringResource(RB_KEY, "sel1.txt"));
        matchOnButton1.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        matchOnButton1.setSelected(true);
        JRadioButton matchOnButton2 = new JRadioButton(RB.getStringResource(RB_KEY, "sel2.txt"));
        matchOnButton2.setActionCommand(RB.getStringResource(RB_KEY, "sel2.txt"));
        matchOnButton2.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        JRadioButton matchOnButton3 = new JRadioButton(RB.getStringResource(RB_KEY, "sel3.txt"));
        matchOnButton3.setActionCommand(RB.getStringResource(RB_KEY, "sel3.txt"));
        matchOnButton3.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        matchOnButton1.addActionListener(this);
        matchOnButton2.addActionListener(this);
        matchOnButton3.addActionListener(this);
        this.matchOnButtonGroup.add(matchOnButton1);
        this.matchOnButtonGroup.add(matchOnButton2);
        this.matchOnButtonGroup.add(matchOnButton3);
        this.matchOnBox.add(matchOnButton1);
        this.matchOnBox.add(matchOnButton2);
        this.matchOnBox.add(matchOnButton3);
        if (this._version < 3) {
            Enumeration<AbstractButton> matchEnum = this.matchOnButtonGroup.getElements();
            boolean first = true;
            while (matchEnum.hasMoreElements()) {
                if (!first) {
                    ((JRadioButton)matchEnum.nextElement()).setEnabled(false);
                    continue;
                }
                first = false;
            }
        }
        TitledBorder bp = BorderFactory.createTitledBorder(RB.getStringResource(RB_KEY, "matchOn.txt"));
        Border margin = BorderFactory.createEmptyBorder(5, 5, 0, 30);
        this.matchOnBox.setBorder(BorderFactory.createCompoundBorder(bp, margin));
        oContainer.add(this.matchOnBox);
        JPanel container = new JPanel();
        container.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 15, true, false, true));
        this.caseSensitive = new JCheckBox(RB.getStringResource(RB_KEY, "matchCase.txt"));
        this.directionBox = new JPanel();
        AutoSizingGridLayout directionLayout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, false);
        this.directionBox.setLayout((LayoutManager)directionLayout);
        this.directionButtonGroup = new ButtonGroup();
        JRadioButton directionButton1 = new JRadioButton(RB.getStringResource(RB_KEY, "item1.txt"));
        directionButton1.setActionCommand(RB.getStringResource(RB_KEY, "item1.txt"));
        JRadioButton directionButton2 = new JRadioButton(RB.getStringResource(RB_KEY, "item2.txt"));
        directionButton2.setActionCommand(RB.getStringResource(RB_KEY, "item2.txt"));
        directionButton2.setSelected(true);
        directionButton1.addActionListener(this);
        directionButton2.addActionListener(this);
        this.directionButtonGroup.add(directionButton1);
        this.directionButtonGroup.add(directionButton2);
        this.directionBox.add(directionButton1);
        this.directionBox.add(directionButton2);
        TitledBorder b = BorderFactory.createTitledBorder(RB.getStringResource(RB_KEY, "direction.txt"));
        margin = BorderFactory.createEmptyBorder(0, 5, 0, 5);
        this.directionBox.setBorder(BorderFactory.createCompoundBorder(b, margin));
        container.add(this.directionBox);
        container.add(this.caseSensitive);
        oContainer.add(container);
        leftPanel.add(oContainer);
        rightPanel.add(this.closeBtn);
        rightPanel.add(new JLabel());
        this.getContentPane().add(findPanel);
    }

    private void setValues() {
        if (this._level == null) {
            this._level = (Level)this._member.getLevel();
        }
        if (this.axis == null) {
            if (this._member != null) {
                this.axis = (Axis)this._member.getDelegate().getRootParent();
            } else if (this._level != null) {
                this.axis = (Axis)this._level.getDimension().getAxis();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        boolean found = false;
        this.setValues();
        if (eSource == this.closeBtn) {
            this.setVisible(false);
        } else if (eSource == this.findNextBtn || eSource == this.findText) {
            this.ignoreCase = !this.caseSensitive.isSelected();
            found = this.directionButtonGroup.getSelection().getActionCommand().equals(RB.getStringResource(RB_KEY, "item2.txt")) ? this.find(true) : this.find(false);
            if (!found) {
                this.displayError();
            }
        }
    }

    private void displayError() {
        if (this.previousFind == null) {
            this.previousFind = "";
        }
        String findError = Message.format((String)RB.getStringResource(RB_KEY, "notFound.txt"), (Object)this.previousFind);
        JOptionPane.showMessageDialog(null, findError, "Error", 2);
        if (this.currentMDTable != null) {
            this.currentMDTable.unselect();
        } else if (this.swingMDTable != null) {
            this.swingMDTable.unselect();
        }
    }

    private boolean find(boolean forward) {
        String findString = this.findText.getText();
        if (findString == null) {
            return false;
        }
        if (!this._isMDTable) {
            return this.findTableMember(forward, findString);
        }
        try {
            int magnitude = this.axis.getMagnitude();
            this.previousIndex = this.getSelectionIndex();
            if (!forward) {
                this.previousIndex -= 2;
            }
            HList tupleList = Level.tupleToHList(this._level);
            int sel = -1;
            Enumeration<AbstractButton> buttons = this.matchOnButtonGroup.getElements();
            boolean selected = false;
            while (buttons.hasMoreElements() && !selected) {
                selected = ((JRadioButton)buttons.nextElement()).isSelected();
                ++sel;
            }
            if (this._imddb instanceof MultidimensionalTableV2Interface) {
                if (forward) {
                    if (this.previousFind == null) {
                        this.previousFind = "";
                    }
                    if (this.previousFind.equalsIgnoreCase(findString) && this.index == -1 && this.previousIndex < magnitude) {
                        this.previousIndex = 0;
                    }
                    this.previousFind = findString;
                    if (this.previousIndex < 0) {
                        this.previousIndex = this.index > 0 ? this.index : 0;
                    }
                    this.index = this._version > 2 ? ((MultidimensionalTableV3Interface)this._imddb).findNextLabel(this.axis.getOrdinal(), (HListInterface)tupleList, findString, this.ignoreCase, this.previousIndex, sel) : ((MultidimensionalTableV2Interface)this._imddb).findNextAxisLabel(this.axis.getOrdinal(), (HListInterface)tupleList, findString, this.ignoreCase, this.previousIndex);
                    this.previousIndex = this.index + 1;
                } else {
                    if (this.previousFind == null) {
                        this.previousFind = "";
                    }
                    if (this.previousFind.equalsIgnoreCase(findString) && this.index == -1 && this.previousIndex < magnitude) {
                        this.previousIndex = magnitude - 1;
                    }
                    this.previousFind = findString;
                    this.index = this._version > 2 ? ((MultidimensionalTableV3Interface)this._imddb).findPrevLabel(this.axis.getOrdinal(), (HListInterface)tupleList, findString, this.ignoreCase, this.previousIndex, sel) : ((MultidimensionalTableV2Interface)this._imddb).findPrevAxisLabel(this.axis.getOrdinal(), (HListInterface)tupleList, findString, this.ignoreCase, this.previousIndex);
                    this.previousIndex = this.index - 1;
                }
            } else {
                this.index = -1;
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        if (this.index >= 0) {
            this.updateTable(this.index);
            return true;
        }
        return false;
    }

    private int getSelectionIndex() {
        Object o = null;
        Object[] selections = null;
        if (this.currentMDTable != null) {
            selections = this.currentMDTable.getSelectedObjects();
        } else if (this.swingMDTable != null) {
            selections = this.swingMDTable.getSelectedObjects();
        }
        if (selections != null) {
            o = selections[selections.length - 1];
        }
        if (o != null) {
            if (o instanceof com.sas.swing.visuals.table.ColumnSelection) {
                com.sas.swing.visuals.table.Column c = (com.sas.swing.visuals.table.Column)((com.sas.swing.visuals.table.ColumnSelection)o).getEnd();
                return c.getIndex();
            }
            if (o instanceof RowSelection) {
                Row r = (Row)((RowSelection)o).getEnd();
                return r.getIndex();
            }
            if (o instanceof ColumnSelection) {
                Column c = (Column)((ColumnSelection)o).getEnd();
                return c.getIndex();
            }
            if (o instanceof com.sas.table.RowSelection) {
                com.sas.table.Row r = (com.sas.table.Row)((com.sas.table.RowSelection)o).getEnd();
                return r.getIndex();
            }
        }
        return -1;
    }

    private boolean findTableMember(boolean forward, String findString) {
        LevelTable levelTable = null;
        if (this.currentMDTable != null) {
            levelTable = (LevelTable)this.currentMDTable.getModelInterface();
        } else if (this.swingMDTable != null) {
            levelTable = (LevelTable)((TableView)this.swingMDTable).getModel();
        }
        int sel = this.getSelectionIndex();
        int how = -1;
        Enumeration<AbstractButton> buttons = this.matchOnButtonGroup.getElements();
        boolean selected = false;
        while (buttons.hasMoreElements() && !selected) {
            selected = ((JRadioButton)buttons.nextElement()).isSelected();
            ++how;
        }
        if (sel > this.previousIndex) {
            this.previousIndex = sel;
        }
        if (!forward && this.previousIndex > 0) {
            this.previousIndex -= 2;
        } else if (!forward) {
            try {
                this.previousIndex = levelTable.countRows(0) - 1;
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        if (forward) {
            try {
                if (this.previousFind == null) {
                    this.previousFind = "";
                }
                if (this.previousFind.equalsIgnoreCase(findString) && this.index == -1 && this.previousIndex < levelTable.countRows(0)) {
                    this.previousIndex = 0;
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
            this.previousFind = findString;
            if (this.previousIndex < 0) {
                this.previousIndex = this.index > 0 ? this.index : 0;
            }
            this.index = this._version > 2 ? ((MultidimensionalTableV3Interface)this._imddb).findNextMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex, how) : ((MultidimensionalTableV2Interface)this._imddb).findNextMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex);
            this.previousIndex = this.index + 1;
            while (levelTable.isIndexRemoved(this.index)) {
                this.index = this._version > 2 ? ((MultidimensionalTableV3Interface)this._imddb).findNextMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex, how) : ((MultidimensionalTableV2Interface)this._imddb).findNextMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex);
                this.previousIndex = this.index + 1;
            }
        } else {
            this.previousFind = findString;
            this.index = this._version > 2 ? ((MultidimensionalTableV3Interface)this._imddb).findPrevMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex, how) : ((MultidimensionalTableV2Interface)this._imddb).findPrevMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex);
            this.previousIndex = this.index - 1;
            while (levelTable.isIndexRemoved(this.index)) {
                this.index = this._version > 2 ? ((MultidimensionalTableV3Interface)this._imddb).findPrevMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex, how) : ((MultidimensionalTableV2Interface)this._imddb).findPrevMember(levelTable.getName(), findString, this.ignoreCase, this.previousIndex);
                this.previousIndex = this.index - 1;
            }
        }
        if (this.index >= 0) {
            int cnt = levelTable.getRemoveCount(this.index, true);
            this.updateTable(this.index - cnt);
            return true;
        }
        return false;
    }

    private void setTransposed() {
        if (this._isMDTable && (this.currentMDTable != null && ((MultidimensionalTableView)this.currentMDTable).isTransposed() || this.swingMDTable != null && ((com.sas.swing.visuals.mdtable.MultidimensionalTableView)this.swingMDTable).isTransposed())) {
            this.isTransposed = true;
            return;
        }
        this.isTransposed = false;
    }

    private void updateTable(int axisCoordinate) {
        if (axisCoordinate < 0) {
            return;
        }
        ++axisCoordinate;
        if (this.currentMDTable != null) {
            if (this.axis.getOrdinal() == 1 && !this.isTransposed || this.axis.getOrdinal() == 0 && this.isTransposed) {
                com.sas.table.Row itemRow = this.currentMDTable.getRow(axisCoordinate);
                this.currentMDTable.scrollToRow(itemRow, true);
                this.currentMDTable.select(itemRow, itemRow, false);
            } else if (this.axis.getOrdinal() == 0 && !this.isTransposed || this.axis.getOrdinal() == 1 && this.isTransposed) {
                Column itemCol = this.currentMDTable.getColumn(axisCoordinate);
                this.currentMDTable.scrollToColumn(itemCol, true);
                this.currentMDTable.select(itemCol, itemCol, false);
            }
        } else if (this.swingMDTable != null) {
            if (this.axis.getOrdinal() == 1 && !this.isTransposed || this.axis.getOrdinal() == 0 && this.isTransposed) {
                Row itemRow = this.swingMDTable.getRow(axisCoordinate);
                this.swingMDTable.scrollToRow(itemRow, true);
                this.swingMDTable.select(itemRow, itemRow, false);
            } else if (this.axis.getOrdinal() == 0 && !this.isTransposed || this.axis.getOrdinal() == 1 && this.isTransposed) {
                com.sas.swing.visuals.table.Column itemCol = this.swingMDTable.getColumn(axisCoordinate);
                this.swingMDTable.scrollToColumn(itemCol, true);
                this.swingMDTable.select(itemCol, itemCol, false);
            }
        }
    }
}

