/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.dialogs;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.swing.visuals.SpinBox;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FilterDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final String RB_KEY = "FilterDialog.";
    protected boolean _wasCancelled;
    protected transient JButton okButton;
    protected transient JButton cancelButton;
    protected transient JButton clearButton;
    protected transient SpinBox spinBox;
    protected transient JComboBox choice;
    private transient MultidimensionalTableV2Interface _imddb;
    private transient Member _member;
    private transient String _title;
    private boolean _isModified;

    public FilterDialog(Frame frame, String title) {
        super(frame, RB.getStringResource(RB_KEY, "title.txt"), true);
        this.createFilterPanel();
        this._title = title;
    }

    public void setMember(Member member) {
        if (member == null) {
            return;
        }
        this._member = member;
        this._imddb = (MultidimensionalTableV2Interface)member.getImddb();
        int val = this._member.getTopBottomN();
        int order = this._member.getSortOrder();
        if (order != 1 && order != 2) {
            order = 1;
        }
        this.choice.setSelectedIndex(order - 1);
        this.spinBox.setValue(Math.max(val, 0));
    }

    public void setDefaultValues() {
    }

    private void createFilterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 2, 10, 10, true, false, false));
        Border eborder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        panel.setBorder(eborder);
        Border b = BorderFactory.createEtchedBorder();
        JPanel topContainer = new JPanel();
        topContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 3, 15, 10, true, false, false));
        topContainer.setBorder(BorderFactory.createTitledBorder(b, RB.getStringResource(RB_KEY, "show.txt")));
        String[] sa = new String[]{RB.getStringResource(RB_KEY, "top.txt"), RB.getStringResource(RB_KEY, "bottom.txt")};
        this.choice = new JComboBox<String>(sa);
        JComboBox<String> comboBox = new JComboBox<String>(new String[]{RB.getStringResource(RB_KEY, "item.txt")});
        this.spinBox = new SpinBox();
        BoundedLong bl = new BoundedLong();
        this.spinBox.setModel((BoundedNumberInterface)bl);
        this.spinBox.setValue(0);
        topContainer.add(this.choice);
        topContainer.add(this.spinBox);
        topContainer.add(comboBox);
        panel.add(topContainer);
        JPanel buttonPanel = new JPanel((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, false, false));
        buttonPanel.setBorder(eborder);
        this.okButton = new JButton(Message.format((String)com.sas.visuals.RB.getStringResource((String)"okButton.txt"), (Object)"     ", (Object)"     "));
        this.cancelButton = new JButton(Message.format((String)com.sas.visuals.RB.getStringResource((String)"cancelButton.txt"), (Object)" ", (Object)"  "));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        panel.add(buttonPanel);
        JPanel bottomContainer = new JPanel();
        bottomContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 15, 10));
        this.clearButton = new JButton(Message.format((String)RB.getStringResource(RB_KEY, "clear.txt"), (Object)" ", (Object)" "));
        bottomContainer.add(this.clearButton);
        panel.add(bottomContainer);
        this.getContentPane().add(panel);
        this.clearButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.choice.addItemListener(this);
        this.spinBox.addItemListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.okButton) {
            this.setVisible(false);
            String s = this.spinBox.getText();
            int n = 0;
            try {
                n = new Integer(s);
            }
            catch (NumberFormatException ne) {
                return;
            }
            this.sort(n);
        } else if (source == this.clearButton) {
            this.setVisible(false);
            this.spinBox.setText("-0");
            this.sort(0);
        } else if (source == this.cancelButton) {
            this.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.spinBox) {
            String s = this.spinBox.getText();
            int n = new Integer(s);
            this.sort(n);
        }
    }

    private void sort(int n) {
        if (this._member == null) {
            return;
        }
        int axisOrdinal = ((Axis)this._member.getDelegate().getRootParent()).getOrdinal();
        HList tupleList = Member.tupleToHList(this._member);
        String direction = com.sas.sasserver.mdtable.commands.RB.getStringResource("ascending.txt");
        if (this.spinBox.getText().equals("-0")) {
            direction = com.sas.sasserver.mdtable.commands.RB.getStringResource("reset.txt");
        } else {
            String selection = (String)this.choice.getSelectedItem();
            if (selection.indexOf(RB.getStringResource(RB_KEY, "top.txt")) >= 0) {
                direction = com.sas.sasserver.mdtable.commands.RB.getStringResource("descending.txt");
            }
        }
        this._member.setSortDirection(direction);
        String serverCommand = this.getServerCommand(direction);
        this._imddb.sort(axisOrdinal, (HListInterface)tupleList, serverCommand, Math.abs(n));
    }

    private String getServerCommand(String direction) {
        if (direction == com.sas.sasserver.mdtable.commands.RB.getStringResource("ascending.txt")) {
            return "Ascending";
        }
        if (direction == com.sas.sasserver.mdtable.commands.RB.getStringResource("descending.txt")) {
            return "Descending";
        }
        return "Reset";
    }

    public void finish() {
        this.dispose();
    }
}

