/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.dialogs;

import com.sas.awt.Container;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.mdtable.commands.ExportToExcelCommand;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.swing.visuals.table.TableView;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DetailDataDialog
extends JDialog
implements ActionListener {
    protected JLabel n;
    protected JLabel m;
    protected JLabel label;
    protected transient JButton closeButton;
    protected transient JButton excelButton;
    protected transient JButton queryButton;
    protected transient TableView tv;
    protected transient JTextField queryTextField;
    protected transient StaticTableInterface modeldsi;
    protected transient String dataSetName;
    protected transient Connection connection;
    protected transient DataSetInterface dataSetInterface;
    protected static final String RB_KEY = "DetailDataDialog.";
    protected static String DETAILLABEL = RB.getStringResource("DetailDataDialog.", "detailLabel.txt");
    protected static String TITLE = RB.getStringResource("DetailDataDialog.", "title.txt");

    public DetailDataDialog(Frame f, StaticTableInterface dsi) {
        super(f, TITLE, false);
        this.modeldsi = dsi;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout((LayoutManager)new AutoSizingGridLayout(4, 1, 10, 5, true, true, true));
        EmptyBorder mainborder = new EmptyBorder(5, 10, 0, 10);
        mainPanel.setBorder(mainborder);
        this.n = new JLabel();
        this.label = new JLabel();
        this.label.setPreferredSize(new Dimension(300, 30));
        this.label.setHorizontalAlignment(0);
        this.label.setHorizontalTextPosition(0);
        mainPanel.add(this.label);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, true, true));
        tablePanel.setDoubleBuffered(true);
        this.tv = new TableView();
        this.tv.setModel(dsi);
        this.updateLabel(null);
        tablePanel.add(this.tv);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 7, 0));
        if (ExportToExcelCommand.isExportAllowed()) {
            this.excelButton = new JButton(RB.getStringResource(RB_KEY, "export.txt"));
            this.excelButton.addActionListener(this);
            buttonPanel.add(this.excelButton);
        }
        if (dsi instanceof RemoteBaseClient) {
            this.connection = ((RemoteBaseClient)dsi)._RemoteObject_getContext();
        }
        if (dsi instanceof DataSetInterface) {
            this.dataSetInterface = (DataSetInterface)dsi;
            this.dataSetName = this.dataSetInterface.getDataSet();
        }
        if (this.connection != null && this.dataSetInterface != null) {
            Container container = this.getWhereClausePanel();
            tablePanel.add(container);
        }
        mainPanel.add(tablePanel);
        this.closeButton = new JButton(RB.getStringResource(RB_KEY, "close.txt"));
        this.closeButton.setPreferredSize(new Dimension(100, 25));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
    }

    protected Container getWhereClausePanel() {
        Container whereContainer = new Container();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 3, 15, 10, true, false, true);
        layout.setRemainderColumn(2);
        whereContainer.setLayout((LayoutManager)layout);
        JLabel queryLabel = new JLabel(RB.getStringResource(RB_KEY, "whereLabel.txt"));
        this.queryTextField = new JTextField();
        this.queryTextField.addActionListener(this);
        this.queryButton = new JButton(Util.getCommonStringResource((String)"NewWindow.txt"));
        this.queryButton.addActionListener(this);
        whereContainer.add(queryLabel);
        whereContainer.add(this.queryTextField);
        whereContainer.add(this.queryButton);
        return whereContainer;
    }

    public void setPanelModel(StaticTableInterface dsi) {
        if (this.modeldsi != null) {
            this.tv.setModel(null);
        }
        if (this.queryTextField != null) {
            this.queryTextField.setText("");
        }
        this.modeldsi = dsi;
        this.tv.setModel(dsi);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.closeButton) {
            this.dispose();
        } else if (source == this.excelButton) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ExportToExcelCommand.export(this.modeldsi);
            this.setCursor(Cursor.getDefaultCursor());
        } else if (source == this.queryButton) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.queryTextField.getText() == null) {
                this.queryTextField.setText("");
            }
            String whereClause = null;
            try {
                Class<?> whereCustomizerDialogUtilClass = Class.forName("com.sas.sasserver.dataset.WhereCustomizerDialogUtil");
                Object wcdu = whereCustomizerDialogUtilClass.newInstance();
                Method showWhereCustomizerDialogMethod = whereCustomizerDialogUtilClass.getMethod("showWhereCustomizerDialog", Component.class, Connection.class, String.class, String.class);
                whereClause = (String)showWhereCustomizerDialogMethod.invoke(wcdu, this, this.connection, this.dataSetName, this.queryTextField.getText());
            }
            catch (Exception ite) {
                ite.printStackTrace();
            }
            if (whereClause != null) {
                this.queryTextField.setText(whereClause);
                this.dataSetInterface.setWhere(whereClause);
            }
            this.setCursor(Cursor.getDefaultCursor());
        } else if (source == this.queryTextField) {
            this.dataSetInterface.setWhere(this.queryTextField.getText());
        }
    }

    public void updateLabel(String lb) {
        int numrows = -1;
        try {
            numrows = this.modeldsi.getRowCount();
        }
        catch (TableException tableException) {
            // empty catch block
        }
        if (lb != null) {
            this.label.setText(lb);
        }
        if (numrows < 0) {
            this.n.setVisible(false);
        } else {
            this.n.setVisible(true);
            this.n.setText(DETAILLABEL + numrows);
        }
    }
}

