/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.dialogs;

import com.sas.mdtable.LevelInterface;
import com.sas.sasserver.mdtable.ComputedValuesCustomizerPanel;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ComputedValuesDialog
extends JDialog {
    public static final String RB_KEY = "ComputedValuesDialog.";
    protected ComputedValuesCustomizerPanel _panel;
    protected MultidimensionalTableInterface _imddb;
    protected Level _level;
    protected boolean _wasCancelled;
    private transient String label1 = RB.getStringResource("ComputedValuesDialog.", "label1.txt");
    private transient String label2 = RB.getStringResource("ComputedValuesDialog.", "label2.txt");

    public ComputedValuesDialog(Frame f, MultidimensionalTableInterface multidimensionalTableInterface) {
        super(f, RB.getStringResource(RB_KEY, "title.txt"), true);
        this._imddb = multidimensionalTableInterface;
        this.init();
    }

    public ComputedValuesDialog(JFrame f, MultidimensionalTableInterface multidimensionalTableInterface) {
        super(f, RB.getStringResource(RB_KEY, "title.txt"), true);
        this._imddb = multidimensionalTableInterface;
        this.init();
    }

    public ComputedValuesDialog(JFrame f, LevelInterface level) {
        super(f, RB.getStringResource(RB_KEY, "title.txt"), true);
        if (level != null && level instanceof Level) {
            this._level = (Level)level;
            this._imddb = this._level.getImddb();
        }
        this.init();
    }

    public void init() {
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 10, 5);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(3, 1, 5, 5);
        this.getContentPane().setLayout((LayoutManager)layout);
        this.getRootPane().setBorder(emptyBorder);
        JPanel labelPanel = new JPanel((LayoutManager)new AutoSizingGridLayout(2, 4, 0, 0, true, false, false));
        JLabel labela = new JLabel(this.label1);
        JLabel labelb = new JLabel(this.label2);
        labelPanel.setPreferredSize(new Dimension(500, 40));
        labela.setFont(new Font("Dialog", 0, 12));
        labelb.setFont(new Font("Dialog", 0, 12));
        labelPanel.add(labela);
        labelPanel.add(labelb);
        this.getContentPane().add("North", labelPanel);
        if (this._level != null) {
            this._panel = new ComputedValuesCustomizerPanel("foo", this._level);
            this.getContentPane().add("Center", this._panel);
        } else {
            this._panel = new ComputedValuesCustomizerPanel();
            this.getContentPane().add("Center", this._panel);
        }
        this.setImddb(this._imddb);
        this._panel.initialize();
        JPanel buttonPanel = new JPanel((LayoutManager)new AutoSizingGridLayout(1, 3, 5, 5));
        this.getContentPane().add("South", buttonPanel);
        buttonPanel.add(new JLabel("                                                                                             "));
        JButton ok = new JButton(Message.format((String)com.sas.visuals.RB.getStringResource((String)"okButton.txt"), (Object)"    ", (Object)"    "));
        buttonPanel.add(ok);
        final JButton cancel = new JButton(Message.format((String)com.sas.visuals.RB.getStringResource((String)"cancelButton.txt"), (Object)" ", (Object)" "));
        buttonPanel.add(cancel);
        final JButton apply = new JButton(Message.format((String)RB.getStringResource("apply.txt"), (Object)"  ", (Object)" "));
        buttonPanel.add(apply);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == cancel) {
                    ComputedValuesDialog.this._wasCancelled = true;
                    ComputedValuesDialog.this.finish();
                } else if (e.getSource() == apply) {
                    ComputedValuesDialog.this.apply();
                } else {
                    ComputedValuesDialog.this.finish();
                    ComputedValuesDialog.this._panel.preCustomizerClosing();
                }
            }
        };
        ok.addActionListener(buttonListener);
        cancel.addActionListener(buttonListener);
        apply.addActionListener(buttonListener);
        this.setResizable(true);
    }

    public void finish() {
        if (this._panel.finish(this._wasCancelled, false)) {
            this.dispose();
        }
    }

    public void apply() {
        this._panel.finish(this._wasCancelled, true);
    }

    public void setImddb(MultidimensionalTableInterface imddb) {
        this._panel.setObject(imddb);
    }
}

