/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.dialogs;

import com.sas.sasserver.mdtable.BaseMDInterfaceCustomizerPanel;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

abstract class BaseMDPanelDialog
extends JDialog {
    protected Container _contentPanel;
    protected BaseMDInterfaceCustomizerPanel _mdPanel;
    protected MultidimensionalTableInterface _mdTable;
    protected Object _extraData;
    boolean _wasCancelled;
    JPanel buttonPanel;
    JButton _okButton;
    JButton _cancelButton;
    JButton _applyButton;

    public BaseMDPanelDialog(Frame f, MultidimensionalTableInterface mdTable) {
        this(f, mdTable, null);
    }

    public BaseMDPanelDialog(Frame f, MultidimensionalTableInterface mdTable, Object extraData) {
        super(f, true);
        this.setTitle(this.getDialogTitle());
        this._extraData = extraData;
        this._contentPanel = this.getContentPanel();
        this._mdPanel = this.getMDPanel();
        if (this._contentPanel == null) {
            this._contentPanel = this._mdPanel;
        }
        this.createRootPanel();
        this._mdPanel.setObject(mdTable);
        this._mdTable = mdTable;
        this._mdPanel.onInitialize();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                BaseMDPanelDialog.this.onCancel();
            }
        });
        this.setResizable(true);
    }

    protected Object getExtraData() {
        return this._extraData;
    }

    protected abstract String getDialogTitle();

    protected abstract BaseMDInterfaceCustomizerPanel getMDPanel();

    protected Container getContentPanel() {
        return null;
    }

    protected void createRootPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 10, true, true, true);
        layout.setRemainderRow(1);
        this.getContentPane().setLayout((LayoutManager)layout);
        JPanel fp = new JPanel();
        AutoSizingGridLayout fpLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        fp.setLayout((LayoutManager)fpLayout);
        EmptyBorder fpborder = new EmptyBorder(10, 10, 0, 10);
        fp.setBorder(fpborder);
        fp.add(this._contentPanel);
        this.getContentPane().add("Center", fp);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 5));
        EmptyBorder border = new EmptyBorder(0, 10, 10, 10);
        this.buttonPanel.setBorder(border);
        JPanel outerButtonPanel = new JPanel();
        outerButtonPanel.setLayout(new FlowLayout(2));
        outerButtonPanel.add(this.buttonPanel);
        this.getContentPane().add("South", outerButtonPanel);
        this._okButton = new JButton(Util.getCommonStringResource((String)"Ok.txt"));
        this.buttonPanel.add(this._okButton);
        this._cancelButton = new JButton(Util.getCommonStringResource((String)"Cancel.txt"));
        this.buttonPanel.add(this._cancelButton);
        this._applyButton = new JButton(Message.format((String)RB.getStringResource("QueryDialog.apply.txt"), (Object)"", (Object)""));
        this.buttonPanel.add(this._applyButton);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == BaseMDPanelDialog.this._cancelButton) {
                    BaseMDPanelDialog.this.onCancel();
                } else if (source == BaseMDPanelDialog.this._okButton) {
                    BaseMDPanelDialog.this.onOK();
                } else if (source == BaseMDPanelDialog.this._applyButton) {
                    BaseMDPanelDialog.this.onApply();
                }
            }
        };
        this._okButton.addActionListener(buttonListener);
        this._cancelButton.addActionListener(buttonListener);
        this._applyButton.addActionListener(buttonListener);
    }

    protected void onApply() {
        this._wasCancelled = false;
        if (this._mdPanel.isEnabled()) {
            this._mdPanel.onApply();
        }
    }

    protected void onCancel() {
        this._wasCancelled = true;
        this.onClose();
    }

    public boolean wasCancelled() {
        return this._wasCancelled;
    }

    protected void onOK() {
        this.onApply();
        this.onClose();
    }

    protected void onClose() {
        if (this._wasCancelled) {
            this._mdPanel.setAppliedOnHide(false);
        }
        this._mdPanel.preCustomizerClosing();
        this.setVisible(false);
        this.dispose();
    }
}

