/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.commands;

import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.lang.BooleanDataInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.sasserver.mdtable.dialogs.FilterDialog;
import com.sas.table.TableException;
import com.sas.text.Message;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;

public class SortCommand
extends MDCommand
implements BooleanDataInterface {
    private transient boolean _isSort;
    private transient int _sortOrder;
    protected transient FilterDialog _dialog;
    int _N;
    protected static final String RB_KEY = "SortCommand.";
    protected static String ASCENDING = RB.getStringResource("ascending.txt");
    protected static String DESCENDING = RB.getStringResource("descending.txt");
    protected static String RESET = RB.getStringResource("reset.txt");
    protected static String SHOW_ALL = RB.getStringResource("showall.txt");

    public SortCommand(long commandMask, Level level) {
        super(commandMask, level);
        this._axis = (Axis)this._level.getDimension().getAxis();
        if (commandMask == 8192L || commandMask == 16384L) {
            this._isSort = true;
        }
        this._N = 0;
    }

    public SortCommand(long commandMask, Member member) {
        super(commandMask, member);
        this._axis = (Axis)this._member.getAxis();
        if (commandMask == 8192L || commandMask == 16384L) {
            this._isSort = true;
        }
        this._N = 0;
    }

    public SortCommand(String commandName, Level level) {
        super(commandName, level);
        this._axis = (Axis)this._level.getDimension().getAxis();
        if (commandName == ASCENDING || commandName == DESCENDING || commandName == RESET || commandName == SHOW_ALL) {
            this._isSort = true;
            this.setSortOrder();
            this.setBooleanData(true);
            this._commandMask = level.isStatisticLevel() ? 8192L : 16384L;
        } else {
            this._commandMask = 262144L;
        }
        this._N = 0;
    }

    public SortCommand(String commandName, Member member) {
        super(commandName, member);
        this._axis = (Axis)this._member.getAxis();
        if (commandName == ASCENDING || commandName == DESCENDING || commandName == RESET || commandName == SHOW_ALL) {
            this._isSort = true;
            this.setSortOrder();
            this.setBooleanData(true);
            this._commandMask = ((Level)member.getLevel()).isStatisticLevel() ? 8192L : 16384L;
        } else {
            this._commandMask = 262144L;
        }
        this._N = 0;
    }

    public SortCommand(Axis a, String commandName, AssociationList asl) {
        this(a, commandName, asl, 0);
    }

    public SortCommand(Axis a, String commandName, AssociationList asl, int N) {
        super(a, commandName, asl);
        this._commandMask = 262144L;
        this._N = N;
    }

    private void setSortOrder() {
        this._sortOrder = this._commandName == ASCENDING ? 2 : (this._commandName == DESCENDING ? 1 : 3);
    }

    @Override
    public void performAction() throws TableException {
        if (this._isSort) {
            if (this._imddb instanceof MultidimensionalTableV2Interface) {
                this.sortPerformAction();
                if (this._member != null) {
                    this._member.setSortDirection(this._commandName);
                } else if (this._level != null) {
                    this._level.setSortDirection(this._commandName);
                }
            } else {
                if (this._member != null) {
                    this._member.setSortDirection(this._commandName);
                } else if (this._level != null) {
                    this._level.setSortDirection(this._commandName);
                }
                this._commandName = this._level.getName() + " Sort " + this.getServerCommand();
                super.performAction();
            }
        } else {
            this.filterPerformAction();
            this.setModelChanged();
        }
    }

    public void sortPerformAction() {
        int ordinal = -1;
        if (this._axis != null) {
            ordinal = this._axis.getOrdinal();
        }
        HListInterface tupleList = this.getTupleList();
        String serverCommand = this.getServerCommand();
        ((MultidimensionalTableV2Interface)this._imddb).sort(ordinal, tupleList, serverCommand, this._N);
        if (this._level == null && this._pairs != null || this._level.isStatisticLevel()) {
            this.setModelChanged();
        } else {
            this._imddb.refreshTable(this._axis, null);
        }
    }

    private String getServerCommand() {
        if (this._commandName == ASCENDING) {
            return "Ascending";
        }
        if (this._commandName == DESCENDING) {
            return "Descending";
        }
        if (this._commandName == SHOW_ALL) {
            return "All";
        }
        return "Reset";
    }

    private HListInterface getTupleList() {
        HList tupleList = null;
        if (this._member != null) {
            tupleList = Member.tupleToHList(this._member);
        } else if (this._level != null) {
            tupleList = Level.tupleToHList(this._level);
        } else if (this._pairs != null) {
            tupleList = this.AssociationListToHList(this._pairs);
        }
        return tupleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterPerformAction() throws TableException {
        if (this._dialog == null) {
            Frame f = this._view != null ? Util.getParentFrame(this._view) : new Frame();
            this._dialog = new FilterDialog(f, RB.getStringResource(RB_KEY, "filter.txt") + this._commandName);
            this._dialog.setMember(this._member);
            this._dialog.pack();
            try {
                Util.centerOverWindow(this._dialog, f);
            }
            catch (IllegalComponentStateException e) {
                Dimension size = this._dialog.getSize();
                Dimension screenSize = this._dialog.getToolkit().getScreenSize();
                this._dialog.setLocation(screenSize.width - size.width, 0);
            }
            finally {
                if (this.changeCursorCommand != null) {
                    this.changeCursorCommand.undoAll();
                    this.changeCursorCommand = null;
                }
            }
        }
        this._dialog.setVisible(true);
        this._dialog.finish();
    }

    protected void setModelChanged() {
        try {
            AxisInterface[] axes = this._imddb.getAxes(0, -1);
            for (int i = 0; i < axes.length; ++i) {
                if (axes[i].equals(this._axis)) continue;
                this._imddb.refreshTable((Axis)axes[i], null);
            }
        }
        catch (TableException te) {
            this._imddb.refreshTable(this._axis, null);
        }
    }

    @Override
    public long getMask() {
        return this._isSort ? 8192L : 262144L;
    }

    @Override
    public String getText() {
        if (!this._isSort && this._imddb instanceof MultidimensionalTableV3Interface) {
            return Message.format((String)RB.getStringResource("filter.txt"), (Object)this._level.getLabel());
        }
        return this._commandName;
    }

    public boolean getBooleanData() {
        if (this._member == null) {
            return this._level.getSortOrder() == this._sortOrder;
        }
        return this._member.getSortOrder() == this._sortOrder;
    }

    public void setBooleanData(boolean isActive) {
    }
}

