/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.ModelInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.measures.Length;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.Column;
import com.sas.swing.visuals.table.ColumnStyle;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.Row;
import com.sas.swing.visuals.table.TableView;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.table.TableInterface;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class TotalsPanel
extends JPanel
implements StaticColumnLabelInterface,
TableInterface,
ItemListener,
ModelInterface {
    static final long serialVersionUID = -2200126657774826693L;
    public static final String RB_KEY = "TotalsPanel.";
    private static final int TotalColumnIndex = 1;
    private static final int NameColumnIndex = 2;
    private static final int TotalLabelColumnIndex = 3;
    static boolean inUseCheckboxState;
    static boolean alreadyInitialized;
    private transient String checkBoxLabel;
    private transient TotalInterface[] data;
    private transient String[] headers;
    private transient JCheckBox inUseCheckbox;
    private transient boolean showInUseOnly;
    private transient TableView table;
    private Integer previousSelection;

    public TotalsPanel(String[] columnLabels, String checkBoxLabel) {
        if (columnLabels.length != 3) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidColumnCount.ex.txt"));
        }
        this.headers = new String[3];
        this.headers[0] = columnLabels[0];
        this.headers[1] = columnLabels[1];
        this.headers[2] = columnLabels[2];
        this.checkBoxLabel = checkBoxLabel;
    }

    private TotalInterface[] getCopyOfDataElements(TotalInterface[] data) {
        if (data == null) {
            return null;
        }
        TotalInterface[] copiedData = new TotalInterface[data.length];
        for (TotalInterface copiedData[i] : data) {
        }
        return copiedData;
    }

    public TotalInterface[] getDataElements() {
        this.table.commitModifiedCells();
        return this.getCopyOfDataElements(this.data);
    }

    public void setDataE(TotalInterface[] totals) {
        this.data = this.getCopyOfDataElements(totals);
    }

    public void initialize() {
        this.removeAll();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        layout.setRemainderRow(1);
        layout.setRemainderColumn(1);
        this.setLayout((LayoutManager)layout);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 5, 5, true, true, true));
        this.add(tablePanel);
        this.table = new TableView();
        this.table.initialize();
        tablePanel.add(this.table);
        this.table.setBackground(SystemColor.window);
        this.table.setRowLabelsVisible(false);
        this.table.setSize(new Dimension(520, 700));
        this.table.setExtendedSelectionAllowed(false);
        this.table.setGridVisible(false);
        this.table.setMultipleSelectionAllowed(false);
        CellStyle cs = this.table.getDefaultCellStyle();
        cs.setBottomMargin(new Length(0.0, "pt"));
        cs.setTopMargin(new Length(0.0, "pt"));
        this.table.setOpaque(true);
        this.table.getDefaultRowStyle().setCellsToSizeCount(3);
        this.table.getDefaultColumnStyle().setResizable(false);
        this.table.setColumnsConformed(true);
        CellStyle ls = this.table.getDefaultLabelStyle();
        ls.setHorizontalJustification(1);
        this.inUseCheckbox = new JCheckBox(this.checkBoxLabel);
        this.inUseCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = TotalsPanel.this.inUseCheckbox.isSelected();
                TotalsPanel.this.firePropertyChange("onlyTotalsInUseDisplayed", selected ? Boolean.FALSE : Boolean.TRUE, selected ? Boolean.TRUE : Boolean.FALSE);
            }
        });
        this.add(this.inUseCheckbox);
        this.table.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Row r = null;
            Enumeration enumer = this.table.getSelectedCells();
            if (enumer.hasMoreElements()) {
                DataCell dc = (DataCell)enumer.nextElement();
                r = dc.getRow();
                int i = r.getIndex();
                Integer oldps = this.previousSelection;
                if (!r.isSelected()) {
                    Integer ii;
                    this.table.select(r, r, false);
                    this.previousSelection = ii = new Integer(i);
                    this.firePropertyChange("tableSelection", oldps, ii);
                }
            }
        }
    }

    public boolean isOnlyTotalsInUseDisplayed() {
        inUseCheckboxState = this.inUseCheckbox.isSelected();
        return inUseCheckboxState;
    }

    public void setDataElements(TotalInterface[] totals) {
        if (totals == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullArray.ex.txt"));
        }
        if (totals.length == 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "zeroLengthArray.ex.txt"));
        }
        this.table.setModel(null);
        this.data = this.getCopyOfDataElements(totals);
        this.table.setModel((StaticTableInterface)this);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setActivationLevel(3);
        cellStyle.setActivatedOnCurrent(true);
        cellStyle.set("viewClass", "com.sas.swing.visuals.table.CheckBoxCell");
        cellStyle.setHorizontalJustification(1);
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setDefaultCellStyle(cellStyle);
        Column column = this.table.getColumn(1);
        column.setSize(70);
        column.setStyle((StaticPropertyBagInterface)columnStyle);
        cellStyle = new CellStyle();
        cellStyle.setHorizontalJustification(1);
        column = this.table.getColumn(2);
        column.setSize(100);
        column.setStyle((StaticPropertyBagInterface)cellStyle);
        cellStyle = new CellStyle();
        cellStyle.setActivationLevel(3);
        cellStyle.setActivatedOnCurrent(true);
        cellStyle.setHorizontalJustification(1);
        columnStyle = new ColumnStyle();
        columnStyle.setMinSize(new Length(100.0, "px"));
        columnStyle.setResizable(true);
        columnStyle.setDefaultCellStyle(cellStyle);
        column = this.table.getColumn(3);
        column.setStyle((StaticPropertyBagInterface)columnStyle);
    }

    @Override
    public void setEnabled(boolean state) {
        this.inUseCheckbox.setEnabled(state);
        this.table.setEnabled(state);
        super.setEnabled(state);
    }

    public void setOnlyTotalsInUseDisplayed(boolean inUseOnly) {
        this.inUseCheckbox.setSelected(inUseOnly);
    }

    public boolean isColumnLabelsSupported() throws TableException {
        return true;
    }

    public Object getColumnLabel(int index) throws TableException {
        return this.headers[index - 1];
    }

    public Object[] getColumnLabels(int startIndex, int count) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"getColumnLabels()"));
    }

    public boolean isColumnsLabelSupported() throws TableException {
        return false;
    }

    public int countColumns(int maxCount) throws TableException {
        return this.getColumnCount();
    }

    public int countRows(int maxCount) throws TableException {
        return this.getRowCount();
    }

    public Object getCell(int rowIndex, int columnIndex) throws TableException {
        if (this.data == null) {
            return null;
        }
        Object retData = null;
        --rowIndex;
        switch (columnIndex) {
            case 2: {
                retData = this.data[rowIndex].getName();
                break;
            }
            case 1: {
                retData = this.data[rowIndex].getTotalState() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: {
                retData = this.data[rowIndex].getTotalLabel();
                break;
            }
            default: {
                throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "invalidColumnIndex.ex.txt"), (Object)new Integer(columnIndex)));
            }
        }
        return retData;
    }

    public Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"getCells()"));
    }

    public Class getCellClass(int rowIndex, int columnIndex) throws TableException {
        return columnIndex == 1 ? Boolean.class : String.class;
    }

    public Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"getCellClasses()"));
    }

    public Object[] getColumn(int index) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"getColumn()"));
    }

    public int getColumnCount() throws TableException {
        return this.headers.length;
    }

    public Object[] getRow(int index) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"getRow()"));
    }

    public int getRowCount() throws TableException {
        return this.data == null ? 0 : this.data.length;
    }

    public boolean isCellsModifiable() {
        return true;
    }

    public boolean isMultipleRowUpdateSupported() {
        return false;
    }

    public boolean isMultipleColumnUpdateSupported() {
        return true;
    }

    public void setCell(int rowIndex, int columnIndex, Object value) throws TableException {
        if (this.data == null) {
            return;
        }
        --rowIndex;
        if (columnIndex == 3) {
            if (((String)value).length() > 200) {
                value = ((String)value).substring(0, 200);
            } else if (Util.equal((Object)value, (Object)"")) {
                value = " ";
            }
            this.data[rowIndex].setTotalLabel((String)value);
        } else if (columnIndex == 1) {
            boolean on = (Boolean)value;
            this.data[rowIndex].setTotalState(on);
        }
    }

    public void setCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, Object[][] values) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"setCells()"));
    }

    public void setColumn(int index, Object[] values) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"setColumn()"));
    }

    public void setRow(int index, Object[] values) throws TableException {
        throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"), (Object)"setRow()"));
    }

    public void clearData() {
        this.data = null;
        this.table.setModel(null);
    }

    public void disableInUseCheckbox() {
        this.inUseCheckbox.enable(false);
    }

    public Enumeration getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public StaticPropertyBagInterface getDefaultLabelStyle() {
        return this.table.getDefaultLabelStyle();
    }

    public StaticPropertyBagInterface getDefaultCellStyle() {
        return this.table.getDefaultCellStyle();
    }

    public boolean attachView() {
        return true;
    }

    public void detachView() {
    }

    static {
        alreadyInitialized = false;
    }
}

