/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.PropertyBag;
import com.sas.collection.SortedCollection;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.sasserver.mdtable.BaseMDInterfaceCustomizerPanel;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.sasserver.mdtable.TotalsElement;
import com.sas.sasserver.mdtable.TotalsPanel;
import com.sas.swing.visuals.table.Row;
import com.sas.swing.visuals.util.Util;
import com.sas.table.FontStyle;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.Comparator;
import com.sas.util.StringComparator;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.PropertyEditorHost;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class TotalsCustomizerPanel
extends BaseMDInterfaceCustomizerPanel {
    public static final String RB_KEY = "TotalsCustomizerPanel.";
    private transient TotalsPanel _totalsPanel;
    private transient ButtonGroup _radioButtonGroup;
    private transient JPanel _radioBox;
    private transient JRadioButton _radioButton1;
    private transient JRadioButton _radioButton2;
    private transient PropertyEditorHost _fgColorHost;
    private transient PropertyEditorHost _bgColorHost;
    private transient PropertyEditorHost _fontHost;
    private transient Color _fgColor;
    private transient Color _bgColor;
    private transient Font _font;
    private static Color DEFAULT_FOREGROUND_COLOR = null;
    private static Color DEFAULT_LABEL_BACKGROUND_COLOR = null;
    private static Color DEFAULT_CELL_BACKGROUND_COLOR = null;
    private static Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private transient int _styleId;
    private transient AxisInterface[] _axisMembers;
    private transient TotalInterface[] _totalsMembers;
    private transient HashMap _dimensionMembers;
    private transient HashMap _hierarchyMembers;
    private transient HashMap _levelMembers;
    private static final boolean DEBUG = false;
    protected static JFrame jf;

    public TotalsCustomizerPanel(String tabName) {
        super(tabName);
    }

    @Override
    protected void initializeValues() {
        super.initializeValues();
        this._styleId = -1;
    }

    @Override
    protected void createGUI() {
        this.setLayout((LayoutManager)new AutoSizingGridLayout(4, 1, 5, 5, true, true, true));
        this.setInsets(10, 10, 10, 10);
        String[] columnLabels = new String[]{RB.getStringResource(RB_KEY, "isTotaledColumnLabel.txt"), RB.getStringResource(RB_KEY, "levelNamesLabel.txt"), RB.getStringResource(RB_KEY, "levelLabelsLabel.txt")};
        String checkBoxLabel = RB.getStringResource(RB_KEY, "inUseCheckBoxLabel.txt");
        this._totalsPanel = new TotalsPanel(columnLabels, checkBoxLabel);
        this._totalsPanel.initialize();
        if (!TotalsPanel.alreadyInitialized) {
            TotalsPanel.inUseCheckboxState = true;
            TotalsPanel.alreadyInitialized = true;
        }
        this._totalsPanel.setOnlyTotalsInUseDisplayed(TotalsPanel.inUseCheckboxState);
        this._totalsPanel.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        JTextArea lb = new JTextArea(RB.getStringResource(RB_KEY, "label1.txt") + RB.getStringResource(RB_KEY, "label2.txt"));
        AutoSizingGridLayout lbLayout = new AutoSizingGridLayout(1, 1, 5, 0, true, true, true);
        lbLayout.setRemainderRow(0);
        lbLayout.setRemainderColumn(0);
        lb.setLayout((LayoutManager)lbLayout);
        lb.setLineWrap(true);
        lb.setWrapStyleWord(true);
        lb.setFont(null);
        lb.setBackground(null);
        this.add(lb);
        this.add(this._totalsPanel);
        JPanel bc = new JPanel();
        bc.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "border.txt"), (int)0, (int)10, (int)10, (int)10));
        bc.setPreferredSize(new java.awt.Dimension(400, 140));
        bc.setLayout((LayoutManager)new AutoSizingGridLayout(4, 1, 5, 5));
        this._radioBox = new JPanel();
        AutoSizingGridLayout radioLayout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, false);
        this._radioBox.setLayout((LayoutManager)radioLayout);
        this._radioButtonGroup = new ButtonGroup();
        this._radioButton1 = new JRadioButton(RB.getStringResource(RB_KEY, "rb1.txt"));
        this._radioButton1.setSelected(true);
        this._radioButton2 = new JRadioButton(RB.getStringResource(RB_KEY, "rb2.txt"));
        this._radioButtonGroup.add(this._radioButton1);
        this._radioButtonGroup.add(this._radioButton2);
        this._radioBox.add(this._radioButton1);
        this._radioBox.add(this._radioButton2);
        bc.add(this._radioBox);
        JPanel fgContainer = new JPanel();
        AutoSizingGridLayout fgLayout = new AutoSizingGridLayout(1, 3, 5, 0, true, false, false);
        fgContainer.setLayout((LayoutManager)fgLayout);
        fgContainer.add(new JLabel(RB.getStringResource(RB_KEY, "fg.txt")));
        this._fgColorHost = new PropertyEditorHost();
        this._fgColorHost.initialize();
        fgContainer.add(this._fgColorHost);
        bc.add(fgContainer);
        JPanel bgContainer = new JPanel();
        AutoSizingGridLayout bgLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, false);
        bgContainer.setLayout((LayoutManager)bgLayout);
        bgContainer.add(new JLabel(RB.getStringResource(RB_KEY, "bg.txt")));
        this._bgColorHost = new PropertyEditorHost();
        this._bgColorHost.initialize();
        bgContainer.add(this._bgColorHost);
        bc.add(bgContainer);
        JPanel fontContainer = new JPanel();
        AutoSizingGridLayout fontLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, false);
        fontContainer.setLayout((LayoutManager)fontLayout);
        fontContainer.add(new JLabel(Message.format((String)RB.getStringResource(RB_KEY, "font.txt"), (Object)"                 ")));
        this._fontHost = new PropertyEditorHost();
        this._fontHost.initialize();
        fontContainer.add(this._fontHost);
        bc.add(fontContainer);
        fgLayout.setInterlockedColumnContainers(new Container[]{bgContainer});
        bgLayout.setInterlockedColumnContainers(new Container[]{fgContainer});
        fontLayout.setInterlockedColumnContainers(new Container[]{fontContainer});
        if (this._fgColor == null) {
            this._fgColor = Color.black;
        }
        if (this._bgColor == null) {
            this._bgColor = Color.lightGray;
        }
        if (this._font == null) {
            this._font = DEFAULT_FONT;
        }
        this._fgColorHost.setPropertyValue(this._fgColor, Color.class);
        this._bgColorHost.setPropertyValue(this._bgColor, Color.class);
        this._fontHost.setPropertyValue(this._font, Font.class);
        this.setState(2);
        this.add(bc);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Enumeration enumer;
                TotalsCustomizerPanel.this._styleId = 0;
                if (e.getActionCommand().equals(RB.getStringResource(TotalsCustomizerPanel.RB_KEY, "rb1.txt"))) {
                    TotalsCustomizerPanel.this._styleId = 1;
                }
                if ((enumer = TotalsCustomizerPanel.this._totalsPanel.getSelectedRows()).hasMoreElements()) {
                    Row r = (Row)enumer.nextElement();
                    TotalsCustomizerPanel.this.setTotalsOnModel(r.getIndex());
                }
                TotalsCustomizerPanel.this._styleId = -1;
                Object source = e.getSource();
                if (source == TotalsCustomizerPanel.this._radioButton1 || source == TotalsCustomizerPanel.this._radioButton2) {
                    TotalsCustomizerPanel.this.displayStyles();
                }
            }
        };
        this._radioButton1.addActionListener(actionListener);
        this._radioButton2.addActionListener(actionListener);
        JTextArea note = new JTextArea(RB.getStringResource(RB_KEY, "note.txt"));
        AutoSizingGridLayout noteLayout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, false);
        note.setLayout((LayoutManager)noteLayout);
        note.setPreferredSize(new java.awt.Dimension(400, 60));
        note.setLineWrap(true);
        note.setWrapStyleWord(true);
        note.setFont(null);
        note.setBackground(null);
        this.add(note);
        this.setState(2);
        this.setEnabled(false);
    }

    @Override
    public void setObject(Object bean) {
        this.onClear();
        super.setObject(bean);
    }

    @Override
    protected void connectionThreadEnding() {
        super.connectionThreadEnding();
        this.setEnabled(!this.wasCancelled() && !this.wasExceptionThrown());
    }

    @Override
    public void preCustomizerClosing() {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.isVisible()) {
            this.onHidden();
        }
        this.onClear();
        super.preCustomizerClosing();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        String propertyName = event.getPropertyName();
        if (source == this._totalsPanel) {
            if (com.sas.util.Util.equal((Object)propertyName, (Object)"onlyTotalsInUseDisplayed")) {
                this.onApply();
                if (!this._onInitialize()) {
                    this._alreadyInitialized = false;
                }
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"tableSelection")) {
                Integer o = (Integer)event.getOldValue();
                if (o != null && o > 0) {
                    this.setTotalsOnModel(o);
                }
                this.displayStyles();
            }
        }
        super.propertyChange(event);
    }

    private Level getLevel(int index) {
        try {
            String dc = (String)this._totalsPanel.getCell(index, 2);
            TotalInterface[] totals = this._totalsPanel.getDataElements();
            Level l = null;
            if (index > 0 && index < totals.length && dc.equals(totals[index - 1].getName())) {
                l = (Level)totals[index - 1];
            } else {
                for (int i = 0; i < totals.length; ++i) {
                    if (!dc.equals(totals[i].getName())) continue;
                    l = (Level)totals[i];
                    break;
                }
            }
            if (l != null) {
                return l;
            }
        }
        catch (TableException te) {
            return null;
        }
        return null;
    }

    private void setState(int state) {
        PropertyEditor fgColorEditor = this._fgColorHost.getPropertyEditor();
        PropertyEditor bgColorEditor = this._bgColorHost.getPropertyEditor();
        PropertyEditor fontEditor = this._fontHost.getPropertyEditor();
        switch (state) {
            case 0: {
                this._fgColorHost.setEnabled(true);
                this._bgColorHost.setEnabled(true);
                this._fontHost.setEnabled(true);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                fgColorEditor.setValue(DEFAULT_FOREGROUND_COLOR);
                bgColorEditor.setValue(DEFAULT_LABEL_BACKGROUND_COLOR);
                fontEditor.setValue(DEFAULT_FONT);
            }
        }
    }

    @Override
    public void updateData() throws TableException {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.isVisible()) {
            this.onVisible();
        }
    }

    private AxisInterface[] getAxisMembers() throws TableException {
        if (this._axisMembers == null) {
            this._axisMembers = this.getRuntimeTableInterface().getAxes(0, this.getRuntimeTableInterface().getAxisCount());
        }
        return this._axisMembers;
    }

    private DimensionInterface[] getDimensionMembers(AxisInterface axis) throws TableException {
        if (this._dimensionMembers == null || !this._dimensionMembers.containsKey(axis)) {
            if (this._dimensionMembers == null) {
                this._dimensionMembers = new HashMap();
            }
            this._dimensionMembers.put(axis, axis.getDimensions(0, axis.getDimensionCount()));
        }
        return (DimensionInterface[])this._dimensionMembers.get(axis);
    }

    private HierarchyInterface[] getHierarchyMembers(DimensionInterface dim) throws TableException {
        if (this._hierarchyMembers == null || !this._hierarchyMembers.containsKey(dim)) {
            if (this._hierarchyMembers == null) {
                this._hierarchyMembers = new HashMap();
            }
            this._hierarchyMembers.put(dim, dim.getHierarchies(0, dim.getHierarchyCount()));
        }
        return (HierarchyInterface[])this._hierarchyMembers.get(dim);
    }

    private LevelInterface[] getLevelMembers(HierarchyInterface hier) throws TableException {
        if (this._levelMembers == null || !this._levelMembers.containsKey(hier)) {
            if (this._levelMembers == null) {
                this._levelMembers = new HashMap();
            }
            this._levelMembers.put(hier, hier.getLevels(0, hier.getLevelCount()));
        }
        return (LevelInterface[])this._levelMembers.get(hier);
    }

    private TotalInterface[] getTotalsMembers() throws TableException {
        if (this._totalsMembers == null) {
            this._totalsMembers = ((MultidimensionalTableV3Interface)this.getRuntimeTableInterface()).getTotalsProperty();
        }
        return this._totalsMembers;
    }

    public boolean setLevels() {
        if (this.getRuntimeTableInterface() == null) {
            this._totalsPanel.clearData();
            return false;
        }
        try {
            if (this._totalsPanel.isOnlyTotalsInUseDisplayed()) {
                this.setLevelsInUse();
            } else {
                this.setAllLevels();
            }
        }
        catch (TableException ex) {
            this.showExceptionWarning((Exception)((Object)ex));
            return false;
        }
        return true;
    }

    private void setAllLevels() throws TableException {
        TotalInterface[] totals = this.getTotalsMembers();
        if (totals != null && totals.length > 0) {
            SortedCollection oc = new SortedCollection((Comparator)new NodeComparator());
            for (int i = 0; i < totals.length; ++i) {
                if (((Level)totals[i]).getDimension() == null || ((Dimension)((Level)totals[i]).getDimension()).getType() == 1 || !((Level)totals[i]).isTotalEnabled()) continue;
                oc.add((Object)totals[i]);
            }
            TotalInterface[] temp = new TotalInterface[oc.count()];
            int count = oc.count();
            for (int i = 0; i < count; ++i) {
                temp[i] = (TotalInterface)oc.get(i);
            }
            this._totalsPanel.setDataElements(temp);
        }
    }

    private void setLevelsInUse() throws TableException {
        this.localInstance.getTotals();
        SortedCollection levelsOC = new SortedCollection((Comparator)new NodeComparator());
        AxisInterface[] axes = this.getAxisMembers();
        if (axes != null) {
            int cnt = axes.length;
            for (int i = 0; i < cnt; ++i) {
                DimensionInterface[] dims = this.getDimensionMembers(axes[i]);
                if (dims == null) continue;
                int cnt2 = dims.length;
                for (int j = 0; j < cnt2 && !((Dimension)dims[j]).isMeasure(); ++j) {
                    HierarchyInterface[] hiers = this.getHierarchyMembers(dims[j]);
                    int cnt4 = hiers.length;
                    for (int m = 0; m < cnt4; ++m) {
                        LevelInterface[] levs = this.getLevelMembers(hiers[m]);
                        if (levs == null) continue;
                        int cnt3 = levs.length;
                        for (int k = 0; k < cnt3; ++k) {
                            if (((Dimension)((Level)levs[k]).getDimension()).getType() == 1 || !((Level)levs[k]).isTotalEnabled()) continue;
                            levelsOC.add((Object)((Level)levs[k]));
                        }
                    }
                }
            }
        }
        if (levelsOC.count() > 0) {
            TotalInterface[] totals = new TotalInterface[levelsOC.count()];
            int cnt = levelsOC.count();
            for (int i = 0; i < cnt; ++i) {
                totals[i] = (TotalInterface)levelsOC.get(i);
            }
            this._totalsPanel.setDataElements(totals);
        } else {
            TotalsPanel.inUseCheckboxState = false;
            this._totalsPanel.setOnlyTotalsInUseDisplayed(TotalsPanel.inUseCheckboxState);
            this._totalsPanel.disableInUseCheckbox();
            this.setAllLevels();
        }
    }

    public void displayStyles() {
        TotalInterface[] totals = this._totalsPanel.getDataElements();
        PropertyEditor fgColorEditor = this._fgColorHost.getPropertyEditor();
        PropertyEditor bgColorEditor = this._bgColorHost.getPropertyEditor();
        PropertyEditor fontEditor = this._fontHost.getPropertyEditor();
        Enumeration enumer = this._totalsPanel.getSelectedRows();
        int type = this.getStyleId();
        if (enumer.hasMoreElements()) {
            Row r = (Row)enumer.nextElement();
            Level l = this.getLevel(r.getIndex());
            boolean i = false;
            StaticPropertyBagInterface sp = null;
            FontStyle fs = new FontStyle();
            fs.setFont(DEFAULT_FONT);
            StaticPropertyBagInterface staticPropertyBagInterface = sp = type == 0 ? l.getTotalLabelStyle() : l.getTotalCellStyle();
            if (sp == null) {
                fgColorEditor.setValue(DEFAULT_FOREGROUND_COLOR);
                bgColorEditor.setValue(type == 0 ? DEFAULT_LABEL_BACKGROUND_COLOR : DEFAULT_CELL_BACKGROUND_COLOR);
                fontEditor.setValue(DEFAULT_FONT);
            } else {
                Color fColor = (Color)sp.get("foregroundColor", (Object)DEFAULT_FOREGROUND_COLOR);
                fgColorEditor.setValue(fColor);
                Color bColor = (Color)sp.get("backgroundColor", (Object)(type == 0 ? DEFAULT_LABEL_BACKGROUND_COLOR : DEFAULT_CELL_BACKGROUND_COLOR));
                bgColorEditor.setValue(bColor);
                Font f = ((FontStyle)((Object)sp.get("fontStyle", (Object)fs))).getFont();
                fontEditor.setValue(f);
            }
        }
    }

    private void setTotalsOnModel(int index) {
        PropertyEditor fgColorEditor = this._fgColorHost.getPropertyEditor();
        PropertyEditor bgColorEditor = this._bgColorHost.getPropertyEditor();
        PropertyEditor fontEditor = this._fontHost.getPropertyEditor();
        try {
            Color bColor;
            PropertyBag styles = new PropertyBag();
            Color fColor = (Color)fgColorEditor.getValue();
            if (fColor != null) {
                styles.set("foregroundColor", (Object)fColor);
            }
            if ((bColor = (Color)bgColorEditor.getValue()) != null) {
                styles.set("backgroundColor", (Object)bColor);
            }
            FontStyle fs = new FontStyle();
            Font f = (Font)fontEditor.getValue();
            if (com.sas.util.Util.unequal((Object)f, (Object)DEFAULT_FONT)) {
                fs.setFont(f);
                styles.set("fontStyle", (Object)fs);
            }
            String dc = (String)this._totalsPanel.getCell(index, 2);
            TotalInterface[] totals = this._totalsPanel.getDataElements();
            Level l = null;
            if (index > 0 && index < totals.length && dc.equals(totals[index - 1].getName())) {
                l = (Level)totals[index - 1];
                if (this.getStyleId() == 0) {
                    l.setTotalLabelStyle((StaticPropertyBagInterface)styles);
                } else {
                    l.setTotalCellStyle((StaticPropertyBagInterface)styles);
                }
            } else {
                for (int i = 0; i < totals.length; ++i) {
                    if (!dc.equals(totals[i].getName())) continue;
                    l = (Level)totals[i];
                    if (this.getStyleId() == 0) {
                        l.setTotalLabelStyle((StaticPropertyBagInterface)styles);
                        continue;
                    }
                    l.setTotalCellStyle((StaticPropertyBagInterface)styles);
                }
            }
            this._totalsPanel.setDataE(totals);
        }
        catch (TableException te) {
            this.showExceptionWarning((Exception)((Object)te));
        }
    }

    public void setTotalsOnModel(TotalInterface[] newTotals) {
        if (newTotals == null || newTotals.length == 0) {
            return;
        }
        try {
            this.getTableDelegate().setTotals(newTotals);
        }
        catch (TableException ex) {
            this.showExceptionWarning((Exception)((Object)ex));
        }
    }

    private int getStyleId() {
        if (this._styleId < 0) {
            Enumeration<AbstractButton> buttons = this._radioButtonGroup.getElements();
            boolean selected = false;
            this._styleId = -1;
            while (buttons.hasMoreElements() && !selected) {
                selected = ((JRadioButton)buttons.nextElement()).isSelected();
                ++this._styleId;
            }
        }
        return this._styleId;
    }

    @Override
    protected boolean createRuntimeTable() {
        return !this.isRuntimeTableReady() && this.isMetabaseAndDatabaseSet();
    }

    @Override
    public void onApply() {
        if (this.isDesignTimeEISApplication()) {
            return;
        }
        Enumeration enumer = this._totalsPanel.getSelectedRows();
        if (enumer.hasMoreElements()) {
            Row r = (Row)enumer.nextElement();
            this.setTotalsOnModel(r.getIndex());
        }
        this.setTotalsOnModel(this._totalsPanel.getDataElements());
    }

    private boolean isDesignTimeEISApplication() {
        try {
            return this.getTableInterface() != this.getRuntimeTableInterface() && this.getTableInterface().getApplication() != null;
        }
        catch (TableException ex) {
            return true;
        }
    }

    @Override
    public void onInitialize() {
        if (this._alreadyInitialized || !this.isRuntimeTableReady() || this.isDesignTimeEISApplication()) {
            return;
        }
        this._alreadyInitialized = true;
        if (!this._onInitialize()) {
            this._alreadyInitialized = false;
        }
    }

    private boolean _onInitialize() {
        this._totalsPanel.clearData();
        boolean rc = this.setLevels();
        if (!rc) {
            this.setEnabled(false);
        } else if (!this.isEnabled()) {
            this.setEnabled(this.isMetabaseAndDatabaseSet());
        }
        this.setState(2);
        return rc;
    }

    @Override
    public void onClear() {
        this._alreadyInitialized = false;
        this._axisMembers = null;
        this._dimensionMembers = null;
        this._hierarchyMembers = null;
        this._levelMembers = null;
        this._totalsMembers = null;
        this._totalsPanel.clearData();
        this.setEnabled(false);
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object node1, Object node2) {
            StringComparator sc = new StringComparator(true);
            if (node1 instanceof ParentNode && node2 instanceof ParentNode) {
                return sc.compare((Object)((ParentNode)node1).getLabel(), (Object)((ParentNode)node2).getLabel());
            }
            return Integer.MAX_VALUE;
        }
    }

    class Element {
        String levelName;
        TotalsElement element;

        Element() {
        }
    }
}

