/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.awt.util.Util;
import com.sas.collection.Pair;
import com.sas.lang.DoubleData;
import com.sas.mdtable.MemberInterface;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.RangeSegment;
import com.sas.models.RangeSegmentInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.sasserver.mdtable.BaseMDInterfaceCustomizerPanel;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.Range;
import com.sas.sasserver.mdtable.RangeCollection;
import com.sas.sasserver.mdtable.RangeInterface;
import com.sas.swing.property.PropertyEditorHost;
import com.sas.swing.visuals.NodeState;
import com.sas.swing.visuals.NodeView;
import com.sas.swing.visuals.TreeView;
import com.sas.table.FontStyle;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.MessageBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NamedTypesCustomizerPanel
extends BaseMDInterfaceCustomizerPanel
implements ActionListener,
ItemListener {
    public static final String RB_KEY = "NamedTypesCustomizerPanel.";
    private static final boolean NAMED = true;
    private static final boolean PAIR = false;
    private static final String POSITIVE_INFINITY = "POSITIVE_INFINITY";
    private static final String MAX_VALUE = "MAX_VALUE";
    private static final String MIN_VALUE = "MIN_VALUE";
    private static final String NEGATIVE_MIN_VALUE = "-MIN_VALUE";
    private static final String NEGATIVE_MAX_VALUE = "-MAX_VALUE";
    private static final String NEGATIVE_INFINITY = "NEGATIVE_INFINITY";
    private static final String NaN = "NaN";
    private static final Double POSITIVE_INFINITY_VAL = new Double(Double.POSITIVE_INFINITY);
    private static final Double MAX_VALUE_VAL = new Double(Double.MAX_VALUE);
    private static final Double MIN_VALUE_VAL = new Double(Double.MIN_VALUE);
    private static final Double NEGATIVE_MIN_VALUE_VAL = new Double(-4.9E-324);
    private static final Double NEGATIVE_MAX_VALUE_VAL = new Double(-1.7976931348623157E308);
    private static final Double NEGATIVE_INFINITY_VAL = new Double(Double.NEGATIVE_INFINITY);
    private static final Double NaN_VAL = new Double(Double.NaN);
    private static Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private static final String STYLE_ID = "styleId";
    private transient PropertyEditorHost _fgColorHost;
    private transient PropertyEditorHost _bgColorHost;
    private transient PropertyEditorHost _fontHost;
    JRadioButton _namedButton;
    JRadioButton _pairButton;
    ButtonGroup _viewByGroup;
    JButton _addButton;
    JButton _removeButton;
    JButton _replaceButton;
    protected JComboBox _namedCombo;
    protected JComboBox _minCombo;
    protected JComboBox _maxCombo;
    protected JComboBox _statCombo;
    protected JComboBox _measureCombo;
    private DefaultComboBoxModel _namedComboModel;
    private DefaultComboBoxModel _minComboModel;
    private DefaultComboBoxModel _maxComboModel;
    private DefaultComboBoxModel _measureComboModel;
    private DefaultComboBoxModel _statComboModel;
    private NodeState _previousViewState;
    private TreeManager _treeManager;
    private boolean _buttonsEnabled;
    private transient boolean dataInitialized;
    private boolean _modified;
    private ArrayList _rangeInfoCollection;
    private RangeInterface[] _rangesFromModel;
    private static final boolean DEBUG = false;

    public NamedTypesCustomizerPanel(String tabName) {
        super(tabName);
    }

    @Override
    protected void createGUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.setInsets(10, 10, 10, 10);
        JPanel panel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 3, 5, 5, true, true, true);
        layout.setRemainderColumn(1);
        panel.setLayout((LayoutManager)layout);
        panel.add(this.createLeftContainer());
        panel.add(this.createRightContainer());
        panel.add(this.createAddReplaceButtonContainer());
        this.add((Component)this.createRadioBox(), "North");
        this.add((Component)panel, "Center");
        this._namedComboModel = new DefaultComboBoxModel();
        this._namedCombo.setModel(this._namedComboModel);
        this._minComboModel = new DefaultComboBoxModel();
        this._minCombo.setModel(this._minComboModel);
        this._maxComboModel = new DefaultComboBoxModel();
        this._maxCombo.setModel(this._maxComboModel);
        this.setEnabled(false);
    }

    private JPanel createRadioBox() {
        JPanel viewByContainer = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 5, 5);
        layout.setFillCell(true);
        viewByContainer.setLayout((LayoutManager)layout);
        JLabel viewBy = new JLabel(RB.getStringResource(RB_KEY, "viewByLabel.txt"));
        this._namedButton = new JRadioButton(RB.getStringResource(RB_KEY, "namedStylesViewLabel.txt"));
        this._pairButton = new JRadioButton(RB.getStringResource(RB_KEY, "pairsViewLabel.txt"));
        this._viewByGroup = new ButtonGroup();
        this._viewByGroup.add(this._namedButton);
        this._viewByGroup.add(this._pairButton);
        this._namedButton.setSelected(true);
        viewByContainer.add(viewBy);
        viewByContainer.add(this._namedButton);
        viewByContainer.add(Box.createGlue());
        viewByContainer.add(this._pairButton);
        return viewByContainer;
    }

    private JPanel createLeftContainer() {
        JPanel leftContainer = new JPanel();
        leftContainer.setLayout(new BorderLayout(5, 5));
        TreeView treeView = new TreeView();
        treeView.initialize();
        if (treeView.getDefaultNodeStyle() != null) {
            treeView.getDefaultNodeStyle().set("imageVisible", (Object)Boolean.FALSE);
        }
        treeView.setDefaultModel(null);
        treeView.setRootNodeVisible(false);
        treeView.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this._treeManager = new TreeManager(treeView);
        JPanel outerContainer = new JPanel();
        outerContainer.setLayout(new FlowLayout(0));
        this._removeButton = new JButton(com.sas.util.Util.getCommonStringResource((String)"Remove.txt"));
        outerContainer.add(this._removeButton);
        leftContainer.add((Component)treeView, "Center");
        leftContainer.add((Component)outerContainer, "South");
        return leftContainer;
    }

    private JPanel createRightContainer() {
        JPanel detailsPanel = this.createDetailsPanel();
        JPanel stylesPanel = this.createStylePanel();
        JPanel container = new JPanel();
        container.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, false, true));
        container.add(detailsPanel);
        container.add(stylesPanel);
        return container;
    }

    private JPanel createAddReplaceButtonContainer() {
        JPanel buttonContainer = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 5, 5);
        layout.setFillCell(true);
        buttonContainer.setLayout((LayoutManager)layout);
        this._addButton = new JButton(com.sas.util.Util.getCommonStringResource((String)"Add.txt"));
        this._replaceButton = new JButton(com.sas.util.Util.getCommonStringResource((String)"Replace.txt"));
        buttonContainer.add(this._addButton);
        buttonContainer.add(this._replaceButton);
        return buttonContainer;
    }

    private JPanel createDetailsPanel() {
        JPanel choiceContainer = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(7, 2, 5, 5);
        layout.setFillCell(true);
        choiceContainer.setLayout((LayoutManager)layout);
        choiceContainer.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "styleSettingsBorderLabel.txt"), (int)0, (int)5, (int)5, (int)5));
        JLabel namedStyleLabel = new JLabel();
        namedStyleLabel.setText(RB.getStringResource(RB_KEY, "namedStyleLabel.txt"));
        JLabel statLabel = new JLabel();
        statLabel.setText(RB.getStringResource(RB_KEY, "statisticLabel.txt"));
        JLabel measuresLabel = new JLabel();
        measuresLabel.setText(RB.getStringResource(RB_KEY, "measureLabel.txt"));
        MyCellRenderer renderer = new MyCellRenderer();
        this._namedCombo = new JComboBox();
        this._namedCombo.setEditable(true);
        this._namedCombo.setLightWeightPopupEnabled(false);
        this._namedCombo.setRenderer(renderer);
        this._measureCombo = new JComboBox();
        this._measureCombo.setLightWeightPopupEnabled(false);
        this._measureCombo.setRenderer(renderer);
        this._statCombo = new JComboBox();
        this._statCombo.setLightWeightPopupEnabled(false);
        this._statCombo.setRenderer(renderer);
        JLabel minLabel = new JLabel();
        minLabel.setText(RB.getStringResource(RB_KEY, "minimumLabel.txt"));
        JLabel maxLabel = new JLabel();
        maxLabel.setText(RB.getStringResource(RB_KEY, "maximumLabel.txt"));
        this._minCombo = new JComboBox();
        this._minCombo.setEditable(true);
        this._minCombo.setLightWeightPopupEnabled(false);
        this._minCombo.setRenderer(renderer);
        this._maxCombo = new JComboBox();
        this._maxCombo.setEditable(true);
        this._maxCombo.setLightWeightPopupEnabled(false);
        this._maxCombo.setRenderer(renderer);
        choiceContainer.add(namedStyleLabel);
        choiceContainer.add(this._namedCombo);
        choiceContainer.add(Box.createVerticalStrut(5));
        choiceContainer.add(Box.createVerticalStrut(5));
        choiceContainer.add(measuresLabel);
        choiceContainer.add(this._measureCombo);
        choiceContainer.add(statLabel);
        choiceContainer.add(this._statCombo);
        choiceContainer.add(Box.createVerticalStrut(5));
        choiceContainer.add(Box.createVerticalStrut(5));
        choiceContainer.add(minLabel);
        choiceContainer.add(this._minCombo);
        choiceContainer.add(maxLabel);
        choiceContainer.add(this._maxCombo);
        return choiceContainer;
    }

    private JPanel createStylePanel() {
        JPanel stylesPanel = new JPanel();
        stylesPanel.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "border.txt"), (int)0, (int)10, (int)10, (int)10));
        stylesPanel.setPreferredSize(new Dimension(300, 110));
        stylesPanel.setLayout((LayoutManager)new AutoSizingGridLayout(3, 1, 5, 5));
        JPanel fgContainer = new JPanel();
        AutoSizingGridLayout fgLayout = new AutoSizingGridLayout(1, 3, 5, 0, true, false, false);
        fgContainer.setLayout((LayoutManager)fgLayout);
        fgContainer.add(new JLabel(RB.getStringResource(RB_KEY, "fg.txt")));
        this._fgColorHost = new PropertyEditorHost();
        this._fgColorHost.setPreferredSize(new Dimension(175, 20));
        fgContainer.add(this._fgColorHost);
        stylesPanel.add(fgContainer);
        JPanel bgContainer = new JPanel();
        AutoSizingGridLayout bgLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, false);
        bgContainer.setLayout((LayoutManager)bgLayout);
        bgContainer.add(new JLabel(RB.getStringResource(RB_KEY, "bg.txt")));
        this._bgColorHost = new PropertyEditorHost();
        bgContainer.add(this._bgColorHost);
        stylesPanel.add(bgContainer);
        JPanel fontContainer = new JPanel();
        AutoSizingGridLayout fontLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, false);
        fontContainer.setLayout((LayoutManager)fontLayout);
        fontContainer.add(new JLabel(Message.format((String)RB.getStringResource(RB_KEY, "font.txt"), (Object)"                      ")));
        this._fontHost = new PropertyEditorHost();
        this._fontHost.setPreferredSize(new Dimension(152, 20));
        fontContainer.add(this._fontHost);
        stylesPanel.add(fontContainer);
        fgLayout.setInterlockedColumnContainers(new Container[]{bgContainer});
        bgLayout.setInterlockedColumnContainers(new Container[]{fgContainer});
        fontLayout.setInterlockedColumnContainers(new Container[]{fontContainer});
        this._fgColorHost.setPropertyValue(null, Color.class);
        this._bgColorHost.setPropertyValue(null, Color.class);
        this._fontHost.setPropertyValue(DEFAULT_FONT, Font.class);
        this.add(stylesPanel);
        return stylesPanel;
    }

    @Override
    public void setObject(Object bean) {
        this.onClear();
        super.setObject(bean);
        this.addLinks();
    }

    @Override
    void addLinks() {
        this._addButton.addActionListener(this);
        this._removeButton.addActionListener(this);
        this._replaceButton.addActionListener(this);
        this._namedButton.addActionListener(this);
        this._pairButton.addActionListener(this);
        this._treeManager.addListener();
        this._treeManager.refreshTreeView();
    }

    @Override
    public void preCustomizerClosing() {
        this._addButton.removeActionListener(this);
        this._removeButton.removeActionListener(this);
        this._replaceButton.removeActionListener(this);
        this._namedButton.removeActionListener(this);
        this._pairButton.removeActionListener(this);
        this._treeManager.removeListener();
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        super.preCustomizerClosing();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setCurrentValues(null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._addButton) {
            RangeInfo rInfo = this.validateRangeFields();
            if (rInfo != null) {
                this.addRange(rInfo);
            } else {
                String title = RB.getStringResource(RB_KEY, "errorDialogTitle.txt");
                String message = RB.getStringResource(RB_KEY, "errorDialogMessage.txt");
                JOptionPane.showMessageDialog(null, message, title, 2);
            }
            this.setButtonsEnabled(true);
        } else if (source == this._removeButton) {
            this.removeRange(this._treeManager.getSelectedNode());
            this.setButtonsEnabled(true);
        } else if (source == this._replaceButton) {
            RangeInfo rInfo = this.validateRangeFields();
            if (rInfo != null) {
                NodeView sn = this._treeManager.getSelectedNode();
                if (sn.getDepth() == 2) {
                    this.replaceRange(this._treeManager.getRangeInfo(sn), rInfo);
                }
            } else {
                String title = RB.getStringResource(RB_KEY, "errorDialogTitle.txt");
                String message = RB.getStringResource(RB_KEY, "errorDialogMessage.txt");
                MessageBox.showModalMessageBox(Util.getParentFrame(this), title, message, 1, 1, 2);
            }
            this.setButtonsEnabled(true);
        } else if (source == this._namedButton || source == this._pairButton) {
            this._treeManager.toggleTree();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        String propertyName = event.getPropertyName();
        if (source == this._treeManager.getTreeView()) {
            this.setButtonsEnabled(true);
        }
        super.propertyChange(event);
    }

    private boolean isValueValid(String value) {
        try {
            if (com.sas.util.Util.equal((Object)value, (Object)POSITIVE_INFINITY) || com.sas.util.Util.equal((Object)value, (Object)MAX_VALUE) || com.sas.util.Util.equal((Object)value, (Object)MIN_VALUE) || com.sas.util.Util.equal((Object)value, (Object)NEGATIVE_MIN_VALUE) || com.sas.util.Util.equal((Object)value, (Object)NEGATIVE_MAX_VALUE) || com.sas.util.Util.equal((Object)value, (Object)NEGATIVE_INFINITY) || com.sas.util.Util.equal((Object)value, (Object)NaN)) {
                return true;
            }
            DoubleData.valueOf((String)value);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @Override
    public void onApply() {
        if (!this.isModified() || this.isDesignTimeEISApplication()) {
            return;
        }
        try {
            this._table.setRanges(this.getRangeInterface());
        }
        catch (TableException ex) {
            this.showExceptionWarning((Exception)((Object)ex));
        }
    }

    @Override
    public void onClear() {
        this._alreadyInitialized = false;
        this._treeManager.getTreeView().setModel(null);
        this._namedCombo.removeAllItems();
        this._minCombo.removeAllItems();
        this._maxCombo.removeAllItems();
        this._statCombo.removeAllItems();
        this._measureCombo.removeAllItems();
        this.setEnabled(false);
    }

    private boolean isDesignTimeEISApplication() {
        try {
            return this.getTableInterface() != this.getRuntimeTableInterface() && this.getTableInterface().getApplication() != null;
        }
        catch (TableException ex) {
            return true;
        }
    }

    @Override
    public void onInitialize() {
        if (this._alreadyInitialized || !this.isRuntimeTableReady() || this.isDesignTimeEISApplication()) {
            return;
        }
        this._alreadyInitialized = this.onRefresh();
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
    }

    private boolean onRefresh() {
        boolean ok = true;
        if (this._rangeInfoCollection == null) {
            this._rangeInfoCollection = new ArrayList();
        } else {
            this._rangeInfoCollection.clear();
        }
        RangeInterface[] rInt = this.getRangesFromModel2();
        if (rInt != null && rInt.length > 0) {
            int cnt = rInt.length;
            for (int i = 0; i < cnt; ++i) {
                this.getRangeInfo2(rInt[i]);
            }
        }
        try {
            this.refreshCombos();
            this.refreshChoices();
            this._treeManager.refreshRanges(this._rangeInfoCollection);
        }
        catch (Exception ex) {
            this.showExceptionWarning(ex);
            ok = false;
        }
        this.setButtonsEnabled(true);
        return ok;
    }

    @Override
    protected boolean isModified() {
        return this._modified;
    }

    private boolean getViewStyle() {
        return this._namedButton.isSelected();
    }

    private boolean isButtonsEnabled() {
        return this._buttonsEnabled;
    }

    private void addRange(RangeInfo rInfo) {
        if (!this.containsRange(rInfo)) {
            ArrayList aList = this.getRangeNames();
            boolean containsName = aList != null ? aList.contains(rInfo.name) : false;
            this._modified = true;
            this._rangeInfoCollection.add(rInfo);
            this._treeManager.addRange(rInfo);
            if (!containsName) {
                this.firePropertyChange("addRange", null, rInfo.name);
            }
        }
    }

    private void removeRange(NodeView node) {
        if (node != null) {
            int depth = node.getDepth();
            if (depth > 1) {
                Node n = (Node)node.getNode();
                this.removeRange((RangeInfo)n.getObjectData());
            } else {
                int cnt = node.getNodeChildCount();
                for (int i = 0; i < cnt; ++i) {
                    NodeView n = (NodeView)node.getNodeChild(0);
                    this.removeRange(n);
                }
            }
        }
    }

    private void removeRange(RangeInfo rInfo) {
        if (this.containsRange(rInfo)) {
            boolean containsName;
            this._modified = true;
            this._rangeInfoCollection.remove(this._rangeInfoCollection.indexOf(rInfo));
            ArrayList aList = this.getRangeNames();
            boolean bl = containsName = aList != null ? aList.contains(rInfo.name) : false;
            if (!containsName) {
                this.firePropertyChange("removeRange", null, rInfo.name);
            }
        }
        this._treeManager.removeRange(rInfo);
    }

    private void replaceRange(RangeInfo oldInfo, RangeInfo newInfo) {
        this._modified = true;
        this.removeRange(oldInfo);
        this.addRange(newInfo);
    }

    private void setCurrentValues(RangeInfo rInfo) {
        if (rInfo != null) {
            this._namedCombo.setSelectedItem(rInfo.name);
            this._measureCombo.setSelectedItem(rInfo.measure);
            this._statCombo.setSelectedItem(rInfo.stat);
            this._minCombo.setSelectedItem(rInfo.min);
            this._maxCombo.setSelectedItem(rInfo.max);
        }
        PropertyEditor fgColorEditor = this._fgColorHost.getPropertyEditor();
        PropertyEditor bgColorEditor = this._bgColorHost.getPropertyEditor();
        PropertyEditor fontEditor = this._fontHost.getPropertyEditor();
        RangeSegment rs = rInfo != null ? rInfo._originalSegment : null;
        fgColorEditor.setValue(rs != null ? rs.get("foregroundColor", null) : null);
        bgColorEditor.setValue(rs != null ? rs.get("backgroundColor", null) : null);
        FontStyle fs = new FontStyle();
        fs.setFont(DEFAULT_FONT);
        Font f = rs != null ? ((FontStyle)((Object)rs.get("fontStyle", (Object)fs))).getFont() : DEFAULT_FONT;
        fontEditor.setValue(f);
    }

    private void setButtonsEnabled(boolean newValue) {
        this._buttonsEnabled = newValue;
        this._addButton.setEnabled(newValue);
        NodeView selectedNode = this._treeManager.getSelectedNode();
        this._removeButton.setEnabled(selectedNode != null);
        this._replaceButton.setEnabled(selectedNode != null && selectedNode.getDepth() != 0);
        if (selectedNode == null || selectedNode.getDepth() <= 0) {
            this.setCurrentValues(null);
        }
    }

    private void refreshChoices() throws TableException {
        MemberInterface[] statistics;
        if (this.getTableInterface() == null) {
            return;
        }
        MemberInterface[] measures = this._table.getMeasureMembersRT();
        if (measures != null && measures.length > 0) {
            this._measureComboModel = new DefaultComboBoxModel<MemberInterface>(measures);
            this._measureCombo.setModel(this._measureComboModel);
        }
        if ((statistics = this._table.getStatisticMembersRT()) != null && statistics.length > 0) {
            this._statComboModel = new DefaultComboBoxModel<MemberInterface>(statistics);
            this._statCombo.setModel(this._statComboModel);
        }
    }

    private void refreshCombos() {
        this._namedComboModel.removeAllElements();
        this._minComboModel.removeAllElements();
        this._maxComboModel.removeAllElements();
        this.addDefaultsNumbers();
        if (this._rangeInfoCollection != null && !this._rangeInfoCollection.isEmpty()) {
            int cnt = this._rangeInfoCollection.size();
            for (int i = 0; i < cnt; ++i) {
                this.addToChoices((RangeInfo)this._rangeInfoCollection.get(i));
            }
        }
    }

    private RangeInterface[] getRangesFromModel2() {
        if (this._rangesFromModel != null) {
            return this._rangesFromModel;
        }
        try {
            this._rangesFromModel = this._table.getRanges();
        }
        catch (TableException ex) {
            System.out.println((Object)ex);
        }
        return this._rangesFromModel;
    }

    private void getRangeInfo2(RangeInterface rInt) {
        MemberInterface measure = rInt.getMeasure();
        MemberInterface statistic = rInt.getStatistic();
        RangeCollection rCol = rInt.getRangeSegments();
        if (rCol != null) {
            int cnt = rCol.getSegmentCount();
            for (int i = 0; i < cnt; ++i) {
                RangeSegment rSegment = (RangeSegment)rCol.getSegment(i);
                RangeInfo rInfo = new RangeInfo();
                rInfo.pair = new Pair((Object)measure, (Object)statistic);
                rInfo.measure = measure;
                rInfo.stat = statistic;
                rInfo.name = (String)rSegment.get(STYLE_ID);
                rInfo.min = NamedTypesCustomizerPanel.getStringValue(rSegment.getMinimumNumber());
                rInfo.max = NamedTypesCustomizerPanel.getStringValue(rSegment.getMaximumNumber());
                rInfo._originalSegment = rSegment;
                this._rangeInfoCollection.add(rInfo);
            }
        }
    }

    private RangeInterface[] getRangeInterface() {
        if (this._rangeInfoCollection == null || this._rangeInfoCollection.isEmpty()) {
            return null;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (RangeInfo rInfo : this._rangeInfoCollection) {
            if (pairs.contains(rInfo.pair)) continue;
            pairs.add(rInfo.pair);
        }
        if (pairs.isEmpty()) {
            return null;
        }
        RangeInterface[] retRanges = new RangeInterface[pairs.size()];
        int cnt = pairs.size();
        for (int i = 0; i < cnt; ++i) {
            Pair pair = (Pair)pairs.get(i);
            RangeCollection rCol = new RangeCollection();
            rCol.removeAllSegments();
            rCol.setContiguousSegmentsRequired(false);
            Range range = new Range((MemberInterface)pair.getFirst(), (MemberInterface)pair.getSecond(), rCol);
            retRanges[i] = range;
            for (RangeInfo rInfo : this._rangeInfoCollection) {
                if (!NamedTypesCustomizerPanel.isPairEqual2(rInfo.pair, pair)) continue;
                Double minDouble = NamedTypesCustomizerPanel.getDoubleValue(rInfo.min);
                Double maxDouble = NamedTypesCustomizerPanel.getDoubleValue(rInfo.max);
                if (rInfo._originalSegment == null) {
                    rInfo._originalSegment = new RangeSegment((Number)minDouble, (Number)maxDouble);
                }
                RangeSegment rSegment = rInfo._originalSegment;
                rSegment.set(STYLE_ID, (Object)rInfo.name);
                rCol.addSegment((RangeSegmentInterface)rSegment);
            }
        }
        return retRanges;
    }

    private static final String getStringValue(Number num) {
        double d = num.doubleValue();
        if (d == MAX_VALUE_VAL) {
            return MAX_VALUE;
        }
        if (d == POSITIVE_INFINITY_VAL) {
            return POSITIVE_INFINITY;
        }
        if (d == MIN_VALUE_VAL) {
            return MIN_VALUE;
        }
        if (d == NEGATIVE_MIN_VALUE_VAL) {
            return NEGATIVE_MIN_VALUE;
        }
        if (d == NEGATIVE_MAX_VALUE_VAL) {
            return NEGATIVE_MAX_VALUE;
        }
        if (d == NEGATIVE_INFINITY_VAL) {
            return NEGATIVE_INFINITY;
        }
        if (Double.isNaN(d)) {
            return NaN;
        }
        return DoubleData.toString((double)d);
    }

    private static final Double getDoubleValue(String value) {
        try {
            if (com.sas.util.Util.equal((Object)value, (Object)POSITIVE_INFINITY)) {
                return POSITIVE_INFINITY_VAL;
            }
            if (com.sas.util.Util.equal((Object)value, (Object)MAX_VALUE)) {
                return MAX_VALUE_VAL;
            }
            if (com.sas.util.Util.equal((Object)value, (Object)MIN_VALUE)) {
                return MIN_VALUE_VAL;
            }
            if (com.sas.util.Util.equal((Object)value, (Object)NEGATIVE_MIN_VALUE)) {
                return NEGATIVE_MIN_VALUE_VAL;
            }
            if (com.sas.util.Util.equal((Object)value, (Object)NEGATIVE_MAX_VALUE)) {
                return NEGATIVE_MAX_VALUE_VAL;
            }
            if (com.sas.util.Util.equal((Object)value, (Object)NEGATIVE_INFINITY)) {
                return NEGATIVE_INFINITY_VAL;
            }
            if (com.sas.util.Util.equal((Object)value, (Object)NaN)) {
                return NaN_VAL;
            }
            return new Double(DoubleData.valueOf((String)value));
        }
        catch (NumberFormatException ex) {
            return new Double(0.0);
        }
    }

    private static final boolean isPairEqual2(Pair pair1, Pair pair2) {
        return com.sas.util.Util.equal((Object)pair1, (Object)pair2);
    }

    private final boolean containsRange(RangeInfo rInfo) {
        if (rInfo == null || this._rangeInfoCollection.isEmpty()) {
            return false;
        }
        Iterator iterator = this._rangeInfoCollection.iterator();
        while (iterator.hasNext()) {
            if (!rInfo.eq((RangeInfo)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public ArrayList getRangeNames() {
        if (this._rangeInfoCollection == null || this._rangeInfoCollection.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (RangeInfo rInfo : this._rangeInfoCollection) {
            if (names.contains(rInfo.name)) continue;
            names.add(rInfo.name);
        }
        return names;
    }

    private RangeInfo validateRangeFields() {
        RangeInfo rInfo = new RangeInfo();
        rInfo.name = (String)this._namedCombo.getSelectedItem();
        if (rInfo.name == null || rInfo.name.length() == 0) {
            return null;
        }
        rInfo.measure = (MemberInterface)this._measureCombo.getSelectedItem();
        if (rInfo.measure == null) {
            return null;
        }
        rInfo.stat = (MemberInterface)this._statCombo.getSelectedItem();
        if (rInfo.stat == null) {
            return null;
        }
        rInfo.pair = new Pair((Object)rInfo.measure, (Object)rInfo.stat);
        rInfo.min = (String)this._minCombo.getSelectedItem();
        if (rInfo.min == null || rInfo.min.length() == 0 || !this.isValueValid(rInfo.min)) {
            return null;
        }
        rInfo.max = (String)this._maxCombo.getSelectedItem();
        if (rInfo.max == null || rInfo.max.length() == 0 || !this.isValueValid(rInfo.max)) {
            return null;
        }
        if (this.containsRange(rInfo)) {
            for (RangeInfo ri : this._rangeInfoCollection) {
                if (!rInfo.eq(ri)) continue;
                rInfo._originalSegment = this.getStyleSegment(ri._originalSegment);
                break;
            }
        } else {
            rInfo._originalSegment = this.getStyleSegment(NamedTypesCustomizerPanel.getDoubleValue(rInfo.min), NamedTypesCustomizerPanel.getDoubleValue(rInfo.max));
        }
        if (this._namedComboModel.getIndexOf(rInfo.name) == -1) {
            this._namedComboModel.addElement(rInfo.name);
        }
        if (this._minComboModel.getIndexOf(rInfo.min) == -1) {
            this._minComboModel.addElement(rInfo.min);
        }
        if (this._maxComboModel.getIndexOf(rInfo.max) == -1) {
            this._maxComboModel.addElement(rInfo.max);
        }
        return rInfo;
    }

    private RangeSegment getStyleSegment(Double min, Double max) {
        Color bColor;
        RangeSegment styles = new RangeSegment((Number)min, (Number)max);
        PropertyEditor fgColorEditor = this._fgColorHost.getPropertyEditor();
        PropertyEditor bgColorEditor = this._bgColorHost.getPropertyEditor();
        PropertyEditor fontEditor = this._fontHost.getPropertyEditor();
        Color fColor = (Color)fgColorEditor.getValue();
        if (fColor != null) {
            styles.set("foregroundColor", (Object)fColor);
        }
        if ((bColor = (Color)bgColorEditor.getValue()) != null) {
            styles.set("backgroundColor", (Object)bColor);
        }
        FontStyle fs = new FontStyle();
        Font f = (Font)fontEditor.getValue();
        if (com.sas.util.Util.unequal((Object)f, (Object)DEFAULT_FONT)) {
            fs.setFont(f);
            styles.set("fontStyle", (Object)fs);
        }
        return styles;
    }

    private RangeSegment getStyleSegment(RangeSegment styles) {
        Color bColor;
        PropertyEditor fgColorEditor = this._fgColorHost.getPropertyEditor();
        PropertyEditor bgColorEditor = this._bgColorHost.getPropertyEditor();
        PropertyEditor fontEditor = this._fontHost.getPropertyEditor();
        Color fColor = (Color)fgColorEditor.getValue();
        if (fColor != null) {
            styles.set("foregroundColor", (Object)fColor);
        }
        if ((bColor = (Color)bgColorEditor.getValue()) != null) {
            styles.set("backgroundColor", (Object)bColor);
        }
        FontStyle fs = new FontStyle();
        Font f = (Font)fontEditor.getValue();
        if (com.sas.util.Util.unequal((Object)f, (Object)DEFAULT_FONT)) {
            fs.setFont(f);
            styles.set("fontStyle", (Object)fs);
        }
        return styles;
    }

    @Override
    public void updateData() throws TableException {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.isVisible()) {
            this.onVisible();
        }
    }

    @Override
    protected void connectionThreadEnding() {
        super.connectionThreadEnding();
        this.update(!this.wasCancelled() && !this.wasExceptionThrown());
    }

    private void update(boolean enabled) {
        this.setEnabled(enabled);
        this.dataInitialized = this.isEnabled();
    }

    @Override
    protected void disposeRemoteObjects() {
        super.disposeRemoteObjects();
        this.dataInitialized = false;
    }

    private void addToChoices(RangeInfo rInfo) {
        if (this._namedComboModel.getIndexOf(rInfo.name) == -1) {
            this._namedComboModel.addElement(rInfo.name);
        }
        if (this._minComboModel.getIndexOf(rInfo.min) == -1) {
            this._minComboModel.addElement(rInfo.min);
        }
        if (this._maxComboModel.getIndexOf(rInfo.max) == -1) {
            this._maxComboModel.addElement(rInfo.max);
        }
    }

    private void addDefaultsNumbers() {
        this._minComboModel.addElement(POSITIVE_INFINITY);
        this._minComboModel.addElement(MAX_VALUE);
        this._minComboModel.addElement(MIN_VALUE);
        this._minComboModel.addElement(NEGATIVE_MIN_VALUE);
        this._minComboModel.addElement(NEGATIVE_MAX_VALUE);
        this._minComboModel.addElement(NEGATIVE_INFINITY);
        this._minComboModel.addElement("0");
        this._maxComboModel.addElement(POSITIVE_INFINITY);
        this._maxComboModel.addElement(MAX_VALUE);
        this._maxComboModel.addElement(MIN_VALUE);
        this._maxComboModel.addElement(NEGATIVE_MIN_VALUE);
        this._maxComboModel.addElement(NEGATIVE_MAX_VALUE);
        this._maxComboModel.addElement(NEGATIVE_INFINITY);
        this._maxComboModel.addElement("0");
    }

    @Override
    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        this.setButtonsEnabled(newValue);
        NodeView selectedNode = this._treeManager.getSelectedNode();
        if (selectedNode != null && selectedNode.getDepth() != 0) {
            this._removeButton.setEnabled(newValue);
        }
    }

    @Override
    protected boolean createRuntimeTable() {
        return !this.isRuntimeTableReady() && this.isMetabaseAndDatabaseSet();
    }

    class RangeInfo {
        Pair pair;
        MemberInterface measure;
        MemberInterface stat;
        String name;
        String min;
        String max;
        RangeSegment _originalSegment;

        public RangeInfo() {
        }

        public RangeInfo(String name, MemberInterface measure, MemberInterface stat, String min, String max) {
            this();
            this.name = name;
            this.measure = measure;
            this.stat = stat;
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o instanceof RangeInfo) {
                RangeInfo rInfo = (RangeInfo)o;
                return com.sas.util.Util.equal((Object)this.name, (Object)rInfo.name) && com.sas.util.Util.equal((Object)this.measure, (Object)rInfo.measure) && com.sas.util.Util.equal((Object)this.stat, (Object)rInfo.stat) && com.sas.util.Util.equal((Object)this.min, (Object)rInfo.min) && com.sas.util.Util.equal((Object)this.max, (Object)rInfo.max) && com.sas.util.Util.equal((Object)this._originalSegment, (Object)rInfo._originalSegment);
            }
            return com.sas.util.Util.equal((Object)this.name, (Object)o.toString());
        }

        public boolean eq(RangeInfo rInfo) {
            return com.sas.util.Util.equal((Object)this.name, (Object)rInfo.name) && com.sas.util.Util.equal((Object)this.measure, (Object)rInfo.measure) && com.sas.util.Util.equal((Object)this.stat, (Object)rInfo.stat) && com.sas.util.Util.equal((Object)this.min, (Object)rInfo.min) && com.sas.util.Util.equal((Object)this.max, (Object)rInfo.max) && com.sas.util.Util.equal((Object)this._originalSegment, (Object)rInfo._originalSegment);
        }

        public String getChildString(boolean viewType) {
            if (viewType) {
                return this.getMeasureString() + ", " + this.getStatisticString() + ", " + this.min + ", " + this.max;
            }
            return this.name + ", " + this.min + ", " + this.max;
        }

        public String getMeasureString() {
            try {
                return this.measure.getLabel();
            }
            catch (TableException tableException) {
                return null;
            }
        }

        public String getStatisticString() {
            try {
                return this.stat.getLabel();
            }
            catch (TableException tableException) {
                return null;
            }
        }

        private String getPairString() {
            return this.getMeasureString() + ", " + this.getStatisticString();
        }

        public String getParentString(boolean viewType) {
            if (viewType) {
                return this.name;
            }
            return this.getPairString();
        }

        public String toString() {
            return "RangeInfo(" + this.name + ", " + this.measure + ", " + this.stat + ", " + this.min + ", " + this.max + ")";
        }
    }

    class TreeManager
    implements ItemListener {
        TreeView _treeView;
        Node _pairRootNode;
        Node _namedRootNode = new Node(RB.getStringResource("NamedTypesCustomizerPanel.", "namedStylesViewRootNodeLabel.txt"));

        public TreeManager() {
            this._pairRootNode = new Node(RB.getStringResource(NamedTypesCustomizerPanel.RB_KEY, "pairsViewRootNodeLabel.txt"));
        }

        public TreeManager(TreeView treeView) {
            this();
            this._treeView = treeView;
        }

        public void refreshRanges(ArrayList ranges) {
            this._namedRootNode.removeAllNodeChildren();
            this._pairRootNode.removeAllNodeChildren();
            if (ranges != null) {
                Iterator iterator = ranges.iterator();
                while (iterator.hasNext()) {
                    this.addRange((RangeInfo)iterator.next());
                }
            }
            this.refreshTreeView();
        }

        public void addListener() {
            this._treeView.addItemListener(this);
        }

        public void addRange(RangeInfo rInfo) {
            this.addRange(rInfo, true);
            this.addRange(rInfo, false);
            this.setSelectedNodeInTree(rInfo);
        }

        public void addRange(RangeInfo rInfo, boolean viewType) {
            Node pNode = this.getParentNode(rInfo, viewType);
            if (pNode != null) {
                if (this.getChildNode(rInfo, viewType, pNode) != null) {
                    return;
                }
                Node cNode = this.createNode(rInfo, viewType, false);
                pNode.addNodeChild((SimpleNodeInterface)cNode, -1);
            } else {
                pNode = this.createNode(rInfo, viewType, true);
                Node cNode = this.createNode(rInfo, viewType, false);
                pNode.addNodeChild((SimpleNodeInterface)cNode, -1);
                this.getRootNode(viewType).addNodeChild((SimpleNodeInterface)pNode, -1);
            }
        }

        private Node getChildNode(RangeInfo rInfo, boolean viewType, Node parent) {
            String s = rInfo.getChildString(viewType);
            if (parent == null) {
                parent = this.getParentNode(rInfo, viewType);
            }
            int cnt = parent.getNodeChildCount();
            for (int i = 0; i < cnt; ++i) {
                Node cNode = (Node)parent.getNodeChild(i);
                if (!com.sas.util.Util.equal((Object)cNode.getNodeText(), (Object)s)) continue;
                return cNode;
            }
            return null;
        }

        private Node createNode(RangeInfo rInfo, boolean viewType, boolean isParent) {
            Node node = new Node();
            if (isParent) {
                node.setNodeText(rInfo.getParentString(viewType));
            } else {
                node.setNodeText(rInfo.getChildString(viewType));
                node.setObjectData((Object)rInfo);
            }
            return node;
        }

        private Node getParentNode(RangeInfo rInfo, boolean viewType) {
            Node root = this.getRootNode(viewType);
            String s = rInfo.getParentString(viewType);
            int cnt = root.getNodeChildCount();
            for (int i = 0; i < cnt; ++i) {
                Node pNode = (Node)root.getNodeChild(i);
                if (!com.sas.util.Util.equal((Object)pNode.getNodeText(), (Object)s)) continue;
                return pNode;
            }
            return null;
        }

        public RangeInfo getRangeInfo(NodeView nv) {
            if (nv == null) {
                return null;
            }
            Node n = (Node)nv.getNode();
            return (RangeInfo)n.getObjectData();
        }

        private Node getRootNode(boolean viewType) {
            if (viewType) {
                return this._namedRootNode;
            }
            return this._pairRootNode;
        }

        public NodeView getSelectedNode() {
            if (this._treeView != null) {
                return this._treeView.getSelectedNode();
            }
            return null;
        }

        public TreeView getTreeView() {
            return this._treeView;
        }

        public void removeRange(NodeView node) {
            int depth = node.getDepth();
            if (depth == 2) {
                RangeInfo rInfo = this.getRangeInfo(node);
                this.removeRange(rInfo, true);
                this.removeRange(rInfo, false);
            } else {
                int cnt = node.getNodeChildCount();
                for (int i = 0; i < cnt; ++i) {
                    NodeView n = (NodeView)node.getNodeChild(0);
                    this.removeRange(n);
                }
            }
        }

        public void removeListener() {
            this._treeView.removeItemListener(this);
        }

        public void removeRange(RangeInfo rInfo) {
            this.removeRange(rInfo, true);
            this.removeRange(rInfo, false);
        }

        private void removeRange(RangeInfo rInfo, boolean viewType) {
            Node pNode = this.getParentNode(rInfo, viewType);
            Node cNode = this.getChildNode(rInfo, viewType, pNode);
            pNode.removeNodeChild((SimpleNodeInterface)cNode);
            if (pNode.getNodeChildCount() == 0) {
                this.getRootNode(viewType).removeNodeChild((SimpleNodeInterface)pNode);
            }
        }

        public void replaceRange(RangeInfo oldInfo, RangeInfo newInfo) {
            this.removeRange(oldInfo);
            this.addRange(newInfo);
        }

        private void setSelectedNodeInTree(RangeInfo rInfo) {
            if (rInfo == null) {
                return;
            }
            Node n = this.getChildNode(rInfo, NamedTypesCustomizerPanel.this.getViewStyle(), null);
            if (n != null) {
                NodeView nv = this.getTreeView().getNodeView((NodeInterface)n, 1);
                if (nv != null) {
                    nv.setVisible();
                    nv.setSelected(true);
                    NamedTypesCustomizerPanel.this.setCurrentValues(rInfo);
                } else {
                    System.out.println("We didn't find the node!");
                }
            }
        }

        public void toggleTree() {
            NodeState tempState = this._treeView.getRoot().getState();
            RangeInfo rInfo = this.getRangeInfo(this._treeView.getSelectedNode());
            this.refreshTreeView();
            NodeView root = this._treeView.getRoot();
            if (NamedTypesCustomizerPanel.this._previousViewState != null) {
                root.setState(NamedTypesCustomizerPanel.this._previousViewState);
            }
            this.setSelectedNodeInTree(rInfo);
            NamedTypesCustomizerPanel.this._previousViewState = tempState;
        }

        private void refreshTreeView() {
            this._treeView.setModel((TreeInterface)this.getRootNode(NamedTypesCustomizerPanel.this.getViewStyle()));
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getSource() == this.getTreeView()) {
                if (event.getStateChange() == 1) {
                    NodeView selectedNode = this.getSelectedNode();
                    if (selectedNode.getDepth() != 2) {
                        if (NamedTypesCustomizerPanel.this.isButtonsEnabled()) {
                            NamedTypesCustomizerPanel.this.setCurrentValues(null);
                        }
                    } else {
                        if (NamedTypesCustomizerPanel.this.isButtonsEnabled()) {
                            NamedTypesCustomizerPanel.this._replaceButton.setEnabled(true);
                        }
                        Node node = (Node)selectedNode.getNode();
                        RangeInfo rInfo = (RangeInfo)node.getObjectData();
                        NamedTypesCustomizerPanel.this.setCurrentValues(rInfo);
                    }
                }
            }
        }
    }

    class MyCellRenderer
    extends DefaultListCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof MemberInterface) {
                MemberInterface mInt = (MemberInterface)value;
                try {
                    String strValue = mInt.getLabel();
                    value = strValue;
                }
                catch (TableException tableException) {
                    // empty catch block
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

