/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.AssociationList;
import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.PropertyBag;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.models.RangeSegment;
import com.sas.models.RangeSegmentInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.ComputedValueInterface;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableDelegate;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.Range;
import com.sas.sasserver.mdtable.RangeCollection;
import com.sas.sasserver.mdtable.RangeInterface;
import com.sas.sasserver.mdtable.Statistic;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.table.FontStyle;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.Util;
import java.awt.Color;
import java.util.Enumeration;

public class MultidimensionalTableV2Delegate
extends MultidimensionalTableDelegate {
    protected transient boolean _orderSet;

    public int findMember(String level, String pattern, boolean ignoreCase) {
        if (level == null || pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV2Interface)this.Imddb)._findMember(level, pattern, ignoreCase, false, "Y", 0, 1);
    }

    public int findCubeMember(String level, String pattern, boolean ignoreCase, boolean matchEntire) {
        if (level == null || pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV2Interface)this.Imddb)._findMember(level, pattern, ignoreCase, matchEntire, "N", 0, 1);
    }

    public int findNextMember(String level, String pattern, boolean ignoreCase, int startPosition) {
        if (level == null || pattern == null) {
            return -1;
        }
        int index = ((MultidimensionalTableV2Interface)this.Imddb)._findMember(level, pattern, ignoreCase, false, "Y", startPosition, 1);
        return index;
    }

    public int findPrevMember(String level, String pattern, boolean ignoreCase, int startPosition) {
        if (level == null || pattern == null) {
            return -1;
        }
        int index = ((MultidimensionalTableV2Interface)this.Imddb)._findMember(level, pattern, ignoreCase, false, "Y", startPosition, -1);
        return index;
    }

    public int findNextAxisLabel(int axisOrdinal, HListInterface tupleList, String pattern, boolean ignoreCase, int startPosition) {
        if (pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV2Interface)this.Imddb)._findAxisLabel(axisOrdinal, tupleList, pattern, ignoreCase, startPosition, 1);
    }

    public int findPrevAxisLabel(int axisOrdinal, HListInterface tupleList, String pattern, boolean ignoreCase, int startPosition) {
        if (pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV2Interface)this.Imddb)._findAxisLabel(axisOrdinal, tupleList, pattern, ignoreCase, startPosition, -1);
    }

    public void sort(LevelInterface l, int sortDirection) {
        Level level;
        if (l instanceof Level && !(level = (Level)l).isAnalysisLevel() && !level.isStatisticLevel()) {
            HList tupleList = Level.tupleToHList(level);
            ExtendedNodeInterface a = level.getRootParent();
            int ordinal = -1;
            Axis oa = null;
            if (a != null && a instanceof AxisInterface) {
                oa = (Axis)a;
                ordinal = oa.getOrdinal();
            } else if (this._version == 3) {
                try {
                    DimensionInterface d;
                    level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(l.getName());
                    if (level != null && (d = level.getDimension()) != null && (oa = (Axis)d.getAxis()) != null) {
                        ordinal = oa.getOrdinal();
                    }
                }
                catch (TableException d) {
                    // empty catch block
                }
            }
            String s = this.getSortString(sortDirection);
            this.sort(ordinal, (HListInterface)tupleList, s, 0);
            level.setSortOrder(sortDirection);
            this.Imddb.refreshTable(oa, null);
        }
    }

    public void sort(int columnNumber, int sortDirection) {
        try {
            AxisInterface a = this.Imddb.getAxis(0);
            if (columnNumber > a.getMagnitude() || columnNumber < 0) {
                return;
            }
            AxisLabelInterface[] al = a.getLabels(columnNumber);
            MemberInterface[] ma = new MemberInterface[al.length];
            for (int i = 0; i < al.length; ++i) {
                ma[i] = al[i].getMember();
            }
            this.sort(ma, sortDirection);
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public void sort(MemberInterface[] columnLabels, int sortDirection) {
        try {
            AssociationList asl = new AssociationList();
            if (columnLabels.length > 0 && columnLabels[0] != null) {
                LevelInterface l = columnLabels[0].getLevel();
                Axis a = (Axis)l.getDimension().getAxis();
                if (a == null || a.getOrdinal() == 1) {
                    return;
                }
                int i = columnLabels.length - 1;
                String s = this.getSortString(sortDirection);
                Member sortLabel = null;
                Level lev = (Level)columnLabels[i].getLevel();
                if (lev.isStatisticLevel()) {
                    sortLabel = (Member)columnLabels[i];
                } else {
                    sortLabel = new Member(this.Imddb);
                    sortLabel.setDelegate(MDCommand.getHiddenStatMember(this.Imddb));
                    sortLabel.setParent((ParentNode)((Object)columnLabels[columnLabels.length - 1]));
                    ((Member)columnLabels[columnLabels.length - 1]).setSortOrder(sortDirection);
                    sortLabel.setTopBottomN(((Member)columnLabels[columnLabels.length - 1]).getTopBottomN());
                    sortLabel.setOrdinal(columnLabels.length);
                    asl.set((Object)sortLabel.getLevel().getName(), (Object)sortLabel.getLabel());
                }
                sortLabel.setSortOrder(sortDirection);
                int N = 0;
                if (sortLabel instanceof Member) {
                    N = sortLabel.getTopBottomN();
                }
                this._orderSet = true;
                while (i > 0) {
                    LevelInterface level = columnLabels[i].getLevel();
                    asl.set((Object)level.getName(), (Object)columnLabels[i].getLabel());
                    --i;
                }
                asl.set((Object)l.getName(), (Object)columnLabels[i].getLabel());
                HListInterface hlist = this.AssociationListToHList(asl);
                this.sort(a.getOrdinal(), hlist, s, N);
                this.Imddb.refreshTable((Axis)this.Imddb.getAxis(1), null);
            }
        }
        catch (TableException te) {
            System.out.println(RB.getStringResource("sort.ex.text"));
        }
    }

    protected HListInterface AssociationListToHList(AssociationList asl) {
        HList hList = new HList();
        int cnt = asl.count();
        for (int i = 0; i < cnt; ++i) {
            String key = (String)asl.getKey(i);
            hList.addItem((String)asl.get((Object)key), 0, key);
        }
        return hList;
    }

    protected String getSortString(int sortType) {
        MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
        if (sortType == 1) {
            return "Descending";
        }
        MultidimensionalTableV2Interface cfr_ignored_1 = (MultidimensionalTableV2Interface)this.Imddb;
        if (sortType == 2) {
            return "Ascending";
        }
        return "Reset";
    }

    public void sort(int axisOrdinal, HListInterface tupleList, String direction, int N) {
        try {
            if (tupleList == null || tupleList.count() == 0) {
                return;
            }
            int cnt = tupleList.count();
            String[] labels = new String[cnt];
            String[] names = new String[cnt];
            for (int i = cnt - 1; i >= 0; --i) {
                labels[i] = tupleList.getString(i);
                names[i] = tupleList.getName(i);
            }
            ((MultidimensionalTableV2Interface)this.Imddb)._sort(axisOrdinal, tupleList, direction, N);
            if (!this._orderSet) {
                Dictionary levels;
                Axis oa = null;
                if (axisOrdinal >= 0) {
                    oa = (Axis)this.Imddb.getAxis(axisOrdinal);
                }
                if ((levels = this.Imddb.getAllLevels()).containsKey((Object)names[names.length - 1])) {
                    Level l = (Level)levels.get((Object)names[names.length - 1]);
                    if (axisOrdinal == 0 && l.isStatisticLevel()) {
                        int axisCoordinate = oa.getAxisCoordinate(labels);
                        if (axisCoordinate >= 0) {
                            AxisLabelInterface[] axisLabels = oa.getLabels(axisCoordinate);
                            Member sortLabel = (Member)axisLabels[axisLabels.length - 1];
                            sortLabel.setSortDirection(direction);
                            sortLabel.setTopBottomN(N);
                        }
                        oa = (Axis)this.Imddb.getAxis(1);
                        this.Imddb.refreshTable(oa, null);
                    } else {
                        l.setSortDirection(direction);
                    }
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public Object getApplicationInfo() {
        return ((MultidimensionalTableV2Interface)this.Imddb)._getApplicationInfo();
    }

    public void setApplicationInfo(Object info) throws TableException {
        if (info instanceof HListInterface) {
            long inError = ((MultidimensionalTableV2Interface)this.Imddb)._setApplicationInfo((HListInterface)((HList)info));
            if (inError == 0L) {
                try {
                    this._stats = null;
                    this.setApplicationInfo();
                }
                catch (TableException te) {
                    throw new TableException(te.getMessage());
                }
                this.setRangeCollection();
                this._axisCount = -1;
                this._firstTimeThru = true;
                this._levels = null;
                this.refreshTable();
            } else {
                throw new TableException(this.getMessage());
            }
        }
    }

    public Object getBookmark() {
        HList hlist = (HList)this.getApplicationInfo();
        if (this.Imddb instanceof MultidimensionalTableV3Interface) {
            HList addonList = new HList();
            MultidimensionalTableV3Interface v3Imddb = (MultidimensionalTableV3Interface)this.Imddb;
            try {
                Dictionary levelsDict = v3Imddb.getAllLevels();
                Enumeration levels = levelsDict.getItems();
                if (levels != null) {
                    HList totalStylesList = new HList();
                    while (levels.hasMoreElements()) {
                        StaticPropertyBagInterface cellStyle;
                        Level level = (Level)levels.nextElement();
                        HList levelList = new HList();
                        boolean addLevel = false;
                        StaticPropertyBagInterface labelStyle = level.getTotalLabelStyle();
                        if (labelStyle != null) {
                            Color labelForegroundColor = (Color)labelStyle.get("foregroundColor", null);
                            Color labelBackgroundColor = (Color)labelStyle.get("backgroundColor", null);
                            FontStyle labelFont = (FontStyle)((Object)labelStyle.get("fontStyle", null));
                            if (labelForegroundColor != null) {
                                levelList.addItem((double)labelForegroundColor.getRGB(), -1, "LABEL_FOREGROUND_COLOR");
                            }
                            if (labelBackgroundColor != null) {
                                levelList.addItem((double)labelBackgroundColor.getRGB(), -1, "LABEL_BACKGROUND_COLOR");
                            }
                            if (labelFont != null) {
                                HList fontList = new HList();
                                fontList.addItem(labelFont.getName(), -1, "NAME");
                                fontList.addItem(labelFont.getSize(), -1, "SIZE");
                                fontList.addItem((double)labelFont.getStyle(), -1, "STYLE");
                                fontList.addItem((double)labelFont.getWeight(), -1, "WEIGHT");
                                fontList.addItem((double)labelFont.getWidth(), -1, "WIDTH");
                                levelList.addItem((HListInterface)fontList, -1, "LABEL_FONT");
                            }
                            addLevel = true;
                        }
                        if ((cellStyle = level.getTotalCellStyle()) != null) {
                            Color cellForegroundColor = (Color)cellStyle.get("foregroundColor", null);
                            Color cellBackgroundColor = (Color)cellStyle.get("backgroundColor", null);
                            FontStyle cellFont = (FontStyle)((Object)cellStyle.get("fontStyle", null));
                            if (cellForegroundColor != null) {
                                levelList.addItem((double)cellForegroundColor.getRGB(), -1, "CELL_FOREGROUND_COLOR");
                            }
                            if (cellBackgroundColor != null) {
                                levelList.addItem((double)cellBackgroundColor.getRGB(), -1, "CELL_BACKGROUND_COLOR");
                            }
                            if (cellFont != null) {
                                HList fontList = new HList();
                                fontList.addItem(cellFont.getName(), -1, "NAME");
                                fontList.addItem(cellFont.getSize(), -1, "SIZE");
                                fontList.addItem((double)cellFont.getStyle(), -1, "STYLE");
                                fontList.addItem((double)cellFont.getWeight(), -1, "WEIGHT");
                                fontList.addItem((double)cellFont.getWidth(), -1, "WIDTH");
                                levelList.addItem((HListInterface)fontList, -1, "CELL_FONT");
                            }
                            addLevel = true;
                        }
                        if (!addLevel) continue;
                        totalStylesList.addItem((HListInterface)levelList, -1, level.getName());
                    }
                    addonList.setItem("TOTAL_STYLES", (HListInterface)totalStylesList);
                }
            }
            catch (TableException levelsDict) {
                // empty catch block
            }
            long CommandsMask = v3Imddb.getCommandsMask();
            addonList.setItem("COMMANDS_MASK", (double)CommandsMask);
            addonList.setItem("DEFAULT_ACTION_MASK", (double)v3Imddb.getDefaultActionMask());
            try {
                boolean coordinatorEnabled = v3Imddb.isCoordinatorEnabled();
                if (coordinatorEnabled) {
                    addonList.setItem("COORDINATOR_ENABLED", "Y");
                } else {
                    addonList.setItem("COORDINATOR_ENABLED", "N");
                }
            }
            catch (TableException coordinatorEnabled) {
                // empty catch block
            }
            try {
                RangeInterface[] ranges = v3Imddb.getRanges();
                if (ranges != null) {
                    HList rangeList = new HList();
                    for (int i = 0; i < ranges.length; ++i) {
                        HList pairList = new HList();
                        RangeInterface range = ranges[i];
                        if (range == null) continue;
                        String measure = range.getMeasure().getName();
                        String statistic = range.getStatistic().getName();
                        RangeCollection segments = range.getRangeSegments();
                        if (segments == null) continue;
                        HList typeSegmentList = new HList();
                        Enumeration typeSegments = segments.getSegments();
                        if (typeSegments == null) continue;
                        while (typeSegments.hasMoreElements()) {
                            RangeSegment typeSegment = (RangeSegment)typeSegments.nextElement();
                            HList segmentList = new HList();
                            String styleId = (String)typeSegment.get("styleId", null);
                            Color segmentForegroundColor = (Color)typeSegment.get("foregroundColor", null);
                            Color segmentBackgroundColor = (Color)typeSegment.get("backgroundColor", null);
                            segmentList.addItem(typeSegment.getMaximumNumber().toString(), -1, "MAXIMUM_NUMBER");
                            segmentList.addItem(typeSegment.getMinimumNumber().toString(), -1, "MINIMUM_NUMBER");
                            segmentList.addItem((double)typeSegment.getColor().getRGB(), -1, "SEGMENT_COLOR");
                            FontStyle font = (FontStyle)((Object)typeSegment.get("fontStyle", null));
                            if (segmentForegroundColor != null) {
                                segmentList.addItem((double)segmentForegroundColor.getRGB(), -1, "SEGMENT_FOREGROUND_COLOR");
                            }
                            if (segmentBackgroundColor != null) {
                                segmentList.addItem((double)segmentBackgroundColor.getRGB(), -1, "SEGMENT_BACKGROUND_COLOR");
                            }
                            if (font != null) {
                                HList fontList = new HList();
                                fontList.addItem(font.getName(), -1, "NAME");
                                fontList.addItem(font.getSize(), -1, "SIZE");
                                fontList.addItem((double)font.getStyle(), -1, "STYLE");
                                fontList.addItem((double)font.getWeight(), -1, "WEIGHT");
                                fontList.addItem((double)font.getWidth(), -1, "WIDTH");
                                segmentList.addItem((HListInterface)fontList, -1, "SEGMENT_FONT");
                            }
                            typeSegmentList.addItem((HListInterface)segmentList, -1, styleId);
                        }
                        pairList.addItem((HListInterface)typeSegmentList, -1, "SEGMENTS");
                        pairList.addItem(measure, 0, "MEASURE");
                        pairList.addItem(statistic, 0, "STATISTIC");
                        rangeList.addItem((HListInterface)pairList, -1, "PAIR");
                    }
                    addonList.setItem("RANGES", (HListInterface)rangeList);
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
            hlist.setItem("CLIENT_ADDON_LIST", (HListInterface)addonList);
        }
        return hlist;
    }

    public void gotoBookmark(Object bookmark) {
        HList hlist;
        this.disableEvents();
        if (bookmark instanceof HListInterface && (hlist = (HList)bookmark) != null) {
            try {
                this.setApplicationInfo(hlist);
            }
            catch (TableException te) {
                throw new IllegalStateException(te.getMessage());
            }
            if (this.Imddb instanceof MultidimensionalTableV3Interface) {
                MultidimensionalTableV3Interface v3Imddb = (MultidimensionalTableV3Interface)this.Imddb;
                HList addonList = null;
                if (hlist.itemExists("CLIENT_ADDON_LIST", 1, 0)) {
                    addonList = (HList)hlist.getList("CLIENT_ADDON_LIST");
                }
                if (addonList != null) {
                    try {
                        Dictionary levelsDict = v3Imddb.getAllLevels();
                        if (addonList.itemExists("TOTAL_STYLES", 1, 0)) {
                            HList totalStylesList = (HList)addonList.getList("TOTAL_STYLES");
                            HList levelList = new HList();
                            String levelName = null;
                            Level level = null;
                            for (int i = 0; i < totalStylesList.count(); ++i) {
                                HList cellFontList;
                                HList labelFontList;
                                levelList = (HList)totalStylesList.getList(i);
                                levelName = totalStylesList.getName(i);
                                PropertyBag labelFontStyles = new PropertyBag();
                                PropertyBag cellFontStyles = new PropertyBag();
                                if (levelName != null) {
                                    level = v3Imddb.findLevel(levelName);
                                }
                                if (level == null || levelList == null) continue;
                                Color cellBackgroundColor = null;
                                Color cellForegroundColor = null;
                                Color labelBackgroundColor = null;
                                Color labelForegroundColor = null;
                                if (levelList.itemExists("CELL_BACKGROUND_COLOR", 1, 0)) {
                                    cellBackgroundColor = new Color((int)levelList.getDouble("CELL_BACKGROUND_COLOR"));
                                    cellFontStyles.set("backgroundColor", (Object)cellBackgroundColor);
                                }
                                if (levelList.itemExists("CELL_FOREGROUND_COLOR", 1, 0)) {
                                    cellForegroundColor = new Color((int)levelList.getDouble("CELL_FOREGROUND_COLOR"));
                                    cellFontStyles.set("foregroundColor", (Object)cellForegroundColor);
                                }
                                if (levelList.itemExists("LABEL_BACKGROUND_COLOR", 1, 0)) {
                                    labelBackgroundColor = new Color((int)levelList.getDouble("LABEL_BACKGROUND_COLOR"));
                                    labelFontStyles.set("backgroundColor", (Object)labelBackgroundColor);
                                }
                                if (levelList.itemExists("LABEL_FOREGROUND_COLOR", 1, 0)) {
                                    labelForegroundColor = new Color((int)levelList.getDouble("LABEL_FOREGROUND_COLOR"));
                                    labelFontStyles.set("foregroundColor", (Object)labelForegroundColor);
                                }
                                if (levelList.itemExists("LABEL_FONT", 1, 0) && (labelFontList = (HList)levelList.getList("LABEL_FONT")) != null) {
                                    FontStyle labelFont = new FontStyle();
                                    if (labelFontList.itemExists("SIZE", 1, 0)) {
                                        labelFont.setSize(labelFontList.getDouble("SIZE"));
                                    }
                                    if (labelFontList.itemExists("STYLE", 1, 0)) {
                                        labelFont.setStyle((int)labelFontList.getDouble("STYLE"));
                                    }
                                    if (labelFontList.itemExists("WEIGHT", 1, 0)) {
                                        labelFont.setWeight((int)labelFontList.getDouble("WEIGHT"));
                                    }
                                    if (labelFontList.itemExists("WIDTH", 1, 0)) {
                                        labelFont.setWidth((int)labelFontList.getDouble("WIDTH"));
                                    }
                                    if (labelFontList.itemExists("NAME", 1, 0)) {
                                        labelFont.setName(labelFontList.getString("NAME"));
                                    }
                                    labelFontStyles.set("fontStyle", (Object)labelFont);
                                }
                                if (levelList.itemExists("CELL_FONT", 1, 0) && (cellFontList = (HList)levelList.getList("CELL_FONT")) != null) {
                                    FontStyle cellFont = new FontStyle();
                                    if (cellFontList.itemExists("SIZE", 1, 0)) {
                                        cellFont.setSize(cellFontList.getDouble("SIZE"));
                                    }
                                    if (cellFontList.itemExists("STYLE", 1, 0)) {
                                        cellFont.setStyle((int)cellFontList.getDouble("STYLE"));
                                    }
                                    if (cellFontList.itemExists("WEIGHT", 1, 0)) {
                                        cellFont.setWeight((int)cellFontList.getDouble("WEIGHT"));
                                    }
                                    if (cellFontList.itemExists("WIDTH", 1, 0)) {
                                        cellFont.setWidth((int)cellFontList.getDouble("WIDTH"));
                                    }
                                    if (cellFontList.itemExists("NAME", 1, 0)) {
                                        cellFont.setName(cellFontList.getString("NAME"));
                                    }
                                    cellFontStyles.set("fontStyle", (Object)cellFont);
                                }
                                if (labelFontStyles != null) {
                                    level.setTotalLabelStyle((StaticPropertyBagInterface)labelFontStyles);
                                }
                                if (cellFontStyles == null) continue;
                                level.setTotalCellStyle((StaticPropertyBagInterface)cellFontStyles);
                            }
                        }
                        if (addonList.itemExists("RANGES", 1, 0)) {
                            HList rangesList = (HList)addonList.getList("RANGES");
                            HList pairlist = new HList();
                            HList segments = new HList();
                            HList segment = new HList();
                            String measure = null;
                            String stat = null;
                            String styleId = null;
                            if (rangesList != null) {
                                RangeInterface[] rangesArray = new Range[rangesList.count()];
                                for (int i = 0; i < rangesList.count(); ++i) {
                                    pairlist = (HList)rangesList.getList(i);
                                    PropertyBag labelFontStyles = new PropertyBag();
                                    if (pairlist == null) continue;
                                    Range range = new Range();
                                    if (pairlist.itemExists("MEASURE", 1, 0)) {
                                        measure = pairlist.getString("MEASURE");
                                        boolean foundMeasure = false;
                                        ParentNode measureLevel = null;
                                        if (levelsDict.containsKey((Object)"_ANLSYS_")) {
                                            measureLevel = (Level)levelsDict.get((Object)"_ANLSYS_");
                                        }
                                        if (measureLevel != null) {
                                            MemberInterface[] cubeMems = ((LevelInterface)((Object)measureLevel.getDelegate())).getMembers(0, -1);
                                            for (int l = 0; l < cubeMems.length; ++l) {
                                                System.out.println("cubeMems[l]: " + cubeMems[l]);
                                                if (!measure.equals(cubeMems[l].getName())) continue;
                                                range.setMeasure(cubeMems[l]);
                                                foundMeasure = true;
                                                break;
                                            }
                                            if (!foundMeasure) {
                                                MemberInterface[] measureMems = ((Level)measureLevel).getMembers(0, -1);
                                                for (int k = measureMems.length - 1; k >= 0; --k) {
                                                    System.out.println("measureMems[k]: " + measureMems[k]);
                                                    if (!measure.equals(measureMems[k].getName())) continue;
                                                    range.setMeasure(measureMems[k]);
                                                    foundMeasure = true;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    if (pairlist.itemExists("STATISTIC", 1, 0)) {
                                        stat = pairlist.getString("STATISTIC");
                                        MemberInterface[] statMembers = v3Imddb.getStatisticMembers();
                                        for (int j = 0; j < statMembers.length; ++j) {
                                            if (!stat.equals(statMembers[j].getName())) continue;
                                            range.setStatistic(statMembers[j]);
                                            break;
                                        }
                                    }
                                    if (pairlist.itemExists("SEGMENTS", 1, 0)) {
                                        segments = (HList)pairlist.getList("SEGMENTS");
                                    }
                                    if (segments != null) {
                                        RangeSegment[] segmentArray = new RangeSegment[segments.count()];
                                        for (int j = 0; j < segments.count(); ++j) {
                                            HList segmentFontList;
                                            RangeSegment rs = null;
                                            styleId = segments.getName(j);
                                            segment = (HList)segments.getList(j);
                                            Color segmentColor = null;
                                            Double max = null;
                                            Double min = null;
                                            try {
                                                String s;
                                                if (segment.itemExists("SEGMENT_COLOR", 1, 0)) {
                                                    segmentColor = new Color((int)segment.getDouble("SEGMENT_COLOR"));
                                                }
                                                if (segment.itemExists("MAXIMUM_NUMBER", 1, 0) && (s = segment.getString("MAXIMUM_NUMBER")) != null) {
                                                    max = s.toLowerCase().equals("infinity") ? new Double(Double.POSITIVE_INFINITY) : (s.toLowerCase().equals("-infinity") ? new Double(Double.NEGATIVE_INFINITY) : (s.toLowerCase().equals("nan") ? new Double(Double.NaN) : new Double(s)));
                                                }
                                                if (segment.itemExists("MINIMUM_NUMBER", 1, 0) && (s = segment.getString("MINIMUM_NUMBER")) != null) {
                                                    min = s.toLowerCase().equals("infinity") ? new Double(Double.POSITIVE_INFINITY) : (s.toLowerCase().equals("-infinity") ? new Double(Double.NEGATIVE_INFINITY) : (s.toLowerCase().equals("nan") ? new Double(Double.NaN) : new Double(s)));
                                                }
                                            }
                                            catch (NumberFormatException nfe) {
                                                nfe.printStackTrace();
                                            }
                                            if (min != null && max != null) {
                                                rs = segmentColor != null ? new RangeSegment(min, max, segmentColor) : new RangeSegment(min, max);
                                            }
                                            if (rs == null) continue;
                                            rs.set("styleId", (Object)styleId);
                                            Color segmentBackgroundColor = null;
                                            Color segmentForegroundColor = null;
                                            if (segment.itemExists("SEGMENT_BACKGROUND_COLOR", 1, 0)) {
                                                segmentBackgroundColor = new Color((int)segment.getDouble("SEGMENT_BACKGROUND_COLOR"));
                                                rs.set("backgroundColor", (Object)segmentBackgroundColor);
                                            }
                                            if (segment.itemExists("SEGMENT_FOREGROUND_COLOR", 1, 0)) {
                                                segmentForegroundColor = new Color((int)segment.getDouble("SEGMENT_FOREGROUND_COLOR"));
                                                rs.set("foregroundColor", (Object)segmentForegroundColor);
                                            }
                                            if (segment.itemExists("SEGMENT_FONT", 1, 0) && (segmentFontList = (HList)segment.getList("SEGMENT_FONT")) != null) {
                                                FontStyle segmentFont = new FontStyle();
                                                if (segmentFontList.itemExists("SIZE", 1, 0)) {
                                                    segmentFont.setSize(segmentFontList.getDouble("SIZE"));
                                                }
                                                if (segmentFontList.itemExists("STYLE", 1, 0)) {
                                                    segmentFont.setStyle((int)segmentFontList.getDouble("STYLE"));
                                                }
                                                if (segmentFontList.itemExists("WEIGHT", 1, 0)) {
                                                    segmentFont.setWeight((int)segmentFontList.getDouble("WEIGHT"));
                                                }
                                                if (segmentFontList.itemExists("WIDTH", 1, 0)) {
                                                    segmentFont.setWidth((int)segmentFontList.getDouble("WIDTH"));
                                                }
                                                if (segmentFontList.itemExists("NAME", 1, 0)) {
                                                    segmentFont.setName(segmentFontList.getString("NAME"));
                                                }
                                                rs.set("fontStyle", (Object)segmentFont);
                                            }
                                            segmentArray[j] = rs;
                                        }
                                        RangeCollection rc = new RangeCollection((RangeSegmentInterface[])segmentArray);
                                        range.setRangeSegments(rc);
                                    }
                                    rangesArray[i] = range;
                                }
                                if (rangesArray != null) {
                                    v3Imddb.setRanges(rangesArray);
                                }
                            }
                        }
                        if (addonList.itemExists("COMMANDS_MASK", 1, 0)) {
                            long CommandsMask = (long)addonList.getDouble("COMMANDS_MASK");
                            v3Imddb.setCommandsMask(CommandsMask);
                        }
                        if (addonList.itemExists("DEFAULT_ACTION_MASK", 1, 0)) {
                            this._defaultActionMask = (long)addonList.getDouble("DEFAULT_ACTION_MASK");
                        }
                        if (addonList.itemExists("COORDINATOR_ENABLED", 1, 0)) {
                            String coordinatorEnabled = addonList.getString("COORDINATOR_ENABLED");
                            this._useCoord = coordinatorEnabled.equals("Y");
                        }
                    }
                    catch (TableException tableException) {
                        // empty catch block
                    }
                }
            }
        }
        this.enableEvents();
    }

    public String getDefaultAction() {
        try {
            if (this._defaultAction == null) {
                this.setApplicationInfo();
            }
        }
        catch (TableException te) {
            this._defaultAction = RB.getStringResource("MultidimensionalTableDelegate.", "defaultAction.txt");
        }
        return this._defaultAction;
    }

    public final void setComputedValuesProperty(ComputedValueInterface[] computedValues) throws TableException {
        long inError = this.setComputedValues(computedValues);
        if (inError != 0L) {
            throw new TableException();
        }
    }

    public final void setSubsetsProperty(SubsetInterface[] subsets) throws TableException {
        long inError = this.setSubsets(subsets);
        if (inError != 0L) {
            throw new TableException();
        }
    }

    public final void setTotalsProperty(TotalInterface[] totals) throws TableException {
        long inError = this.setTotals(totals);
        if (inError != 0L) {
            throw new TableException();
        }
    }

    public long getCommandsMask() {
        return this._commandsMask;
    }

    public void setCommandsMask(long mask) {
        long oldMask = this._commandsMask;
        if (this._commandsMask != mask) {
            this._commandsMask = mask;
            if (this.anyPropertyChangeListeners()) {
                this.firePropertyChange("commandsMask", new Long(oldMask), new Long(mask));
            }
        }
    }

    public MemberInterface[] getStatistics(String measure) throws TableException {
        int i;
        if (!this._sourceSet) {
            this.synchronizeServer();
        }
        OrderedCollection sc = new OrderedCollection();
        if (this._stats == null || this._stats.count() == 0) {
            this.populateStats();
        }
        if (this._stats.containsKey((Object)measure)) {
            OrderedCollection oc = (OrderedCollection)this._stats.get((Object)measure);
            for (i = 0; i < oc.count(); ++i) {
                Statistic s = (Statistic)oc.get(i);
                sc.add((Object)s.getMember());
            }
        }
        int cnt = sc.count();
        MemberInterface[] stats = new MemberInterface[cnt];
        for (i = 0; i < cnt; ++i) {
            stats[i] = (MemberInterface)sc.get(i);
        }
        return stats;
    }

    public MemberInterface[] getSelectedStatistics(String measure) throws TableException {
        int i;
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        OrderedCollection oc = new OrderedCollection();
        OrderedCollection sc = new OrderedCollection();
        if (this._stats == null || this._stats.count() == 0) {
            this.populateStats();
        }
        String[] m = new String[]{measure};
        if (measure == null) {
            m = this.getSelectedMeasures();
        }
        for (int j = 0; j < m.length; ++j) {
            if (this._stats.containsKey((Object)m[j])) {
                oc = (OrderedCollection)this._stats.get((Object)m[j]);
            } else {
                HListInterface hlist = this._getMeasures();
                int cnt = hlist.count();
                for (int i2 = 0; i2 < cnt; ++i2) {
                    if (!hlist.getString(i2).equalsIgnoreCase(measure) || !this._stats.containsKey((Object)hlist.getName(i2))) continue;
                    oc = (OrderedCollection)this._stats.get((Object)hlist.getName(i2));
                }
            }
            for (i = 0; i < oc.count(); ++i) {
                Statistic s = (Statistic)oc.get(i);
                if (!s.isSelected() || sc.contains((Object)s)) continue;
                sc.add((Object)s);
            }
        }
        int cnt = sc.count();
        MemberInterface[] stats = new MemberInterface[cnt];
        for (i = 0; i < cnt; ++i) {
            Statistic s = (Statistic)sc.get(i);
            int index = s.getOrdinal();
            if (measure == null) {
                index = i;
            }
            stats[index] = s.getMember();
        }
        return stats;
    }

    public void setSelectedStatistics(String measure, String[] stats) throws TableException {
        if (!this._sourceSet) {
            this.synchronizeServer();
        }
        if (measure == null) {
            this.setSelectedStatistics(stats);
        } else {
            OrderedCollection oc = null;
            if (this._stats == null || this._stats.count() == 0) {
                this.populateStats();
            }
            boolean oldNeedsRefresh = this._needsRefresh;
            this._needsRefresh = false;
            MemberInterface[] oldStatMems = this.getSelectedStatistics(measure);
            String[] oldStats = new String[oldStatMems.length];
            for (int i = 0; i < oldStatMems.length; ++i) {
                oldStats[i] = oldStatMems[i].getName();
            }
            this._needsRefresh = oldNeedsRefresh;
            if (!Util.arrayEqual((Object)oldStats, (Object)stats)) {
                int i;
                boolean b = this._stats.containsKey((Object)measure);
                if (b) {
                    oc = (OrderedCollection)this._stats.get((Object)measure);
                } else if (!b) {
                    HListInterface hlist = this._getMeasures();
                    int cnt = hlist.count();
                    for (i = 0; i < cnt; ++i) {
                        if (!hlist.getString(i).equalsIgnoreCase(measure) || !this._stats.containsKey((Object)hlist.getName(i))) continue;
                        oc = (OrderedCollection)this._stats.get((Object)hlist.getName(i));
                    }
                } else {
                    throw new TableException(Message.format((String)RB.getStringResource("MultidimensionalTableDelegate.", "invalidmeasure.ex.txt"), (Object)measure));
                }
                boolean state = false;
                if (stats == null || stats.length == 0) {
                    state = false;
                }
                for (int i2 = 0; i2 < oc.count(); ++i2) {
                    Statistic s = (Statistic)oc.get(i2);
                    s.setSelected(state);
                    s.setOrdinal(state ? i2 : -1);
                }
                if (stats != null && stats.length > 0) {
                    int ord = 0;
                    block3: for (i = 0; i < stats.length; ++i) {
                        for (int j = 0; j < oc.count(); ++j) {
                            Statistic s = (Statistic)oc.get(j);
                            if (!stats[i].equals(s.getName())) continue;
                            s.setSelected(true);
                            s.setOrdinal(ord++);
                            continue block3;
                        }
                    }
                }
                this._needsRefresh = true;
                if (this._version != 3) {
                    this._tableSet = false;
                }
                this._statistics = null;
                this._formatList = null;
                this.firePropertyChange("selectedStatistics", oldStats, stats);
            }
        }
    }

    public boolean isStatisticsPerMeasureSupported() {
        HList hl;
        if (this._statsPerMeasure == -1 && (hl = (HList)this.Imddb._getCustomizations("STATSPERMEASURE")).itemExists("STATSPERMEASURE", 1, 0)) {
            this._statsPerMeasure = (int)hl.getDouble("STATSPERMEASURE");
        }
        return this._statsPerMeasure > 0;
    }
}

