/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.Component;
import com.sas.collection.AssociationList;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.Dictionary;
import com.sas.collection.DictionaryInterface;
import com.sas.collection.OrderedCollection;
import com.sas.collection.Pair;
import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.collection.StringCollection;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListAttributes;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.mdtable.AxisChangedEvent;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelChangedEvent;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.DrillEvent;
import com.sas.mdtable.DrillListener;
import com.sas.mdtable.DrillListenerList;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.NodeInterface;
import com.sas.models.RangeSegment;
import com.sas.models.RangeSegmentInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.SparseCache;
import com.sas.models.StaticCacheInterface;
import com.sas.models.TreeInterface;
import com.sas.rmi.LocalModelInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.ComputedValueInterface;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Hierarchy;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.Range;
import com.sas.sasserver.mdtable.RangeCollection;
import com.sas.sasserver.mdtable.RangeInterface;
import com.sas.sasserver.mdtable.Statistic;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.sasserver.mdtable._rprxMultidimensionalTableInterface;
import com.sas.sasserver.mdtable.commands.ComputedValuesCommand;
import com.sas.sasserver.mdtable.commands.ExportToExcelCommand;
import com.sas.sasserver.mdtable.commands.LevelNameCommand;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.sasserver.mdtable.commands.RangeTypesCommand;
import com.sas.sasserver.mdtable.commands.ShowDetailCommand;
import com.sas.sasserver.mdtable.commands.SubsetsCommand;
import com.sas.sasserver.mdtable.commands.TotalsCommand;
import com.sas.table.FontStyle;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.Command;
import com.sas.util.CommandsInterface;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.transforms.StringToColorTransform;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MultidimensionalTableDelegate
extends Component
implements LocalModelInterface,
ContentsChangedListener,
NodeInterface {
    public MultidimensionalTableInterface Imddb;
    protected transient boolean _needsRefresh;
    private transient boolean _refreshTotals;
    private transient boolean _refreshSubsets;
    private transient boolean _refreshComputedValues;
    private transient boolean _hasDefaultTable;
    private transient boolean _inInit;
    protected transient boolean _tableSet;
    protected transient boolean _sourceSet;
    private transient boolean _setSynchDrill;
    protected transient int pendingEventGateCount;
    protected transient Axis[] _axes;
    protected transient Dimension[] _dimensions;
    protected transient int _axisCount;
    protected transient int _dimensionCount;
    protected transient int _cellCount;
    protected transient SparseCache _rawCellCache;
    protected transient SparseCache _fmtCellCache;
    protected transient int _colCount;
    protected transient int _rowCount;
    protected transient OrderedCollection _tableLevels;
    protected transient OrderedCollection _subsetLevels;
    protected transient String[] _measures;
    protected transient String[] _statistics;
    protected transient Dictionary _levelIds;
    protected transient String[] _allmeasures;
    protected transient String[] _allstats;
    protected String _applicationId;
    protected String _metabaseId;
    protected String _databaseId;
    private static String _databasePassword;
    private static String _userId;
    protected boolean _useCoord;
    protected boolean _verify;
    private static String _subsetStatement;
    protected String[] _columnAxis;
    protected String[] _rowAxis;
    protected String[] _slicerAxis;
    protected String _tableName;
    protected Dictionary _levels;
    protected OrderedCollection _rangeObjects;
    private static String LINESEPARATOR;
    protected transient int bufferSize;
    protected transient int bufferBlocks;
    protected transient String _defaultAction;
    protected transient long _defaultActionMask;
    protected long _commandsMask;
    protected transient int _isStatLabelHidden;
    protected transient AssociationList _stats;
    protected transient int _statsPerMeasure;
    protected transient boolean _firstTimeThru;
    protected transient boolean _verifyLevels;
    protected transient HListInterface _cubeDefinition;
    protected transient HListInterface _formatList;
    protected int _version;
    public static final String STYLEID = "styleId";
    protected static final String RB_KEY = "MultidimensionalTableDelegate.";
    protected transient ContentsChangedListenerList allContentsChangedListeners;
    private DrillListenerList allDrillListeners;
    private transient Dictionary _cellTypes;

    @Override
    public void _setRemoteHandle(Object o) {
        this.Imddb = (MultidimensionalTableInterface)o;
        this._version = 1;
        if (this.Imddb instanceof MultidimensionalTableV3Interface) {
            this._version = 3;
        } else if (this.Imddb instanceof MultidimensionalTableV2Interface) {
            this._version = 2;
        }
    }

    public MultidimensionalTableInterface getRemoteHandle() {
        return this.Imddb;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean attachView() {
        return true;
    }

    public void detachView() {
    }

    public synchronized void disableEvents() {
        ++this.pendingEventGateCount;
    }

    public synchronized void enableEvents() {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (this.pendingEventGateCount == 0) {
                this.fireContentsChanged();
            }
        }
    }

    private void init() {
        this.pendingEventGateCount = 0;
        this._hasDefaultTable = true;
        this._inInit = false;
        this._tableSet = false;
        this._sourceSet = false;
        this._needsRefresh = true;
        this._refreshTotals = false;
        this._refreshSubsets = false;
        this._refreshComputedValues = false;
        this._setSynchDrill = true;
        this._tableName = null;
        this._axisCount = -1;
        this._dimensionCount = -1;
        this._cellCount = -1;
        this._firstTimeThru = true;
        this._verifyLevels = false;
        this._dimensions = null;
        this._axes = null;
        this._levelIds = new Dictionary();
        this._colCount = -1;
        this._rowCount = -1;
        this._isStatLabelHidden = -1;
        this._stats = null;
        this._statsPerMeasure = -1;
        this._formatList = null;
        this._cubeDefinition = new HList();
        this._defaultActionMask = -1L;
    }

    public synchronized void setDefaultValues() {
        super.setDefaultValues();
        this.init();
        this._applicationId = null;
        this._metabaseId = null;
        this._databaseId = null;
        _databasePassword = null;
        _userId = null;
        this._useCoord = false;
        this._verify = false;
        this._columnAxis = null;
        this._rowAxis = null;
        this._slicerAxis = null;
        _subsetStatement = null;
        this._measures = null;
        this._statistics = null;
        this._subsetLevels = new OrderedCollection();
        this._tableLevels = new OrderedCollection();
        this._commandsMask = 917503L;
        this._rangeObjects = null;
        this.bufferSize = 1200;
        this.bufferBlocks = 400;
    }

    public synchronized void initialize() {
        super.initialize();
        this.addContentsChangedListener(this);
        this._inInit = false;
        try {
            if (this._applicationId != null && !this._applicationId.equals("")) {
                this._sourceSet = true;
            }
            if (this._stats == null || this._stats.count() == 0) {
                this.populateStats();
                this._needsRefresh = true;
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public synchronized void synchronizeServer() throws TableException {
        this._needsRefresh = false;
        if (!this._sourceSet) {
            if (this._applicationId != null && this._applicationId.length() != 0) {
                this.setApplication(this._applicationId);
            } else if (this._metabaseId != null && this._databaseId != null) {
                this.setSource();
                if (!(this._rowAxis != null && this._rowAxis.length != 0 || this._columnAxis != null && this._columnAxis.length != 0 || !this._hasDefaultTable)) {
                    this.setApplicationInfo();
                } else if (this._rowAxis != null && this._rowAxis.length > 0 && this._measures != null && this._measures.length > 0 && this._stats != null && this._stats.count() > 0) {
                    if (this._tableSet & this._version == 3) {
                        ((MultidimensionalTableV3Interface)this.Imddb).modifyTable();
                    } else {
                        this.initializeTable();
                    }
                } else {
                    this._needsRefresh = true;
                }
            } else {
                this._needsRefresh = true;
            }
        } else if (this._metabaseId != null && this._databaseId != null) {
            if (!(this._rowAxis != null && this._rowAxis.length != 0 || this._columnAxis != null && this._columnAxis.length != 0 || !this._hasDefaultTable)) {
                this.setApplicationInfo();
            } else if ((this._rowAxis != null && this._rowAxis.length > 0 || this._columnAxis != null && this._columnAxis.length > 0) && this._measures != null && this._measures.length > 0 && this._stats != null && this._stats.count() > 0) {
                this._needsRefresh = true;
                if (this._tableSet & this._version == 3) {
                    ((MultidimensionalTableV3Interface)this.Imddb).modifyTable();
                } else {
                    this.initializeTable();
                }
            } else {
                this._needsRefresh = true;
            }
        } else if (this._applicationId != null && this._applicationId.length() > 0) {
            this.setApplicationInfo();
        } else {
            this._needsRefresh = true;
        }
        if (this._rangeObjects == null && this._tableSet && this._sourceSet) {
            this.setRangeCollection();
        }
    }

    protected void setApplicationInfo() throws TableException {
        HList csort;
        HList csort2;
        int i;
        HList hlist = (HList)this.Imddb._getApplicationInfo();
        if (hlist == null || hlist.count() == 0) {
            this._hasDefaultTable = false;
            this._tableSet = false;
            this._needsRefresh = true;
            return;
        }
        this._tableSet = true;
        this._sourceSet = true;
        this._needsRefresh = false;
        String mId = null;
        if (hlist.itemExists("REPOSITORY", 1, 0)) {
            mId = hlist.getString("REPOSITORY");
        }
        if (mId == null) {
            mId = hlist.getString("METABASE");
        }
        String dId = hlist.getString("TABLE");
        if (mId != null && !mId.equals(this._metabaseId) || dId != null && !dId.equals(this._databaseId)) {
            this._dimensions = null;
            this._dimensionCount = -1;
            this._levels = null;
            this._cubeDefinition = new HList();
        }
        this.setMetabase(mId);
        this._needsRefresh = false;
        this.setDatabase(dId);
        this._needsRefresh = false;
        this._sourceSet = true;
        HList dims = null;
        HList sel = null;
        HList down = null;
        HList analysis = null;
        if (hlist.getAt("SELECT_L") != null) {
            sel = (HList)hlist.getList("SELECT_L");
        }
        if (sel != null) {
            this.setDefaultAction(sel);
        }
        if (hlist.getAt("DIMENSIONS_L") != null) {
            dims = (HList)hlist.getList("DIMENSIONS_L");
        }
        if (dims != null) {
            int cnt = dims.count();
            if (cnt >= 3) {
                down = (HList)dims.getList(0);
                analysis = (HList)dims.getList(cnt - 1);
            }
            if (down != null && analysis != null) {
                String[] rows = new String[down.count()];
                for (int i2 = 0; i2 < down.count(); ++i2) {
                    HList hierarch = (HList)down.getList(i2);
                    rows[i2] = hierarch.getAt("HIERARCH") != null ? hierarch.getString("HIERARCH") : hierarch.getString("VARNAME");
                }
                if (rows != null && rows.length > 0) {
                    this.setRowAxis(rows);
                } else {
                    this.setRowAxis(new String[0]);
                }
                this._needsRefresh = false;
                HList across = null;
                StringCollection columns = new StringCollection();
                for (i = 1; i < cnt - 1; ++i) {
                    across = (HList)dims.getList(i);
                    for (int j = 0; j < across.count(); ++j) {
                        HList hierarch = (HList)across.getList(j);
                        if (hierarch.getAt("HIERARCH") != null) {
                            columns.add(hierarch.getString("HIERARCH"));
                            continue;
                        }
                        columns.add(hierarch.getString("VARNAME"));
                    }
                }
                if (columns.count() > 0) {
                    this.setColumnAxis(columns.getStringItems());
                } else {
                    this.setColumnAxis(new String[0]);
                }
                this._needsRefresh = false;
                int count = analysis.count();
                String[] meas = new String[count];
                String[] stat = null;
                for (int i3 = 0; i3 < count; ++i3) {
                    HList h = (HList)analysis.getList(i3);
                    meas[i3] = ((StringItem)h.getAt("VARNAME")).getValue();
                }
                this.Imddb.disableEvents();
                if (meas != null && meas.length > 0) {
                    this.setSelectedMeasures(meas);
                }
                this._needsRefresh = false;
                this._tableSet = true;
                this._sourceSet = true;
                ListItem s = (ListItem)hlist.getAt("STATS_L");
                if (s != null) {
                    HList statsList = (HList)s.getValue();
                    int scount = statsList.count();
                    StringCollection statC = new StringCollection();
                    this._firstTimeThru = true;
                    MemberInterface[] allMeasures = this.Imddb.getMeasureMembers();
                    boolean found = false;
                    for (int i4 = 0; i4 < scount; ++i4) {
                        HListItem li = statsList.getItem(i4);
                        if (li instanceof ListItem) {
                            HListInterface hli = ((ListItem)li).getValue();
                            String measure = statsList.getName(i4);
                            found = false;
                            for (int m = 0; m < allMeasures.length && !found; ++m) {
                                if (!allMeasures[m].getName().equals(measure)) continue;
                                found = true;
                            }
                            if (!found) continue;
                            int hcnt = hli.count();
                            for (int j = 0; j < hcnt; ++j) {
                                String st = hli.getName(j);
                                if (statC.contains((Object)st)) continue;
                                statC.add(st);
                            }
                            if (!(this.Imddb instanceof MultidimensionalTableV2Interface)) continue;
                            this._needsRefresh = false;
                            ((MultidimensionalTableV2Interface)this.Imddb).setSelectedStatistics(measure, statC.toStringArray());
                            statC.removeAll();
                            continue;
                        }
                        String o = statsList.getName(i4);
                        if (!Util.unequal((Object)o, (Object)"MAXSEL") || statC.contains((Object)o)) continue;
                        statC.add(o);
                    }
                    stat = statC.toStringArray();
                }
                if (stat != null && stat.length > 0) {
                    this.setSelectedStatistics(stat);
                }
            }
        } else {
            this._tableSet = false;
            throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "missingapplinfo.ex.txt"), (Object)this._applicationId));
        }
        this.Imddb.enableEvents();
        this._needsRefresh = false;
        this._tableSet = true;
        this._sourceSet = true;
        Dictionary levels = this.getAllLevels();
        HList custom = null;
        if (hlist.getAt("CUSTOM_L") != null) {
            custom = (HList)hlist.getList("CUSTOM_L");
        }
        if (custom != null && custom.getAt("CATSORTORDER") != null && (csort2 = (HList)custom.getList("CATSORTORDER")).getAt("CUSTOM") != null) {
            HList li = (HList)csort2.getList("CUSTOM");
            if (levels != null) {
                for (i = 0; i < li.count(); ++i) {
                    if (!levels.containsKey((Object)li.getName(i))) continue;
                    Level level = (Level)levels.get((Object)li.getName(i));
                    String v = li.getString(i);
                    String sd = v.substring(0, v.indexOf(" "));
                    if (sd.equalsIgnoreCase("ascending")) {
                        level.setSortOrder(2);
                        continue;
                    }
                    if (sd.equalsIgnoreCase("descending")) {
                        level.setSortOrder(1);
                        continue;
                    }
                    if (!sd.equalsIgnoreCase("reset")) continue;
                    level.setSortOrder(3);
                }
            }
        }
        LevelInterface[] ali = ((Axis)this.getAxis(0)).getLevels();
        if (custom != null && custom.getAt("ANLSORTORDER") != null && (csort = (HList)custom.getList("ANLSORTORDER")).getAt("CUSTOM") != null) {
            HList li = (HList)csort.getList("CUSTOM");
            block8: for (int i5 = 0; i5 < li.count(); ++i5) {
                String meas = li.getName(i5);
                String v = ((HList)li.getList(i5)).getString("DIR");
                String stat = ((HList)li.getList(i5)).getString("STAT");
                int n = (int)((HList)li.getList(i5)).getDouble("N");
                String prefix = stat;
                HList tupleList = new HList();
                if (((HList)li.getList(i5)).itemExists("CLASSES", 1, 0)) {
                    tupleList = (HList)((HList)li.getList(i5)).getList("CLASSES");
                } else {
                    for (int j = ali.length - 1; j >= 0; --j) {
                        if (ali[j].getName().equals("_STATS_")) {
                            tupleList.addItem(stat, 0, ali[j].getName());
                            continue;
                        }
                        if (ali[j].getName().equals("_ANLSYS_")) {
                            tupleList.addItem(meas, 0, ali[j].getName());
                            continue;
                        }
                        tupleList.addItem("", 0, ali[j].getName());
                    }
                }
                boolean hiddenStat = false;
                if (ali[ali.length - 1].getName().equals("_ANLSYS_")) {
                    hiddenStat = true;
                    tupleList.removeAt("_STATS_");
                    prefix = meas;
                }
                if (!(this.Imddb instanceof MultidimensionalTableV2Interface)) continue;
                int index = -1;
                AxisInterface colAxis = this.getAxis(0);
                index = ((Axis)colAxis).getAxisCoordinate(HList.toStringArray((HListInterface)tupleList));
                while (index >= 0 && index < colAxis.getMagnitude()) {
                    AxisLabelInterface[] al = ((Axis)this.getAxis(0)).getLabels(index);
                    Member sortLabel = null;
                    boolean match = false;
                    for (int k = al.length - 1; k >= 0; --k) {
                        AxisLabelInterface label = al[k];
                        Level l = (Level)label.getMember().getLevel();
                        if (label != null && l.isAnalysisLevel() && !label.getName().equalsIgnoreCase(meas)) {
                            match = false;
                            break;
                        }
                        if (label != null && !l.isStatisticLevel() && !label.getLabel().equalsIgnoreCase(tupleList.getString(k))) {
                            match = false;
                            break;
                        }
                        match = true;
                    }
                    if (match) {
                        if (hiddenStat) {
                            int cnt = tupleList.count();
                            String[] labels = new String[cnt];
                            for (int jj = cnt - 1; jj >= 0; --jj) {
                                labels[jj] = tupleList.getString(jj);
                            }
                            Axis oa = (Axis)this.Imddb.getAxis(0);
                            String[] newLabels = new String[labels.length - 1];
                            System.arraycopy(labels, 0, newLabels, 0, newLabels.length);
                            int axisCoordinate = oa.getAxisCoordinate(newLabels);
                            AxisLabelInterface[] colLabels = oa.getLabels(axisCoordinate);
                            sortLabel = new Member(this.Imddb);
                            sortLabel.setDelegate(MDCommand.getHiddenStatMember(this.Imddb));
                            sortLabel.setParent((ParentNode)((Object)colLabels[colLabels.length - 1]));
                            sortLabel.setOrdinal(colLabels.length);
                        } else {
                            sortLabel = (Member)al[al.length - 1];
                        }
                        if (n > 0) {
                            sortLabel.setTopBottomN(n);
                        }
                        if (v.equalsIgnoreCase("ascending")) {
                            sortLabel.setSortOrder(2);
                            continue block8;
                        }
                        if (v.equalsIgnoreCase("descending")) {
                            sortLabel.setSortOrder(1);
                            continue block8;
                        }
                        if (!v.equalsIgnoreCase("reset")) continue block8;
                        sortLabel.setSortOrder(3);
                        continue block8;
                    }
                    index = ((MultidimensionalTableV2Interface)this.Imddb).findNextAxisLabel(0, (HListInterface)tupleList, prefix, true, index + 1);
                }
            }
        }
    }

    protected void setDefaultAction(HList sel) {
        HList anywhere;
        HList doubleClick;
        if (sel != null && sel.getAt("DOUBLE") != null && (doubleClick = (HList)sel.getList("DOUBLE")) != null && doubleClick.getAt("_ANYWHERE_") != null && (anywhere = (HList)doubleClick.getList("_ANYWHERE_")) != null) {
            this._defaultAction = anywhere.getString("WHAT");
        }
        if (this._defaultAction == null || this._defaultAction.equals("_DRILLDOWN_")) {
            this._defaultAction = "Drilldown";
            this._defaultActionMask = 256L;
        } else if (this._defaultAction.equals("_NAVIGATE_UP_")) {
            this._defaultAction = "Up";
            this._defaultActionMask = 4096L;
        } else if (this._defaultAction.equals("_NAVIGATE_DOWN_")) {
            this._defaultAction = "Down";
            this._defaultActionMask = 128L;
        } else if (this._defaultAction.equals("_EXPAND_VALUE_")) {
            this._defaultAction = "Expand";
            this._defaultActionMask = 512L;
        } else if (this._defaultAction.equals("_COLLAPSE_VALUE_")) {
            this._defaultAction = "Collapse";
            this._defaultActionMask = 64L;
        } else if (this._defaultAction.equals("_NAVIGATE_LEFT_")) {
            this._defaultAction = "Left";
            this._defaultActionMask = 1024L;
        } else if (this._defaultAction.equals("_NAVIGATE_RIGHT_")) {
            this._defaultAction = "Right";
            this._defaultActionMask = 2048L;
        } else if (this._defaultAction.equals("_COMPUTED_VALUES_")) {
            this._defaultAction = "Computed Values...";
            this._defaultActionMask = 2L;
        } else if (this._defaultAction.equals("_SELECT_SUBSET_")) {
            this._defaultAction = "Subsets...";
            this._defaultActionMask = 8L;
        } else if (this._defaultAction.equals("_REACHTHRU_")) {
            this._defaultAction = "Show Detail Data...";
            this._defaultActionMask = 1L;
        } else {
            this._defaultAction = "NOT_SUPPORTED";
            this._defaultActionMask = 0L;
        }
    }

    public synchronized LevelInterface[] getIndependentLevels() throws TableException {
        HListInterface hlist = this._getIndependentLevels();
        int count = hlist.count();
        LevelInterface[] li = new LevelInterface[count];
        int i = 0;
        while (i < count) {
            String name = hlist.getName(i);
            String label = hlist.getString(i);
            if (name == null || name.equals("")) {
                name = label;
            }
            Level l = new Level(null, name, label, this.Imddb);
            li[i++] = l;
        }
        return li;
    }

    public synchronized void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public synchronized void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        if (this.allContentsChangedListeners != null && this.allContentsChangedListeners.count() > 0) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
        this.firePropertyChange((PropertyChangeEvent)event);
    }

    protected synchronized void fireContentsChanged() {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        this.fireContentsChanged(new ContentsChangedEvent((Object)this.Imddb));
    }

    public void firePropertyChange(String prop, Object oldv, Object newv) {
        MultidimensionalTableInterface ci;
        if (this.pendingEventGateCount <= 0 && (ci = this.Imddb) != null) {
            ci.firePropertyChange(prop, oldv, newv);
        }
    }

    public void contentsChanged(ContentsChangedEvent ce) {
    }

    public void addDrillListener(DrillListener listener) {
        if (this.allDrillListeners == null) {
            this.allDrillListeners = new DrillListenerList();
        }
        this.allDrillListeners.add(listener);
    }

    public void removeDrillListener(DrillListener listener) {
        if (this.allDrillListeners != null) {
            this.allDrillListeners.remove(listener);
        }
    }

    protected void notifyDrill(DrillEvent event) {
        if (this.allDrillListeners == null || this.allDrillListeners.count() == 0) {
            return;
        }
        for (DrillListener listener : this.allDrillListeners.getListeners()) {
            listener.drill(event);
        }
    }

    public synchronized ComputedValueInterface[] getComputedValues() throws TableException {
        if (this._tableSet) {
            this._refreshComputedValues = true;
        }
        Dictionary levels = this.getAllLevels();
        Enumeration enumer = levels.getItems();
        ComputedValueInterface[] computedValues = new ComputedValueInterface[levels.count()];
        int i = 0;
        while (enumer.hasMoreElements()) {
            Level level = (Level)enumer.nextElement();
            computedValues[i++] = level;
        }
        this._refreshComputedValues = false;
        return computedValues;
    }

    public long setComputedValue(String label, String level, Object[] expression) throws TableException {
        OrderedCollection oc = null;
        HList hlexp = new HList();
        Dictionary levels = this.getAllLevels();
        Level l = null;
        if (this._version == 3) {
            l = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(level);
        } else if (levels.containsKey((Object)level)) {
            l = (Level)levels.get((Object)level);
        }
        if (l != null) {
            if (expression != null && expression.length >= 1 && expression[0] != "" && expression[0] != null) {
                oc = new OrderedCollection();
                for (int i = 0; i < expression.length; ++i) {
                    String nm = null;
                    String lb = null;
                    if (expression[i] instanceof MemberInterface) {
                        MemberInterface m = (MemberInterface)expression[i];
                        nm = m.getName();
                        lb = m.getLabel();
                        oc.add((Object)m);
                    } else if (expression[i] instanceof String && ((String)expression[i]).startsWith("FORMAT=")) {
                        String f = ((String)expression[i]).substring(7);
                        nm = "VARFMT";
                        lb = f.indexOf(".") == -1 && f.length() > 0 ? f + "." : f;
                        oc.add((Object)f);
                    } else {
                        lb = (String)expression[i];
                        oc.add((Object)lb);
                    }
                    hlexp.addItem(lb, i, nm);
                }
            }
        } else {
            throw new TableException(RB.getStringResource(RB_KEY, "invalidlevel.ex.txt"));
        }
        long inError = this.Imddb._setComputedValue(label, level, (HListInterface)hlexp);
        if (inError != 0L) {
            throw new TableException(this.getMessage());
        }
        Axis axis = null;
        ExtendedNodeInterface p = l.getRootParent();
        if (p instanceof Axis) {
            axis = (Axis)p;
        }
        try {
            l.clearCache();
            Level cube = (Level)l.getDelegate();
            if (cube != null) {
                cube.clearCache();
            }
        }
        catch (CacheException ce) {
            ce.printStackTrace();
        }
        AssociationList asl = l.getComputedValues();
        if (asl == null) {
            asl = new AssociationList();
        }
        asl.set((Object)label, (Object)oc);
        l.setComputedValues(asl);
        if (level.equals("_ANLSYS_")) {
            this._allmeasures = null;
        }
        if (axis != null) {
            this.refreshTable(axis, null);
        } else {
            this.refreshTable();
        }
        return inError;
    }

    public synchronized long setComputedValues() throws TableException {
        Dictionary levels = this.getAllLevels();
        Enumeration enumer = levels.getItems();
        OrderedCollection computedValues = new OrderedCollection();
        Level level = null;
        int i = 0;
        while (enumer.hasMoreElements()) {
            level = (Level)enumer.nextElement();
            if (!level.computedValueNeedsRefresh()) continue;
            computedValues.add((Object)level);
        }
        ComputedValueInterface[] cv = new ComputedValueInterface[computedValues.count()];
        while (i < computedValues.count()) {
            cv[i] = (ComputedValueInterface)computedValues.get(i);
            ++i;
        }
        return this.setComputedValues(cv);
    }

    public synchronized long setComputedValues(ComputedValueInterface[] computedValues) throws TableException {
        long inError = 0L;
        OrderedCollection clr = new OrderedCollection();
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (computedValues == null) {
            return inError;
        }
        if (this._tableSet) {
            for (int i = 0; i < computedValues.length; ++i) {
                if (computedValues[i] == null || !((Level)computedValues[i]).computedValueNeedsRefresh()) continue;
                clr.add((Object)computedValues[i]);
            }
            HListInterface list = this.computedValueToHList(computedValues);
            if (list.count() > 0) {
                inError = this.Imddb._setComputedValues(list);
                if (inError != 0L) {
                    throw new TableException(this.getMessage());
                }
                for (int i = 0; i < clr.count(); ++i) {
                    Level cube = (Level)((Level)clr.get(i)).getDelegate();
                    if (cube == null) continue;
                    cube.reset();
                }
            }
            this.refreshTable();
        } else {
            Level level = null;
            Dictionary levels = this.getAllLevels();
            this._needsRefresh = true;
            this._refreshComputedValues = true;
            for (int i = 0; i < computedValues.length; ++i) {
                if (computedValues[i] == null) continue;
                if (this._version == 3) {
                    level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(computedValues[i].getName());
                } else if (levels.containsKey((Object)computedValues[i].getName())) {
                    level = (Level)levels.get((Object)computedValues[i].getName());
                } else if (!this._sourceSet) {
                    level = new Level(null, computedValues[i].getName(), null, this.Imddb);
                    levels.set((Object)computedValues[i].getName(), (Object)level);
                    this._verifyLevels = true;
                } else {
                    level = null;
                }
                if (level == null) continue;
                level.setComputedValues(computedValues[i].getComputedValues());
                level.setComputedValueNeedsRefresh(true);
            }
        }
        this.firePropertyChange("computedValues", null, computedValues);
        return inError;
    }

    private HListInterface computedValueToHList(ComputedValueInterface[] computedValues) throws TableException {
        HList cvList = new HList();
        cvList.setAttribute(HListAttributes.HONORCASE, true);
        if (computedValues != null) {
            Dictionary levels = this.getAllLevels();
            Level level = null;
            for (int i = 0; i < computedValues.length; ++i) {
                HList info = new HList();
                if (computedValues[i] == null) continue;
                if (this._version == 3) {
                    level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(computedValues[i].getName());
                } else if (levels.containsKey((Object)computedValues[i].getName())) {
                    level = (Level)levels.get((Object)computedValues[i].getName());
                }
                if (level == null) continue;
                if (level != computedValues[i]) {
                    if (computedValues[i] instanceof Level && !((Level)computedValues[i]).computedValueNeedsRefresh()) {
                        level.setComputedValueNeedsRefresh(false);
                        continue;
                    }
                } else if (!level.computedValueNeedsRefresh()) continue;
                level.setComputedValueNeedsRefresh(false);
                AssociationList asl = level.getComputedValues(true);
                boolean removeCV = false;
                if (asl != null) {
                    Enumeration enumer = asl.getKeys();
                    while (enumer.hasMoreElements()) {
                        String label = (String)enumer.nextElement();
                        Object item = asl.get((Object)label);
                        HList hlexp = new HList();
                        if (item != null && item instanceof OrderedCollection) {
                            OrderedCollection oc = (OrderedCollection)item;
                            int cnt = oc.count();
                            for (int j = 0; j < cnt; ++j) {
                                String nm = null;
                                String lb = null;
                                if (oc.get(j) instanceof MemberInterface) {
                                    MemberInterface m = (MemberInterface)oc.get(j);
                                    nm = m.getName();
                                    lb = m.getLabel();
                                } else if (oc.get(j) instanceof String && ((String)oc.get(j)).startsWith("FORMAT=")) {
                                    String f = ((String)oc.get(j)).substring(7);
                                    nm = "VARFMT";
                                    lb = f.indexOf(".") == -1 && f.length() > 0 ? f + "." : f;
                                } else {
                                    lb = (String)oc.get(j);
                                }
                                hlexp.addItem(lb, j, nm);
                            }
                        } else {
                            removeCV = true;
                        }
                        HList list1 = new HList();
                        list1.addItem(label, list1.count(), "LABEL");
                        list1.addItem((HListInterface)hlexp, list1.count(), "EXPRESSION");
                        info.addItem((HListInterface)list1, info.count(), label);
                    }
                }
                if (removeCV) {
                    level._computedValues.removeAll(null);
                }
                cvList.addItem((HListInterface)info, cvList.count(), computedValues[i].getName());
            }
        }
        return cvList;
    }

    public synchronized TotalInterface[] getTotals() throws TableException {
        Dictionary levels;
        if (this._tableSet) {
            this._refreshTotals = true;
        }
        if ((levels = this.getAllLevels()) == null) {
            return new TotalInterface[0];
        }
        Enumeration enumer = levels.getItems();
        OrderedCollection temp = new OrderedCollection();
        int i = 0;
        while (enumer.hasMoreElements()) {
            Level level = (Level)enumer.nextElement();
            if (level.getDimension() != null && ((Dimension)level.getDimension()).getType() == 1) continue;
            temp.add((Object)level);
        }
        int count = temp.count();
        TotalInterface[] totals = new TotalInterface[count];
        for (i = 0; i < count; ++i) {
            totals[i] = (TotalInterface)temp.get(i);
        }
        this._refreshTotals = false;
        return totals;
    }

    public synchronized long setTotals() throws TableException {
        Dictionary levels = this.getAllLevels();
        Enumeration enumer = levels.getItems();
        TotalInterface[] totals = new TotalInterface[levels.count()];
        Level level = null;
        int i = 0;
        while (enumer.hasMoreElements()) {
            level = (Level)enumer.nextElement();
            if (!level.totalNeedsRefresh()) continue;
            totals[i++] = level;
        }
        return this.setTotals(totals);
    }

    public synchronized long setTotals(TotalInterface[] totals) throws TableException {
        long inError = 0L;
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (this._tableSet) {
            HListInterface totalsList = this.totalToHList(totals);
            if (totalsList.count() > 0) {
                inError = this.Imddb._setTotals(totalsList);
                if (inError != 0L) {
                    throw new TableException(this.getMessage());
                }
                this._refreshTotals = false;
                this.getSubsets();
                this.refreshTable();
            }
        } else {
            Dictionary levels = this.getAllLevels();
            Level level = null;
            this._needsRefresh = true;
            this._refreshTotals = true;
            for (int i = 0; i < totals.length; ++i) {
                if (totals[i] == null) continue;
                if (this._version == 3) {
                    level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(totals[i].getName());
                } else if (levels.containsKey((Object)totals[i].getName())) {
                    level = (Level)levels.get((Object)totals[i].getName());
                }
                if (level == null && !this._sourceSet) {
                    level = new Level(null, totals[i].getName(), null, this.Imddb);
                    levels.set((Object)totals[i].getName(), (Object)level);
                    this._verifyLevels = true;
                }
                if (level == null) continue;
                level.setTotalLabel(totals[i].getTotalLabel());
                level.setTotalState(totals[i].getTotalState());
                level.setTotalEnabled(totals[i].isTotalEnabled());
                if (totals[i] instanceof Level) {
                    level.setTotalLabelStyle(((Level)totals[i]).getTotalLabelStyle());
                    level.setTotalCellStyle(((Level)totals[i]).getTotalCellStyle());
                }
                level.setTotalNeedsRefresh(true);
            }
        }
        this.firePropertyChange("totals", null, totals);
        return inError;
    }

    private HListInterface totalToHList(TotalInterface[] totals) throws TableException {
        HList totalsList = new HList();
        totalsList.setAttribute(HListAttributes.HONORCASE, true);
        if (totals != null) {
            Dictionary levels = this.getAllLevels();
            double state = -1.0;
            Level level = null;
            for (int i = 0; i < totals.length; ++i) {
                if (totals[i] == null) continue;
                if (this._version == 3) {
                    level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(totals[i].getName());
                } else if (levels.containsKey((Object)totals[i].getName())) {
                    level = (Level)levels.get((Object)totals[i].getName());
                }
                if (level == null) continue;
                HList info = new HList();
                if (level != totals[i]) {
                    level.setTotalLabel(totals[i].getTotalLabel());
                    level.setTotalState(totals[i].getTotalState());
                    if (totals[i] instanceof Level) {
                        level.setTotalLabelStyle(((Level)totals[i]).getTotalLabelStyle());
                        level.setTotalCellStyle(((Level)totals[i]).getTotalCellStyle());
                    }
                    if (totals[i] instanceof Level && !((Level)totals[i]).totalNeedsRefresh()) {
                        level.setTotalNeedsRefresh(false);
                        continue;
                    }
                } else if (!level.totalNeedsRefresh()) continue;
                level.setTotalNeedsRefresh(false);
                info.addItem(totals[i].getTotalLabel(), 0, "LABEL");
                state = totals[i].getTotalState() ? 1.0 : 0.0;
                info.addItem(state, 1, "STATE");
                totalsList.addItem((HListInterface)info, totalsList.count(), totals[i].getName());
            }
        }
        return totalsList;
    }

    public synchronized OrderedCollection getTableLevels() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        this._tableLevels = new OrderedCollection();
        int axisCount = this.getAxisCount();
        for (int j = 0; j < axisCount; ++j) {
            DimensionInterface[] d = this.getAxis(j).getDimensions(0, -1);
            for (int i = 0; i < d.length; ++i) {
                if (((Dimension)d[i]).getType() == 1) continue;
                LevelInterface[] l = d[i].getLevels(0, -1);
                for (int k = 0; k < l.length; ++k) {
                    this._tableLevels.add((Object)l[k]);
                }
            }
        }
        return this._tableLevels;
    }

    public synchronized OrderedCollection getSubsetLevels() throws TableException {
        if (this._subsetLevels == null) {
            this._subsetLevels = new OrderedCollection();
        } else {
            this._subsetLevels.removeAll();
        }
        Dictionary al = this.getAllLevels();
        Enumeration enumer = al.getItems();
        OrderedCollection tl = this.getTableLevels();
        LevelInterface l = null;
        while (enumer.hasMoreElements()) {
            l = (LevelInterface)enumer.nextElement();
            if (tl.contains((Object)l)) continue;
            this._subsetLevels.add((Object)l);
        }
        return this._subsetLevels;
    }

    public synchronized String getFormattedCell(int ordinal) throws TableException {
        try {
            if (this._fmtCellCache == null) {
                this._fmtCellCache = new SparseCache((StaticCacheInterface)new CellReader(true), null, this.bufferSize, this.bufferBlocks);
            }
            return (String)this._fmtCellCache.getFromCache((long)ordinal);
        }
        catch (CacheException ce) {
            throw new TableException((Exception)((Object)ce));
        }
    }

    public synchronized String[] getFormattedCells(int startOrdinal, int endOrdinal) throws TableException {
        if (startOrdinal == endOrdinal) {
            String[] fmtCell = new String[]{this.getFormattedCell(startOrdinal)};
            return fmtCell;
        }
        try {
            if (this._fmtCellCache == null) {
                this._fmtCellCache = new SparseCache((StaticCacheInterface)new CellReader(true), null, this.bufferSize, this.bufferBlocks);
            }
            Object[] cells = this._fmtCellCache.getFromCache((long)startOrdinal, (long)endOrdinal, false);
            String[] fmtCell = new String[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                fmtCell[i] = (String)cells[i];
            }
            return fmtCell;
        }
        catch (CacheException ce) {
            throw new TableException((Exception)((Object)ce));
        }
    }

    public synchronized TreeInterface getDependentLabels(int axis) throws TableException {
        return this.getDependentLabels(axis, 0, -1, "");
    }

    public synchronized TreeInterface getDependentLabels(int axis, int start, int count) throws TableException {
        return this.getDependentLabels(axis, start, count, "");
    }

    public synchronized TreeInterface getDependentLabels(int axis, int start, int count, String dimension) throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        Object label = null;
        int axisCount = this.getAxisCount();
        if (axisCount <= axis) {
            return null;
        }
        Axis axisNode = (Axis)this.getAxis(axis);
        Level parent = (Level)axisNode.getRoot();
        if (dimension != null || !dimension.equals(null) || !dimension.equals("")) {
            parent.setLabel(dimension);
        }
        Level root = parent;
        return root;
    }

    public synchronized int[] getAxisCoordinates(int cellOrdinal) throws TableException {
        int[] coords;
        block4: {
            if (this._needsRefresh) {
                this.synchronizeServer();
            }
            try {
                coords = new int[this.getAxisCount()];
                int colCount = this.getAxis(0).getMagnitude();
                if (colCount <= 0) break block4;
                coords[1] = cellOrdinal / colCount;
                coords[0] = cellOrdinal - coords[1] * colCount;
            }
            catch (TableException te) {
                coords = new int[2];
                for (int i = 0; i < coords.length; ++i) {
                    coords[i] = -1;
                }
            }
        }
        return coords;
    }

    public synchronized int getCellOrdinal(int[] coords) throws TableException {
        int ordinal = -1;
        try {
            int row = coords[1];
            int col = coords[0];
            int colCount = this.getAxis(0).getMagnitude();
            ordinal = row * colCount + col;
        }
        catch (TableException te) {
            return ordinal;
        }
        return ordinal;
    }

    public synchronized int getPointCount(int axis) throws TableException {
        int count;
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        int n = count = axis == 0 ? this._colCount : this._rowCount;
        if (count == -1) {
            count = this.Imddb._getPointCount(axis);
            if (axis == 0) {
                this._colCount = count;
            } else {
                this._rowCount = count;
            }
        }
        return count;
    }

    public synchronized String[] getLabels(String level) throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        Object[] _members = null;
        OrderedCollection oc = null;
        if (this._levelIds.contains((Object)level)) {
            oc = (OrderedCollection)this._levelIds.get((Object)level);
            Enumeration enumer = oc.getItems();
            int i = 0;
            _members = new String[oc.count()];
            while (enumer.hasMoreElements()) {
                _members[i++] = (String)enumer.nextElement();
            }
        } else {
            HListInterface hlist = this.Imddb._getMembers(level, this._tableSet ? "Y" : "N", 0, -1);
            _members = new String[hlist.count()];
            for (int i = 0; i < hlist.count(); ++i) {
                _members[i] = hlist.getString(i);
            }
            oc = new OrderedCollection(_members);
            this._levelIds.set((Object)level, (Object)oc);
        }
        return _members;
    }

    public synchronized void setSource() throws TableException {
        this.setSource(this._metabaseId, this._databaseId, this._useCoord);
    }

    public synchronized void setSource(String metaName, String dataName) throws TableException {
        this.setSource(metaName, dataName, this._useCoord);
    }

    public synchronized void setSource(String metaName, String dataName, boolean useCoord) throws TableException {
        long inError = 0L;
        if (this._sourceSet && metaName.equals(this._metabaseId) && dataName.equals(this._databaseId) && useCoord == this._useCoord) {
            return;
        }
        String oldmd = this._metabaseId;
        String olddb = this._databaseId;
        this._metabaseId = metaName;
        this._databaseId = dataName;
        this._useCoord = useCoord;
        if (this._metabaseId != null && this._databaseId != null) {
            String useCoordStr = null;
            useCoordStr = this._useCoord ? "Y" : "N";
            inError = this.Imddb._setSource(this._metabaseId, this._databaseId, useCoordStr);
            if (inError != 0L) {
                throw new TableException(this.getMessage());
            }
        } else {
            throw new TableException();
        }
        this._levels = null;
        this._cubeDefinition = new HList();
        this._tableSet = false;
        this._sourceSet = true;
        this._dimensions = null;
        this._dimensionCount = -1;
        this._defaultActionMask = -1L;
        this._stats = null;
        this._firstTimeThru = true;
        this._formatList = null;
        this.refreshTable();
        this.firePropertyChange("measures", null, null);
        this.firePropertyChange("statistics", null, null);
        this.firePropertyChange("dimensions", null, null);
        if (Util.unequal((Object)oldmd, (Object)this._metabaseId)) {
            this.firePropertyChange("metabase", null, null);
        }
        if (Util.unequal((Object)olddb, (Object)this._databaseId)) {
            this.firePropertyChange("database", null, null);
        }
    }

    public synchronized void initializeTable() throws TableException {
        if (!this._inInit) {
            this._applicationId = null;
            String[][] axes = new String[2][];
            if (this._measures == null || this._measures.length == 0) {
                throw new TableException(RB.getStringResource(RB_KEY, "measure.ex.txt"));
            }
            if (this._rowAxis == null || this._rowAxis.length == 0) {
                throw new TableException(RB.getStringResource(RB_KEY, "rowaxis.ex.txt"));
            }
            axes[0] = this._columnAxis;
            axes[1] = this._rowAxis;
            this._inInit = true;
            if (this.Imddb instanceof MultidimensionalTableV2Interface && ((MultidimensionalTableV2Interface)this.Imddb).isStatisticsPerMeasureSupported()) {
                this._needsRefresh = false;
                this.initializeTable(axes, this._slicerAxis, this._measures, null, null, null);
            } else {
                this._needsRefresh = false;
                this.initializeTable(axes, this._slicerAxis, this._measures, this.getSelectedStatistics(), null, null);
            }
            this._inInit = false;
        }
    }

    public synchronized void initializeTable(String[][] axisDimensions, String[] slicerDimensions, String[] measures, String[] stats) throws TableException {
        this.initializeTable(axisDimensions, slicerDimensions, measures, stats, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void initializeTable(String[][] axisDimensions, String[] slicerDimensions, String[] measures, String[] stats, SubsetInterface[] where, TotalInterface[] totaledLevels) throws TableException {
        if (!this._sourceSet) {
            this.setSource();
        }
        HList axesList = new HList();
        if (measures == null || measures.length < 1 || measures.length == 1 && (measures[0] == null || measures[0].equals(""))) {
            this._inInit = false;
            throw new TableException(RB.getStringResource(RB_KEY, "measure.ex.txt"));
        }
        if (axisDimensions == null || axisDimensions.length < 2 || axisDimensions[1] == null || axisDimensions[1].length < 1) {
            this._inInit = false;
            throw new TableException(RB.getStringResource(RB_KEY, "rowaxis.ex.txt"));
        }
        for (int i = 0; i < axisDimensions.length; ++i) {
            HList dims = new HList();
            for (int j = 0; axisDimensions[i] != null && j < axisDimensions[i].length; ++j) {
                StringItem dimId = new StringItem(axisDimensions[i][j]);
                dims.add((Object)dimId);
            }
            axesList.add((Object)new ListItem((HListInterface)dims));
        }
        this._needsRefresh = false;
        boolean updatedWhere = false;
        if (where == null) {
            where = this.getSubsets();
            for (int i = 0; i < where.length; ++i) {
                if (((Level)where[i]).subsetNeedsRefresh() || where[i].getSubset() == null) continue;
                ((Level)where[i]).setSubsetNeedsRefresh(true);
            }
            updatedWhere = true;
        }
        if (totaledLevels == null) {
            totaledLevels = this.getTotals();
            for (int i = 0; i < totaledLevels.length; ++i) {
                if (((Level)totaledLevels[i]).totalNeedsRefresh() || !totaledLevels[i].getTotalState() && (totaledLevels[i].getTotalLabel() == null || totaledLevels[i].getTotalLabel().equals(((Level)totaledLevels[i]).getLabel()))) continue;
                ((Level)totaledLevels[i]).setTotalNeedsRefresh(true);
            }
        }
        HListInterface whereList = this.subsetToHList(where);
        if (!updatedWhere) {
            SubsetInterface[] levelWhere = this.getSubsets();
            String levelName = null;
            for (int i = 0; i < levelWhere.length; ++i) {
                Object[] subValues = levelWhere[i].getSubset();
                if (subValues == null || ((HList)whereList).itemExists(levelName = ((Level)levelWhere[i]).getName(), 1, 0)) continue;
                HList info = new HList();
                int k = 0;
                for (int j = 0; subValues != null && j < subValues.length; ++j) {
                    if (subValues[j] == null) continue;
                    info.addItem((String)subValues[j], k++, null);
                }
                whereList.addItem((HListInterface)info, whereList.count(), levelName);
            }
        }
        HListInterface totaledList = this.totalToHList(totaledLevels);
        this.setColumnAxis(axisDimensions[0]);
        this.setRowAxis(axisDimensions[1]);
        this.setSlicerAxis(slicerDimensions);
        this.setSelectedMeasures(measures);
        String[] statNames = null;
        String[] measureNames = null;
        if (stats != null) {
            this.setSelectedStatistics(stats);
            this._needsRefresh = false;
            measureNames = this.transformLabelsToNames(this.getMeasureMembers(), measures);
            statNames = this.transformLabelsToNames(this.getStatisticMembers(), stats);
        }
        long inError = 0L;
        if (this.Imddb instanceof MultidimensionalTableV2Interface && ((MultidimensionalTableV2Interface)this.Imddb).isStatisticsPerMeasureSupported()) {
            HListInterface measureStats = this.statsToHList(this._stats);
            if (measureStats.count() <= 0) {
                this._axisCount = -1;
                this.refreshTable();
                this._inInit = false;
                this._tableSet = false;
                throw new TableException(RB.getStringResource(RB_KEY, "statistic.ex.txt"));
            }
            inError = ((MultidimensionalTableV2Interface)this.Imddb)._initializeMeasureStatTable((HListInterface)axesList, slicerDimensions, measureStats, whereList, totaledList);
        } else if (statNames != null && statNames.length > 0) {
            inError = this.Imddb._initializeTable((HListInterface)axesList, slicerDimensions, measureNames, statNames, whereList, totaledList);
        } else {
            this._axisCount = -1;
            this.refreshTable();
            this._inInit = false;
            this._tableSet = false;
            throw new TableException(RB.getStringResource(RB_KEY, "statistic.ex.txt"));
        }
        this._tableSet = true;
        this._applicationId = null;
        if (inError != 0L) {
            this._axisCount = -1;
            this.refreshTable();
            this._inInit = false;
            this._tableSet = false;
            throw new TableException(this.getMessage());
        }
        Dictionary levels = this.getAllLevels();
        Enumeration enumer = levels.getItems();
        while (enumer.hasMoreElements()) {
            Level l = (Level)enumer.nextElement();
            if (l.getComputedValues() != null) {
                l.setComputedValueNeedsRefresh(true);
            }
            if (l.getDrillSubset() != null) {
                l.setDrillSubset(null);
                l.setDrillSubsetNeedsRefresh(false);
            }
            if (l.getSubset() == null) continue;
            l.setSubsetNeedsRefresh(true);
        }
        this.setComputedValues();
        if (this._version == 3) {
            ((MultidimensionalTableV3Interface)this.Imddb).setSortOrders();
        }
        this.setRangeCollection();
        if (axesList.count() != this._axisCount) {
            this._axisCount = axesList.count();
        }
        this.refreshTable();
    }

    protected HListInterface statsToHList(AssociationList statistics) {
        HList statsList = new HList();
        statsList.setAttribute(HListAttributes.HONORCASE, true);
        try {
            NodeInterface[] measureMembers = this.getMeasureMembers();
            String[] measureLabels = this.getSelectedMeasures();
            String[] measureNames = this.transformLabelsToNames(measureMembers, measureLabels);
            if (statistics != null) {
                for (int i = 0; i < measureNames.length; ++i) {
                    String m = measureNames[i];
                    if (!statistics.containsKey((Object)m)) continue;
                    OrderedCollection oc = (OrderedCollection)statistics.get((Object)m);
                    HList hl = new HList();
                    for (int j = 0; j < oc.count(); ++j) {
                        Statistic s = (Statistic)oc.get(j);
                        if (!s.isSelected()) continue;
                        int ord = s.getOrdinal();
                        while (ord >= hl.count()) {
                            hl.add((Object)new StringItem());
                        }
                        hl.setItem(ord, s.getLabel());
                        hl.setName(s.getName(), ord);
                    }
                    if (hl.count() <= 0) continue;
                    statsList.addItem((HListInterface)hl, -1, m);
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return statsList;
    }

    public String[] transformLabelsToNames(NodeInterface[] nodes, String[] labels) {
        if (labels == null || nodes == null) {
            return new String[0];
        }
        StringCollection snc = new StringCollection();
        boolean found = false;
        for (int j = 0; j < labels.length; ++j) {
            int i;
            found = false;
            for (i = 0; i < nodes.length; ++i) {
                if (!labels[j].equalsIgnoreCase(nodes[i].getNodeExpandedText())) continue;
                snc.add(nodes[i].getNodeText());
                found = true;
                break;
            }
            if (found) continue;
            for (i = 0; i < nodes.length; ++i) {
                if (!labels[j].equalsIgnoreCase(nodes[i].getNodeText())) continue;
                snc.add(nodes[i].getNodeText());
                found = true;
                break;
            }
            if (found) continue;
            snc.add(labels[j]);
        }
        return snc.toStringArray();
    }

    public String[] transformNamesToLabels(NodeInterface[] nodes, String[] names) {
        if (names == null || nodes == null) {
            return new String[0];
        }
        StringCollection snc = new StringCollection();
        boolean found = false;
        for (int j = 0; j < names.length; ++j) {
            int i;
            found = false;
            for (i = 0; i < nodes.length; ++i) {
                if (!names[j].equalsIgnoreCase(nodes[i].getNodeText())) continue;
                snc.add(nodes[i].getNodeExpandedText());
                found = true;
                break;
            }
            if (found) continue;
            for (i = 0; i < nodes.length; ++i) {
                if (!names[j].equalsIgnoreCase(nodes[i].getNodeExpandedText())) continue;
                snc.add(nodes[i].getNodeExpandedText());
                found = true;
                break;
            }
            if (found) continue;
            snc.add(names[j]);
        }
        return snc.toStringArray();
    }

    private String[] getStatisticNames(String[] stats) throws TableException {
        int i;
        int j;
        if (stats == null) {
            return new String[0];
        }
        StringCollection snc = new StringCollection();
        MemberInterface[] sm = this.getStatisticMembers();
        if (stats == null || sm == null) {
            return new String[0];
        }
        boolean found = false;
        block0: for (j = 0; j < stats.length; ++j) {
            found = false;
            for (i = 0; i < sm.length; ++i) {
                if (!stats[j].equalsIgnoreCase(sm[i].getLabel())) continue;
                snc.add(sm[i].getName());
                found = true;
                continue block0;
            }
        }
        if (!found) {
            block2: for (j = 0; j < stats.length; ++j) {
                for (i = 0; i < sm.length; ++i) {
                    if (!stats[j].equalsIgnoreCase(sm[i].getName())) continue;
                    snc.add(sm[i].getName());
                    continue block2;
                }
            }
        }
        return snc.toStringArray();
    }

    public synchronized Dictionary getAllLevels() throws TableException {
        HList subhl;
        int i;
        int count;
        boolean needsUpdate;
        if (this._levels == null) {
            this._levels = new Dictionary();
        }
        if (this.Imddb == null) {
            return this._levels;
        }
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (!this._sourceSet) {
            return this._levels;
        }
        boolean _applyServerSort = false;
        if (!this._firstTimeThru && this._verifyLevels) {
            Enumeration enum1 = this._levels.getItems();
            while (enum1.hasMoreElements()) {
                Level l = (Level)enum1.nextElement();
                if (l.getDimension() != null) continue;
                this._levels.remove((Object)l);
            }
            this._verifyLevels = false;
        }
        if (this._firstTimeThru) {
            _applyServerSort = true;
            this._refreshTotals = true;
            this._refreshComputedValues = true;
            this._refreshSubsets = true;
            this._firstTimeThru = false;
        }
        boolean bl = needsUpdate = this._axisCount <= 0;
        if (!needsUpdate) {
            for (int i2 = 0; i2 < this._axisCount; ++i2) {
                if (this.getAxis(i2).getNodeChildCount() >= 0) continue;
                needsUpdate = true;
                break;
            }
        }
        if (this._tableSet && needsUpdate && (count = this.getAxisCount()) > 0) {
            AxisInterface[] axes = this.getAxes(0, count);
            for (int a = 0; a < axes.length; ++a) {
                if (axes[a].getNodeChildCount() > 0 || (count = axes[a].getDimensionCount()) <= 0) continue;
                DimensionInterface[] dims = axes[a].getDimensions(0, count);
                for (int d = 0; d < dims.length; ++d) {
                    count = dims[d].getHierarchyCount();
                    if (count <= 0) continue;
                    HierarchyInterface[] hiers = dims[d].getHierarchies(0, count);
                    for (int h = 0; h < hiers.length; ++h) {
                        LevelInterface[] levelInterfaceArray = hiers[h].getLevels(0, -1);
                    }
                }
            }
        }
        HList hlist = null;
        Level l = null;
        if (this._refreshTotals) {
            double dbl = 0.0;
            int count2 = 0;
            hlist = (HList)this.Imddb._getAllLevels();
            for (int i3 = 0; i3 < hlist.count(); ++i3) {
                String s;
                int index;
                HList hl = (HList)hlist.getList(i3);
                if (hl.getItem("CATEGORY") != null) {
                    String name = hlist.getName(i3);
                    if (name == null || name.equals("")) {
                        name = hl.getString("VARLABEL");
                    }
                    if (this._levels == null) {
                        this._levels = new Dictionary();
                    }
                    if (this._levels.containsKey((Object)name)) {
                        l = (Level)this._levels.get((Object)name);
                        if (l.getLabel() == null) {
                            l.setLabel(hl.getString("VARLABEL"));
                        }
                        if (l.getDelegate() == null) {
                            l.setDelegate((ExtendedNodeInterface)((Object)this.findCubeLevel(name)));
                        }
                        if (l.totalNeedsRefresh()) {
                            continue;
                        }
                    } else {
                        l = new Level(null, name, hl.getString("VARLABEL"), this.Imddb);
                        l.setDelegate((ExtendedNodeInterface)((Object)this.findCubeLevel(name)));
                        this._levels.set((Object)l.getName(), (Object)l);
                    }
                    if (hl.getItem("TOTALS") != null) {
                        HList totalhl = (HList)hl.getList("TOTALS");
                        if (totalhl != null && totalhl.count() > 0) {
                            dbl = totalhl.getItem("TOTALON") != null ? totalhl.getDouble("TOTALON") : 0.0;
                            l.setTotalLabel(totalhl.getString("LABEL"));
                        }
                    } else {
                        dbl = 0.0;
                    }
                    l.setTotalState(dbl == 1.0);
                    if (hl.getItem("TOTALACL") != null) {
                        dbl = hl.getDouble("TOTALACL");
                        if (dbl == 1.0) {
                            l.setTotalEnabled(false);
                            ++count2;
                        } else {
                            l.setTotalEnabled(true);
                        }
                    } else {
                        l.setTotalEnabled(true);
                    }
                    l.setTotalNeedsRefresh(false);
                }
                if (!_applyServerSort || hl.getItem("SORT") == null || l == null || l.isAnalysisLevel() || (index = (s = hl.getString("SORT")).indexOf(" ")) < 0) continue;
                s = s.substring(0, s.indexOf(" "));
                this._refreshTotals = false;
                l.setSortDirection(s);
            }
            if (this._version == 2 && count2 == hlist.count() - 2) {
                MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
                this._commandsMask &= 4L ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this._refreshTotals = false;
            if (this._levels.count() > hlist.count()) {
                Enumeration enumer = this._levels.getItems();
                while (enumer.hasMoreElements()) {
                    Dimension d;
                    l = (Level)enumer.nextElement();
                    if (l.getDelegate() == null) {
                        l.setDelegate((ExtendedNodeInterface)((Object)this.findCubeLevel(l.getName())));
                    }
                    if ((d = (Dimension)l.getDimension()) != null && d.getType() == 1 || hlist.find(l.getName(), 1, 0) >= 0) continue;
                    this._levels.removeAt((Object)l.getName());
                }
            }
        }
        if (this._refreshSubsets && this._tableSet) {
            this._refreshSubsets = false;
            hlist = (HList)this.Imddb._getSubsets();
            for (i = 0; i < hlist.count(); ++i) {
                subhl = (HList)hlist.getList(i);
                Object[] subValues = new String[subhl.count()];
                StringCollection drillSubCollection = new StringCollection();
                String name = hlist.getName(i);
                if (this._levels.containsKey((Object)name)) {
                    l = (Level)this._levels.get((Object)name);
                    if (l.getLabel() == null) {
                        l.setLabel(hlist.getString("VARLABEL"));
                    }
                    if (l.getDelegate() == null) {
                        l.setDelegate((ExtendedNodeInterface)((Object)this.findCubeLevel(name)));
                    }
                    if (l.subsetNeedsRefresh()) {
                        continue;
                    }
                } else {
                    try {
                        ExtendedNodeInterface ie = (ExtendedNodeInterface)((Object)this.findCubeLevel(name));
                        l = new Level(null, name, null, this.Imddb);
                        l.setDelegate(ie);
                        this._levels.set((Object)l.getName(), (Object)l);
                    }
                    catch (TableException ie) {
                        // empty catch block
                    }
                }
                int cnt = subhl.count();
                OrderedCollection oc = new OrderedCollection();
                if (cnt > 0) {
                    for (int j = 0; j < cnt; ++j) {
                        String isDrill = subhl.getName(j);
                        if (isDrill == null) {
                            Object[] od = l.getDrillSubset();
                            if (od != null) {
                                l.setDrillSubset(null);
                            }
                            subValues[j] = subhl.getString(j);
                            continue;
                        }
                        drillSubCollection.add(subhl.getString(j));
                    }
                } else if (l.getDrillSubset() != null) {
                    if (!l._isDown) {
                        l.setDrillSubsetNeedsRefresh(true);
                        l.setDrillSubset(null);
                    }
                    if (l.getSubset() != null) {
                        l.setSubsetNeedsRefresh(true);
                        oc.add((Object)l);
                    }
                } else if (l.getSubset() != null) {
                    l.setSubset(null);
                    l.setSubsetNeedsRefresh(false);
                }
                if (oc.count() > 0) {
                    SubsetInterface[] si = new SubsetInterface[oc.count()];
                    for (int n = 0; n < si.length; ++n) {
                        si[n] = (SubsetInterface)oc.get(n);
                    }
                    boolean oldSetSynchDrill = this._setSynchDrill;
                    this._setSynchDrill = false;
                    this.setSubsets(si);
                    this._setSynchDrill = oldSetSynchDrill;
                }
                if (drillSubCollection.count() > 0) {
                    l.setDrillSubset(drillSubCollection.toStringArray());
                    l.setDrillSubsetNeedsRefresh(false);
                    continue;
                }
                if (subValues == null || subValues.length <= 0) continue;
                l.setSubset(subValues);
                l.setSubsetNeedsRefresh(false);
            }
        }
        if (this._refreshComputedValues && this._tableSet) {
            this._refreshComputedValues = false;
            hlist = (HList)this.Imddb._getComputedValues();
            for (i = 0; i < hlist.count(); ++i) {
                subhl = (HList)hlist.getList(i);
                String name = hlist.getName(i);
                if (this._levels.containsKey((Object)name)) {
                    l = (Level)this._levels.get((Object)name);
                    if (l.getDelegate() == null) {
                        l.setDelegate((ExtendedNodeInterface)((Object)this.findCubeLevel(name)));
                    }
                    if (l.computedValueNeedsRefresh()) {
                        continue;
                    }
                } else {
                    l = new Level(null, name, null, this.Imddb);
                    l.setDelegate((ExtendedNodeInterface)((Object)this.findCubeLevel(name)));
                    this._levels.set((Object)l.getName(), (Object)l);
                }
                AssociationList compValues = new AssociationList();
                for (int j = 0; j < subhl.count(); ++j) {
                    HList compList;
                    int fcnt;
                    HList list = (HList)subhl.getList(j);
                    String origin = list.getString("ORIGIN");
                    if (origin != null) {
                        origin = Strings.removeWhitespace((String)origin);
                    }
                    if (origin != null && origin.equalsIgnoreCase("compcol")) continue;
                    String label = list.getString("LABEL");
                    String format = null;
                    if (list.itemExists("VARFMT", 1, 0)) {
                        format = list.getString("VARFMT");
                    }
                    if ((fcnt = (compList = (HList)list.getList("COMPUTED")).count()) <= 0) continue;
                    OrderedCollection oc = new OrderedCollection(fcnt);
                    MemberInterface[] members = null;
                    int memCount = -1;
                    if (name != null && name.equals("_ANLSYS_")) {
                        members = this.getMeasureMembers();
                        memCount = members.length;
                    } else {
                        memCount = l.getMemberCount();
                    }
                    for (int k = 0; k < fcnt; ++k) {
                        HList cl = (HList)compList.getList(k);
                        double type = cl.getDouble("VARIABLE");
                        Object item = cl.getString("NAME");
                        if (type == 1.0) {
                            for (int k1 = 0; k1 < memCount; ++k1) {
                                if (name.equals("_ANLSYS_")) {
                                    if (!item.equals(members[k1].getName())) continue;
                                    item = members[k1];
                                    break;
                                }
                                MemberInterface mem = l.getMember(k1);
                                if (!item.equals(mem.getLabel())) continue;
                                item = mem;
                                break;
                            }
                        }
                        oc.add(item);
                    }
                    if (format != null) {
                        oc.add((Object)("FORMAT=" + format));
                    }
                    compValues.set((Object)label, (Object)oc);
                }
                l.setComputedValues(compValues);
                l.setComputedValueNeedsRefresh(false);
            }
        }
        return this._levels;
    }

    public synchronized LevelInterface findCubeLevel(String name) throws TableException {
        Level l = null;
        DimensionInterface[] dims = this.getDimensions(0, -1);
        boolean found = false;
        for (int d = 0; d < dims.length && !found; ++d) {
            HierarchyInterface[] hiers = dims[d].getHierarchies(0, -1);
            for (int h = 0; h < hiers.length && !found; ++h) {
                LevelInterface[] levels = hiers[h].getLevels(0, -1);
                for (int v = 0; v < levels.length && !found; ++v) {
                    if (!levels[v].getName().equals(name) && !levels[v].getLabel().equals(name)) continue;
                    l = (Level)levels[v];
                    found = true;
                }
            }
        }
        if (!found) {
            throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "levelNeedsDelegate.ex.txt"), (Object)name));
        }
        return l;
    }

    public void subsetTable(SubsetInterface[] subsets) throws TableException {
        this.setSubsets(subsets);
    }

    public void subsetTable() throws TableException {
        this.setSubsets();
    }

    private void synchDrillSubsets(SubsetInterface[] subsets) {
        try {
            if (subsets != null) {
                Dictionary levels = this.getAllLevels();
                Level level = null;
                for (int i = 0; i < subsets.length; ++i) {
                    Object[] subValues;
                    if (subsets[i] == null) continue;
                    if (this._version == 3) {
                        level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(subsets[i].getName());
                    } else if (levels.containsKey((Object)subsets[i].getName())) {
                        level = (Level)levels.get((Object)subsets[i].getName());
                    }
                    if (level == null) continue;
                    AssociationList asl = new AssociationList();
                    if (subsets[i] != level) {
                        level.setDrillSubset(subsets[i].getDrillSubset());
                        if (subsets[i] instanceof Level && !((Level)subsets[i]).drillSubsetNeedsRefresh()) {
                            level.setDrillSubsetNeedsRefresh(false);
                            continue;
                        }
                    } else if (level._isDown) continue;
                    level.setDrillSubsetNeedsRefresh(false);
                    if (((Dimension)level.getDimension()).getType() == 1 || (subValues = subsets[i].getDrillSubset()) == null) continue;
                    String levelName = subsets[i].getName();
                    for (int j = 0; j < subValues.length; ++j) {
                        asl.set((Object)levelName, (Object)((String)subValues[j]));
                    }
                    Axis axis = null;
                    ExtendedNodeInterface p = level.getRootParent();
                    if (p instanceof Axis) {
                        axis = (Axis)p;
                        MDCommand command = new MDCommand(axis, "Drilldown", asl);
                        command.performAction();
                        continue;
                    }
                    throw new TableException();
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public long setSubsets(SubsetInterface[] subsets) throws TableException {
        long inError;
        block12: {
            block11: {
                HListInterface whereList;
                inError = 0L;
                if (this._needsRefresh) {
                    this.synchronizeServer();
                }
                if (!this._tableSet) break block11;
                if (this._setSynchDrill) {
                    this.synchDrillSubsets(subsets);
                    this._setSynchDrill = false;
                }
                if ((whereList = this.subsetToHList(subsets)).count() <= 0) break block12;
                inError = this.Imddb._subsetTable(whereList);
                if (inError != 0L) {
                    throw new TableException(this.getMessage());
                }
                Axis a = (Axis)this.getAxis(0);
                AxisLabelInterface al = null;
                if (a != null) {
                    al = a.getSortIdentifier();
                }
                this.refreshTable();
                if (al == null || a == null) break block12;
                a.setSortIdentifier(al);
                break block12;
            }
            Dictionary levels = this.getAllLevels();
            Level level = null;
            this._needsRefresh = true;
            this._refreshSubsets = true;
            if (subsets != null) {
                for (int i = 0; i < subsets.length; ++i) {
                    if (subsets[i] == null) continue;
                    if (this._version == 3) {
                        level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(subsets[i].getName());
                    } else if (levels.containsKey((Object)subsets[i].getName())) {
                        level = (Level)levels.get((Object)subsets[i].getName());
                    } else if (!this._sourceSet) {
                        level = new Level(null, subsets[i].getName(), null, this.Imddb);
                        levels.set((Object)subsets[i].getName(), (Object)level);
                        this._verifyLevels = true;
                    }
                    if (level == null) continue;
                    level.setSubset(subsets[i].getSubset());
                    level.setSubsetNeedsRefresh(true);
                    Object[] si = subsets[i].getDrillSubset();
                    if (si == null) continue;
                    level.setDrillSubset(si);
                    level.setDrillSubsetNeedsRefresh(true);
                }
            }
        }
        this.firePropertyChange("subsets", null, subsets);
        return inError;
    }

    private HListInterface subsetToHList(SubsetInterface[] subsets) throws TableException {
        HList whereList = new HList();
        whereList.setAttribute(HListAttributes.HONORCASE, true);
        if (subsets != null) {
            Dictionary levels = this.getAllLevels();
            Level level = null;
            for (int i = 0; i < subsets.length; ++i) {
                if (subsets[i] == null) continue;
                if (this._version == 3) {
                    level = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(subsets[i].getName());
                } else if (levels.containsKey((Object)subsets[i].getName())) {
                    level = (Level)levels.get((Object)subsets[i].getName());
                }
                if (level == null) continue;
                HList info = new HList();
                if (subsets[i] != level) {
                    level.setSubset(subsets[i].getSubset());
                    if (!level.subsetNeedsRefresh()) continue;
                    if (subsets[i] instanceof Level && !((Level)subsets[i]).subsetNeedsRefresh()) {
                        level.setSubsetNeedsRefresh(false);
                        continue;
                    }
                } else if (!level.subsetNeedsRefresh()) continue;
                level.setSubsetNeedsRefresh(false);
                if (((Dimension)level.getDimension()).getType() == 1) continue;
                Object[] subValues = subsets[i].getSubset();
                int k = 0;
                for (int j = 0; subValues != null && j < subValues.length; ++j) {
                    if (subValues[j] == null) continue;
                    info.addItem((String)subValues[j], k++, null);
                }
                whereList.addItem((HListInterface)info, whereList.count(), subsets[i].getName());
            }
        }
        return whereList;
    }

    public long setSubsets() throws TableException {
        Dictionary levels = this.getAllLevels();
        Enumeration enumer = levels.getItems();
        SubsetInterface[] subsets = new SubsetInterface[levels.count()];
        Level level = null;
        int i = 0;
        while (enumer.hasMoreElements()) {
            level = (Level)enumer.nextElement();
            if (!level.subsetNeedsRefresh() && !level.drillSubsetNeedsRefresh()) continue;
            subsets[i++] = level;
        }
        return this.setSubsets(subsets);
    }

    public SubsetInterface[] getSubsets() throws TableException {
        Dictionary levels;
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (this._tableSet) {
            this._refreshSubsets = true;
        }
        if ((levels = this.getAllLevels()) == null) {
            return new SubsetInterface[0];
        }
        Enumeration enumer = levels.getItems();
        OrderedCollection temp = new OrderedCollection();
        int i = 0;
        while (enumer.hasMoreElements()) {
            Level level = (Level)enumer.nextElement();
            if (level.getDimension() != null && ((Dimension)level.getDimension()).getType() == 1) continue;
            temp.add((Object)level);
        }
        int count = temp.count();
        SubsetInterface[] subsets = new SubsetInterface[count];
        for (i = 0; i < count; ++i) {
            subsets[i] = (SubsetInterface)temp.get(i);
        }
        this._refreshSubsets = false;
        return subsets;
    }

    public synchronized void setMetabase(String metabaseId) throws TableException {
        if (!MultidimensionalTableDelegate.stringsEqual(this._metabaseId, metabaseId)) {
            String old = this._metabaseId;
            this._needsRefresh = true;
            this._tableSet = false;
            this._sourceSet = false;
            this._metabaseId = metabaseId;
            this.firePropertyChange("metabase", old, this._metabaseId);
        }
    }

    public synchronized void setDatabase(String databaseId) throws TableException {
        if (!MultidimensionalTableDelegate.stringsEqual(this._databaseId, databaseId)) {
            String old = this._databaseId;
            this._needsRefresh = true;
            this._tableSet = false;
            this._sourceSet = false;
            this._databaseId = databaseId;
            this.firePropertyChange("database", old, this._databaseId);
        }
    }

    public synchronized void setCoordinatorEnabled(boolean useCoord) {
        if (this._useCoord != useCoord) {
            boolean old = this._useCoord;
            this._useCoord = useCoord;
            HList optlist = new HList();
            boolean enabled = useCoord;
            optlist.addItem((double)enabled, 0, "MDCoord");
            this.Imddb._setOptions((HListInterface)optlist);
            this.firePropertyChange("coordinatorEnabled", new Boolean(old), new Boolean(this._useCoord));
        }
    }

    public synchronized void setVerifyEnabled(boolean verify) {
        if (this._verify != verify) {
            boolean old = this._verify;
            this._verify = verify;
            HList optlist = new HList();
            boolean enabled = verify;
            optlist.addItem((double)enabled, 0, "MDVerify");
            this.Imddb._setOptions((HListInterface)optlist);
            this.firePropertyChange("verifyEnabled", new Boolean(old), new Boolean(this._verify));
        }
    }

    public synchronized boolean isVerifyEnabled() {
        return this._verify;
    }

    public synchronized void setColumnAxis(String[] dimensionIds) throws TableException {
        if (!Util.arrayEqual((Object)this._columnAxis, (Object)dimensionIds)) {
            String[] old = this._columnAxis;
            this._columnAxis = dimensionIds;
            this._needsRefresh = true;
            if (this._version != 3) {
                this._tableSet = false;
            }
            this.firePropertyChange("columnAxis", old, this._columnAxis);
        }
    }

    public synchronized void setRowAxis(String[] dimensionIds) throws TableException {
        if (!Util.arrayEqual((Object)this._rowAxis, (Object)dimensionIds)) {
            String[] old = this._rowAxis;
            this._rowAxis = dimensionIds;
            this._needsRefresh = true;
            if (this._version != 3) {
                this._tableSet = false;
            }
            this.firePropertyChange("rowAxis", old, this._rowAxis);
        }
    }

    public synchronized void setSlicerAxis(String[] dimensionIds) throws TableException {
        if (!Util.arrayEqual((Object)this._slicerAxis, (Object)dimensionIds)) {
            String[] old = this._slicerAxis;
            this._slicerAxis = dimensionIds;
            this._needsRefresh = true;
            if (this._version != 3) {
                this._tableSet = false;
            }
            this.firePropertyChange("slicerAxis", old, this._slicerAxis);
        }
    }

    public synchronized void setSelectedMeasures(String[] measures) throws TableException {
        try {
            if (measures != null && measures.length > 0 && !Util.arrayEqual((Object)this._measures, (Object)measures)) {
                String[] old = this._measures;
                this._needsRefresh = false;
                String[] oldStats = this.getSelectedStatistics();
                this._measures = measures;
                this._statistics = null;
                this._formatList = null;
                String[] newStats = this.getSelectedStatistics();
                this._needsRefresh = true;
                if (this._version != 3) {
                    this._tableSet = false;
                }
                this.firePropertyChange("selectedMeasures", old, this._measures);
                this.firePropertyChange("selectedStatistics", oldStats, newStats);
            }
        }
        catch (TableException te) {
            this._needsRefresh = true;
        }
    }

    public synchronized void setSelectedStatistics(String[] stats) throws TableException {
        try {
            boolean saveRefresh = this._needsRefresh;
            this._needsRefresh = false;
            if (this._statistics == null) {
                this.getSelectedStatistics();
            }
            if (!Util.arrayEqual((Object)this._statistics, (Object)stats)) {
                String[] old = this._statistics;
                this._statistics = stats;
                if (this._stats == null || this._stats.count() == 0) {
                    this.populateStats();
                }
                if (this.Imddb instanceof MultidimensionalTableV2Interface) {
                    String[] statNames = this.transformLabelsToNames(this.getStatisticMembers(), stats);
                    MultidimensionalTableV2Interface mdtv2 = (MultidimensionalTableV2Interface)this.Imddb;
                    for (int i = 0; this._stats != null && i < this._stats.count(); ++i) {
                        String measure = (String)this._stats.getKey(i);
                        this._needsRefresh = false;
                        mdtv2.setSelectedStatistics(measure, statNames);
                    }
                }
                this._formatList = null;
                this._needsRefresh = true;
                if (this._version != 3) {
                    this._tableSet = false;
                }
                this.firePropertyChange("selectedStatistics", old, this._statistics);
            } else {
                this._needsRefresh = saveRefresh;
            }
        }
        catch (TableException te) {
            te.printStackTrace();
        }
    }

    public synchronized String getMetabase() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._metabaseId;
    }

    public synchronized String getDatabase() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._databaseId;
    }

    public synchronized boolean isCoordinatorEnabled() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._useCoord;
    }

    public synchronized String[] getColumnAxis() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._columnAxis;
    }

    public synchronized String[] getRowAxis() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._rowAxis;
    }

    public synchronized String[] getSlicerAxis() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._slicerAxis;
    }

    public synchronized String[] getSelectedMeasures() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._measures;
    }

    public synchronized String[] getSelectedStatistics() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (this._statistics == null && this._stats != null) {
            String[] selectedMeasures = this.getSelectedMeasures();
            String[] names = this.transformLabelsToNames(this.getMeasureMembers(), selectedMeasures);
            StringCollection sc = new StringCollection();
            for (int i = 0; i < names.length; ++i) {
                if (!this._stats.containsKey((Object)names[i])) continue;
                OrderedCollection oc = (OrderedCollection)this._stats.get((Object)names[i]);
                OrderedCollection selected = new OrderedCollection();
                for (int j = 0; j < oc.count(); ++j) {
                    Statistic s = (Statistic)oc.get(j);
                    if (!s.isSelected()) continue;
                    selected.add((Object)s);
                }
                int cnt = selected.count();
                String[] stats = new String[cnt];
                for (int k = 0; k < cnt; ++k) {
                    Statistic s = (Statistic)selected.get(k);
                    stats[s.getOrdinal()] = s.getMember().getName();
                }
                for (int l = 0; l < stats.length; ++l) {
                    if (sc.contains((Object)stats[l])) continue;
                    sc.add(stats[l]);
                }
            }
            this._statistics = sc.toStringArray();
        }
        if (this._statistics == null) {
            this._statistics = new String[0];
        }
        return this._statistics;
    }

    public synchronized void reset() {
        this._axisCount = -1;
        this._colCount = -1;
        this._rowCount = -1;
        this._cubeDefinition = new HList();
        if (this._axes != null) {
            for (int i = 0; i < this._axes.length; ++i) {
                if (this._axes[i] == null) continue;
                this._axes[i].reset();
            }
        }
        this._levelIds = new Dictionary();
        this.clearCache();
    }

    public synchronized void reset(Axis a) {
        this._colCount = -1;
        this._rowCount = -1;
        if (a == null && this._axes != null) {
            for (int i = 0; i < this._axes.length; ++i) {
                if (this._axes[i] == null) continue;
                this._axes[i].reset();
            }
        } else if (a != null) {
            a.reset();
        }
        this._levelIds = new Dictionary();
        this.clearCache(a);
    }

    private synchronized void clearCache() {
        this._cellCount = -1;
        if (this._fmtCellCache != null) {
            this._fmtCellCache.invalidateCache();
        }
        if (this._rawCellCache != null) {
            this._rawCellCache.invalidateCache();
        }
        if (this._levels != null) {
            Enumeration enumer = this._levels.getItems();
            while (enumer.hasMoreElements()) {
                Level level = (Level)enumer.nextElement();
                try {
                    level.clearCache();
                    level.setParent(null);
                }
                catch (CacheException ce) {
                    ce.printStackTrace();
                }
            }
        }
    }

    private synchronized void clearCache(Axis a) {
        this._cellCount = -1;
        if (this._fmtCellCache != null) {
            this._fmtCellCache.invalidateCache();
        }
        if (this._rawCellCache != null) {
            this._rawCellCache.invalidateCache();
        }
        if (this._levels != null) {
            Enumeration enumer = this._levels.getItems();
            while (enumer.hasMoreElements()) {
                Level level = (Level)enumer.nextElement();
                boolean clearall = false;
                if (a != null) {
                    ExtendedNodeInterface rootParent = level.getRootParent();
                    if (rootParent instanceof Dimension || rootParent instanceof Axis && rootParent.equals(a)) {
                        clearall = true;
                    }
                } else if (a == null) {
                    clearall = true;
                }
                if (!clearall) continue;
                try {
                    level.clearCache();
                }
                catch (CacheException ce) {
                    ce.printStackTrace();
                }
            }
        }
    }

    public void refreshTable() {
        this._axisCount = -1;
        this.reset();
        this.fireContentsChanged(new ContentsChangedEvent((Object)this.Imddb));
    }

    public void refreshTable(Axis a, AxisLabelInterface focusLabel) {
        this.refreshTable(a, focusLabel, true);
    }

    public void refreshTable(Axis a, AxisLabelInterface focusLabel, boolean needsReset) {
        if (needsReset) {
            this.reset(a);
        }
        try {
            this.getAllLevels();
        }
        catch (TableException tableException) {
            // empty catch block
        }
        this.fireContentsChanged(new AxisChangedEvent(this.Imddb, a, focusLabel));
    }

    public void refreshTable(AxisLabelInterface focusLabel, int how) {
        if (focusLabel instanceof Member) {
            LevelInterface l = ((Member)focusLabel).getLevel();
            if (l != null) {
                Dimension d = (Dimension)l.getDimension();
                ((Axis)d.getAxis()).reset(false);
                d.reset(false);
                this._cellCount = -1;
                if (this._fmtCellCache != null) {
                    this._fmtCellCache.invalidateCache();
                }
                if (this._rawCellCache != null) {
                    this._rawCellCache.invalidateCache();
                }
                this._rowCount = -1;
                ParentNode el = null;
                Hierarchy h = (Hierarchy)((Level)l).getParent();
                int count = h.countNodeChildren(0);
                int i = 0;
                for (i = 0; i < count && !h.getNodeChild(i).equals((Object)l); ++i) {
                }
                if (how == 2) {
                    for (int j = i + 1; j < count; ++j) {
                        el = (Level)h.getNodeChild(j);
                        if (el == null) continue;
                        try {
                            el.clearCache();
                            continue;
                        }
                        catch (CacheException cacheException) {
                            // empty catch block
                        }
                    }
                } else {
                    if (i < count - 1) {
                        el = (Level)h.getNodeChild(i + 1);
                    }
                    if (el != null) {
                        try {
                            el.clearCache();
                        }
                        catch (CacheException cacheException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (how == 2) {
                ((Member)focusLabel).reset();
            }
        }
        this.fireContentsChanged(new AxisLabelChangedEvent(this.Imddb, focusLabel, how));
    }

    public void refreshTable(int d, MemberInterface member, MemberInterface toMember) {
        this.notifyDrill(new DrillEvent(this.Imddb, d, member, toMember));
    }

    public synchronized void addRange(MemberInterface measure, MemberInterface statistic, RangeCollection range) throws TableException {
        try {
            if (this._rangeObjects == null) {
                this.setRangeCollection();
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        RangeInterface r = null;
        boolean found = false;
        int cnt = this._rangeObjects.count();
        for (int i = 0; i < cnt; ++i) {
            r = (RangeInterface)this._rangeObjects.get(i);
            if (!r.getMeasure().equals(measure) || !r.getStatistic().equals(statistic)) continue;
            found = true;
            break;
        }
        if (found) {
            RangeCollection rc = r.getRangeSegments();
            int cnt2 = range.getSegmentCount();
            for (int i = 0; i < cnt2; ++i) {
                rc.addSegment(range.getSegment(i));
            }
        } else {
            this._rangeObjects.add((Object)new Range(measure, statistic, range));
        }
    }

    public synchronized void setRanges(RangeInterface[] ranges) throws TableException {
        OrderedCollection oldRanges = this._rangeObjects;
        if (ranges != null) {
            if (this._rangeObjects == null) {
                this._rangeObjects = new OrderedCollection();
            } else {
                this._rangeObjects.removeAll();
            }
            for (int i = 0; i < ranges.length; ++i) {
                this._rangeObjects.add((Object)ranges[i]);
            }
        } else {
            this._rangeObjects = null;
        }
        this.firePropertyChange("cellTypes", null, null);
        this.firePropertyChange("ranges", null, this._rangeObjects);
        this.fireContentsChanged(new ContentsChangedEvent((Object)this.Imddb));
    }

    public synchronized RangeInterface[] getRanges() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        RangeInterface[] ri = null;
        if (this._rangeObjects != null) {
            int cnt = this._rangeObjects.count();
            ri = new RangeInterface[cnt];
            for (int i = 0; i < cnt; ++i) {
                ri[i] = (RangeInterface)this._rangeObjects.get(i);
            }
        }
        return ri;
    }

    public RangeInterface[] getRanges(String type) throws TableException {
        return new RangeInterface[0];
    }

    public synchronized RangeCollection getRange(MemberInterface measure, MemberInterface statistic) throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        try {
            int cnt = this._rangeObjects.count();
            int i = 0;
            while (i < cnt) {
                RangeInterface r;
                if ((r = (RangeInterface)this._rangeObjects.get(i++)) == null) continue;
                MemberInterface m = r.getMeasure();
                MemberInterface s = r.getStatistic();
                if (Util.equal((Object)m, (Object)measure)) {
                    if (!Util.equal((Object)s, (Object)statistic)) continue;
                    return r.getRangeSegments();
                }
                if (!(m != null & measure != null) || !measure.getName().startsWith("CV") || !m.getLabel().equals(measure.getLabel()) || !Util.equal((Object)s, (Object)statistic)) continue;
                r.setMeasure(measure);
                return r.getRangeSegments();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void setRangeCollection() throws TableException {
        if (this._rangeObjects == null) {
            this._rangeObjects = new OrderedCollection();
        }
        HList rangeList = (HList)this.Imddb._getRanges();
        String measureName = null;
        String statName = null;
        int count = 0;
        if (rangeList != null) {
            count = rangeList.count();
        }
        if (count > 0) {
            MemberInterface[] measuresArray = this.getMeasureMembers();
            MemberInterface[] statisticArray = this.getStatisticMembers();
            int i = 0;
            boolean more = true;
            while (count > 0 && i < count) {
                int k;
                StringItem statisticItem;
                RangeCollection rangeCollection = new RangeCollection();
                rangeCollection.setContiguousSegmentsRequired(false);
                rangeCollection.removeAllSegments();
                HList list = (HList)rangeList.getList(i++);
                StringItem measureItem = (StringItem)list.getAt("_ANLSYS_");
                if (measureItem != null) {
                    measureName = measureItem.getValue();
                }
                Member measure = null;
                for (int k2 = 0; k2 < measuresArray.length; ++k2) {
                    if (!measuresArray[k2].getName().equals(measureName)) continue;
                    measure = (Member)measuresArray[k2];
                    break;
                }
                if ((statisticItem = (StringItem)list.getAt("_STATS_")) != null) {
                    statName = statisticItem.getValue();
                }
                Member statistic = null;
                boolean found = false;
                for (k = 0; k < statisticArray.length; ++k) {
                    if (!statisticArray[k].getName().equals(statName)) continue;
                    statistic = (Member)statisticArray[k];
                    found = true;
                    break;
                }
                if (!found) {
                    for (k = 0; k < statisticArray.length; ++k) {
                        if (!statisticArray[k].getLabel().equals(statName)) continue;
                        statistic = (Member)statisticArray[k];
                        break;
                    }
                }
                DoubleItem minItem = null;
                DoubleItem maxItem = null;
                Color fColor = null;
                Color bColor = null;
                int j = 0;
                while (more && (minItem = (DoubleItem)list.getAt("MIN", ++j, 0)) != null) {
                    StringItem bColorItem;
                    maxItem = (DoubleItem)list.getAt("MAX", j, 0);
                    double min = minItem.isMissing() ? Double.NEGATIVE_INFINITY : minItem.getValue();
                    double max = maxItem.isMissing() ? Double.POSITIVE_INFINITY : maxItem.getValue();
                    RangeSegment rs = new RangeSegment((Number)new Double(min), (Number)new Double(max));
                    StringItem fColorItem = (StringItem)list.getAt("RGB COLORN", j, 0);
                    if (fColorItem == null || fColorItem.getValue().equals("")) {
                        fColorItem = (StringItem)list.getAt("RGB COLOR", j, 0);
                    }
                    if (fColorItem == null || fColorItem.getValue().equals("")) {
                        fColorItem = (StringItem)list.getAt("COLOR", j, 0);
                    }
                    if (fColorItem != null && (fColor = this.setColorRS(fColorItem)) != null) {
                        rs.set("foregroundColor", (Object)fColor);
                    }
                    if ((bColorItem = (StringItem)list.getAt("RGB BACKGRND COLORN", j, 0)) == null || bColorItem.getValue().equals("")) {
                        bColorItem = (StringItem)list.getAt("RGB BACKGRND COLOR", j, 0);
                    }
                    if (bColorItem != null && (bColor = this.setColorRS(bColorItem)) != null) {
                        rs.set("backgroundColor", (Object)bColor);
                    }
                    StringItem fontItem = (StringItem)list.getAt("FONT", j, 0);
                    DoubleItem fontSizeItem = (DoubleItem)list.getAt("FONT SIZEN", j, 0);
                    if (fontItem != null) {
                        StringItem fontStyleItem = (StringItem)list.getAt("FONT STYLE", j, 0);
                        Font font = this.setFontRS(fontItem, fontStyleItem, fontSizeItem);
                        FontStyle fs = new FontStyle();
                        fs.setFont(font);
                        rs.set("fontStyle", (Object)fs);
                    }
                    if (measure != null && statistic != null) {
                        String styleId = measureName + statName + j;
                        rs.set(STYLEID, (Object)styleId.intern());
                    }
                    rangeCollection.addSegment((RangeSegmentInterface)rs);
                }
                if (measure == null || statistic == null) continue;
                this.addRange(measure, statistic, rangeCollection);
            }
        }
    }

    private Color setColorRS(StringItem colorItem) {
        String sasColor = colorItem.getValue();
        if (sasColor.equalsIgnoreCase("sysback")) {
            return SystemColor.window;
        }
        if (sasColor.equalsIgnoreCase("sysfore") || sasColor.equalsIgnoreCase("foreground")) {
            return SystemColor.windowText;
        }
        if (sasColor.equalsIgnoreCase("sysecb") || sasColor.equalsIgnoreCase("background")) {
            return Color.red;
        }
        if (sasColor.equalsIgnoreCase("error")) {
            return Color.red;
        }
        if (sasColor.equalsIgnoreCase("warning")) {
            return Color.green;
        }
        try {
            Color c = (Color)StringToColorTransform.defaultInstance.transform((Object)sasColor);
            return c;
        }
        catch (IllegalArgumentException ie) {
            return null;
        }
    }

    private Font setFontRS(StringItem fontItem, StringItem fontStyle, DoubleItem fontSize) {
        String name = fontItem.getValue();
        int style = 0;
        int size = 12;
        if (fontSize != null) {
            size = (int)fontSize.getValue();
        }
        if (fontStyle != null) {
            String styleString = fontStyle.getValue();
            if (styleString.equalsIgnoreCase("BOLD")) {
                style = 1;
            } else if (styleString.equalsIgnoreCase("ITALIC")) {
                style = 2;
            } else if (styleString.startsWith("BOLDITALIC")) {
                style = 3;
            }
        }
        return new Font(name, style, size);
    }

    public synchronized String getApplication() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this._applicationId;
    }

    public synchronized void setApplication(String applicationId) throws TableException {
        if (applicationId == null && this._applicationId == null || this._applicationId == null && applicationId.length() == 0 || applicationId == null && this._applicationId.length() == 0) {
            return;
        }
        if (applicationId == this._applicationId) {
            this._tableSet = true;
            return;
        }
        String old = this._applicationId;
        if (applicationId == null || applicationId.length() == 0) {
            this._applicationId = applicationId;
            this._tableSet = false;
            this.refreshTable();
            this.firePropertyChange("application", old, this._applicationId);
            return;
        }
        int levels = 0;
        int fromIndex = 0;
        int index = 0;
        while (fromIndex >= 0) {
            index = applicationId.indexOf(".", fromIndex);
            if (index >= 0) {
                ++levels;
                fromIndex = Math.min(index + 1, applicationId.length() - 1);
                continue;
            }
            fromIndex = index;
        }
        if (levels != 3 || !applicationId.trim().toUpperCase().endsWith(RB.getStringResource(RB_KEY, "appSuffix.txt"))) {
            throw new TableException(RB.getStringResource(RB_KEY, "app.ex.txt"));
        }
        long inError = this.Imddb._setApplication(applicationId);
        if (inError == 0L) {
            this._applicationId = applicationId;
            this._needsRefresh = false;
            this._firstTimeThru = true;
            this._stats = null;
            try {
                this.setApplicationInfo();
            }
            catch (TableException te) {
                this._applicationId = old;
                te.printStackTrace();
            }
        } else {
            this._tableSet = false;
            this._needsRefresh = true;
            this._firstTimeThru = true;
            throw new TableException(this.getMessage());
        }
        this.setRangeCollection();
        this._axisCount = -1;
        this.refreshTable();
        this.firePropertyChange("application", old, this._applicationId);
        this.firePropertyChange("measures", null, null);
        this.firePropertyChange("statistics", null, null);
        this.firePropertyChange("dimensions", null, null);
    }

    public synchronized String[] getDimensions() throws TableException {
        StringCollection oc = new StringCollection();
        DimensionInterface[] dims = this.getDimensions(0, -1);
        for (int i = 0; i < dims.length; ++i) {
            if (((Dimension)dims[i]).getType() != 0) continue;
            oc.add(dims[i].getLabel());
        }
        return oc.toStringArray();
    }

    public synchronized MemberInterface[] getMeasureMembers() throws TableException {
        MemberInterface[] mi = null;
        Level l = null;
        Dictionary levels = this.getAllLevels();
        if (levels.containsKey((Object)"_ANLSYS_")) {
            l = (Level)levels.get((Object)"_ANLSYS_");
            Level cube = (Level)l.getDelegate();
            try {
                if (cube != null) {
                    mi = cube.getMembers(0, cube.getMemberCount());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (mi == null) {
            mi = new MemberInterface[]{};
        }
        return mi;
    }

    public synchronized String[] getMeasures() throws TableException {
        try {
            MemberInterface[] members = this.getMeasureMembers();
            int mcnt = members.length;
            if (mcnt > 0) {
                this._allmeasures = new String[mcnt];
            }
            for (int i = 0; i < mcnt; ++i) {
                this._allmeasures[i] = members[i].getLabel();
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return this._allmeasures;
    }

    public synchronized MemberInterface[] getStatisticMembers() throws TableException {
        Level l = null;
        Dictionary levels = this.getAllLevels();
        if (levels.containsKey((Object)"_STATS_")) {
            l = (Level)levels.get((Object)"_STATS_");
            Level cube = (Level)l.getDelegate();
            try {
                MemberInterface[] cubeMembers = cube.getMembers(0, -1);
                return cubeMembers;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        MemberInterface[] ma = new MemberInterface[]{};
        return ma;
    }

    public synchronized String[] getStatistics() throws TableException {
        try {
            MemberInterface[] stats = this.getStatisticMembers();
            int scnt = stats.length;
            if (scnt > 0) {
                this._allstats = new String[scnt];
            }
            for (int i = 0; i < scnt; ++i) {
                this._allstats[i] = stats[i].getLabel();
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return this._allstats;
    }

    protected void populateStats() throws TableException {
        if (!this._sourceSet) {
            this.setSource();
        }
        if (!this._sourceSet) {
            return;
        }
        boolean saveRefresh = this._needsRefresh;
        this._needsRefresh = false;
        try {
            if (this._stats == null) {
                this._stats = new AssociationList();
            } else {
                this._stats.removeAll();
            }
            if (this.Imddb instanceof MultidimensionalTableV2Interface) {
                HList statList = (HList)((MultidimensionalTableV2Interface)this.Imddb)._getMeasureStatistics();
                for (int i = 0; i < statList.count(); ++i) {
                    String m = statList.getName(i);
                    OrderedCollection oc = new OrderedCollection();
                    HList measList = (HList)statList.getList(i);
                    MemberInterface[] availableStats = this.getStatisticMembers();
                    int ord = 0;
                    block3: for (int j = 0; j < measList.count(); ++j) {
                        String statstr = measList.getName(j);
                        for (int k = 0; k < availableStats.length; ++k) {
                            if (!statstr.equals(availableStats[k].getName())) continue;
                            Statistic s = new Statistic(availableStats[k]);
                            s.setSelected(false);
                            s.setOrdinal(ord++);
                            oc.add((Object)s);
                            continue block3;
                        }
                    }
                    this._stats.set((Object)m, (Object)oc);
                }
            } else {
                String[] selectedMeasures = this.getMeasures();
                NodeInterface[] measureMembers = this.getMeasureMembers();
                String[] measureNames = this.transformLabelsToNames(measureMembers, selectedMeasures);
                String[] selectedStats = this.getSelectedStatistics();
                String[] statNames = this.transformLabelsToNames(this.getStatisticMembers(), selectedStats);
                MemberInterface[] availableStats = this.getStatisticMembers();
                for (int i = 0; i < measureNames.length; ++i) {
                    String m = measureNames[i];
                    OrderedCollection oc = new OrderedCollection();
                    int ord = 0;
                    block6: for (int j = 0; j < statNames.length; ++j) {
                        String statstr = statNames[j];
                        for (int k = 0; k < availableStats.length; ++k) {
                            if (!statstr.equals(availableStats[k].getName())) continue;
                            Statistic s = new Statistic(availableStats[k]);
                            s.setSelected(false);
                            s.setOrdinal(ord++);
                            oc.add((Object)s);
                            continue block6;
                        }
                    }
                    this._stats.set((Object)m, (Object)oc);
                }
            }
        }
        catch (TableException te) {
            this._needsRefresh = saveRefresh;
        }
        this._needsRefresh = saveRefresh;
    }

    public StaticPropertyBagInterface getCellStyle(int ordinal) throws TableException {
        StaticPropertyBagInterface sp = new Cell(ordinal).getData();
        PropertyBag p = new PropertyBag(sp);
        String[] types = this.getCellType(ordinal);
        for (int i = 0; types != null && i < types.length; ++i) {
            p.merge(this.getCellTypeStyle(types[i]));
        }
        return p;
    }

    public boolean isCellStylesSupported() {
        return true;
    }

    public StaticPropertyBagInterface getDefaultCellStyle() throws TableException {
        return null;
    }

    public StaticPropertyBagInterface getDefaultLabelStyle() throws TableException {
        return null;
    }

    private void _setCellTypeStyles() throws TableException {
        this._cellTypes = new Dictionary();
        if (this._rangeObjects == null) {
            this.setRangeCollection();
        }
        if (this._rangeObjects != null) {
            int cnt1 = this._rangeObjects.count();
            for (int j = 0; j < cnt1; ++j) {
                RangeInterface r = (RangeInterface)this._rangeObjects.get(j);
                if (r == null) continue;
                RangeCollection rc = r.getRangeSegments();
                int cnt = rc.getSegmentCount();
                for (int i = 0; i < cnt; ++i) {
                    RangeSegment rSeg = (RangeSegment)rc.getSegment(i);
                    Object styleID = rSeg.get(STYLEID, PropertyBag.NO_SUCH_ELEMENT);
                    if (styleID == PropertyBag.NO_SUCH_ELEMENT || !(styleID instanceof String)) continue;
                    this._cellTypes.set((Object)((String)styleID), (Object)rSeg);
                }
            }
        }
    }

    public synchronized String[] getCellType(int ordinal) throws TableException {
        this._setCellTypeStyles();
        Pair pair = this.getPair(ordinal);
        if (pair != null) {
            Member stat;
            Member measure = (Member)pair.getFirst();
            RangeCollection range = this.getRange(measure, stat = (Member)pair.getSecond());
            if (range != null && range.getSegmentCount() > 0) {
                StringCollection cellTypes = new StringCollection();
                int cnt = range.getSegmentCount();
                for (int i = 0; i < cnt; ++i) {
                    RangeSegment rSeg = (RangeSegment)range.getSegment(i);
                    Object styleID = rSeg.get(STYLEID, PropertyBag.NO_SUCH_ELEMENT);
                    if (styleID == PropertyBag.NO_SUCH_ELEMENT || !(styleID instanceof String)) continue;
                    double dMin = rSeg.getMinimumNumber().doubleValue();
                    double dMax = rSeg.getMaximumNumber().doubleValue();
                    double dVal = (Double)this.getCell(ordinal);
                    if (!(dVal >= dMin) || !(dVal <= dMax)) continue;
                    cellTypes.add(styleID);
                }
                if (cellTypes.count() > 0) {
                    return cellTypes.getStringItems();
                }
            }
            return null;
        }
        return null;
    }

    public synchronized String[] getCellTypes() throws TableException {
        this._setCellTypeStyles();
        Enumeration enumer = this._cellTypes.getKeys();
        String[] ct = new String[this._cellTypes.count()];
        int i = 0;
        while (enumer.hasMoreElements()) {
            ct[i++] = (String)enumer.nextElement();
        }
        return ct.length == 0 ? null : ct;
    }

    public synchronized StaticPropertyBagInterface[] getCellTypeStyles() throws TableException {
        this._setCellTypeStyles();
        Enumeration enumer = this._cellTypes.getItems();
        StaticPropertyBagInterface[] cs = new StaticPropertyBagInterface[this._cellTypes.count()];
        int i = 0;
        while (enumer.hasMoreElements()) {
            cs[i++] = (StaticPropertyBagInterface)enumer.nextElement();
        }
        return cs.length == 0 ? null : cs;
    }

    public StaticPropertyBagInterface getCellTypeStyle(String type) throws TableException {
        this._setCellTypeStyles();
        try {
            return (StaticPropertyBagInterface)this._cellTypes.get((Object)type);
        }
        catch (Exception e) {
            throw new TableException();
        }
    }

    private Pair getPair(int ordinal) {
        try {
            int[] coords = this.getAxisCoordinates(ordinal);
            AxisLabelInterface[] labels = this.getAxis(0).getLabels(coords[0]);
            Member measure = null;
            Member statistic = null;
            if (this.isStatLabelHidden() == 1) {
                measure = (Member)labels[labels.length - 1].getMember();
                statistic = this.getHiddenStatMember();
            } else {
                measure = (Member)labels[labels.length - 2].getMember();
                statistic = (Member)labels[labels.length - 1].getMember();
            }
            Pair pair = new Pair((Object)measure, (Object)statistic);
            return pair;
        }
        catch (Exception e) {
            return null;
        }
    }

    public NodeInterface getRoot() {
        return this;
    }

    public String getNodeExpandedText() {
        return "All Dimensions";
    }

    public String getNodeText() {
        return "All Dimensions";
    }

    public String getNodeType() {
        return "Multidimensionsal Table";
    }

    public int countNodeChildren(int maximumChildCount) {
        try {
            return this.getDimensionCount();
        }
        catch (TableException te) {
            return 0;
        }
    }

    public int getNodeChildCount() {
        try {
            return this.getDimensionCount();
        }
        catch (TableException te) {
            return -1;
        }
    }

    public boolean isLeafNode() {
        try {
            return this.getDimensionCount() == 0;
        }
        catch (TableException te) {
            return true;
        }
    }

    public SimpleNodeInterface getNodeChild(int index) {
        try {
            return this.getDimension(index);
        }
        catch (TableException te) {
            return null;
        }
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        try {
            return this.getDimensions(startIndex, count);
        }
        catch (TableException te) {
            te.printStackTrace();
            return null;
        }
    }

    public synchronized String getTableLabel() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (this._tableName == null || this._tableName.equals(null)) {
            this._tableName = this.Imddb._getTableName();
        }
        return this._tableName;
    }

    private void initializeAxes() {
        try {
            int axisCount = this.getAxisCount();
            if (axisCount < 0) {
                return;
            }
            this._axes = new Axis[axisCount];
            for (int i = 0; i < axisCount; ++i) {
                this._axes[i] = new Axis(i, this.Imddb);
            }
        }
        catch (TableException te) {
            te.printStackTrace();
        }
    }

    public synchronized int getAxisCount() throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (this._axisCount == -1 && this._tableSet) {
            this._axisCount = this._axes == null || this._axes.length == 0 ? this.Imddb._getAxisCount() : this._axes.length;
        }
        return this._axisCount;
    }

    public synchronized AxisInterface getAxis(int index) throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        return this.getAxes(index, 1)[0];
    }

    public synchronized AxisInterface[] getAxes(int index, int count) throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (this._axes == null) {
            this.initializeAxes();
        }
        if (count == -1) {
            count = this.getAxisCount() - index;
        }
        if (index < 0 || index + count > this.getAxisCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (count < 0) {
            return new AxisInterface[0];
        }
        AxisInterface[] tempAxes = new AxisInterface[count];
        for (int i = 0; i < count; ++i) {
            tempAxes[i] = this._axes[index++];
        }
        return tempAxes;
    }

    public synchronized int getCellCount() throws TableException {
        if (this._cellCount == -1) {
            if (this._needsRefresh) {
                this.synchronizeServer();
            }
            AxisInterface[] axes = this.getAxes(0, -1);
            this._cellCount = 0;
            for (int i = 0; i < axes.length; ++i) {
                this._cellCount = this._cellCount > 0 ? axes[i].getMagnitude() * this._cellCount : axes[i].getMagnitude();
            }
        }
        return this._cellCount;
    }

    public synchronized Object getCell(int ordinal) throws TableException {
        try {
            if (this._rawCellCache == null) {
                this._rawCellCache = new SparseCache((StaticCacheInterface)new CellReader(false), null, this.bufferSize, this.bufferBlocks);
            }
            return this._rawCellCache.getFromCache((long)ordinal);
        }
        catch (CacheException ce) {
            return new TableException((Exception)((Object)ce));
        }
    }

    public synchronized Object[] getCells(int fromOrdinal, int toOrdinal) throws TableException {
        try {
            if (this._rawCellCache == null) {
                this._rawCellCache = new SparseCache((StaticCacheInterface)new CellReader(false), null, this.bufferSize, this.bufferBlocks);
            }
            return this._rawCellCache.getFromCache((long)fromOrdinal, (long)toOrdinal, false);
        }
        catch (CacheException ce) {
            throw new TableException((Exception)((Object)ce));
        }
    }

    public Class getCellClass(int ordinal) throws TableException {
        return Double.class;
    }

    public Class[] getCellClasses(int fromOrdinal, int toOrdinal) throws TableException {
        if (toOrdinal < 0 || fromOrdinal < 0 || toOrdinal > this.getCellCount() || fromOrdinal > this.getCellCount()) {
            throw new IndexOutOfBoundsException();
        }
        int cnt = toOrdinal - fromOrdinal + 1;
        Class[] cl = new Class[cnt];
        for (int i = fromOrdinal; i < cnt; ++i) {
            cl[i] = this.getCell(i).getClass();
        }
        return cl;
    }

    public synchronized int getBufferBlocks() {
        return this.bufferBlocks;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public void useBufferHints(BufferHints hints) {
        while (hints != null) {
            if ((hints.how & 1) == 1) {
                if (hints.what == 8192) {
                    this.setBufferBlocks(hints.count);
                } else if (hints.what == 4096) {
                    this.setBufferSize(hints.count);
                }
            }
            hints = hints.moreHints;
        }
    }

    public synchronized void setBufferBlocks(int bufferBlocks) {
        this.bufferBlocks = bufferBlocks;
        try {
            if (this._rawCellCache != null) {
                this._rawCellCache.configureCache(-1, bufferBlocks, -1, -1, -1);
            }
            if (this._fmtCellCache != null) {
                this._fmtCellCache.configureCache(-1, bufferBlocks, -1, -1, -1);
            }
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public synchronized void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        try {
            if (this._rawCellCache != null) {
                this._rawCellCache.configureCache(bufferSize, -1, -1, -1, -1);
            }
            if (this._fmtCellCache != null) {
                this._fmtCellCache.configureCache(bufferSize, -1, -1, -1, -1);
            }
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public synchronized String getCubeLabel() throws TableException {
        return "Multidimensional Table";
    }

    public synchronized int getDimensionCount() throws TableException {
        if (this._dimensionCount == -1) {
            DimensionInterface[] dims = this.getDimensions(0, -1);
            this._dimensionCount = dims.length;
        }
        return this._dimensionCount;
    }

    public synchronized DimensionInterface getDimension(int index) throws TableException {
        return this.getDimensions(index, 1)[0];
    }

    public synchronized DimensionInterface[] getDimensions(int index, int count) throws TableException {
        if (this._needsRefresh) {
            this.synchronizeServer();
        }
        if (this._sourceSet) {
            if (this._dimensions == null) {
                this.initializeDimensions();
            }
            if (count == -1) {
                count = this._dimensionCount - index;
            }
            if (index < 0 || index + count > this.getDimensionCount()) {
                throw new TableException();
            }
            DimensionInterface[] diSubset = new DimensionInterface[count];
            int i = 0;
            while (i < count) {
                diSubset[i++] = this._dimensions[index++];
            }
            return diSubset;
        }
        return new DimensionInterface[0];
    }

    private void initializeDimensions() {
        HListInterface hli = this._getDimensions();
        LevelInterface[] ilevels = null;
        try {
            ilevels = this.getIndependentLevels();
        }
        catch (TableException te) {
            te.printStackTrace();
        }
        int count = 0;
        if (hli != null) {
            count = hli.count();
        }
        if (ilevels != null && ilevels.length > 0) {
            count += ilevels.length;
        }
        if (count > 0) {
            this._dimensionCount = count;
            this._dimensions = new Dimension[this._dimensionCount];
        }
        if (hli != null) {
            for (int i = 0; i < hli.count(); ++i) {
                String label = hli.getString(i);
                String name = hli.getName(i);
                if (name == null || name.equals("")) {
                    name = label;
                }
                try {
                    Dimension d = new Dimension(null, name, label, this.Imddb);
                    if (name.equalsIgnoreCase("Measures")) {
                        d.setType(1);
                    }
                    this._dimensions[i] = d;
                    continue;
                }
                catch (TableException te) {
                    te.printStackTrace();
                }
            }
        }
        if (ilevels != null) {
            int offset = hli != null ? hli.count() : 0;
            for (int i = 0; i < ilevels.length; ++i) {
                try {
                    String label = ilevels[i].getLabel();
                    String name = ilevels[i].getName();
                    if (name == null || name.equals("")) {
                        name = label;
                    }
                    Dimension d = new Dimension(null, name, label, this.Imddb);
                    d.setType(2);
                    this._dimensions[offset++] = d;
                    continue;
                }
                catch (TableException te) {
                    te.printStackTrace();
                }
            }
        }
    }

    public String getMessage() {
        String[] errMsg = this.Imddb._getMessage();
        StringBuffer sbuf = new StringBuffer();
        if (errMsg == null) {
            return sbuf.toString();
        }
        for (int i = 0; i < errMsg.length; ++i) {
            sbuf.append(errMsg[i]);
            sbuf.append(LINESEPARATOR);
        }
        return sbuf.toString();
    }

    private Member getHiddenStatMember() throws TableException {
        Dictionary levels = this.getAllLevels();
        Enumeration enumer = levels.getItems();
        Level level = null;
        Member statistic = null;
        while (enumer.hasMoreElements()) {
            level = (Level)enumer.nextElement();
            if (!level.isStatisticLevel()) continue;
            statistic = (Member)level.getMember(0);
            break;
        }
        return statistic;
    }

    private int isStatLabelHidden() {
        try {
            AxisLabelInterface[] colLabels = this.getAxis(0).getLabels(0);
            if (colLabels != null && colLabels.length > 0 && ((Level)colLabels[colLabels.length - 1].getMember().getLevel()).isAnalysisLevel()) {
                return 1;
            }
            return 0;
        }
        catch (TableException te) {
            return 0;
        }
    }

    private static final boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null || s2.length() == 0;
        }
        if (s2 == null) {
            return s1.length() == 0;
        }
        return s1.equals(s2);
    }

    public synchronized HListInterface _getDimensions() {
        HListInterface dimensionList = null;
        int index = this._cubeDefinition.find("Dimensions", 1, 0);
        if (this._version == 3) {
            if (index == -1) {
                this._cubeDefinition = ((MultidimensionalTableV3Interface)this.Imddb)._describeCube();
            }
            dimensionList = this._cubeDefinition.getList("Dimensions");
        } else {
            dimensionList = ((_rprxMultidimensionalTableInterface)((Object)this.Imddb))._Remote__getDimensions();
        }
        return dimensionList;
    }

    public synchronized HListInterface _getIndependentLevels() {
        HListInterface independentLevelsList = null;
        int index = this._cubeDefinition.find("IndependentLevels", 1, 0);
        if (this._version == 3) {
            if (index == -1) {
                this._cubeDefinition = ((MultidimensionalTableV3Interface)this.Imddb)._describeCube();
            }
            independentLevelsList = this._cubeDefinition.getList("IndependentLevels");
        } else {
            independentLevelsList = ((_rprxMultidimensionalTableInterface)((Object)this.Imddb))._Remote__getIndependentLevels();
        }
        return independentLevelsList;
    }

    public synchronized HListInterface _getHierarchies(String hierarchyName) {
        HListInterface hierarchiesList = null;
        int index = this._cubeDefinition.find("Hierarchies", 1, 0);
        if (this._version == 3) {
            if (index == -1) {
                this._cubeDefinition = ((MultidimensionalTableV3Interface)this.Imddb)._describeCube();
            }
            HListInterface tempList = null;
            tempList = this._cubeDefinition.getList("Hierarchies");
            if (tempList.find(hierarchyName, 1, 0) == -1) {
                HList temp2List = new HList();
                temp2List = this._cubeDefinition.getList("IndependentLevels");
                if (temp2List.find(hierarchyName, 1, 0) >= 0) {
                    hierarchiesList = new HList();
                    hierarchiesList.addItem(hierarchyName, -1, null);
                } else {
                    HListInterface temp3List = null;
                    temp3List = this._cubeDefinition.getList("Levels");
                    for (int i = 0; i < temp3List.count(); ++i) {
                        int stringIndex;
                        HListInterface temp4List = null;
                        temp4List = temp3List.getList(i);
                        if (temp4List.find(hierarchyName, 1, 0) < 0 || (stringIndex = temp4List.find(hierarchyName, 1, 0)) <= -1) continue;
                        if (hierarchiesList == null) {
                            hierarchiesList = new HList();
                        }
                        hierarchiesList.addItem(hierarchyName, -1, null);
                    }
                }
            } else {
                hierarchiesList = tempList.getList(hierarchyName);
            }
        } else {
            hierarchiesList = ((_rprxMultidimensionalTableInterface)((Object)this.Imddb))._Remote__getHierarchies(hierarchyName);
        }
        return hierarchiesList;
    }

    public synchronized HListInterface _getMeasures() {
        HListInterface measuresList = null;
        int index = this._cubeDefinition.find("Measures", 1, 0);
        if (this._version == 3) {
            if (index == -1) {
                this._cubeDefinition = ((MultidimensionalTableV3Interface)this.Imddb)._describeCube();
            }
            measuresList = this._cubeDefinition.getList("Measures");
        } else {
            measuresList = ((_rprxMultidimensionalTableInterface)((Object)this.Imddb))._Remote__getMeasures();
        }
        return measuresList;
    }

    public synchronized HListInterface _getStatistics() {
        HListInterface statisticsList = null;
        int index = this._cubeDefinition.find("Statistics", 1, 0);
        if (this._version == 3) {
            if (index == -1) {
                this._cubeDefinition = ((MultidimensionalTableV3Interface)this.Imddb)._describeCube();
            }
            statisticsList = this._cubeDefinition.getList("Statistics");
        } else {
            statisticsList = ((_rprxMultidimensionalTableInterface)((Object)this.Imddb))._Remote__getStatistics();
        }
        return statisticsList;
    }

    public synchronized HListInterface _getLevels(String hierarchyId) {
        HListInterface levelsList = null;
        int index = this._cubeDefinition.find("Levels", 1, 0);
        if (this._version == 3) {
            if (index == -1) {
                this._cubeDefinition = ((MultidimensionalTableV3Interface)this.Imddb)._describeCube();
            }
            HList tempList = new HList();
            tempList = this._cubeDefinition.getList("Levels");
            if (tempList.find(hierarchyId, 1, 0) == -1) {
                HListInterface temp2List = null;
                temp2List = this._cubeDefinition.getList("IndependentLevels");
                if (temp2List.find(hierarchyId, 1, 0) >= 0) {
                    String tempString = temp2List.getString(temp2List.find(hierarchyId, 1, 0));
                    levelsList = new HList();
                    levelsList.addItem(tempString, -1, hierarchyId);
                } else {
                    for (int i = 0; i < tempList.count(); ++i) {
                        HListInterface temp3List = null;
                        temp3List = tempList.getList(i);
                        if (temp3List.find(hierarchyId, 1, 0) < 0) continue;
                        String tempString = temp3List.getString(temp3List.find(hierarchyId, 1, 0));
                        if (levelsList == null) {
                            levelsList = new HList();
                        }
                        levelsList.addItem(tempString, -1, hierarchyId);
                        break;
                    }
                }
            } else {
                levelsList = tempList.getList(hierarchyId);
            }
        } else {
            levelsList = ((_rprxMultidimensionalTableInterface)((Object)this.Imddb))._Remote__getLevels(hierarchyId);
        }
        return levelsList;
    }

    static {
        LINESEPARATOR = System.getProperty("line.separator");
    }

    class CellReader
    implements StaticCacheInterface {
        private boolean _readFormatted;

        public CellReader(boolean readFormatted) {
            this._readFormatted = readFormatted;
        }

        public Object getFromCache(long key) throws CacheException {
            return this.getFromCache(key, key, true)[0];
        }

        public Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
            return this.getFromCache(keys[0], keys[keys.length - 1], readFully);
        }

        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            double[] rawData = null;
            Object[] formattedData = null;
            int len = 0;
            if (this._readFormatted) {
                formattedData = MultidimensionalTableDelegate.this.Imddb._getFormattedCells((int)startOrdinal, (int)endOrdinal);
                return formattedData;
            }
            rawData = MultidimensionalTableDelegate.this.Imddb._getRawCells((int)startOrdinal, (int)endOrdinal);
            len = rawData.length;
            Object[] dbl = new Double[len];
            for (int index = 0; index < len; ++index) {
                dbl[index] = new Double(rawData[index]);
            }
            return dbl;
        }

        public long[] computeCacheKeyRange(long startOrdinal, long endOrdinal, int readBuffer) throws CacheException {
            long[] returnKeys = null;
            try {
                SparseCache currentCache;
                int numRows = 0;
                int numCols = 0;
                int cellCount = MultidimensionalTableDelegate.this.getCellCount();
                if (startOrdinal < 0L) {
                    startOrdinal = 0L;
                }
                if (startOrdinal == endOrdinal && readBuffer > 0) {
                    if (cellCount < readBuffer) {
                        startOrdinal = 0L;
                        endOrdinal = cellCount - 1;
                    } else {
                        int square = (int)Math.sqrt(readBuffer);
                        AxisInterface[] axes = MultidimensionalTableDelegate.this.getAxes(0, -1);
                        int colCount = axes[0].getMagnitude();
                        int rowCount = axes[1].getMagnitude();
                        int[] startCoords = MultidimensionalTableDelegate.this.getAxisCoordinates((int)startOrdinal);
                        numCols = Math.min(colCount - startCoords[0], square);
                        if (numCols < square) {
                            square = readBuffer / numCols;
                        }
                        numRows = Math.min(rowCount - startCoords[1], square);
                        int[] endCoords = new int[]{startCoords[0] + numCols - 1, startCoords[1] + numRows - 1};
                        endOrdinal = MultidimensionalTableDelegate.this.getCellOrdinal(endCoords);
                    }
                } else {
                    if (endOrdinal > (long)(cellCount - 1)) {
                        endOrdinal = cellCount - 1;
                    }
                    if (startOrdinal > endOrdinal) {
                        throw new CacheException(RB.getStringResource(MultidimensionalTableDelegate.RB_KEY, "invalidOrdinal.ex.txt"));
                    }
                }
                int[] startCoords = MultidimensionalTableDelegate.this.getAxisCoordinates((int)startOrdinal);
                int[] endCoords = MultidimensionalTableDelegate.this.getAxisCoordinates((int)endOrdinal);
                int i = 0;
                if (startCoords[0] > endCoords[0]) {
                    int endCol;
                    int startCol = startCoords[0];
                    startCoords[0] = endCol = endCoords[0];
                    endCoords[0] = startCol;
                }
                int cachedCount = (endCoords[1] - startCoords[1] + 1) * (endCoords[0] - startCoords[0] + 1);
                returnKeys = new long[cachedCount];
                SparseCache sparseCache = currentCache = this._readFormatted ? MultidimensionalTableDelegate.this._fmtCellCache : MultidimensionalTableDelegate.this._rawCellCache;
                if (currentCache.getCacheCapacity() < cachedCount) {
                    currentCache.configureCache(cachedCount, -1, -1, -1, -1);
                }
                int[] coords = new int[]{0, 0};
                for (int r = startCoords[1]; r <= endCoords[1]; ++r) {
                    int c = startCoords[0];
                    while (c <= endCoords[0]) {
                        coords[0] = c++;
                        coords[1] = r;
                        returnKeys[i++] = MultidimensionalTableDelegate.this.getCellOrdinal(coords);
                    }
                }
            }
            catch (TableException te) {
                throw new CacheException(RB.getStringResource(MultidimensionalTableDelegate.RB_KEY, "secondaryCache.ex.txt"));
            }
            return returnKeys;
        }

        public long[] getCacheKeys() throws CacheException {
            long[] keys = null;
            try {
                keys = new long[MultidimensionalTableDelegate.this.getCellCount()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = i;
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
            return keys;
        }

        public boolean cacheContainsKey(long key) throws CacheException {
            try {
                return key < (long)MultidimensionalTableDelegate.this.getCellCount();
            }
            catch (TableException tableException) {
                return false;
            }
        }

        public int getCacheKeyUse() {
            return 1;
        }

        public void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) throws CacheException {
        }

        public void useBufferHints(BufferHints hints) {
        }

        public int count() {
            try {
                return MultidimensionalTableDelegate.this.getCellCount();
            }
            catch (TableException te) {
                return MultidimensionalTableDelegate.this._cellCount;
            }
        }

        public StaticCacheInterface getSecondaryCache() {
            return null;
        }
    }

    private final class Cell
    implements StaticPropertyBagInterface,
    CommandsInterface {
        public int _ordinal;
        private boolean _isV2;
        private boolean _isV3;
        private final String COMMANDS = "Commands";
        private final String[] KEYS = new String[]{"Commands"};
        private Command[] _commands;
        private int _length;

        public Cell(int ordinal) {
            this._ordinal = ordinal;
            if (MultidimensionalTableDelegate.this.Imddb instanceof MultidimensionalTableV2Interface) {
                this._isV2 = true;
            }
        }

        public Command[] getCommands() {
            OrderedCollection oc = new OrderedCollection();
            if (MultidimensionalTableDelegate.this._version == 3) {
                return MDCommand.getCommands(MultidimensionalTableDelegate.this.Imddb, this._ordinal);
            }
            if (this._isV2) {
                MultidimensionalTableV2Interface v2Imddb = (MultidimensionalTableV2Interface)MultidimensionalTableDelegate.this.Imddb;
                LevelNameCommand ln = null;
                try {
                    int[] cellOrdinal = MultidimensionalTableDelegate.this.Imddb.getAxisCoordinates(this._ordinal);
                    AxisLabelInterface[] colLabels = MultidimensionalTableDelegate.this.getAxis(0).getLabels(cellOrdinal[0]);
                    if (MultidimensionalTableDelegate.this.isStatLabelHidden() == 1) {
                        Member statLabel = new Member(v2Imddb);
                        statLabel.setDelegate(MultidimensionalTableDelegate.this.getHiddenStatMember());
                        statLabel.setParent((ParentNode)((Object)colLabels[colLabels.length - 1]));
                        statLabel.setOrdinal(colLabels.length);
                        ln = new LevelNameCommand(statLabel);
                    } else {
                        ln = new LevelNameCommand((Member)colLabels[colLabels.length - 1]);
                    }
                }
                catch (TableException cellOrdinal) {
                    // empty catch block
                }
                boolean addSeparator = false;
                if ((1L & MultidimensionalTableDelegate.this._commandsMask) != 0L) {
                    oc.add((Object)new ShowDetailCommand(RB.getStringResource("showDetail.txt"), this._ordinal, (MultidimensionalTableV2Interface)MultidimensionalTableDelegate.this.Imddb));
                    oc.add((Object)MenuSeparatorCommand.instance());
                }
                if (ln != null) {
                    oc.add(ln);
                    oc.add((Object)MenuSeparatorCommand.instance());
                }
                if ((2L & MultidimensionalTableDelegate.this._commandsMask) != 0L) {
                    oc.add((Object)new ComputedValuesCommand(RB.getStringResource("computedValues.txt"), MultidimensionalTableDelegate.this.Imddb));
                }
                if ((4L & MultidimensionalTableDelegate.this._commandsMask) != 0L) {
                    oc.add((Object)new TotalsCommand(RB.getStringResource("totals.txt"), MultidimensionalTableDelegate.this.Imddb));
                }
                if ((8L & MultidimensionalTableDelegate.this._commandsMask) != 0L) {
                    oc.add((Object)new SubsetsCommand(RB.getStringResource("subsets.txt"), MultidimensionalTableDelegate.this.Imddb));
                }
                if ((0x10L & MultidimensionalTableDelegate.this._commandsMask) != 0L) {
                    oc.add((Object)new RangeTypesCommand(RB.getStringResource("rangeTypes.txt"), MultidimensionalTableDelegate.this.Imddb));
                }
                if ((0x20L & MultidimensionalTableDelegate.this._commandsMask) != 0L) {
                    oc.add((Object)new ExportToExcelCommand(RB.getStringResource("excel.txt"), MultidimensionalTableDelegate.this.Imddb));
                }
                if (oc.count() > 0 && oc.get(oc.count() - 1) == MenuSeparatorCommand.instance()) {
                    oc.removeAt(oc.count() - 1);
                }
            }
            int cnt = oc.count();
            this._commands = new Command[cnt];
            for (int i = 0; i < cnt; ++i) {
                this._commands[i] = (Command)oc.get(i);
            }
            return this._commands;
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        public boolean containsKey(String key) {
            return key == "Commands";
        }

        public int count() {
            this._length = 8;
            if (ExportToExcelCommand.isExportAllowed()) {
                this._length = 9;
            }
            return this._length;
        }

        public Object get(String key) {
            if (this.containsKey(key)) {
                return this;
            }
            throw new NoSuchElementException();
        }

        public Object get(String key, Object defaultValue) {
            if (this.containsKey(key)) {
                return this;
            }
            return defaultValue;
        }

        public String[] listKeys() {
            return this.KEYS;
        }

        public DictionaryInterface toDictionary(DictionaryInterface initialDictionary) {
            return initialDictionary;
        }

        public void addPropertyBagChangedListener(PropertyBagChangedListener listener) {
        }

        public void removePropertyBagChangedListener(PropertyBagChangedListener listener) {
        }

        public StaticPropertyBagInterface getData() {
            return this;
        }
    }
}

