/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.Dictionary;
import com.sas.collection.StringCollection;
import com.sas.lang.StringData;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.sasserver.mdtable.Element;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.TextParser;
import com.sas.sasserver.mdtable.TextParserConstants;
import com.sas.table.TableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Enumeration;

public class MDStringData
extends StringData
implements TextParserConstants,
ContentsChangedListener {
    static final long serialVersionUID = 390755206907538766L;
    public static final String RB_KEY = "MDStringData.";
    protected String _originalText;
    protected int _errorContextLength = 20;
    protected transient String _displayText;
    protected transient MultidimensionalTableInterface _mdModel;
    protected transient TextParser _parser;
    protected transient int _lastReturnCode;
    protected transient int _lastErrorPosition;

    public int getLastErrorCode() {
        return this._lastReturnCode;
    }

    public String getLastErrorText() {
        String text;
        switch (this._lastReturnCode) {
            case 1: {
                text = RB.getStringResource(RB_KEY, "MissingClose.txt");
                break;
            }
            case 2: {
                text = RB.getStringResource(RB_KEY, "MissingOpen.txt");
                break;
            }
            case 3: {
                text = RB.getStringResource(RB_KEY, "MissingLevel.txt");
                break;
            }
            case 4: {
                text = RB.getStringResource(RB_KEY, "TooManyLevels.txt");
                break;
            }
            default: {
                text = "";
            }
        }
        return text;
    }

    public int getLastErrorPosition() {
        return this._lastErrorPosition;
    }

    public String[] getIncorrectLevelNames() {
        Dictionary levels;
        if (this._mdModel == null) {
            return null;
        }
        try {
            levels = this._mdModel.getAllLevels();
        }
        catch (TableException e) {
            e.printStackTrace();
            return null;
        }
        StringCollection levelNames = new StringCollection();
        Enumeration vals = levels.getItems();
        while (vals.hasMoreElements()) {
            try {
                levelNames.add(((LevelInterface)vals.nextElement()).getLabel().toLowerCase());
            }
            catch (TableException e) {
                e.printStackTrace();
            }
        }
        StringCollection bad = new StringCollection();
        int count = this._parser._elements.size();
        for (int i = 0; i < count; ++i) {
            String name = ((Element)this._parser._elements.elementAt((int)i)).levelName;
            if (name == null || levelNames.contains((Object)name.toLowerCase())) continue;
            bad.add(name);
        }
        return bad.toStringArray();
    }

    public String getStringShowingErrorLocation() {
        if (this._lastErrorPosition < 0) {
            return null;
        }
        int length = this._originalText.length();
        String before = "";
        if (this._lastErrorPosition > 0) {
            before = this._originalText.substring(Math.max(0, this._lastErrorPosition - this._errorContextLength), this._lastErrorPosition);
        }
        String errorChar = "";
        if (this._lastErrorPosition < length) {
            errorChar = new Character(this._originalText.charAt(this._lastErrorPosition)).toString();
        }
        String after = "";
        if (this._lastErrorPosition < length - 1) {
            after = this._originalText.substring(this._lastErrorPosition + 1, Math.min(length, this._lastErrorPosition + this._errorContextLength));
        }
        String errorFmt = RB.getStringResource(RB_KEY, "ErrorStringFmt.txt");
        return MessageFormat.format(errorFmt, before, errorChar, after);
    }

    public String getText() {
        String ret = this.getDisplayText();
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public String getDisplayText() {
        if (this._displayText == null) {
            this.createDisplayText();
        }
        return this._displayText;
    }

    public String getOriginalText() {
        return this._originalText;
    }

    public void setText(String text) {
        if (this._parser == null) {
            this._parser = new TextParser();
        }
        if (text != null && (this._originalText != text || this._displayText == null || this._displayText == this._originalText)) {
            this._originalText = text;
            int[] errorPos = new int[]{-1};
            this._lastReturnCode = this._parser.processText(text, errorPos);
            this._lastErrorPosition = errorPos[0];
            this.createDisplayText();
        } else {
            this._originalText = text;
        }
        this.notifyViewers(this._displayText);
    }

    public MultidimensionalTableInterface getMDModel() {
        return this._mdModel;
    }

    public void setMDModel(MultidimensionalTableInterface mdModel) {
        if (this._mdModel == mdModel) {
            return;
        }
        if (this._mdModel != null) {
            this._mdModel.removeContentsChangedListener(this);
        }
        this._mdModel = mdModel;
        if (this._mdModel != null) {
            this._mdModel.addContentsChangedListener(this);
        }
    }

    public String getAllLevelsString() {
        StringCollection labels;
        String format;
        block17: {
            if (this._mdModel == null) {
                return "";
            }
            Dictionary levelDict = null;
            try {
                levelDict = this._mdModel.getAllLevels();
            }
            catch (TableException tableException) {
                // empty catch block
            }
            if (levelDict == null) {
                return "";
            }
            format = RB.getStringResource(RB_KEY, "LevelFmt.txt");
            Enumeration levelsEnum = levelDict.getItems();
            labels = new StringCollection();
            StringCollection names = new StringCollection();
            while (levelsEnum.hasMoreElements()) {
                LevelInterface levelI = (LevelInterface)levelsEnum.nextElement();
                try {
                    if (levelI.getName().equals("_ANLSYS_") || levelI.getName().equals("_STATS_")) continue;
                    labels.add(levelI.getLabel());
                    names.add(levelI.getName());
                }
                catch (TableException e) {}
            }
            StringCollection tempLabels = new StringCollection();
            try {
                String[] temp = this._mdModel.getRowAxis();
                if (temp == null) break block17;
                StringCollection rcLabels = new StringCollection(temp);
                temp = this._mdModel.getColumnAxis();
                if (temp != null) {
                    for (int i = 0; i < temp.length; ++i) {
                        rcLabels.add(temp[i]);
                    }
                }
                DimensionInterface[] dims = this._mdModel.getDimensions(0, -1);
                block8: for (int m = 0; m < rcLabels.count(); ++m) {
                    for (int i = 0; i < dims.length; ++i) {
                        HierarchyInterface[] hiers = dims[i].getHierarchies(0, -1);
                        for (int j = 0; j < hiers.length; ++j) {
                            if (!rcLabels.getString(m).equals(hiers[j].getLabel())) continue;
                            LevelInterface[] levels = hiers[j].getLevels(0, -1);
                            for (int k = 0; k < levels.length; ++k) {
                                labels.remove((Object)levels[k].getLabel());
                                names.remove((Object)levels[k].getName());
                                tempLabels.add(levels[k].getLabel());
                            }
                            continue block8;
                        }
                    }
                    String levelName = rcLabels.getString(m);
                    int nameIndex = names.getIndex(levelName, 0);
                    if (nameIndex < 0) continue;
                    tempLabels.add(labels.get(nameIndex));
                    labels.removeAt(nameIndex);
                    names.removeAt(nameIndex);
                }
                int i = tempLabels.count();
                while (i-- > 0) {
                    labels.add(tempLabels.get(i), 0);
                }
            }
            catch (TableException temp) {
                // empty catch block
            }
        }
        StringBuffer levelsString = new StringBuffer();
        int count = labels.count();
        for (int i = 0; i < count; ++i) {
            String label = (String)labels.get(i);
            levelsString.append("{");
            String levelName = "{" + label + "}";
            levelsString.append(MessageFormat.format(format, label, levelName));
            levelsString.append("}");
            if (i >= count - 1) continue;
            levelsString.append("\n");
        }
        return levelsString.toString();
    }

    private void createDisplayText() {
        if (this._parser == null) {
            this.setText(this._originalText);
        }
        if (this._parser == null || this._parser._elements == null || this._parser._elements.size() == 0 || this._mdModel == null) {
            this._displayText = this._originalText;
            return;
        }
        int count = this._parser._elements.size();
        Object[] elements = new Element[count];
        this._parser._elements.copyInto(elements);
        for (int i = 0; i < count; ++i) {
            ((Element)elements[i]).levelValue = null;
        }
        try {
            SubsetInterface[] subsets = this._mdModel.getSubsets();
            StringBuffer buf = new StringBuffer(256);
            block3: for (int i = 0; i < count; ++i) {
                if (((Element)elements[i]).levelName == null) continue;
                for (int j = 0; j < subsets.length; ++j) {
                    if (subsets[j] == null || !((LevelInterface)((Object)subsets[j])).getLabel().toLowerCase().equals(((Element)elements[i]).levelName.toLowerCase())) continue;
                    Object[] values = subsets[j].getDrillSubset();
                    if (values == null) {
                        values = subsets[j].getSubset();
                    }
                    if (values == null || values.length <= 0) continue block3;
                    buf.setLength(0);
                    this.appendValues(buf, values);
                    ((Element)elements[i]).levelValue = buf.toString();
                    continue block3;
                }
            }
        }
        catch (TableException e) {
            e.printStackTrace();
        }
        StringBuffer buf = new StringBuffer();
        buf.ensureCapacity(this._originalText.length());
        this.finishDisplayText(buf, (Element[])elements);
        this._displayText = buf.toString();
    }

    protected void finishDisplayText(StringBuffer buf, Element[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].levelName == null) {
                this.beforeText(elements[i], buf);
                this.afterText(elements[i], buf);
                continue;
            }
            if (elements[i].levelName == null || elements[i].levelValue == null) continue;
            this.beforeText(elements[i], buf);
            this.levelValue(elements[i], buf);
            this.afterText(elements[i], buf);
        }
    }

    private void appendValues(StringBuffer buf, Object[] values) {
        if (values != null) {
            int k = 0;
            while (k < values.length) {
                buf.append(values[k].toString());
                if (++k >= values.length) continue;
                buf.append(", ");
            }
        }
    }

    protected void notifyViewers(String newText) {
        this.firePropertyChange("text", null, newText);
        this.firePropertyChange("stringData", null, newText);
    }

    private void beforeText(Element element, StringBuffer buf) {
        if (element.beforeStart != -5) {
            this.append(this._originalText.substring(element.beforeStart, element.beforeEnd + 1), element, buf);
        }
    }

    private void afterText(Element element, StringBuffer buf) {
        if (element.afterStart != -5) {
            this.append(this._originalText.substring(element.afterStart, element.afterEnd + 1), element, buf);
        }
    }

    private void levelValue(Element element, StringBuffer buf) {
        if (element.levelValue != null) {
            buf.append(element.levelValue);
        }
    }

    private void append(String text, Element element, StringBuffer buf) {
        if (!element.hasEscapeOrBracket) {
            buf.append(text);
        } else {
            char[] chars = text.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\\' && i + 1 < chars.length && (chars[i + 1] == '\\' || chars[i + 1] == '{' || chars[i + 1] == '}')) {
                    buf.append(chars[++i]);
                    continue;
                }
                if (chars[i] == '}') continue;
                buf.append(chars[i]);
            }
        }
    }

    public void contentsChanged(ContentsChangedEvent e) {
        this.createDisplayText();
        this.notifyViewers(this._displayText);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setText(this._originalText);
    }
}

