/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.ModelInterface;
import com.sas.awt.Panel;
import com.sas.collection.StringCollection;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.RB;
import com.sas.table.TableException;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.DualSelector;
import com.sas.visuals.OkCancelHelpDialog;
import java.awt.Frame;
import java.awt.LayoutManager;

class MDSelectorDialog
extends OkCancelHelpDialog {
    public static final String RB_KEY = "MDSelectorDialog.";
    public static final int MEASURES = 2;
    public static final int STATISTICS = 3;
    protected DualSelector dualSelector = null;
    protected MultidimensionalTableInterface table = null;
    protected int type;
    protected String[] selectedValues;
    private boolean buttonCancelled;

    @Override
    public void initialize() {
        super.initialize();
        Panel panel = this.getMainPanel();
        panel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, true, true));
        panel.setInsets(10, 10, 10, 10);
        this.dualSelector = new DualSelector();
        this.dualSelector.initialize();
        panel.add(this.dualSelector);
        switch (this.type) {
            case 2: {
                this.getMeasures();
                break;
            }
            case 3: {
                this.getStatistics();
            }
        }
    }

    private void getMeasures() {
        if (this.table != null) {
            try {
                String[] measures = this.table.getMeasures();
                if (measures == null || measures.length == 0) {
                    return;
                }
                StringCollection sc = new StringCollection();
                StringCollection selSc = new StringCollection();
                int cnt = measures.length;
                for (int i = 0; i < cnt; ++i) {
                    if (this.containsValue(measures[i], this.selectedValues)) {
                        selSc.add(measures[i]);
                        continue;
                    }
                    sc.add(measures[i]);
                }
                this.dualSelector.attachModel((ModelInterface)sc);
                this.dualSelector.setList2ModelInterface((ModelInterface)selSc);
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
    }

    private boolean containsValue(String value, String[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        int cnt = array.length;
        for (int i = 0; i < cnt; ++i) {
            if (!Util.equal((Object)value, (Object)array[i])) continue;
            return true;
        }
        return false;
    }

    private void getStatistics() {
        if (this.table != null) {
            try {
                String[] statistics = this.table.getStatistics();
                if (statistics == null || statistics.length == 0) {
                    return;
                }
                StringCollection sc = new StringCollection();
                StringCollection selSc = new StringCollection();
                int cnt = statistics.length;
                for (int i = 0; i < cnt; ++i) {
                    if (this.containsValue(statistics[i], this.selectedValues)) {
                        selSc.add(statistics[i]);
                        continue;
                    }
                    sc.add(statistics[i]);
                }
                this.dualSelector.attachModel((ModelInterface)sc);
                this.dualSelector.setList2ModelInterface((ModelInterface)selSc);
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
    }

    public MDSelectorDialog(Frame parent, int type, MultidimensionalTableInterface table) {
        super(parent, MDSelectorDialog.getTitle(type));
        this.type = type;
        this.table = table;
    }

    public MDSelectorDialog(Frame parent, int type, MultidimensionalTableInterface table, String[] selectedValues) {
        this(parent, type, table);
        this.selectedValues = selectedValues;
    }

    public StringCollection getSelectedItems() {
        if (this.buttonCancelled) {
            return this.selectedValues == null ? null : new StringCollection(this.selectedValues);
        }
        StringCollection sc = new StringCollection();
        sc.addItems(this.getDualSelector().getList2Items().getItems());
        return sc;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.buttonCancelled = true;
    }

    public DualSelector getDualSelector() {
        return this.dualSelector;
    }

    private static String getTitle(int type) {
        switch (type) {
            case 2: {
                return RB.getStringResource(RB_KEY, "measuresLabel.txt");
            }
            case 3: {
                return RB.getStringResource(RB_KEY, "statisticsLabel.txt");
            }
        }
        throw new IllegalArgumentException("invalid type: " + type);
    }
}

