/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.ModelInterface;
import com.sas.collection.AssociationList;
import com.sas.collection.StringCollection;
import com.sas.mdtable.MemberInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.table.StaticFormattedDataInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;

public class LevelTable
implements StaticTableInterface,
StaticFormattedDataInterface,
ModelInterface {
    protected transient int _rowCount;
    private AssociationList _removeList;
    private StringCollection _cvList;
    private boolean _includeComputedValues;
    private boolean _includeTotals;
    protected transient Level _level;
    private transient Object[] _subset;
    static String blankString = new String("");
    static Member blankMember = new Member(blankString);

    public LevelTable(Level l) {
        this._level = l;
        this._rowCount = -1;
        this.setRemovelist();
        this.reset();
        this.populateRemoveList();
    }

    public LevelTable(Level l, boolean includeComputedValues, boolean includeTotals) {
        this._level = l;
        this._rowCount = -1;
        this._includeComputedValues = includeComputedValues;
        this._includeTotals = includeTotals;
        this.setRemovelist();
        this.reset();
        this.populateRemoveList();
    }

    void setLevel(Level level) {
        this._level = level;
        this.reset();
        this.populateRemoveList();
    }

    public String getName() {
        return this._level.getName();
    }

    public String getLabel() {
        return this._level.getLabel();
    }

    public void reset() {
        this._removeList.removeAll();
        this._cvList.removeAll();
        this._rowCount = -1;
        this._level.reset();
    }

    private void setRemovelist() {
        this._removeList = new AssociationList();
        this._cvList = new StringCollection();
        if (!this._includeComputedValues) {
            AssociationList asl = this._level.getComputedValues();
            if (asl == null && this._level.getDelegate() != null) {
                asl = ((Level)this._level.getDelegate()).getComputedValues();
            }
            if (asl != null) {
                this._cvList.addItems(asl.getKeys());
            }
        }
    }

    private void populateRemoveList() {
        try {
            int count = this._level.getMemberCount();
            if (!this._includeTotals) {
                MemberInterface m = this._level.getMember(count - 1);
                if (m.getName().equalsIgnoreCase("_Total_")) {
                    this.removeMember((Member)m);
                } else {
                    m = this._level.getMember(0);
                    if (m.getName().equalsIgnoreCase("_Total_")) {
                        this.removeMember((Member)m);
                    }
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    void addSubset(SubsetInterface subset, int pos) {
        Object[] o = subset.getSubset();
        if (this._level.Imddb instanceof MultidimensionalTableV2Interface) {
            for (int i = 0; i < o.length; ++i) {
                int index = ((MultidimensionalTableV2Interface)this._level.Imddb).findMember(this.getName(), (String)o[i], false);
                this.addToRemoveList(index, o[i]);
            }
        } else {
            try {
                int numKids = this._level.getMemberCount();
                block3: for (int i = 0; i < o.length; ++i) {
                    String memberLabel = (String)o[i];
                    for (int j = 0; j < numKids; ++j) {
                        MemberInterface member = this._level.getMember(j);
                        if (!memberLabel.equals(member.getLabel())) continue;
                        this.addToRemoveList(j, o[i]);
                        continue block3;
                    }
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
    }

    void removeMember(int index, String memberName) throws TableException {
        int i = index;
        MemberInterface m = this._level.getMember(index - 1);
        int memCount = this._level.getMemberCount();
        boolean found = false;
        while (i <= memCount) {
            if (m.getLabel().equals(memberName)) {
                this.addToRemoveList(i - 1, memberName);
                if (this._rowCount <= 0) break;
                --this._rowCount;
                break;
            }
            if (++i > this._level.getMemberCount()) continue;
            m = this._level.getMember(i - 1);
        }
    }

    private void removeMember(Member member) {
        this.addToRemoveList(member.getOrdinal(), member.getLabel());
        if (this._rowCount > 0) {
            --this._rowCount;
        }
    }

    void addMember(String memberName) throws TableException {
        if (this._removeList.contains((Object)memberName)) {
            this._removeList.remove((Object)memberName);
            ++this._rowCount;
        }
    }

    public int countColumns(int maxCount) throws TableException {
        return this.getColumnCount();
    }

    public int countRows(int maxCount) throws TableException {
        int countRows = this.getRowCount();
        if (maxCount > 0 && maxCount < countRows) {
            return maxCount;
        }
        return countRows;
    }

    public Object getCell(int rowIndex, int columnIndex) throws TableException {
        int cnt;
        int index = this.mapIndex(rowIndex);
        if (index >= (cnt = this._level.getMemberCount())) {
            return blankMember;
        }
        MemberInterface m = this._level.getMember(index);
        if (!this._includeComputedValues && (this._cvList.contains((Object)m.getLabel()) || m.getName().startsWith("CVALUE")) || !this._includeTotals && m.getName().equalsIgnoreCase("_Total_")) {
            this.removeMember((Member)m);
            m = index < this._rowCount ? (MemberInterface)this.getCell(rowIndex, columnIndex) : blankMember;
        }
        return m;
    }

    public int mapIndex(int index) {
        int newIndex = index - 1;
        int i = 0;
        int cnt = this._removeList.count();
        for (int j = 0; j < cnt; ++j) {
            i = (Integer)this._removeList.getKey(j);
            if (i > newIndex) continue;
            ++newIndex;
        }
        return newIndex;
    }

    public boolean isIndexRemoved(int index) {
        int i = 0;
        int cnt = this._removeList.count();
        for (int j = 0; j < cnt; ++j) {
            i = (Integer)this._removeList.getKey(j);
            if (i != index) continue;
            return true;
        }
        return false;
    }

    public int getRemoveCount(int index, boolean forward) {
        int k = 0;
        int cnt = this._removeList.count();
        for (int j = 0; j < cnt; ++j) {
            int i = (Integer)this._removeList.getKey(j);
            if (i > index) continue;
            ++k;
        }
        return k;
    }

    public Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Object[][] m = new MemberInterface[rowCount][1];
        for (int i = startRowIndex - 1; i < rowCount; ++i) {
            m[i][0] = (MemberInterface)this.getCell(i + 1, 1);
        }
        return m;
    }

    public Class getCellClass(int rowIndex, int columnIndex) throws TableException {
        return String.class;
    }

    public Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Class[][] c = new Class[rowCount][columnCount];
        for (int i = startRowIndex - 1; i < rowCount; ++i) {
            for (int j = startColumnIndex - 1; j < columnCount; ++j) {
                c[i][j] = this.getCell(i + 1, j + 1).getClass();
            }
        }
        return c;
    }

    public Object[] getColumn(int index) throws TableException {
        if (index == 1) {
            return this._level.getMembers(0, -1);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getColumnCount() throws TableException {
        return 1;
    }

    public Object[] getRow(int index) throws TableException {
        Object[] o = new Object[]{this._level.getMember(index - 1)};
        return o;
    }

    public int getRowCount() throws TableException {
        int removeCount = this._removeList.count();
        if (!this._includeComputedValues) {
            removeCount += this._cvList.count();
        }
        int countRows = this._rowCount;
        if (this._rowCount == -1) {
            this._rowCount = this._level.getMemberCount() - removeCount;
        }
        return this._rowCount;
    }

    public String getFormattedCell(int rowIndex, int columnIndex) throws TableException {
        MemberInterface m = (MemberInterface)this.getCell(rowIndex, columnIndex);
        return m != null ? m.getLabel() : null;
    }

    public String[][] getFormattedCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        String[][] c = new String[rowCount][columnCount];
        for (int i = startRowIndex - 1; i < rowCount; ++i) {
            c[i][columnCount - 1] = ((MemberInterface)this.getCell(i + 1, columnCount)).getLabel();
        }
        return c;
    }

    public String[] getFormattedColumn(int index) throws TableException {
        if (index == 1) {
            MemberInterface[] m = this._level.getMembers(0, -1);
            String[] labels = new String[m.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = m[i].getLabel();
            }
            return labels;
        }
        throw new IndexOutOfBoundsException();
    }

    public String[] getFormattedRow(int index) throws TableException {
        Object[] members = this.getColumn(index);
        String[] names = new String[members.length];
        for (int i = 0; i < members.length; ++i) {
            names[i] = ((MemberInterface)members[i]).getLabel();
        }
        return names;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return this._level.getNodeChild(index);
    }

    public Level getLevel() {
        return this._level;
    }

    public MultidimensionalTableInterface getImddb() {
        return this._level.getImddb();
    }

    public void setSubset(Object[] subset) {
        this._subset = subset;
    }

    public Object[] getDrillSubset() {
        return null;
    }

    public void setDrillSubset(Object[] subset) {
    }

    public Object[] getSubset() {
        return this._subset;
    }

    private void addToRemoveList(int index, Object o) {
        int len = this._removeList.count();
        for (int i = 0; i < len; ++i) {
            int key = (Integer)this._removeList.getKey(i);
            if (key < index) continue;
            this._removeList.add(i, (Object)new Integer(index), o);
            return;
        }
        this._removeList.set((Object)new Integer(index), o);
    }

    public boolean attachView() {
        return true;
    }

    public void detachView() {
    }
}

