/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.Dictionary;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.models.CacheException;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticCacheInterface;
import com.sas.sasserver.mdtable.AbstractChildrenReader;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.table.TableException;
import com.sas.text.Message;

public class Hierarchy
extends ParentNode
implements HierarchyInterface {
    static final long serialVersionUID = 9145422905787686302L;
    private transient HListInterface hli;
    protected static final String RB_KEY = "Hierarchy.";

    public Hierarchy(Dimension dimension, MultidimensionalTableInterface mdDelegate) {
        super(mdDelegate);
        this.setParent(dimension);
    }

    public Hierarchy(Dimension dimension, String name, String label, MultidimensionalTableInterface mdDelegate) throws TableException {
        this(dimension, mdDelegate);
        this.setName(name);
        this.setLabel(label);
        this.reset();
    }

    public void reset() {
        this.hli = null;
        try {
            this.clearCache();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    @Override
    public DimensionInterface getDimension() {
        return (DimensionInterface)((Object)this.getParent());
    }

    @Override
    public int getLevelCount() throws TableException {
        return this.countNodeChildren(0);
    }

    @Override
    public LevelInterface getLevel(int index) throws TableException {
        return this.getLevels(index, 1)[0];
    }

    @Override
    public LevelInterface[] getLevels(int index, int count) throws TableException {
        if (count == -1) {
            count = this.getLevelCount() - index;
        }
        if (count == -1) {
            return new LevelInterface[0];
        }
        SimpleNodeInterface[] si = this.getNodeChildren(index, count);
        if (si == null) {
            throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "noLevel.ex.txt"), (Object)this.getName()));
        }
        LevelInterface[] li = new LevelInterface[si.length];
        for (int i = 0; i < si.length; ++i) {
            li[i] = (LevelInterface)si[i];
        }
        return li;
    }

    @Override
    public HierarchyInterface getMetaHierarchy() {
        return (HierarchyInterface)((Object)this.getDelegate());
    }

    @Override
    protected StaticCacheInterface createCache() {
        return new ChildrenReader();
    }

    class ChildrenReader
    extends AbstractChildrenReader {
        ChildrenReader() {
        }

        @Override
        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            Level[] li = null;
            boolean isAxis = Hierarchy.this.getRootParent() instanceof AxisInterface;
            if (isAxis) {
                try {
                    Hierarchy cubeHier = (Hierarchy)Hierarchy.this.getDelegate();
                    LevelInterface[] cubeLevels = cubeHier.getLevels((int)startOrdinal, (int)(endOrdinal - startOrdinal + 1L));
                    Dictionary levels = Hierarchy.this.Imddb.getAllLevels();
                    li = new Level[cubeLevels.length];
                    for (int i = 0; i < cubeLevels.length; ++i) {
                        Level l = null;
                        if (Hierarchy.this.Imddb instanceof MultidimensionalTableV3Interface) {
                            l = ((MultidimensionalTableV3Interface)Hierarchy.this.Imddb).findLevel(cubeLevels[i].getName());
                            if (l != null) {
                                li[i] = l;
                                li[i].setParent(Hierarchy.this);
                                li[i].setDelegate((ExtendedNodeInterface)((Object)cubeLevels[i]));
                                li[i].clearCache();
                            }
                        } else if (levels.containsKey((Object)cubeLevels[i].getName())) {
                            li[i] = l = (Level)levels.get((Object)cubeLevels[i].getName());
                            li[i].setParent(Hierarchy.this);
                            li[i].setDelegate((ExtendedNodeInterface)((Object)cubeLevels[i]));
                            li[i].clearCache();
                        }
                        if (l != null) continue;
                        li[i] = new Level(Hierarchy.this, null, null, Hierarchy.this.Imddb);
                        li[i].setDelegate((ExtendedNodeInterface)((Object)cubeLevels[i]));
                        levels.set((Object)cubeLevels[i].getName(), (Object)li[i]);
                    }
                }
                catch (TableException te) {
                    te.printStackTrace();
                }
            } else {
                if (Hierarchy.this.hli == null) {
                    Hierarchy.this.hli = Hierarchy.this.Imddb._getLevels(Hierarchy.this.getName());
                }
                if (Hierarchy.this.hli != null) {
                    int count = (int)(endOrdinal - startOrdinal + 1L);
                    if (count > Hierarchy.this.hli.count()) {
                        if (readFully) {
                            throw new CacheException();
                        }
                        count = (int)((long)Hierarchy.this.hli.count() - startOrdinal);
                    }
                    li = new Level[count];
                    int offset = (int)startOrdinal;
                    int i = 0;
                    while (i < count) {
                        String label = Hierarchy.this.hli.getString(offset);
                        String name = Hierarchy.this.hli.getName(offset);
                        Level l = null;
                        if (name == null || name.equals("")) {
                            name = label;
                        }
                        try {
                            l = new Level(Hierarchy.this, name, label, Hierarchy.this.Imddb);
                            l.setOrdinal(offset);
                        }
                        catch (TableException tableException) {
                            // empty catch block
                        }
                        li[i] = l;
                        ++i;
                        ++offset;
                    }
                }
            }
            return li;
        }

        @Override
        public int count() {
            if (this.count == -1) {
                if (Hierarchy.this.getRootParent() instanceof Axis) {
                    try {
                        Hierarchy cubeHier = (Hierarchy)Hierarchy.this.getDelegate();
                        if (cubeHier != null) {
                            this.count = cubeHier.getLevelCount();
                        }
                        this.count = 0;
                    }
                    catch (TableException te) {
                        this.count = -1;
                        return 0;
                    }
                } else {
                    if (Hierarchy.this.hli == null) {
                        Hierarchy.this.hli = Hierarchy.this.Imddb._getLevels(Hierarchy.this.getName());
                    }
                    this.count = Hierarchy.this.hli != null ? Hierarchy.this.hli.count() : 0;
                }
            }
            return this.count;
        }
    }
}

