/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.AssociationList;
import com.sas.sasserver.mdtable.BaseMDInterfaceCustomizerPanel;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.swing.visuals.CheckBoxList;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.LabelView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JScrollPane;

public class CommandsCustomizerPanel
extends BaseMDInterfaceCustomizerPanel {
    public static final String RB_KEY = "CommandsCustomizerPanel.";
    private static String label = com.sas.sasserver.mdtable.RB.getStringResource("CommandsCustomizerPanel.", "label.txt");
    private static String LB = RB.getStringResource("lb.txt");
    private transient CheckBoxList checkBoxList;
    private transient AssociationList commandsList;
    private transient int prevIndex;
    private transient long _commandsMask;

    public static void main(String[] argv) {
        CommandsCustomizerPanel cp = new CommandsCustomizerPanel();
        cp.initialize();
        cp.setVisible(true);
    }

    public CommandsCustomizerPanel() {
        this(com.sas.sasserver.mdtable.RB.getStringResource(RB_KEY, "title.txt"));
    }

    public CommandsCustomizerPanel(String tabName) {
        super(tabName);
    }

    @Override
    protected void createGUI() {
        this.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 0, 5, true, false, false));
        this.setInsets(10, 10, 10, 10);
        this.setList();
        int cnt = this.commandsList.count();
        Object[] cl = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            cl[i] = (String)this.commandsList.get(i);
        }
        this.checkBoxList = new CheckBoxList(cl);
        this.updateCommandsList(917503L);
        JScrollPane scrollPane = new JScrollPane((Component)this.checkBoxList);
        this.checkBoxList.setVisibleRowCount(Math.max(this.checkBoxList.getModel().getSize(), 17));
        LabelView labelView = new LabelView(label);
        this.add(labelView);
        this.add(scrollPane);
        this.setEnabled(false);
    }

    @Override
    public void setObject(Object bean) {
        this.onClear();
        super.setObject(bean);
        this._commandsMask = 917503L;
    }

    @Override
    protected boolean createRuntimeTable() {
        return !this.isRuntimeTableReady() && this.isMetabaseAndDatabaseSet();
    }

    protected boolean canEnable() {
        return this.isRuntimeTableReady() && (this.isMetabaseAndDatabaseSet() || this.isApplicationSet()) && this.getTableInterface() instanceof MultidimensionalTableV2Interface;
    }

    @Override
    protected boolean isModified() {
        return this._commandsMask != this.getCurrentMask();
    }

    private long getCurrentMask() {
        long mask = 917503L;
        int[] indices = this.checkBoxList.getSelectedIndices();
        if (indices.length >= 0) {
            long selectedMask = 0L;
            for (int i = 0; indices.length > i; ++i) {
                selectedMask |= ((Long)this.commandsList.getKey(indices[i])).longValue();
            }
            mask = selectedMask & 0xDFFFFL;
        }
        return mask;
    }

    @Override
    public void onApply() {
        if (!this.isEnabled() || this.isDesignTimeEISApplication() || !this.isModified()) {
            return;
        }
        long mask = this.getCurrentMask();
        if ((this._commandsMask & 0x80000L) > 0L) {
            mask |= 0x80000L;
        }
        if (this.getTableInterface() instanceof MultidimensionalTableV2Interface) {
            ((MultidimensionalTableV2Interface)this.getTableInterface()).setCommandsMask(mask);
        }
    }

    private boolean isDesignTimeEISApplication() {
        try {
            return this.getTableInterface() != this.getRuntimeTableInterface() && this.getTableInterface().getApplication() != null;
        }
        catch (TableException ex) {
            return true;
        }
    }

    @Override
    public void onInitialize() {
        if (this._alreadyInitialized || !this.isRuntimeTableReady() || this.isDesignTimeEISApplication()) {
            return;
        }
        this._alreadyInitialized = true;
        this._commandsMask = ((MultidimensionalTableV2Interface)this.getTableInterface()).getCommandsMask();
        this.updateCommandsList(this._commandsMask);
    }

    @Override
    public void onClear() {
        this._alreadyInitialized = false;
        this.checkBoxList.clearSelection();
        this.checkBoxList.setSelectionInterval(0, this.checkBoxList.getModel().getSize());
        this.setEnabled(false);
    }

    private void setList() {
        this.commandsList = new AssociationList();
        this.commandsList.set((Object)new Long(256L), (Object)RB.getStringResource("drilldown.txt"));
        this.commandsList.set((Object)new Long(128L), (Object)RB.getStringResource("down.txt"));
        this.commandsList.set((Object)new Long(4096L), (Object)RB.getStringResource("up.txt"));
        this.commandsList.set((Object)new Long(512L), (Object)RB.getStringResource("expand.txt"));
        this.commandsList.set((Object)new Long(64L), (Object)RB.getStringResource("collapse.txt"));
        this.commandsList.set((Object)new Long(1024L), (Object)RB.getStringResource("left.txt"));
        this.commandsList.set((Object)new Long(2048L), (Object)RB.getStringResource("right.txt"));
        this.commandsList.set((Object)new Long(1L), (Object)RB.getStringResource("showDetail.txt"));
        this.commandsList.set((Object)new Long(65536L), (Object)RB.getStringResource("query.txt"));
        this.commandsList.set((Object)new Long(32768L), (Object)Message.format((String)RB.getStringResource("find.txt"), (Object)LB));
        this.commandsList.set((Object)new Long(16384L), (Object)Message.format((String)RB.getStringResource("labelSort.txt"), (Object)LB));
        this.commandsList.set((Object)new Long(8192L), (Object)RB.getStringResource("dataSort.txt"));
        this.commandsList.set((Object)new Long(262144L), (Object)RB.getStringResource("filter.txt"));
        this.commandsList.set((Object)new Long(2L), (Object)RB.getStringResource("computedValues.txt"));
        this.commandsList.set((Object)new Long(4L), (Object)RB.getStringResource("totals.txt"));
        this.commandsList.set((Object)new Long(8L), (Object)RB.getStringResource("subsets.txt"));
        this.commandsList.set((Object)new Long(16L), (Object)RB.getStringResource("rangeTypes.txt"));
        this.commandsList.set((Object)new Long(32L), (Object)RB.getStringResource("excel.txt"));
    }

    @Override
    public void updateData() throws TableException {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.onClear();
        if (this.isVisible()) {
            this.onVisible();
        }
    }

    @Override
    public void preCustomizerClosing() {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.isVisible()) {
            this.onHidden();
        }
        this.onClear();
        super.preCustomizerClosing();
    }

    private void updateCommandsList(long commandsMask) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        int cnt = this.commandsList.count();
        for (int i = 0; i < cnt; ++i) {
            long command = (Long)this.commandsList.getKey(i);
            if ((commandsMask & command) == 0L) continue;
            al.add(new Integer(i));
        }
        int[] ia = new int[al.size()];
        int cnt2 = ia.length;
        for (int i = 0; i < cnt2; ++i) {
            ia[i] = (Integer)al.get(i);
        }
        this.checkBoxList.setSelectedIndices(ia);
        if (!this.isEnabled() && this.canEnable()) {
            this.setEnabled(true);
        } else if (this.isEnabled() && !this.canEnable()) {
            this.setEnabled(false);
        }
    }
}

