/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.awt.util.Util;
import com.sas.collection.Dictionary;
import com.sas.mdtable.MemberInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.RemoteDesignTimeBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RemoteObjectCustomizerPanel;
import com.sas.sasserver.mdtable.ComputedValueInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.RangeInterface;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.table.TableException;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JOptionPane;

public abstract class BaseMDInterfaceCustomizerPanel
extends RemoteObjectCustomizerPanel {
    protected transient TableWrapper _table;
    protected transient MultidimensionalTableInterface localInstance;
    protected transient MultidimensionalTableInterface table;
    protected transient boolean dataInitialized;
    transient boolean _preCustomizerClosingCalled;
    transient boolean _appliedOnHide;
    transient boolean _initializedOnShow;
    protected boolean _alreadyInitialized;
    private boolean _createdTable;
    private boolean _customizerClosed;
    private static boolean PRINT_STACK_TRACE = false;

    public BaseMDInterfaceCustomizerPanel(String tabName) {
        super(tabName);
        this.initializeValues();
        this.createGUI();
    }

    protected void initializeValues() {
        this.setInitializedOnShow(true);
        this.setAppliedOnHide(true);
        this.dialogAsynchronous = true;
        this._alreadyInitialized = false;
    }

    protected abstract void createGUI();

    protected MultidimensionalTableInterface getTableInterface() {
        return this.table;
    }

    protected MultidimensionalTableInterface getRuntimeTableInterface() {
        return this.localInstance;
    }

    protected TableWrapper getTableDelegate() {
        return this._table;
    }

    protected boolean isRuntimeTableReady() {
        return this.getRuntimeTableInterface() != null;
    }

    protected boolean createRuntimeTable() {
        return false;
    }

    protected void createRemoteObjectsIfNeeded() {
        if (this.createRuntimeTable()) {
            this.setEnabled(false);
            this.runConnectionThread();
        }
    }

    @Override
    public void setVisible(boolean newValue) {
        if (newValue == this.isVisible()) {
            return;
        }
        if (newValue) {
            this.createRemoteObjectsIfNeeded();
            this.onVisible();
        } else {
            this.onHidden();
        }
        super.setVisible(newValue);
    }

    protected boolean isModified() {
        return false;
    }

    public boolean isAppliedOnHide() {
        return this._appliedOnHide;
    }

    public void setAppliedOnHide(boolean newValue) {
        this._appliedOnHide = newValue;
    }

    public boolean isInitializedOnShow() {
        return this._initializedOnShow;
    }

    public void setInitializedOnShow(boolean newValue) {
        this._initializedOnShow = newValue;
    }

    public void onVisible() {
        if (this.isInitializedOnShow()) {
            this.onInitialize();
        }
    }

    public void onHidden() {
        if (this.isAppliedOnHide()) {
            this.onApply();
        }
    }

    public void onApply() {
    }

    public void onInitialize() {
    }

    public void onClear() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        MultidimensionalTableInterface tableSource = this.isRuntimeTableReady() ? this.getRuntimeTableInterface() : this.getTableInterface();
        String propertyName = event.getPropertyName();
        if (source == tableSource && (com.sas.util.Util.equal((Object)propertyName, (Object)"database") || com.sas.util.Util.equal((Object)propertyName, (Object)"metabase") || com.sas.util.Util.equal((Object)propertyName, (Object)"application"))) {
            this.onClear();
            if (this.isVisible()) {
                this.onVisible();
            }
        }
    }

    protected void showExceptionWarning(Exception ex) {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (PRINT_STACK_TRACE) {
            ex.printStackTrace();
        }
        JOptionPane.showMessageDialog(this, ex.getMessage(), com.sas.util.Util.getCommonStringResource((String)"Warning.txt"), 2);
    }

    @Override
    public void setEnabled(boolean newValue) {
        Util.setEnabledOnContainer(this, newValue);
        super.setEnabled(newValue);
    }

    @Override
    public void setObject(Object bean) {
        if (bean instanceof MultidimensionalTableInterface) {
            if (this.table != null) {
                this.table.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            this.table = (MultidimensionalTableInterface)bean;
            if (this.table != null) {
                this.table.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            this._table = new TableWrapper(this.table);
            if (!(this.table instanceof RemoteDesignTimeBaseClient)) {
                this.localInstance = this.table;
                this._table.setRuntimeTableInterface(this.localInstance);
            }
        }
        super.setObject(bean);
    }

    @Override
    protected void createRemoteObjects() throws Exception {
        super.createRemoteObjects();
        if (this.localInstance != null && this.localInstance instanceof RemoteBaseClient) {
            ((RemoteBaseClient)((Object)this.localInstance)).stop();
        }
        String remoteClass = "com.sas.sasserver.mdtable.MultidimensionalTableInterface";
        if (this.table instanceof MultidimensionalTableV3Interface) {
            remoteClass = "com.sas.sasserver.mdtable.MultidimensionalTableV3Interface";
        } else if (this.table instanceof MultidimensionalTableV2Interface) {
            remoteClass = "com.sas.sasserver.mdtable.MultidimensionalTableV2Interface";
        }
        this.localInstance = (MultidimensionalTableInterface)this.rocf.newInstance(remoteClass, this.connection);
        BaseMDInterfaceCustomizerPanel.initializeTableProperties(this.table, this.localInstance);
        if (this.localInstance instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.localInstance));
        }
        this._table.setRuntimeTableInterface(this.localInstance);
        this._createdTable = true;
    }

    public static final void initializeTableProperties(MultidimensionalTableInterface fromTable, MultidimensionalTableInterface toTable) throws TableException {
        if (fromTable != null && toTable != null) {
            if (fromTable instanceof MultidimensionalTableV3Interface && toTable instanceof MultidimensionalTableV3Interface) {
                MultidimensionalTableV3Interface fromTableV3 = (MultidimensionalTableV3Interface)fromTable;
                MultidimensionalTableV3Interface toTableV3 = (MultidimensionalTableV3Interface)toTable;
                BaseMDInterfaceCustomizerPanel.initializeTableV3Properties(fromTableV3, toTableV3);
            } else {
                toTable.setCoordinatorEnabled(fromTable.isCoordinatorEnabled());
                if (fromTable.getApplication() != null) {
                    toTable.setApplication(fromTable.getApplication());
                } else {
                    if (fromTable.getMetabase() != null) {
                        toTable.setMetabase(fromTable.getMetabase());
                    }
                    if (fromTable.getDatabase() != null) {
                        toTable.setDatabase(fromTable.getDatabase());
                    }
                }
                if (fromTable.getTotals() != null) {
                    toTable.setTotals(fromTable.getTotals());
                }
                if (fromTable.getSubsets() != null) {
                    toTable.setSubsets(fromTable.getSubsets());
                }
                if (fromTable.getRowAxis() != null) {
                    toTable.setRowAxis(fromTable.getRowAxis());
                }
                if (fromTable.getColumnAxis() != null) {
                    toTable.setColumnAxis(fromTable.getColumnAxis());
                }
                if (fromTable.getSelectedMeasures() != null) {
                    toTable.setSelectedMeasures(fromTable.getSelectedMeasures());
                }
                if (fromTable.getSelectedStatistics() != null) {
                    toTable.setSelectedStatistics(fromTable.getSelectedStatistics());
                }
                if (fromTable.getComputedValues() != null) {
                    toTable.setComputedValues(fromTable.getComputedValues());
                }
                if (fromTable.getRanges() != null) {
                    toTable.setRanges(fromTable.getRanges());
                }
            }
        }
    }

    public static final void initializeTableV3Properties(MultidimensionalTableV3Interface fromTableV3, MultidimensionalTableV3Interface toTableV3) throws TableException {
        toTableV3.setCoordinatorEnabled(fromTableV3.isCoordinatorEnabled());
        toTableV3.setStatisticLabelHidden(fromTableV3.isStatisticLabelHidden());
        if (fromTableV3.getApplication() != null) {
            toTableV3.setApplication(fromTableV3.getApplication());
        } else {
            if (fromTableV3.getMetabase() != null) {
                toTableV3.setMetabase(fromTableV3.getMetabase());
            }
            if (fromTableV3.getDatabase() != null) {
                toTableV3.setDatabase(fromTableV3.getDatabase());
            }
        }
        if (fromTableV3.getTotalsProperty() != null) {
            toTableV3.setTotalsProperty(fromTableV3.getTotalsProperty());
        }
        if (fromTableV3.getSubsetsProperty() != null) {
            toTableV3.setSubsetsProperty(fromTableV3.getSubsetsProperty());
        }
        if (fromTableV3.getRowAxis() != null) {
            toTableV3.setRowAxis(fromTableV3.getRowAxis());
        }
        if (fromTableV3.getColumnAxis() != null) {
            toTableV3.setColumnAxis(fromTableV3.getColumnAxis());
        }
        if (fromTableV3.getSelectedMeasures() != null) {
            toTableV3.setSelectedMeasures(fromTableV3.getSelectedMeasures());
        }
        if (fromTableV3.getSelectedStatistics() != null) {
            toTableV3.setSelectedStatistics(fromTableV3.getSelectedStatistics());
        }
        if (fromTableV3.getSelectedMeasures() != null) {
            String[] selectedMeasures = fromTableV3.getMeasures();
            for (int i = 0; selectedMeasures != null && i < selectedMeasures.length; ++i) {
                MemberInterface[] selectedStats = fromTableV3.getSelectedStatistics(selectedMeasures[i]);
                toTableV3.setSelectedStatistics(selectedMeasures[i], selectedStats);
            }
        }
        if (fromTableV3.getComputedValuesProperty() != null) {
            toTableV3.setComputedValuesProperty(fromTableV3.getComputedValuesProperty());
        }
        if (fromTableV3.getRanges() != null) {
            toTableV3.setRanges(fromTableV3.getRanges());
        }
        if (fromTableV3.getSortOrders() != null) {
            toTableV3.setSortOrders(fromTableV3.getSortOrders());
        }
    }

    public void preCustomizerClosing() {
        this._preCustomizerClosingCalled = true;
        if (this.getTableInterface() != null) {
            this.getTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    protected abstract void updateData() throws TableException;

    @Override
    protected void disposeRemoteObjects() {
        if (this._createdTable) {
            super.disposeRemoteObjects();
        }
        this.localInstance = null;
    }

    @Override
    protected void connectionThreadEnding() {
        super.connectionThreadEnding();
        if (!this.wasCancelled() && !this.wasExceptionThrown()) {
            try {
                this.updateData();
            }
            catch (TableException ex) {
                ex.printStackTrace();
            }
            this.firePropertyChange("mdtable", null, this.localInstance);
        }
    }

    protected boolean isMetabaseSet() {
        String mb;
        if (this._table == null) {
            return false;
        }
        try {
            mb = this._table.getMetabase();
        }
        catch (TableException ex) {
            mb = null;
        }
        return mb != null && mb.length() > 0;
    }

    protected boolean isDatabaseSet() {
        String db;
        if (this._table == null) {
            return false;
        }
        try {
            db = this._table.getDatabase();
        }
        catch (TableException ex) {
            db = null;
        }
        return db != null && db.length() > 0;
    }

    protected boolean isMetabaseAndDatabaseSet() {
        return this.isMetabaseSet() && this.isDatabaseSet();
    }

    protected boolean isApplicationSet() {
        String db;
        if (this._table == null) {
            return false;
        }
        try {
            db = this._table.getApplication();
        }
        catch (TableException ex) {
            db = null;
        }
        return db != null && db.length() > 0;
    }

    boolean isRowAxisSet() {
        try {
            if (this.table == null) {
                return false;
            }
            return this.isStringArraySet(this._table.getRowAxis());
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean isColumnAxisSet() {
        try {
            if (this.table == null) {
                return false;
            }
            return this.isStringArraySet(this._table.getColumnAxis());
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean isMeasuresSet() {
        try {
            if (this.table == null) {
                return false;
            }
            return this.isStringArraySet(this._table.getSelectedMeasures());
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean isStatisticsSet() {
        try {
            MultidimensionalTableV2Interface v2Table;
            String[] measures;
            if (this.table == null) {
                return false;
            }
            if (this.isStringArraySet(this._table.getSelectedStatistics())) {
                return true;
            }
            if ((this.table instanceof MultidimensionalTableV2Interface || this.table instanceof MultidimensionalTableV3Interface) && (measures = (v2Table = (MultidimensionalTableV2Interface)this.table).getSelectedMeasures()) != null && measures.length > 0) {
                int cnt = measures.length;
                for (int i = 0; i < cnt; ++i) {
                    if (!this.isMemberInterfaceArraySet(v2Table.getSelectedStatistics(measures[i]))) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isMemberInterfaceArraySet(MemberInterface[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            return true;
        }
        return false;
    }

    private boolean isStringArraySet(String[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || array[i].length() <= 0) continue;
            return true;
        }
        return false;
    }

    void notifyMetabaseOrDatabaseChanged() {
        try {
            if (this.table != null) {
                this.table.setRowAxis(null);
                this.table.setColumnAxis(null);
                this.table.setSelectedMeasures(null);
                this.table.setSelectedStatistics(null);
                this.table.setRanges(null);
                this.table.setTotals(null);
                this.table.setSubsets(null);
                this.table.setComputedValues(null);
            }
        }
        catch (TableException ex) {
            this.showExceptionWarning((Exception)((Object)ex));
        }
    }

    Rocf getRocf() {
        return this.rocf;
    }

    Connection getConnection() {
        return this.connection;
    }

    MultidimensionalTableInterface getMDDB() {
        return this.localInstance;
    }

    void setRemote(Rocf rocf, Connection connection) {
        super.disposeRemoteObjects();
        this.rocf = rocf;
        if (this.connection != null) {
            this.connection.stop();
        }
        this.connection = connection;
    }

    void setMDDB(MultidimensionalTableInterface mdtable) {
        this.localInstance = mdtable;
        this._table.setRuntimeTableInterface(this.localInstance);
        try {
            this.updateData();
        }
        catch (TableException ex) {
            System.out.println((Object)ex);
        }
    }

    void addLinks() {
    }

    @Override
    public void customizerClosing() {
        if (!this._preCustomizerClosingCalled && !this._customizerClosed) {
            this.preCustomizerClosing();
        }
        if (this._createdTable) {
            this.firePropertyChange("customizerClosed", null, null);
        }
        super.customizerClosing();
    }

    public void setCustomizerClosed(boolean newValue) {
        this._customizerClosed = newValue;
    }

    class TableWrapper {
        MultidimensionalTableInterface _localInstance;
        MultidimensionalTableInterface _table;

        public TableWrapper(MultidimensionalTableInterface table) {
            this._table = table;
        }

        public MultidimensionalTableInterface getTableInterface() {
            return this._table;
        }

        public MultidimensionalTableInterface getRuntimeTableInterface() {
            return this._localInstance;
        }

        public void setRuntimeTableInterface(MultidimensionalTableInterface mdtable) {
            this._localInstance = mdtable;
        }

        public void setMDDB(MultidimensionalTableInterface mdtable) {
            this.setRuntimeTableInterface(mdtable);
        }

        public boolean isDifferent() {
            return this.getRuntimeTableInterface() != null && this.getRuntimeTableInterface() != BaseMDInterfaceCustomizerPanel.this.table;
        }

        public void onClear() throws TableException {
            this.setColumnAxis(null);
            this.setRowAxis(null);
            this.setSelectedMeasures(null);
            this.setSelectedStatistics(null);
            if (this.getTableInterface() != this.getRuntimeTableInterface()) {
                MultidimensionalTableInterface dTable = this.getTableInterface();
                if (dTable instanceof MultidimensionalTableV2Interface) {
                    ((MultidimensionalTableV2Interface)dTable).setSubsetsProperty(null);
                    ((MultidimensionalTableV2Interface)dTable).setComputedValuesProperty(null);
                    ((MultidimensionalTableV2Interface)dTable).setTotalsProperty(null);
                }
                dTable.setRanges(null);
                dTable.setSubsets(null);
                dTable.setTotals(null);
            }
        }

        public boolean initializeTable() throws TableException {
            if (BaseMDInterfaceCustomizerPanel.this.isMetabaseAndDatabaseSet() && BaseMDInterfaceCustomizerPanel.this.isRowAxisSet() && BaseMDInterfaceCustomizerPanel.this.isColumnAxisSet() && BaseMDInterfaceCustomizerPanel.this.isMeasuresSet() && BaseMDInterfaceCustomizerPanel.this.isStatisticsSet()) {
                if (this.isDifferent()) {
                    this.getRuntimeTableInterface().initializeTable();
                } else {
                    this.getTableInterface().initializeTable();
                }
                return true;
            }
            return false;
        }

        public void enableEvents() {
            this.getTableInterface().enableEvents();
        }

        public void disableEvents() {
            this.getTableInterface().disableEvents();
        }

        public String getMetabase() throws TableException {
            return this.getTableInterface().getMetabase();
        }

        public void setMetabase(String metabase) throws TableException {
            this.getTableInterface().setMetabase(metabase);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setMetabase(metabase);
            }
        }

        public void setSource(String metabase, String database) throws TableException {
            MultidimensionalTableInterface dTable = this.getTableInterface();
            MultidimensionalTableInterface rTable = this.getRuntimeTableInterface();
            String oldmd = dTable.getMetabase();
            String olddb = dTable.getDatabase();
            if (com.sas.util.Util.unequal((Object)oldmd, (Object)metabase) || com.sas.util.Util.unequal((Object)olddb, (Object)database)) {
                this.onClear();
                dTable.setSource(metabase, database);
                if (this.isDifferent()) {
                    rTable.setSource(metabase, database);
                }
                dTable.setMetabase(metabase);
                dTable.setDatabase(database);
            }
        }

        public String getDatabase() throws TableException {
            return this.getTableInterface().getDatabase();
        }

        public void setDatabase(String database) throws TableException {
            this.getTableInterface().setDatabase(database);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setDatabase(database);
            }
        }

        public String getApplication() throws TableException {
            return this.getTableInterface().getApplication();
        }

        public void setApplication(String application) throws TableException {
            if (com.sas.util.Util.unequal((Object)application, (Object)this.getTableInterface().getApplication())) {
                this.onClear();
            }
            this.getTableInterface().setApplication(application);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setApplication(application);
            }
        }

        public String[] getRowAxis() throws TableException {
            return this.getTableInterface().getRowAxis();
        }

        public void setRowAxis(String[] dimensions) throws TableException {
            this.getTableInterface().setRowAxis(dimensions);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setRowAxis(dimensions);
            }
        }

        public String[] getColumnAxis() throws TableException {
            return this.getTableInterface().getColumnAxis();
        }

        public void setColumnAxis(String[] dimensions) throws TableException {
            this.getTableInterface().setColumnAxis(dimensions);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setColumnAxis(dimensions);
            }
        }

        public String[] getSelectedMeasures() throws TableException {
            return this.getTableInterface().getSelectedMeasures();
        }

        public void setSelectedMeasures(String[] measures) throws TableException {
            this.getTableInterface().setSelectedMeasures(measures);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setSelectedMeasures(measures);
            }
        }

        public String[] getSelectedStatistics() throws TableException {
            return this.getTableInterface().getSelectedStatistics();
        }

        public void setSelectedStatistics(String[] measures) throws TableException {
            this.getTableInterface().setSelectedStatistics(measures);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setSelectedStatistics(measures);
            }
        }

        public MemberInterface[] getSelectedStatistics(String measure) throws TableException {
            if (this.getTableInterface() instanceof MultidimensionalTableV2Interface) {
                return ((MultidimensionalTableV2Interface)this.getTableInterface()).getSelectedStatistics(measure);
            }
            return null;
        }

        public void setSelectedStatistics(String measure, MemberInterface[] stats) throws TableException {
            if (this.getTableInterface() instanceof MultidimensionalTableV3Interface) {
                ((MultidimensionalTableV3Interface)this.getTableInterface()).setSelectedStatistics(measure, stats);
            }
            if (this.isDifferent() && this.getRuntimeTableInterface() instanceof MultidimensionalTableV3Interface) {
                ((MultidimensionalTableV3Interface)this.getRuntimeTableInterface()).setSelectedStatistics(measure, stats);
            }
        }

        public RangeInterface[] getRanges() throws TableException {
            return this.getTableInterface().getRanges();
        }

        public void setRanges(RangeInterface[] ranges) throws TableException {
            this.getTableInterface().setRanges(ranges);
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setRanges(ranges);
            }
        }

        public SubsetInterface[] getSubsets() throws TableException {
            if (this.getTableInterface() instanceof MultidimensionalTableV3Interface) {
                return ((MultidimensionalTableV3Interface)this.getTableInterface()).getSubsetsProperty();
            }
            return this.getTableInterface().getSubsets();
        }

        public void setSubsets(SubsetInterface[] subsets) throws TableException {
            if (this.getTableInterface() instanceof MultidimensionalTableV2Interface) {
                ((MultidimensionalTableV2Interface)this.getTableInterface()).setSubsetsProperty(subsets);
            } else {
                this.getTableInterface().setSubsets(subsets);
            }
            if (this.isDifferent()) {
                if (this.getRuntimeTableInterface() instanceof MultidimensionalTableV2Interface) {
                    ((MultidimensionalTableV2Interface)this.getRuntimeTableInterface()).setSubsetsProperty(subsets);
                } else {
                    this.getRuntimeTableInterface().setSubsets(subsets);
                }
            }
        }

        public TotalInterface[] getTotals() throws TableException {
            MultidimensionalTableInterface mdTable = this.getTableInterface();
            if (mdTable instanceof MultidimensionalTableV3Interface) {
                return ((MultidimensionalTableV3Interface)mdTable).getTotalsProperty();
            }
            return mdTable.getTotals();
        }

        public void setTotals(TotalInterface[] totals) throws TableException {
            MultidimensionalTableInterface mdTable = this.getTableInterface();
            if (mdTable instanceof MultidimensionalTableV2Interface) {
                ((MultidimensionalTableV2Interface)mdTable).setTotalsProperty(totals);
            } else {
                this.getTableInterface().setTotals(totals);
            }
            if (this.isDifferent()) {
                if (this.getRuntimeTableInterface() instanceof MultidimensionalTableV2Interface) {
                    ((MultidimensionalTableV2Interface)this.getRuntimeTableInterface()).setTotalsProperty(totals);
                } else {
                    this.getRuntimeTableInterface().setTotals(totals);
                }
            }
        }

        public MemberInterface[] getMeasureMembersRT() throws TableException {
            if (this.isDifferent()) {
                return this.getRuntimeTableInterface().getMeasureMembers();
            }
            return this.getTableInterface().getMeasureMembers();
        }

        public RangeInterface[] getRangesRT() throws TableException {
            if (this.isDifferent()) {
                return this.getRuntimeTableInterface().getRanges();
            }
            return this.getTableInterface().getRanges();
        }

        public MemberInterface[] getStatisticMembersRT() throws TableException {
            if (this.isDifferent()) {
                return this.getRuntimeTableInterface().getStatisticMembers();
            }
            return this.getTableInterface().getStatisticMembers();
        }

        public Dictionary getAllLevelsRT() throws TableException {
            if (this.isDifferent()) {
                return this.getRuntimeTableInterface().getAllLevels();
            }
            return this.getTableInterface().getAllLevels();
        }

        public SubsetInterface[] getSubsetsRT() throws TableException {
            if (this.isDifferent()) {
                return this.getRuntimeTableInterface().getSubsets();
            }
            return this.getTableInterface().getSubsets();
        }

        public void setSubsetsRT() throws TableException {
            if (this.isDifferent()) {
                this.getRuntimeTableInterface().setSubsets();
            } else {
                this.getTableInterface().setSubsets();
            }
        }

        public ComputedValueInterface[] getComputedValues() throws TableException {
            return this.getTableInterface().getComputedValues();
        }

        public void setComputedValues(ComputedValueInterface[] cv) throws TableException {
            if (this.getTableInterface() instanceof MultidimensionalTableV2Interface) {
                ((MultidimensionalTableV2Interface)this.getTableInterface()).setComputedValuesProperty(cv);
            } else {
                this.getTableInterface().setComputedValues(cv);
            }
            if (this.isDifferent()) {
                if (this.getRuntimeTableInterface() instanceof MultidimensionalTableV2Interface) {
                    ((MultidimensionalTableV2Interface)this.getRuntimeTableInterface()).setComputedValuesProperty(cv);
                } else {
                    this.getRuntimeTableInterface().setComputedValues(cv);
                }
            }
        }

        public String[] getLabelsRT(String dimension) throws TableException {
            if (this.isDifferent()) {
                return this.getRuntimeTableInterface().getLabels(dimension);
            }
            return this.getTableInterface().getLabels(dimension);
        }
    }
}

