/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.logtrap;

import com.sas.rmi.Connection;
import com.sas.rmi.LocalModelInterface;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.inputstream.InputStreamInterface;
import com.sas.sasserver.inputstream.ReadExitInterface;
import com.sas.sasserver.logtrap.LogTrapInterface;
import com.sas.sasserver.submit.SubmitInterface;
import java.io.PrintStream;

public class LogTrapDelegate
implements LocalModelInterface,
ReadExitInterface {
    private transient Rocf m_rocf;
    private transient Connection m_ctxt;
    private transient SubmitInterface m_submit;
    private transient InputStreamInterface m_istream;
    private transient String m_fileref;
    private transient PrintStream m_out;
    private transient LogTrapInterface m_remoteObject;
    private transient RemoteBaseClient m_rbc;

    @Override
    public void _setRemoteHandle(Object o) {
        this.m_remoteObject = (LogTrapInterface)o;
        this.m_rbc = (RemoteBaseClient)o;
        this.m_rocf = this.m_rbc._RemoteObject_getClassFactory();
        this.m_ctxt = this.m_rbc._RemoteObject_getContext();
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public void initialize() {
        if (this.m_out == null) {
            this.m_out = System.out;
        }
        this.startLogTrap();
    }

    public void stop() {
        this.stopLogTrap();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.m_out != null) {
            this.m_out.flush();
        }
        if (this.m_ctxt != null) {
            // empty if block
        }
        if (this.m_istream != null) {
            ((RemoteBaseClient)((Object)this.m_istream)).stop();
        }
        this.m_ctxt = null;
        this.m_istream = null;
        this.m_submit = null;
    }

    public void startLogTrap() {
        this.loadLocals();
        this.m_submit.setProgramText("PROC PRINTTO LOG=" + this.m_fileref + ";RUN;");
    }

    public void stopLogTrap() {
    }

    void loadLocals() {
        try {
            if (this.m_submit == null) {
                this.m_submit = (SubmitInterface)this.m_rocf.newInstance(SubmitInterface.class, this.m_ctxt);
                this.m_istream = (InputStreamInterface)this.m_rocf.newInstance(InputStreamInterface.class, this.m_ctxt);
                this.m_fileref = this.m_istream.makeInputStream(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public InputStreamInterface getInputStream() {
        return this.m_istream;
    }

    public SubmitInterface getSubmit() {
        return this.m_submit;
    }

    @Override
    public void processReadBuffer(byte[] buffer, int len) {
        if (len == 0) {
            return;
        }
        byte[] byteUnicode = new byte[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if (buffer[i] == 0) continue;
            byteUnicode[j] = buffer[i];
            ++j;
        }
        if (this.m_out == null) {
            this.m_out = System.out;
        }
        this.m_out.print(new String(byteUnicode, 0, j));
    }

    public void setPrintStream(PrintStream out) {
        this.m_out = out != null ? out : System.out;
    }
}

