/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.inputstream;

import com.sas.sasserver.inputstream.ReadExitInterface;
import com.sas.security.SecuritySupport;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

public class ThreadedListener
implements Runnable {
    Thread m_thread;
    ServerSocket m_serverSocket;
    Socket m_socket;
    DataInputStream m_in;
    InputStream m_is;
    int m_portNum;
    String m_hostName;
    String m_retVal = "";
    Vector m_lvec = new Vector();
    ReadExitInterface m_readExit;

    public ThreadedListener(ServerSocket serverSocket, ReadExitInterface readExit) {
        this.m_serverSocket = serverSocket;
        this.m_readExit = readExit;
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = SecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        try {
            if (this.m_thread != null) {
                this.m_thread = null;
            }
            Socket tsock = this.m_socket;
            ServerSocket tserv = this.m_serverSocket;
            this.m_socket = null;
            this.m_serverSocket = null;
            if (tsock != null) {
                tsock.close();
            }
            if (tserv != null) {
                tserv.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.m_serverSocket != null) {
            try {
                this.m_socket = SecuritySupport.securitySupport.socketAccept(this.m_serverSocket);
                this.m_is = this.m_socket.getInputStream();
                this.m_in = new DataInputStream(this.m_is);
            }
            catch (SocketException se) {
                this.stop();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.stop();
                return;
            }
            byte[] byteArray = new byte[4096];
            boolean done = false;
            while (!done) {
                try {
                    int len = this.m_in.read(byteArray);
                    boolean bl = done = len < 0;
                    if (!done) {
                        if (this.m_readExit == null || len <= 0) continue;
                        this.m_readExit.processReadBuffer(byteArray, len);
                        continue;
                    }
                    this.m_readExit.processReadBuffer(null, 0);
                }
                catch (SocketException se) {
                    done = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.stop();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }
}

