/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.inputstream;

import com.sas.rmi.Connection;
import com.sas.rmi.LocalModelInterface;
import com.sas.rmi.RMIUtil;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.inputstream.EchoListener;
import com.sas.sasserver.inputstream.InputStreamInterface;
import com.sas.sasserver.inputstream.ReadExitInterface;
import com.sas.sasserver.inputstream.ThreadedListener;
import com.sas.sasserver.submit.SubmitInterface;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class InputStreamDelegate
implements LocalModelInterface {
    private transient Thread m_thread;
    private transient ServerSocket m_serverSocket;
    private transient Socket m_socket;
    private transient DataInputStream m_in;
    private transient InputStream m_is;
    private transient int m_portNum;
    private transient String m_hostName;
    private transient String m_retVal = "";
    private transient SubmitInterface m_submit;
    private static transient int m_count = 0;
    private transient ThreadedListener tl;
    private transient Vector m_lvec = new Vector();
    private transient Connection m_ctxt;
    private transient InputStreamInterface m_remoteObject;
    private transient RemoteBaseClient m_rbc;
    static final String RB_KEY = "DataSetDelegate.";

    @Override
    public void _setRemoteHandle(Object o) {
        this.m_remoteObject = (InputStreamInterface)o;
        this.m_rbc = (RemoteBaseClient)o;
    }

    public String makeInputStream(ReadExitInterface readExit) {
        String fName = "STR" + m_count++;
        try {
            this.m_serverSocket = new ServerSocket(0);
            this.m_hostName = this.getLocalHost();
            this.m_portNum = this.m_serverSocket.getLocalPort();
            String s = "FILENAME " + fName + " SOCKET '" + this.m_hostName + ':' + this.m_portNum + "';";
            ThreadedListener tl = new ThreadedListener(this.m_serverSocket, readExit);
            tl.start();
            this.submit(s);
            this.m_lvec.addElement(tl);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return fName;
    }

    void submit(String s) {
        if (this.m_submit == null) {
            Rocf rocf = this.m_rbc._RemoteObject_getClassFactory();
            this.m_ctxt = this.m_rbc._RemoteObject_getContext();
            try {
                this.m_submit = (SubmitInterface)rocf.newInstance(SubmitInterface.class, this.m_ctxt);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        this.m_submit.setProgramText(s);
    }

    public void stop() {
        if (this.m_ctxt != null) {
            if (this.m_submit != null) {
                this.m_ctxt.stop(this.m_submit);
            }
            this.m_submit = null;
            this.m_ctxt = null;
        }
        if (this.m_lvec != null) {
            for (int i = this.m_lvec.size() - 1; i >= 0; --i) {
                Object o = this.m_lvec.elementAt(i);
                ThreadedListener tl = (ThreadedListener)o;
                tl.stop();
                this.m_lvec.removeElementAt(i);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public String getLocalHost() {
        String s = RMIUtil.getInetAddress().getHostAddress();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Rocf rocf = new Rocf();
        Connection ctxt = new Connection();
        try {
            InputStreamInterface li = (InputStreamInterface)rocf.newInstance(InputStreamInterface.class, ctxt);
            SubmitInterface si = (SubmitInterface)rocf.newInstance(SubmitInterface.class, ctxt);
            String fname = li.makeInputStream(new EchoListener());
            String fname2 = li.makeInputStream(new EchoListener());
            si.setProgramText("PROC PRINTTO LOG=" + fname + ";RUN;");
            si.setProgramText("PROC PRINTTO PRINT=" + fname + ";RUN;");
            si.setProgramText("PROC PRINT DATA=SASUSER.CLASS;RUN;");
            si.setProgramText("PROC PRINT DATA=SASUSER.CRIME;RUN;");
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            rocf.stop();
        }
        System.exit(0);
    }
}

