/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.imdb;

import com.sas.iom.SASGMS.IGMSAppl;
import com.sas.sasserver.imdb.IMDBErrorException;
import com.sas.sasserver.imdb.IMDBException;
import com.sas.sasserver.imdb.IMDBWarningException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StringHolder;

public class IMDBUtil {
    protected IGMSAppl gms = null;
    private transient ORB orb = null;
    private static final String GMSid = "9C186A64-83E4-11D2-B956-00C04F81993C";
    static final String RB_KEY = "IMDB.";

    public void setGMS(IGMSAppl gms) {
        this.gms = gms;
    }

    public IGMSAppl getGMS() {
        return this.gms;
    }

    public void SetContext(IGMSAppl gms, String applicationContext) {
        gms.applicationContext(applicationContext);
    }

    public void SetContext(String applicationContext) {
        this.SetContext(this.gms, applicationContext);
    }

    public String DoRequest(IGMSAppl gms, String request) {
        String retStr = null;
        StringHolder s = new StringHolder();
        try {
            gms.DoRequest(request, s);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        retStr = s.value;
        if (retStr.indexOf("ERROR") == 0) {
            throw new IMDBException(retStr);
        }
        return retStr;
    }

    public String DoRequest(String request) {
        return this.DoRequest(this.gms, request);
    }

    public String[][] DoRequestToArray(IGMSAppl gms, String request, int numColumns) {
        String[][] retArray = null;
        if (numColumns < 0) {
            String[] colTitles = IMDBUtil.getReturnVars(request);
            numColumns = colTitles.length;
        }
        StringHolder s = new StringHolder();
        try {
            gms.DoRequest(request, s);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        String outstr = s.value;
        if (outstr.toUpperCase().indexOf("ERROR") == 0) {
            retArray = new String[1][1];
            retArray[0][0] = outstr;
            throw new IMDBException(outstr);
        }
        if (numColumns == 1 && request.toUpperCase().indexOf("RETURN") == -1 && !request.startsWith("STOREDPROC")) {
            retArray = new String[1][1];
            retArray[0][0] = outstr;
        } else {
            StringTokenizer t = new StringTokenizer(outstr, "^", true);
            int numRecs = t.countTokens();
            try {
                if (numRecs > 0) {
                    numRecs = new Integer(t.nextToken().trim());
                }
                retArray = new String[numRecs][numColumns];
                boolean skip = false;
                for (int i = 0; i < numRecs; ++i) {
                    for (int j = 0; j < numColumns; ++j) {
                        if (!skip) {
                            t.nextToken();
                        }
                        retArray[i][j] = new String(t.nextToken().trim());
                        if (retArray[i][j].equals("^")) {
                            retArray[i][j] = "";
                            skip = true;
                            continue;
                        }
                        skip = false;
                    }
                }
            }
            catch (NumberFormatException e) {
                retArray = new String[1][1];
                retArray[0][0] = outstr;
            }
        }
        return retArray;
    }

    public String[][] DoRequestToArray(String request, int numColumns) {
        return this.DoRequestToArray(this.gms, request, numColumns);
    }

    public static String[] getReturnVars(String request) {
        String[] retCols = null;
        StringTokenizer t = null;
        int numColumns = 0;
        int curpos = request.toLowerCase().lastIndexOf("return");
        if (curpos > 0) {
            t = new StringTokenizer(request.substring(curpos + 6), "^");
            numColumns = t.countTokens();
        }
        retCols = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            retCols[i] = t.nextToken().trim();
        }
        return retCols;
    }

    public static String[] getReturnVars(String request, boolean returnColumnsOnly) {
        String[] retCols = IMDBUtil.getReturnVars(request);
        if (returnColumnsOnly) {
            for (int i = 0; i < retCols.length; ++i) {
                String substr;
                int offset = retCols[i].indexOf(":");
                if (offset == -1) continue;
                retCols[i] = substr = retCols[i].substring(0, offset);
            }
        }
        return retCols;
    }

    protected static String propertiesToUrl(String id, Properties properties) {
        StringBuffer buffer = new StringBuffer("bridge://");
        buffer.append(properties.getProperty("host"));
        buffer.append(":");
        buffer.append(properties.getProperty("port"));
        buffer.append("/");
        buffer.append(id);
        StringBuffer query = null;
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (propertyName.equals("host") || propertyName.equals("port")) continue;
            if (query == null) {
                query = new StringBuffer();
            } else {
                query.append("&");
            }
            query.append(propertyName);
            query.append("=");
            query.append(properties.getProperty(propertyName));
        }
        if (query != null) {
            buffer.append("?");
            buffer.append(query.toString());
        }
        return buffer.toString();
    }

    protected void processException(Exception ex) {
        String errorMessage = ex.getMessage();
        if (errorMessage.length() > 7) {
            int startIndex = errorMessage.indexOf(" ", 7);
            int messageNumber = Integer.parseInt(errorMessage.substring(7, startIndex));
            errorMessage = "ERROR: " + errorMessage.substring(startIndex);
            if (messageNumber > 0) {
                throw new IMDBWarningException(errorMessage, messageNumber);
            }
            throw new IMDBErrorException(errorMessage, messageNumber);
        }
        throw new IMDBException("No message found.");
    }
}

