/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.imdb;

import com.sas.collection.AssociationList;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.Set;
import com.sas.collection.SortedCollection;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.iom.SASGMS.IGMSAppl;
import com.sas.models.BufferHints;
import com.sas.models.SimpleTable;
import com.sas.rmi.gmsstub.GMSStubDelegate;
import com.sas.sasserver.imdb.IMDBColumn;
import com.sas.sasserver.imdb.IMDBUtil;
import com.sas.sasserver.imdb.RB;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.Comparator;
import com.sas.util.GenericComparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class IMDBTableDelegate
extends GMSStubDelegate {
    protected transient OrderedCollection dataSetNames;
    protected transient OrderedCollection dataSetIDs;
    protected transient Dictionary updates;
    protected transient OrderedCollection columnInfos;
    protected transient boolean readOnly;
    protected transient boolean clearModel;
    protected transient String[][] updateTable;
    protected transient String currentQuery;
    protected transient String columnInfoUsed;
    protected transient boolean updateTableOnly;
    protected SimpleTable delegate = new SimpleTable();
    protected IGMSAppl gms;
    protected IMDBUtil imdb;
    static final String RB_KEY = "IMDB.";

    public IMDBTableDelegate() {
        this.initializeAllData();
        this.imdb = new IMDBUtil();
    }

    @Override
    public Object getGMS() {
        if (this.gms == null) {
            this.gms = (IGMSAppl)super.getGMS();
        }
        return this.gms;
    }

    public synchronized void disableEvents() {
        this.delegate.disableEvents();
    }

    public synchronized void enableEvents() {
        this.delegate.enableEvents();
    }

    public synchronized int countColumns(int maxColumnCount) {
        return this.delegate.countColumns(maxColumnCount);
    }

    public synchronized int countRows(int maxRowCount) {
        return this.delegate.countRows(maxRowCount);
    }

    public synchronized Object getCell(int rowIndex, int columnIndex) {
        return this.delegate.getCell(rowIndex, columnIndex);
    }

    public synchronized Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        return this.delegate.getCells(startRowIndex, startColumnIndex, rowCount, columnCount);
    }

    public synchronized Class getCellClass(int rowIndex, int columnIndex) {
        return this.delegate.getCellClass(rowIndex, columnIndex);
    }

    public synchronized Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        return this.delegate.getCellClasses(startRowIndex, startColumnIndex, rowCount, columnCount);
    }

    public synchronized Object[] getColumn(int columnIndex) {
        return this.delegate.getColumn(columnIndex);
    }

    public synchronized int getColumnCount() {
        return this.delegate.getColumnCount();
    }

    public synchronized void setColumnCount(int numColumns) {
        this.delegate.setColumnCount(numColumns);
    }

    public synchronized Object[] getRow(int rowIndex) {
        return this.delegate.getRow(rowIndex);
    }

    public synchronized int getRowCount() {
        return this.delegate.getRowCount();
    }

    public boolean isMultipleColumnUpdateSupported() {
        return this.delegate.isMultipleColumnUpdateSupported();
    }

    public synchronized Object getRowLabel(int rowIndex) {
        return this.delegate.getRowLabel(rowIndex);
    }

    public synchronized Object[] getRowLabels(int startRowIndex, int rowCount) {
        return this.delegate.getRowLabels(startRowIndex, rowCount);
    }

    public boolean isRowLabelsModifiable() {
        return this.delegate.isRowLabelsModifiable();
    }

    public synchronized void setRowLabel(int rowIndex, Object label) {
        this.delegate.setRowLabel(rowIndex, label);
    }

    public boolean isColumnLabelsSupported() {
        return this.delegate.isColumnLabelsSupported();
    }

    public synchronized Object getColumnLabel(int columnIndex) {
        return this.delegate.getColumnLabel(columnIndex);
    }

    public synchronized Object[] getColumnLabels(int startColumnIndex, int columnCount) {
        return this.delegate.getColumnLabels(startColumnIndex, columnCount);
    }

    public boolean isColumnsLabelSupported() {
        return this.delegate.isColumnsLabelSupported();
    }

    public boolean isColumnLabelsModifiable() {
        return this.delegate.isColumnLabelsModifiable();
    }

    public synchronized void setColumnLabel(int columnIndex, Object label) {
        this.delegate.setColumnLabel(columnIndex, label);
    }

    public synchronized Class[] getColumnClasses(int startColumnIndex, int columnCount) {
        return this.delegate.getColumnClasses(startColumnIndex, columnCount);
    }

    public synchronized Class[] getColumnClasses() {
        return this.delegate.getColumnClasses();
    }

    public synchronized Class getColumnClass(int columnIndex) {
        return this.delegate.getColumnClass(columnIndex);
    }

    public synchronized void addColumn(int columnIndex) {
        this.delegate.addColumn(columnIndex);
    }

    public synchronized void addRow(int rowIndex) {
        this.delegate.addRow(rowIndex);
    }

    public synchronized Object getColumnDefaultValue(int columnIndex) {
        return this.delegate.getColumnDefaultValue(columnIndex);
    }

    public synchronized Object[] getColumnDefaultValues(int startColumnIndex, int columnCount) {
        return this.delegate.getColumnDefaultValues(startColumnIndex, columnCount);
    }

    public synchronized void setColumnDefaultValue(int columnIndex, Object newValue) {
        this.delegate.setColumnDefaultValue(columnIndex, newValue);
    }

    public synchronized void setColumnClass(int columnIndex, Class newValue) {
        this.delegate.setColumnClass(columnIndex, newValue);
    }

    public synchronized void setColumnLabelsSupported(boolean p0) {
        this.delegate.setColumnLabelsSupported(p0);
    }

    public synchronized void setRowLabelsSupported(boolean p0) {
        this.delegate.setRowLabelsSupported(p0);
    }

    public synchronized void deleteAllColumns() {
        this.delegate.deleteAllColumns();
    }

    public synchronized void deleteAllRows() {
        this.delegate.deleteAllRows();
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        this.delegate.addContentsChangedListener(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        this.delegate.removeContentsChangedListener(listener);
    }

    public StaticPropertyBagInterface getDefaultCellStyle() {
        return this.delegate.getDefaultCellStyle();
    }

    public void setDefaultCellStyle(StaticPropertyBagInterface newValue) {
        this.delegate.setDefaultCellStyle(newValue);
    }

    public StaticPropertyBagInterface getDefaultColumnStyle() {
        return this.delegate.getDefaultColumnStyle();
    }

    public void setDefaultColumnStyle(StaticPropertyBagInterface newValue) {
        this.delegate.setDefaultColumnStyle(newValue);
    }

    public StaticPropertyBagInterface getDefaultLabelStyle() {
        return this.delegate.getDefaultLabelStyle();
    }

    public void setDefaultLabelStyle(StaticPropertyBagInterface newValue) {
        this.delegate.setDefaultLabelStyle(newValue);
    }

    public StaticPropertyBagInterface getDefaultRowStyle() {
        return this.delegate.getDefaultRowStyle();
    }

    public void setDefaultRowStyle(StaticPropertyBagInterface newValue) {
        this.delegate.setDefaultRowStyle(newValue);
    }

    public StaticPropertyBagInterface getCellStyle(int rowIndex, int columnIndex) {
        return this.delegate.getCellStyle(rowIndex, columnIndex);
    }

    public boolean isCellStylesSupported() {
        return this.delegate.isCellStylesSupported();
    }

    public StaticPropertyBagInterface getColumnLabelStyle(int colIndex) {
        return this.delegate.getColumnLabelStyle(colIndex);
    }

    public boolean isColumnLabelStylesSupported() {
        return this.delegate.isColumnLabelStylesSupported();
    }

    public StaticPropertyBagInterface getColumnStyle(int colIndex) {
        return this.delegate.getColumnStyle(colIndex);
    }

    public boolean isColumnStylesSupported() {
        return this.delegate.isColumnStylesSupported();
    }

    public StaticPropertyBagInterface getRowLabelStyle(int rowIndex) {
        return this.delegate.getRowLabelStyle(rowIndex);
    }

    public boolean isRowLabelStylesSupported() {
        return this.delegate.isRowLabelStylesSupported();
    }

    public boolean isRowLabelsSupported() {
        return this.delegate.isRowLabelsSupported();
    }

    public StaticPropertyBagInterface getRowStyle(int rowIndex) {
        return this.delegate.getRowStyle(rowIndex);
    }

    public boolean isRowStylesSupported() {
        return this.delegate.isRowStylesSupported();
    }

    public String[][] getFormattedCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        if (startColumnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startColumnIndex)));
        }
        if (startRowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startRowIndex)));
        }
        Object[][] cellObjs = this.getCells(startRowIndex, startColumnIndex, rowCount, columnCount);
        String[][] cellStrings = (String[][])cellObjs;
        return cellStrings;
    }

    public void setRow(int rowIndex, Object[] cells) {
        int valuesLength = cells.length;
        if (valuesLength != this.getColumnCount()) {
            String message = RB.getStringResource(RB_KEY, "invalidArraySize.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource(RB_KEY, "invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.updateTableOnly) {
            String[][] item;
            AssociationList updateArray = new AssociationList();
            for (int i = 0; i < this.columnInfos.count(); ++i) {
                Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
                Object[] value = new Object[]{((IMDBColumn)this.columnInfos.get((int)i)).variableID, cells[i]};
                updateArray.add(0, (Object)dataSetID, (Object)value);
            }
            Enumeration e = updateArray.getKeys();
            String updateRequest = "";
            String verifyRequest = "";
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                String relativeRow = "";
                String whenIndex = "";
                String oldWhenValue = "";
                for (int i = 0; i < this.updateTable[0].length; ++i) {
                    if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                        relativeRow = this.updateTable[rowIndex][i];
                        whenIndex = this.updateTable[0][i + 1];
                        oldWhenValue = this.updateTable[rowIndex][i + 1];
                        i = this.updateTable[0].length;
                    }
                    ++i;
                }
                verifyRequest = verifyRequest + "^VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
                updateRequest = updateRequest + "^UPDATE^" + String.valueOf(key) + "^" + relativeRow;
                updateRequest = updateRequest + "^" + whenIndex + "^" + oldWhenValue;
                item = null;
                String last = null;
                try {
                    while (true) {
                        item = (Object[])updateArray.get((Object)key);
                        updateRequest = updateRequest + "^" + String.valueOf(item[0]) + "^" + String.valueOf(item[1]);
                        updateArray.remove((Object)item);
                    }
                }
                catch (NoSuchElementException ex) {
                    last = String.valueOf(item[1]);
                    if (!last.equals("")) continue;
                    updateRequest = updateRequest + "^";
                }
            }
            verifyRequest = verifyRequest.substring(1);
            String request = verifyRequest + updateRequest;
            try {
                item = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        this.updateTableOnly = true;
        this.delegate.setRow(rowIndex, cells);
        this.updateTableOnly = false;
    }

    public void setCell(int rowIndex, int columnIndex, Object cell) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource(RB_KEY, "invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.updateTableOnly) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)(columnIndex - 1))).dataSetID;
            Integer variableID = ((IMDBColumn)this.columnInfos.get((int)(columnIndex - 1))).variableID;
            String request = "";
            String relativeRow = "";
            String whenIndex = "";
            String oldWhenValue = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(dataSetID.toString())) {
                    relativeRow = this.updateTable[rowIndex][i];
                    whenIndex = this.updateTable[0][i + 1];
                    oldWhenValue = this.updateTable[rowIndex][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = "VERIFY^" + String.valueOf(dataSetID) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            request = request + "^UPDATE^" + String.valueOf(dataSetID) + "^" + relativeRow;
            request = request + "^" + whenIndex + "^" + oldWhenValue;
            request = request + "^" + String.valueOf(variableID) + "^" + cell;
            try {
                String[][] i = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        this.delegate.setCell(rowIndex, columnIndex, cell);
    }

    public boolean isRowsInsertable() {
        return false;
    }

    public String getColumnInfoUsed() {
        return this.columnInfoUsed;
    }

    public String getFormattedCell(int p1, int p2) throws TableException {
        Object cellObj = this.getCell(p1, p2);
        String cellString = cellObj.toString();
        return cellString;
    }

    public void setFormattedRow(int rowIndex, String[] cells) {
        this.setRow(rowIndex, cells);
    }

    public int getColumnIndex(String columnName) throws TableException, IllegalArgumentException {
        int index;
        int columnCount = this.getColumnCount();
        boolean found = false;
        for (index = 1; !found && index <= columnCount; ++index) {
            if (!columnName.equalsIgnoreCase((String)this.getColumnInfo(index, "NAME"))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    public void setFormattedColumn(int columnIndex, String[] cells) {
        this.setColumn(columnIndex, cells);
    }

    public boolean isColumnsRedefinable() {
        return false;
    }

    public void setBufferBlocks(int p1) {
        throw new RuntimeException("IMDBTable::setBufferBlocks()");
    }

    public Object getColumnInfo(int index, String columnInfoName) throws TableException {
        int columnIndex;
        String columnInfo;
        String request;
        Integer fileID = ((IMDBColumn)this.columnInfos.get((int)(index - 1))).dataSetID;
        Integer variableID = ((IMDBColumn)this.columnInfos.get((int)(index - 1))).variableID;
        if (fileID == 0) {
            return null;
        }
        if (variableID == 0) {
            if (columnInfoName.equalsIgnoreCase("NAME")) {
                return "OBS";
            }
            return null;
        }
        int iData = this.dataSetIDs.getIndex((Object)fileID, 0);
        String dataSetName = (String)this.dataSetNames.get(iData);
        if (dataSetName.equalsIgnoreCase("UNKNOWN")) {
            request = "DSNAMES^DSID";
            String[][] ret2D = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 2);
            boolean found = false;
            for (int i = 0; !found && i < ret2D.length; ++i) {
                if (!ret2D[i][1].equalsIgnoreCase(fileID.toString())) continue;
                found = true;
                dataSetName = ret2D[i][0];
                this.dataSetNames.set(iData, (Object)dataSetName);
            }
        }
        if (columnInfoName.equalsIgnoreCase("TABLE")) {
            columnInfo = dataSetName;
            return columnInfo;
        }
        if (columnInfoName.equalsIgnoreCase("NAME")) {
            String columnName = ((IMDBColumn)this.columnInfos.get((int)(index - 1))).columnName;
            if (columnName != null) {
                columnInfo = columnName;
                return columnInfo;
            }
            columnIndex = 2;
            request = "VARNAMES^" + dataSetName + "^VARID";
        } else {
            String columnType;
            if (columnInfoName.equalsIgnoreCase("TYPE") && (columnType = ((IMDBColumn)this.columnInfos.get((int)(index - 1))).columnType) != null) {
                columnInfo = columnType;
                return columnInfo;
            }
            request = "VARNAMES^" + dataSetName + "^VARID^" + columnInfoName;
            columnIndex = 3;
        }
        String[][] ret2D = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, columnIndex);
        int position = -1;
        String Index2 = String.valueOf(variableID);
        block1: for (int i = 0; i < ret2D.length; ++i) {
            if (ret2D[i][1].equalsIgnoreCase(Index2)) {
                position = i;
            }
            int count = this.columnInfos.count();
            for (int j = 0; j < count; ++j) {
                if (fileID != ((IMDBColumn)this.columnInfos.get((int)j)).dataSetID || !ret2D[i][1].equalsIgnoreCase(String.valueOf(((IMDBColumn)this.columnInfos.get((int)j)).variableID))) continue;
                IMDBColumn column = (IMDBColumn)this.columnInfos.get(j);
                if (columnInfoName.equalsIgnoreCase("NAME")) {
                    column.columnName = ret2D[i][0];
                    continue block1;
                }
                if (!columnInfoName.equalsIgnoreCase("TYPE")) continue block1;
                column.columnType = ret2D[i][2];
                continue block1;
            }
        }
        columnInfo = columnIndex == 2 ? ret2D[position][0] : ret2D[position][2];
        return columnInfo;
    }

    public void commitRow() {
        throw new RuntimeException("IMDBTable::commitRow()");
    }

    public boolean isMultipleRowUpdateSupported() {
        return this.isCellsModifiable();
    }

    public void addRow(int rowIndex, Object[] cells) {
        String[][] item;
        int valuesLength = cells.length;
        if (valuesLength != this.getColumnCount()) {
            String message = RB.getStringResource(RB_KEY, "invalidArraySize.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.isRowsExtendable()) {
            String message = RB.getStringResource(RB_KEY, "rowsExtendable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.isRowsInsertable() && rowIndex != -1) {
            String message = RB.getStringResource(RB_KEY, "rowsInsertable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        AssociationList updateArray = new AssociationList();
        for (int i = 0; i < this.columnInfos.count(); ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            Object[] value = new Object[]{((IMDBColumn)this.columnInfos.get((int)i)).variableID, cells[i]};
            updateArray.add(0, (Object)dataSetID, (Object)value);
        }
        Enumeration e = updateArray.getKeys();
        String request = "";
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String whenIndex = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    whenIndex = this.updateTable[0][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = request + "^UPDATE^" + String.valueOf(key) + "^-1";
            request = request + "^" + whenIndex + "^0";
            item = null;
            String last = null;
            try {
                while (true) {
                    item = (Object[])updateArray.get((Object)key);
                    request = request + "^" + String.valueOf(item[0]) + "^" + String.valueOf(item[1]);
                    updateArray.remove((Object)item);
                }
            }
            catch (NoSuchElementException ex) {
                last = String.valueOf(item[1]);
                if (!last.equals("")) continue;
                request = request + "^";
            }
        }
        request = request.substring(1);
        try {
            item = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
        }
        catch (Exception ex) {
            String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        rowIndex = this.delegate.getRowCount() + 1;
        this.delegate.addRow(rowIndex, cells);
    }

    public void addRow(int rowIndex, Object[] cells, int uniqueKey) {
        int valuesLength = cells.length;
        if (valuesLength != this.getColumnCount()) {
            String message = RB.getStringResource(RB_KEY, "invalidArraySize.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.isRowsExtendable()) {
            String message = RB.getStringResource(RB_KEY, "rowsExtendable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.isRowsInsertable() && rowIndex != -1) {
            String message = RB.getStringResource(RB_KEY, "rowsInsertable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        AssociationList updateArray = new AssociationList();
        for (int i = 0; i < this.columnInfos.count(); ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            Object[] value = new Object[]{((IMDBColumn)this.columnInfos.get((int)i)).variableID, cells[i]};
            updateArray.add(0, (Object)dataSetID, (Object)value);
        }
        Enumeration e = updateArray.getKeys();
        String request = "";
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String whenIndex = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    whenIndex = this.updateTable[0][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = request + "^UPDATE^" + String.valueOf(key) + "^-1";
            request = request + "^" + whenIndex + "^0";
            Object[] item = null;
            String last = null;
            try {
                while (true) {
                    item = (Object[])updateArray.get((Object)key);
                    request = request + "^" + String.valueOf(item[0]) + "^" + String.valueOf(item[1]);
                    updateArray.remove((Object)item);
                }
            }
            catch (NoSuchElementException ex) {
                last = String.valueOf(item[1]);
                if (!last.equals("")) continue;
                request = request + "^";
            }
        }
        request = request.substring(1);
        try {
            String[][] ret2D = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
            try {
                uniqueKey = Integer.parseInt(ret2D[0][0]);
            }
            catch (Exception ex) {
                uniqueKey = 0;
            }
        }
        catch (Exception ex) {
            String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        rowIndex = this.delegate.getRowCount() + 1;
        this.delegate.addRow(rowIndex, cells);
    }

    public void setColumnInfoUsed(String p1) throws TableException {
        throw new RuntimeException("IMDBTable::setColumnInfoUsed()");
    }

    public void setCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, Object[][] cells) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource(RB_KEY, "invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        AssociationList updateArray = new AssociationList();
        for (int i = startColumnIndex; i < startColumnIndex + columnCount; ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            Object[] value = new Object[2];
            value[0] = ((IMDBColumn)this.columnInfos.get((int)i)).variableID;
            Object[] singleColumn = new Object[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                singleColumn[j] = cells[j][i];
            }
            value[1] = singleColumn;
            updateArray.add(0, (Object)dataSetID, (Object)value);
        }
        Enumeration e = updateArray.getKeys();
        String updateRequest = "";
        String verifyRequest = "";
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String[] relativeRows = new String[rowCount];
            String whenIndex = "";
            String[] oldWhenValues = new String[rowCount];
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    whenIndex = this.updateTable[0][i + 1];
                    for (int j = 0; j < rowCount; ++j) {
                        relativeRows[j] = this.updateTable[j][i];
                        oldWhenValues[j] = this.updateTable[j][i + 1];
                        i = this.updateTable[0].length;
                    }
                }
                ++i;
            }
            for (int j = 0; j < rowCount; ++j) {
                verifyRequest = verifyRequest + "^VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRows[j] + "^" + whenIndex + "^EQ^" + oldWhenValues[j];
                updateRequest = updateRequest + "^UPDATE^" + String.valueOf(key) + "^" + relativeRows[j];
                updateRequest = updateRequest + "^" + whenIndex + "^" + oldWhenValues[j];
                Object[] item = null;
                String last = null;
                try {
                    while (true) {
                        item = (Object[])updateArray.get((Object)key);
                        updateRequest = updateRequest + "^" + String.valueOf(item[0]) + "^" + String.valueOf(((Object[])item[1])[j]);
                        updateArray.remove((Object)item);
                    }
                }
                catch (NoSuchElementException ex) {
                    last = String.valueOf(item[1]);
                    if (!last.equals("")) continue;
                    updateRequest = updateRequest + "^";
                    continue;
                }
            }
        }
        verifyRequest = verifyRequest.substring(1);
        String request = verifyRequest + updateRequest;
        try {
            String[][] j = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
        }
        catch (Exception ex) {
            String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        this.updateTableOnly = true;
        this.delegate.setCells(startRowIndex, startColumnIndex, rowCount, columnCount, cells);
        this.updateTableOnly = false;
    }

    public boolean isCellsModifiable() {
        return !this.isReadOnly();
    }

    public void setFormattedCell(int rowIndex, int columnIndex, String cell) {
        this.setCell(rowIndex, columnIndex, cell);
    }

    public boolean isRowsLabelSupported() {
        return false;
    }

    public boolean isRowsDeletable() {
        if (this.clearModel) {
            return true;
        }
        return this.isCellsModifiable();
    }

    public boolean isColumnsDeletable() {
        return this.clearModel;
    }

    public String getWhere() {
        return this.getQuery();
    }

    public String getQuery() {
        return this.currentQuery;
    }

    public void setColumn(int columnIndex, Object[] cells) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource(RB_KEY, "invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)columnIndex)).dataSetID;
        Integer variableID = ((IMDBColumn)this.columnInfos.get((int)columnIndex)).variableID;
        String updateRequest = "";
        String verifyRequest = "";
        String whenIndex = this.updateTable[0][columnIndex];
        for (int i = 0; i < this.getRowCount(); ++i) {
            String relativeRow = this.updateTable[i + 1][columnIndex];
            String oldWhenValue = this.updateTable[i + 1][columnIndex];
            verifyRequest = verifyRequest + "^VERIFY^" + String.valueOf(dataSetID) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            updateRequest = updateRequest + "^UPDATE^" + String.valueOf(dataSetID) + "^" + relativeRow;
            updateRequest = updateRequest + "^" + whenIndex + "^" + oldWhenValue;
            updateRequest = updateRequest + "^" + String.valueOf(variableID) + "^" + cells[i];
        }
        verifyRequest = verifyRequest.substring(1);
        String request = verifyRequest + updateRequest;
        try {
            String[][] i = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
        }
        catch (Exception ex) {
            String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        this.updateTableOnly = true;
        this.delegate.setColumn(columnIndex, cells);
        this.updateTableOnly = false;
    }

    public void deleteRow(int rowIndex) {
        if (this.clearModel) {
            this.delegate.deleteRow(rowIndex);
            return;
        }
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource(RB_KEY, "invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        Set files = new Set();
        for (int i = 0; i < this.columnInfos.count(); ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            files.add((Object)dataSetID);
        }
        Enumeration e = files.getItems();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String relativeRow = "";
            String whenIndex = "";
            String oldWhenValue = "";
            String request = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    relativeRow = this.updateTable[rowIndex][i];
                    whenIndex = this.updateTable[0][i + 1];
                    oldWhenValue = this.updateTable[rowIndex][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = request + "VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            request = request + "^DELETE^" + String.valueOf(key) + "^" + relativeRow;
            try {
                String[][] i = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        this.delegate.deleteRow(rowIndex);
    }

    public void deleteRow(int rowIndex, OrderedCollection filesIncludedInDeletion) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource(RB_KEY, "invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        Set files = new Set();
        for (int i = 0; i < this.columnInfos.count(); ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            if (!filesIncludedInDeletion.contains((Object)dataSetID)) continue;
            files.add((Object)dataSetID);
        }
        Enumeration e = files.getItems();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String relativeRow = "";
            String whenIndex = "";
            String oldWhenValue = "";
            String request = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    relativeRow = this.updateTable[rowIndex][i];
                    whenIndex = this.updateTable[0][i + 1];
                    oldWhenValue = this.updateTable[rowIndex][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = request + "VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            request = request + "^DELETE^" + String.valueOf(key) + "^" + relativeRow;
            try {
                String[][] i = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource(RB_KEY, "updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        this.delegate.deleteRow(rowIndex);
    }

    public String[] getFormattedRow(int rowIndex) {
        Object[] rowObj = this.getRow(rowIndex);
        String[] rowString = new String[rowObj.length];
        for (int i = 0; i < rowObj.length; ++i) {
            rowString[i] = rowObj[i].toString();
        }
        return rowString;
    }

    public boolean isColumnsExtendable() {
        return false;
    }

    public void addColumn(int p1, Class p2, Object p3) {
        String message = RB.getStringResource(RB_KEY, "columnsExtendableInsertable.ex.txt");
        throw new IllegalArgumentException(message);
    }

    public void useBufferHints(BufferHints p1) {
        throw new RuntimeException("IMDBTable::useBufferHints()");
    }

    public String[] getFormattedColumn(int columnIndex) {
        Object[] columnObj = this.getColumn(columnIndex);
        String[] columnString = new String[columnObj.length];
        for (int i = 0; i < columnObj.length; ++i) {
            columnString[i] = columnObj[i].toString();
        }
        return columnString;
    }

    public void deleteColumn(int p1) {
        if (!this.isColumnsDeletable()) {
            String message = RB.getStringResource(RB_KEY, "columnsDeletable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        this.delegate.deleteColumn(p1);
    }

    public void setReadOnly(boolean readOnly) {
        if (this.currentQuery != null) {
            String message = RB.getStringResource(RB_KEY, "setReadOnlyFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        this.readOnly = readOnly;
        String requestUpdateInfo = "select^0^3^UPEQ^WHEN^return^2^4";
        String[][] result = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), requestUpdateInfo, 2);
        for (int j = 0; j < result.length; ++j) {
            this.updates.set((Object)result[j][0], (Object)result[j][1]);
        }
    }

    public void close() {
        throw new RuntimeException("IMDBTable::close()");
    }

    public boolean isColumnsInsertable() {
        return false;
    }

    public void setDisplayedColumns(String[] p1) {
        throw new RuntimeException("IMDBTable::setDisplayedColumns()");
    }

    public int count() {
        throw new RuntimeException("IMDBTable::count()");
    }

    public int getBufferBlocks() {
        throw new RuntimeException("IMDBTable::getBufferBlocks()");
    }

    public int getBufferSize() {
        throw new RuntimeException("IMDBTable::getBufferSize()");
    }

    public void setBufferSize(int p1) {
        throw new RuntimeException("IMDBTable::setBufferSize()");
    }

    public String[] getDisplayedColumns() {
        throw new RuntimeException("IMDBTable::getDisplayedColumns()");
    }

    public void refresh() {
        this.setQuery(this.currentQuery);
    }

    public String[] getColumnInfoNames() throws TableException {
        throw new RuntimeException("IMDBTable::getColumnInfoNames()");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setFormattedCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, String[][] cells) {
        this.setCells(startRowIndex, startColumnIndex, rowCount, columnCount, cells);
    }

    public boolean isRowsExtendable() {
        return this.isCellsModifiable();
    }

    public void setWhere(String request) {
        this.setQuery(request);
    }

    public void setQuery(String request) {
        int i;
        StringTokenizer t;
        String[] returnVars = IMDBUtil.getReturnVars(request, true);
        this.clearAllData();
        this.currentQuery = request;
        boolean multiple = false;
        if (returnVars.length > 0) {
            t = new StringTokenizer(returnVars[0], ".");
            if (t.countTokens() > 1) {
                multiple = true;
            } else {
                multiple = false;
                StringTokenizer t2 = new StringTokenizer(request, "^");
                t2.nextToken();
                this.dataSetIDs.add((Object)Integer.valueOf(t2.nextToken()));
                this.dataSetNames.add((Object)"UNKNOWN");
            }
        }
        for (int i2 = 0; i2 < returnVars.length; ++i2) {
            IMDBColumn columnInfo;
            if (multiple) {
                t = new StringTokenizer(returnVars[i2], ".");
                columnInfo = new IMDBColumn();
                columnInfo.dataSetID = Integer.valueOf(t.nextToken());
                columnInfo.variableID = Integer.valueOf(t.nextToken());
                this.columnInfos.append(i2, (Object)columnInfo);
                if (!this.dataSetIDs.contains((Object)columnInfo.dataSetID)) {
                    this.dataSetIDs.add((Object)columnInfo.dataSetID);
                    this.dataSetNames.add((Object)"UNKNOWN");
                }
            } else {
                columnInfo = new IMDBColumn();
                columnInfo.dataSetID = (Integer)this.dataSetIDs.get(0);
                columnInfo.variableID = Integer.valueOf(returnVars[i2]);
                this.columnInfos.append(i2, (Object)columnInfo);
            }
            this.delegate.addColumn(i2 + 1, String.class, null);
            this.setColumnLabel(i2 + 1, returnVars[i2]);
        }
        int count = 0;
        String[] updateRow0 = new String[this.dataSetIDs.count() * 2];
        if (!this.readOnly) {
            SortedCollection sortedDataSetIDs = new SortedCollection(this.dataSetIDs.getItems(), (Comparator)GenericComparator.defaultInstance, false);
            for (i = 0; i < sortedDataSetIDs.count(); ++i) {
                String when;
                String obs = sortedDataSetIDs.get(i).toString();
                try {
                    when = (String)this.updates.get((Object)obs);
                }
                catch (NoSuchElementException e) {
                    String message = RB.getStringResource(RB_KEY, "missingWHEN.ex.txt");
                    throw new IllegalArgumentException(message);
                }
                request = request + "^" + obs + ".0";
                request = request + "^" + obs + "." + when;
                count += 2;
                updateRow0[i * 2] = obs;
                updateRow0[i * 2 + 1] = when;
            }
        }
        String[][] ret2D = this.imdb.DoRequestToArray((IGMSAppl)this.getGMS(), request, returnVars.length + count);
        if (!this.readOnly) {
            this.updateTable = new String[ret2D.length + 1][count];
            this.updateTable[0] = updateRow0;
        }
        for (i = 0; i < ret2D.length; ++i) {
            if (!this.readOnly) {
                int j;
                String[] newRow = new String[returnVars.length];
                for (j = 0; j < returnVars.length; ++j) {
                    newRow[j] = ret2D[i][j];
                }
                this.delegate.addRow(i + 1, newRow);
                for (j = 0; j < count; ++j) {
                    this.updateTable[i + 1][j] = ret2D[i][j + returnVars.length];
                }
                continue;
            }
            this.delegate.addRow(i + 1, ret2D[i]);
        }
    }

    protected synchronized void initializeAllData() {
        this.columnInfos = new OrderedCollection();
        this.dataSetNames = new OrderedCollection();
        this.dataSetIDs = new OrderedCollection();
        this.updates = new Dictionary();
        this.readOnly = true;
        this.clearModel = false;
        this.currentQuery = null;
        this.updateTableOnly = false;
    }

    protected synchronized void clearAllData() {
        this.columnInfos.removeAll();
        this.dataSetNames.removeAll();
        this.dataSetIDs.removeAll();
        this.clearModel = true;
        this.delegate.deleteAllRows();
        this.delegate.deleteAllColumns();
        this.clearModel = false;
        this.currentQuery = null;
    }
}

