/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.datawizard;

import com.sas.rmi.Template;
import com.sas.sasserver.datawizard.Delegate;
import com.sas.sasserver.datawizard.Final;
import com.sas.sasserver.datawizard.Interface;
import com.sas.sasserver.datawizard.InterfaceBeanInfo;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;

public class DataWiz {
    String m_datasetName;
    String m_packageName;
    String m_className;
    String m_homeDir;
    String m_dfSource;
    String m_dfEntry;
    String[] m_cols;
    Class[] m_colTypes;

    public void setSourceEntry(String name) {
        this.m_dfSource = name;
    }

    public void setDataformEntry(String name) {
        this.m_dfEntry = name;
    }

    public void setDatasetName(String name) {
        this.m_datasetName = name;
    }

    public void setClassName(String name) {
        if (name == null) {
            this.m_className = null;
        } else {
            int pos = name.lastIndexOf(".");
            if (pos >= 0) {
                this.m_packageName = name.substring(0, pos);
                this.m_className = name.substring(pos + 1);
            } else {
                this.m_packageName = null;
                this.m_className = name;
            }
        }
    }

    public void setHomeDir(String name) {
        this.m_homeDir = name;
        if (!this.m_homeDir.endsWith("/")) {
            this.m_homeDir = this.m_homeDir + "/";
        }
    }

    public void setSelectedColumns(String[] cols) {
        this.m_cols = cols;
    }

    public void setSelectedColumns(String[] cols, Class[] colTypes) {
        this.m_cols = cols;
        for (int i = 0; i < this.m_cols.length; ++i) {
            this.m_cols[i] = this.m_cols[i].toUpperCase();
        }
        this.m_colTypes = colTypes;
    }

    public void generate() throws Exception {
        if (this.m_datasetName == null) {
            throw new Exception("Dataset name must be set");
        }
        if (this.m_className == null) {
            throw new Exception("Class name must be set");
        }
        if (this.m_homeDir == null) {
            throw new Exception("Home directory must be set");
        }
        if (this.m_cols == null || this.m_cols.length == 0) {
            throw new Exception("Selected columns must be set");
        }
        Template template = new Interface();
        this.gen(template, "", "Interface");
        template = new InterfaceBeanInfo();
        this.gen(template, "", "InterfaceBeanInfo");
        template = new Delegate();
        this.gen(template, "", "Delegate");
        template = new Final();
        this.gen(template, "FinalRemoteDesignTime", "");
    }

    protected void gen(Template template, String prefix, String suffix) throws IOException {
        String[] lines = template.getTemplate();
        String separator = "%";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(baos));
        for (int line = 0; line < lines.length; ++line) {
            String trimLine = lines[line].trim();
            if (trimLine.startsWith("#")) continue;
            int startPos = lines[line].indexOf(separator);
            while (startPos >= 0) {
                int endPos = lines[line].indexOf(separator, startPos + 1);
                if (endPos >= 0) {
                    if (startPos > 0) {
                        out.print(lines[line].substring(0, startPos));
                    }
                    String tag = lines[line].substring(startPos + 1, endPos);
                    this.processTag(tag, out);
                    if (endPos + 1 < lines[line].length()) {
                        lines[line] = lines[line].substring(endPos + 1);
                        startPos = lines[line].indexOf(separator);
                        continue;
                    }
                    startPos = -1;
                    lines[line] = "";
                    continue;
                }
                startPos = -1;
            }
            out.println(lines[line]);
        }
        out.flush();
        out.close();
        String fname = this.m_homeDir;
        if (this.m_packageName != null) {
            fname = fname + this.m_packageName.replace('.', '/') + "/";
        }
        fname = fname + prefix + this.m_className + suffix + ".java";
        System.out.println("Writing " + fname);
        FileOutputStream fos = new FileOutputStream(fname);
        fos.write(baos.toByteArray());
        fos.close();
    }

    protected void processTag(String tag, PrintWriter out) throws IOException {
        if (tag.equalsIgnoreCase("NAME")) {
            out.print(this.m_className);
        } else if (tag.equalsIgnoreCase("FULLNAME")) {
            String s = "";
            if (this.m_packageName != null) {
                s = this.m_packageName + ".";
            }
            s = s + this.m_className;
            out.print(s);
        } else if (tag.equalsIgnoreCase("DATASET")) {
            out.print(this.m_datasetName);
        } else if (tag.equalsIgnoreCase("SETSOURCE")) {
            if (this.m_dfSource != null) {
                out.print("m_proxy.setSource(\"" + this.m_dfSource + "\");");
            }
        } else if (tag.equalsIgnoreCase("SETENTRY")) {
            if (this.m_dfEntry != null) {
                out.print("m_proxy.setEntry(\"" + this.m_dfEntry + "\");");
            }
        } else if (tag.equalsIgnoreCase("SETSOURCEFINAL")) {
            if (this.m_dfSource != null) {
                out.print("setSource(\"" + this.m_dfSource + "\");");
            }
        } else if (tag.equalsIgnoreCase("SETENTRYFINAL")) {
            if (this.m_dfEntry != null) {
                out.print("setEntry(\"" + this.m_dfEntry + "\");");
            }
        } else if (tag.equalsIgnoreCase("TIMESTAMP")) {
            out.print(new Date().toString());
        } else if (tag.equalsIgnoreCase("PACKAGE")) {
            if (this.m_packageName != null) {
                out.print("package " + this.m_packageName + ";");
            }
        } else if (tag.equalsIgnoreCase("COLUMNS")) {
            String s = "";
            for (int i = 0; i < this.m_cols.length; ++i) {
                if (i > 0) {
                    s = s + ",";
                }
                s = s + "\"" + this.m_cols[i] + "\"";
            }
            out.print(s);
        } else if (tag.equalsIgnoreCase("INTERFACE_PROPERTIES")) {
            for (int i = 0; i < this.m_cols.length; ++i) {
                out.println("  String getFormatted" + this.m_cols[i] + "();");
                out.println("  void   setFormatted" + this.m_cols[i] + "(String value);");
                out.println("");
                if (this.m_colTypes == null) continue;
                if (this.m_colTypes[i] == Double.class) {
                    out.println("  double get" + this.m_cols[i] + "();");
                    out.println("  void   set" + this.m_cols[i] + "(double value);");
                } else {
                    out.println("  String get" + this.m_cols[i] + "();");
                    out.println("  void   set" + this.m_cols[i] + "(String value);");
                }
                out.println("");
            }
        } else if (tag.equalsIgnoreCase("DELEGATE_METHODS")) {
            for (int i = 0; i < this.m_cols.length; ++i) {
                out.println("  public String getFormatted" + this.m_cols[i] + "()");
                out.println("  {");
                out.println("    return m_proxy._getColumnValue(\"" + this.m_cols[i] + "\");");
                out.println("  }");
                out.println("  public void   setFormatted" + this.m_cols[i] + "(String value)");
                out.println("  {");
                out.println("    m_proxy._setColumnValue(\"" + this.m_cols[i] + "\", value);");
                out.println("  }");
                out.println("");
                if (this.m_colTypes == null) continue;
                if (this.m_colTypes[i] == Double.class) {
                    out.println("  public double get" + this.m_cols[i] + "()");
                    out.println("  {");
                    out.println("    return m_proxy._getRawColumnDoubleValue(\"" + this.m_cols[i] + "\");");
                    out.println("  }");
                    out.println("  public void   set" + this.m_cols[i] + "(double value)");
                    out.println("  {");
                    out.println("    m_proxy._setRawColumnValue(\"" + this.m_cols[i] + "\", value);");
                    out.println("  }");
                } else {
                    out.println("  public String get" + this.m_cols[i] + "()");
                    out.println("  {");
                    out.println("    return m_proxy._getRawColumnValue(\"" + this.m_cols[i] + "\");");
                    out.println("  }");
                    out.println("  public void   set" + this.m_cols[i] + "(String value)");
                    out.println("  {");
                    out.println("    m_proxy._setRawColumnValue(\"" + this.m_cols[i] + "\", value);");
                    out.println("  }");
                }
                out.println("");
            }
        } else {
            throw new IOException("Unknown template tag: " + tag);
        }
    }
}

