/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.datasetinfo;

import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.NodeIcon;
import com.sas.models.SimpleNodeInterface;
import com.sas.sasserver.SASListNodeDelegate;
import com.sas.sasserver.datasetinfo.DataSetInfoInterface;
import com.sas.sasserver.datasetinfo.RB;
import com.sas.table.TableException;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;

public class DataSetInfoDelegate
extends SASListNodeDelegate {
    private transient DataSetInfoInterface m_remoteObject;
    protected transient String dataSetName;
    protected transient Dictionary variableInfoCache = new Dictionary();
    static final String RB_KEY = "DataSetInfoDelegate.";
    protected OrderedCollectionInterface infoOrder;

    @Override
    public synchronized void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.m_remoteObject = (DataSetInfoInterface)this.remoteObject();
    }

    public DataSetInfoInterface getRemoteHandle() {
        return this.m_remoteObject;
    }

    public synchronized void setDataSet(String dataSetName) {
        this.m_remoteObject._setDataSet(dataSetName);
        this.dataSetName = this.m_remoteObject._getDataSet();
        this.variableInfoCache.removeAll();
        this.fireContentsChanged();
        this.firePropertyChange("dataSet", null, this.dataSetName);
    }

    public synchronized String getDataSet() {
        return this.dataSetName;
    }

    protected HListInterface readVariableInfo(int variableIndex) {
        HListInterface variableInfoList;
        Integer index = new Integer(variableIndex);
        if (this.variableInfoCache.containsKey((Object)index)) {
            variableInfoList = (HList)this.variableInfoCache.get((Object)index);
        } else {
            variableInfoList = this.m_remoteObject._getColumnInfo(variableIndex);
            this.variableInfoCache.set((Object)index, (Object)variableInfoList);
        }
        return variableInfoList;
    }

    public synchronized String getVariableFormat(int variableIndex) {
        HList variableInfoList = (HList)this.readVariableInfo(variableIndex);
        return variableInfoList.getString("FORMAT");
    }

    public synchronized String getVariableInformat(int variableIndex) {
        HList variableInfoList = (HList)this.readVariableInfo(variableIndex);
        return variableInfoList.getString("INFORMAT");
    }

    public synchronized String getVariableLabel(int variableIndex) {
        HList variableInfoList = (HList)this.readVariableInfo(variableIndex);
        return variableInfoList.getString("LABEL");
    }

    public synchronized int getVariableLength(int variableIndex) {
        HList variableInfoList = (HList)this.readVariableInfo(variableIndex);
        return (int)variableInfoList.getDouble("LENGTH");
    }

    public synchronized String getVariableName(int variableIndex) {
        HList variableInfoList = (HList)this.readVariableInfo(variableIndex);
        return variableInfoList.getString("NAME");
    }

    public synchronized int getVariableIndex(String variableName) {
        return this.m_remoteObject._getColumnIndex(variableName);
    }

    public synchronized Class getVariableClass(int variableIndex) {
        HList variableInfoList = (HList)this.readVariableInfo(variableIndex);
        String type = variableInfoList.getString("CLASS");
        return type.startsWith("C") ? String.class : Double.class;
    }

    public synchronized String[] getVariableUniqueValues(int variableIndex) {
        int index;
        HList variableInfoList = (HList)this.readVariableInfo(variableIndex);
        HList uniqueValues = (HList)variableInfoList.getList(index = variableInfoList.find("VALUES", 1, 1));
        if (uniqueValues == null) {
            uniqueValues = (HList)this.m_remoteObject._getColumnUniqueValues(variableIndex);
            variableInfoList.setItem(index, (HListInterface)uniqueValues);
        }
        Object[] uniqueValuesArray = uniqueValues.toArray();
        String[] uniqueValuesStringArray = new String[uniqueValuesArray.length];
        for (int i = 0; i < uniqueValuesArray.length; ++i) {
            uniqueValuesStringArray[i] = uniqueValuesArray[i].toString();
        }
        return uniqueValuesStringArray;
    }

    @Override
    public synchronized int getNodeChildCount() {
        return this.count();
    }

    @Override
    public synchronized SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        int nodeChildCount = this.getNodeChildCount();
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        for (int index = startIndex; index < startIndex + count && index < startIndex + nodeChildCount; ++index) {
            NodeIcon node = new NodeIcon(this.getVariableName(index + 1));
            node.setDefaultIcon(new ImageView(Resources.getImage((String)"Column")));
            childrenArray[index - startIndex] = node;
        }
        return childrenArray;
    }

    @Override
    public synchronized boolean isLeafNode() {
        return this.getNodeChildCount() == 0;
    }

    @Override
    public synchronized String getNodeText() {
        return this.getDataSet();
    }

    @Override
    public synchronized IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"DataSet"));
    }

    public void setDefaultValues() {
        this.infoOrder = new OrderedCollection();
        this.infoOrder.add((Object)"NAME");
        this.infoOrder.add((Object)"LABEL");
        this.infoOrder.add((Object)"FORMAT");
        this.infoOrder.add((Object)"INFORMAT");
        this.infoOrder.add((Object)"CLASS");
        this.infoOrder.add((Object)"INDEX");
        this.infoOrder.add((Object)"LENGTH");
    }

    public synchronized OrderedCollectionInterface getInfoOrder() {
        return this.infoOrder;
    }

    public synchronized void setInfoOrder(OrderedCollectionInterface infoOrder) {
        this.infoOrder = infoOrder;
    }

    public synchronized int countColumns(int maxCount) throws TableException {
        return this.getColumnCount();
    }

    public synchronized int countRows(int maximumRowCount) throws TableException {
        return this.getRowCount();
    }

    public synchronized Object getCell(int rowIndex, int columnIndex) throws TableException {
        String infoItem = (String)this.infoOrder.get(columnIndex - 1);
        if (infoItem == "NAME") {
            return this.getVariableName(rowIndex);
        }
        if (infoItem == "LABEL") {
            return this.getVariableLabel(rowIndex);
        }
        if (infoItem == "FORMAT") {
            return this.getVariableFormat(rowIndex);
        }
        if (infoItem == "INFORMAT") {
            return this.getVariableInformat(rowIndex);
        }
        if (infoItem == "CLASS") {
            return this.getVariableClass(rowIndex);
        }
        if (infoItem == "INDEX") {
            return new Integer(rowIndex);
        }
        if (infoItem == "LENGTH") {
            return new Integer(this.getVariableLength(rowIndex));
        }
        throw new IllegalArgumentException();
    }

    public synchronized Class getCellClass(int rowIndex, int columnIndex) throws TableException {
        return this.getColumnClass(columnIndex);
    }

    public synchronized Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Class[][] types = new Class[rowCount][columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            Class columnClass = this.getColumnClass(startColumnIndex + c - 1);
            for (int r = 1; r <= rowCount; ++r) {
                types[r - 1][c - 1] = columnClass;
            }
        }
        return types;
    }

    public synchronized Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Object[][] cells = new Object[rowCount][columnCount];
        for (int r = 1; r <= rowCount; ++r) {
            for (int c = 1; c <= columnCount; ++c) {
                cells[r - 1][c - 1] = this.getCell(startRowIndex + r - 1, startColumnIndex + c - 1);
            }
        }
        return cells;
    }

    public synchronized Object[] getColumn(int columnIndex) throws TableException {
        int rowCount = this.getRowCount();
        Object[] cells = new Object[rowCount];
        for (int r = 1; r <= rowCount; ++r) {
            cells[r - 1] = this.getCell(r, columnIndex);
        }
        return cells;
    }

    public synchronized int getColumnCount() throws TableException {
        return this.infoOrder.count();
    }

    public synchronized Object[] getRow(int rowIndex) throws TableException {
        int columnCount = this.getColumnCount();
        Object[] cells = new Object[columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            cells[c - 1] = this.getCell(c, rowIndex);
        }
        return cells;
    }

    public synchronized int getRowCount() throws TableException {
        return this.count();
    }

    public synchronized Class getColumnClass(int columnIndex) throws TableException {
        String infoItem = (String)this.infoOrder.get(columnIndex - 1);
        if (infoItem == "NAME" || infoItem == "LABEL" || infoItem == "FORMAT" || infoItem == "INFORMAT") {
            return String.class;
        }
        if (infoItem == "CLASS") {
            return Class.class;
        }
        if (infoItem == "INDEX" || infoItem == "LENGTH") {
            return Integer.class;
        }
        throw new IllegalArgumentException();
    }

    public synchronized Class[] getColumnClasses(int startColumnIndex, int columnCount) throws TableException {
        Class[] types = new Class[columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            types[c - 1] = this.getColumnClass(startColumnIndex + c - 1);
        }
        return types;
    }

    public synchronized Object getColumnLabel(int columnIndex) throws TableException {
        String infoItem = (String)this.infoOrder.get(columnIndex - 1);
        if (infoItem == "NAME") {
            return RB.getStringResource(RB_KEY, "NAME.txt");
        }
        if (infoItem == "LABEL") {
            return RB.getStringResource(RB_KEY, "LABEL.txt");
        }
        if (infoItem == "FORMAT") {
            return RB.getStringResource(RB_KEY, "FORMAT.txt");
        }
        if (infoItem == "INFORMAT") {
            return RB.getStringResource(RB_KEY, "INFORMAT.txt");
        }
        if (infoItem == "CLASS") {
            return RB.getStringResource(RB_KEY, "CLASS.txt");
        }
        if (infoItem == "INDEX") {
            return RB.getStringResource(RB_KEY, "INDEX.txt");
        }
        if (infoItem == "LENGTH") {
            return RB.getStringResource(RB_KEY, "LENGTH.txt");
        }
        throw new IllegalArgumentException();
    }

    public synchronized Object[] getColumnLabels(int startColumnIndex, int columnCount) throws TableException {
        Object[] labels = new Object[columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            labels[c - 1] = this.getVariableLabel(startColumnIndex + c - 1);
        }
        return labels;
    }

    public synchronized boolean isColumnLabelsSupported() throws TableException {
        return true;
    }

    public synchronized boolean isColumnsLabelSupported() throws TableException {
        return false;
    }
}

