/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.dataset;

import com.sas.GlobalInfoTable;
import com.sas.models.NodeIcon;
import com.sas.models.SimpleNodeInterface;
import com.sas.sasserver.SASListNode;
import com.sas.sasserver.datasetinfo.DataSetInfoInterface;
import java.util.Enumeration;

public class SASDataSetNode
extends SASListNode {
    protected String datasetName;
    protected DataSetInfoInterface datasetInfo;

    public SASDataSetNode() {
        this.setIconNames("DataSet", "DataSet");
    }

    public SASDataSetNode(String text) {
        super(text);
        this.datasetName = text;
        this.setIconNames("DataSet", "DataSet");
    }

    public SASDataSetNode(String text, String nodeType) {
        super(text, nodeType);
        this.datasetName = text;
        this.setIconNames("DataSet", "DataSet");
    }

    public SASDataSetNode(String text, String expandedText, String nodeType) {
        super(text, nodeType);
        this.setNodeExpandedText(expandedText);
        this.datasetName = expandedText;
        this.setIconNames("DataSet", "DataSet");
    }

    protected DataSetInfoInterface getDataSetInfo() {
        if (this.datasetInfo == null) {
            try {
                this.datasetInfo = (DataSetInfoInterface)this.classFactory.newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.datasetinfo.DataSetInfoInterface"), this.rocfContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.datasetInfo.setDataSet(this.datasetName);
        }
        return this.datasetInfo;
    }

    public synchronized int getNodeChildCount() {
        DataSetInfoInterface info = this.getDataSetInfo();
        return info.count();
    }

    public synchronized SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        DataSetInfoInterface info = this.getDataSetInfo();
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        int i = 0;
        Enumeration items = info.getItems(startIndex, startIndex + count);
        while (items.hasMoreElements()) {
            String item = (String)items.nextElement();
            NodeIcon node = new NodeIcon(item);
            node.setDefaultIcon(SASListNode.getImage("Column"));
            node.setNodeExpandedText(this.datasetName + "." + item);
            childrenArray[i++] = node;
        }
        return childrenArray;
    }
}

