/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.dataset;

import com.sas.GlobalInfoTable;
import com.sas.awt.util.Util;
import com.sas.rmi.Connection;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.dataset.DataSetPasswordDialog;
import com.sas.sasserver.dataset.RB;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.MessageBox;
import java.awt.Component;
import java.awt.Frame;

public class DataSetPasswordTransform
implements TransformInterface {
    static final long serialVersionUID = -2448273313048609920L;
    static final String RB_KEY = "DataSetPasswordTransform.";
    protected Component parent;
    protected Frame parentFrame;
    protected Connection connection;
    protected DataSetInterface dataSet;
    protected int maxAttempts;

    public DataSetPasswordTransform(Component parent, Connection connection) {
        this(parent, connection, 3);
    }

    public DataSetPasswordTransform(Component parent, Connection connection, int maxAttempts) {
        this.parent = parent;
        this.connection = connection;
        this.maxAttempts = maxAttempts;
        this.parentFrame = Util.getParentFrame(parent);
        if (this.parentFrame == null) {
            this.parentFrame = new Frame();
        }
    }

    protected void initDataSet() {
        if (this.dataSet == null) {
            try {
                this.dataSet = (DataSetInterface)this.connection.getClassFactory().newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.dataset.DataSetInterface"), this.connection);
                this.dataSet.initialize();
            }
            catch (Exception ex) {
                String message = RB.getStringResource(RB_KEY, "unableToCreateDataSet.txt");
                MessageBox.showModalMessageBox(this.parentFrame, message);
            }
        }
    }

    protected String displayPasswordDialog(String dataSetName) {
        DataSetPasswordDialog dialog = new DataSetPasswordDialog(this.parentFrame, dataSetName);
        dialog.initialize();
        dialog.pack();
        dialog.setModal(true);
        dialog.centerOver(this.parent);
        dialog.setVisible(true);
        return dialog.getDataSetName();
    }

    protected String promptForPassword(String dataSetName) throws Exception {
        dataSetName = this.displayPasswordDialog(dataSetName);
        try {
            this.dataSet.setDataSet(dataSetName);
        }
        catch (Exception e) {
            String message = RB.getStringResource(RB_KEY, "unableToOpenDataSet.txt");
            MessageBox.showModalMessageBox(this.parentFrame, message);
            throw e;
        }
        this.dataSet.close();
        return dataSetName;
    }

    public Object transform(Object value) {
        String dataSetName = (String)value;
        if (dataSetName == null || dataSetName.length() == 0) {
            return dataSetName;
        }
        this.initDataSet();
        if (this.dataSet == null) {
            return dataSetName;
        }
        try {
            this.dataSet.setDataSet(dataSetName);
            this.dataSet.close();
        }
        catch (Exception e) {
            for (int attempt = 1; attempt <= this.maxAttempts; ++attempt) {
                try {
                    dataSetName = this.promptForPassword(dataSetName);
                    return dataSetName;
                }
                catch (Exception ae) {
                    continue;
                }
            }
            String message = RB.getStringResource(RB_KEY, "tooManyAttempts.txt");
            MessageBox.showModalMessageBox(this.parentFrame, message);
            return null;
        }
        return dataSetName;
    }
}

