/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.dataset;

import com.sas.sasserver.dataset.PromptPanel;
import com.sas.sasserver.dataset.RB;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.ButtonDialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

class DataSetPasswordDialog
extends ButtonDialog
implements ActionListener {
    static final String RB_KEY = "DataSetPasswordTransform.";
    protected PromptPanel promptPanel;
    protected String dataSetName;
    static final String okString = Util.getCommonStringResource((String)"Ok.txt");
    static final String cancelString = Util.getCommonStringResource((String)"Cancel.txt");
    static final String passwordPrompt = RB.getStringResource("DataSetPasswordTransform.", "enterPassword.txt");

    public DataSetPasswordDialog(Frame parentFrame, String dataSetName) {
        super(parentFrame, new String[][]{{okString, "close"}, {cancelString, "cancel"}});
        this.dataSetName = dataSetName;
        this.setTitle(dataSetName);
        this.initialize();
        this.promptPanel = new PromptPanel(new String[]{passwordPrompt}, new String[]{""}, new int[]{20}, new boolean[]{true});
        this.getMainPanel().setLayout((LayoutManager)new AutoSizingGridLayout(1, 1));
        this.getMainPanel().add(this.promptPanel);
        this.getButtonPanel().getButton(okString).addActionListener(this);
        this.getButtonPanel().getButton(cancelString).addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.setVisible(false);
        String command = event.getActionCommand();
        if (command.equals("close")) {
            String password = this.promptPanel.getFieldValue(0);
            if (password.length() > 0) {
                this.dataSetName = this.dataSetName + "(pw='" + password + "')";
            }
        } else if (command.equals("cancel")) {
            this.dataSetName = "";
        }
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.dataSetName = "";
    }
}

