/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.dataset;

import com.sas.Component;
import com.sas.collection.OrderedCollection;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.table.TableException;
import com.sas.util.Util;
import com.sas.util.transforms.ObjectToStringTransform;

public class DataSetNode
extends Component
implements NodeInterface {
    protected boolean hasChildren;
    protected OrderedCollection children = new OrderedCollection();
    protected String nodeText;
    protected String nodeType;
    protected int parentRowIndex;
    protected int uncleRowIndex;
    protected DataSetInterface dataSet;
    protected int level;
    protected boolean allChildrenRead;
    protected int numChildrenRead;
    protected String whereClause;
    protected int childLevel;

    public DataSetNode(DataSetInterface dataSet, String text, int parentRowIndex, int uncleRowIndex, int level) {
        this.nodeText = text;
        this.parentRowIndex = parentRowIndex;
        this.uncleRowIndex = uncleRowIndex;
        this.dataSet = dataSet;
        this.level = level;
        this.hasChildren = true;
        this.allChildrenRead = false;
        this.numChildrenRead = 0;
        this.childLevel = level + 1;
    }

    public int getParentRowIndex() {
        return this.parentRowIndex;
    }

    public int getUncleRowIndex() {
        return this.uncleRowIndex;
    }

    public void setUncleRowIndex(int uncleRowIndex) {
        this.uncleRowIndex = uncleRowIndex;
    }

    public int getLevel() {
        return this.level;
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return this.getNodeChildren(index, 1)[0];
    }

    public int getNodeChildCount() {
        if (!this.allChildrenRead) {
            this.readChildren(0, -1);
        }
        return this.numChildrenRead;
    }

    protected synchronized void readChildren(int startIndex, int count) {
        int currentRowIndex;
        String newWhereClause = null;
        try {
            newWhereClause = this.dataSet.getColumnInfo(this.dataSet.getLevelColumn(), "NAME") + " eq " + this.childLevel + " and " + this.dataSet.getColumnInfo(this.dataSet.getIndexColumn(), "NAME") + " gt " + this.parentRowIndex;
            if (this.uncleRowIndex > 0) {
                newWhereClause = newWhereClause + " and " + this.dataSet.getColumnInfo(this.dataSet.getIndexColumn(), "NAME") + " lt " + this.uncleRowIndex;
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        if (!Util.equal((Object)this.whereClause, newWhereClause)) {
            this.whereClause = newWhereClause;
            this.dataSet.disableEvents();
            this.dataSet.setWhere(this.whereClause);
            this.dataSet.enableEventsSilently(true);
            this.allChildrenRead = false;
            this.numChildrenRead = 0;
            this.children.removeAll();
        }
        DataSetNode previousChild = null;
        int n = currentRowIndex = startIndex >= this.numChildrenRead ? startIndex : this.numChildrenRead - 1;
        while (!this.allChildrenRead && (count < 0 || currentRowIndex <= startIndex + count && currentRowIndex > this.numChildrenRead - 1)) {
            block10: {
                try {
                    String cellText = (String)ObjectToStringTransform.defaultInstance.transform(this.dataSet.getCell(currentRowIndex + 1, this.dataSet.getTextColumn()));
                    int nextIndex = ((Double)this.dataSet.getCell(currentRowIndex + 1, this.dataSet.getIndexColumn())).intValue();
                    if (previousChild != null) {
                        previousChild.setUncleRowIndex(nextIndex);
                    }
                    DataSetNode child = new DataSetNode(this.dataSet, cellText, nextIndex, 0, this.childLevel);
                    ++this.numChildrenRead;
                    previousChild = child;
                    this.children.add((Object)child);
                }
                catch (IndexOutOfBoundsException e) {
                    this.allChildrenRead = true;
                    if (previousChild == null) break block10;
                    previousChild.setUncleRowIndex(this.uncleRowIndex);
                }
                catch (TableException e) {
                    break;
                }
            }
            ++currentRowIndex;
        }
        if (this.allChildrenRead && this.numChildrenRead == 0 && this.hasChildren) {
            this.hasChildren = false;
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        this.readChildren(startIndex, count);
        int i = 0;
        for (int c = startIndex; i < count && c < this.numChildrenRead; ++i, ++c) {
            childrenArray[i] = (SimpleNodeInterface)this.children.get(c);
        }
        return childrenArray;
    }

    public boolean isLeafNode() {
        return !this.hasChildren;
    }

    public String getNodeExpandedText() {
        return this.getNodeText();
    }

    public String getNodeText() {
        return this.nodeText;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSetNode) {
            DataSetNode otherNode = (DataSetNode)((Object)obj);
            if (this.parentRowIndex == otherNode.parentRowIndex && Util.equal((Object)this.dataSet.getDataSet(), (Object)otherNode.dataSet.getDataSet())) {
                return true;
            }
        }
        return false;
    }
}

